
/************************************************************************\
 *
 * NuSEO.PHP Enterprise v1.6
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

var nuseo_modules = new Array();
var nuseo_fx_accordion = null;

function nuseo_register_module( module_name )
{
	var module_info = new Object();
	module_info.name = module_name;
	module_info.groups = new Array();
	nuseo_modules.push( module_info );
}

//var nuseo_setting_groups = new Array();
var nuseo_advanced_mode  = false;


function nuseo_register_settings_group( module_name, settings_group_name, is_summary )
{

  for ( i = 0; i < nuseo_modules.length; i++ )
  {
    
    if ( module_name == nuseo_modules[ i ].name )
    {
	    var group_elem_id = "ns-settings-group-" + settings_group_name;
    	
    	//create setting-group item
	    var group_info = new Object();
	    group_info.name = settings_group_name;
	    group_info.id = group_elem_id;
	    group_info.elem = null;
	    group_info.is_summary = is_summary;
	    group_info.module = nuseo_modules[ i ];
	    
	    nuseo_modules[ i ].groups.push( group_info );    
      break;
    }
  }
}

function nuseo_show_switch_mode( mode_elem )
{
  nuseo_advanced_mode = !nuseo_advanced_mode;
  if (nuseo_advanced_mode)          // showing advanced settings
  {
    mode_elem.textContent = "Show Standard Settings";
  }
  else
  {
    mode_elem.textContent = "Show Advanced Settings";
  }
  
  var divs = document.getElementsByClassName("ns-advanced-setting");
  
  for ( i = 0; i < divs.length; i++ )
  {
      divs[ i ].style.display = nuseo_advanced_mode ? "" : "none";
  }
  
}

function nuseo_show_module_summary( module_name )
{
    nuseo_show_settings_group( module_name, module_name + "-summary" );
}

function nuseo_show_settings_group( module_name, settings_group_name )
{
    for ( i = 0; i < nuseo_modules.length; i++ )
    {
        var groups = nuseo_modules[ i ].groups;
        var group_count = groups.length;
    
        module_found = module_name == nuseo_modules[ i ].name;

        for ( j = 0;  j < group_count; j++)
        {
            var group_item = groups[ j ];

            if ( !group_item.elem )
            {
		        group_item.elem = nuseo_fetch_object( group_item.id );
                if ( !group_item.elem ) 
                    continue;
	        }

            setting_group_found = false;
            if ( module_found )
            {
                if ( '' != settings_group_name )
                {
                    setting_group_found = ( group_item.name == settings_group_name );
                }
                else
                {
                    //hide summary in case of show-all
                    setting_group_found = !group_item.is_summary;
                }
            } // if module_found

            group_item.elem.style.display = ( setting_group_found ) ? "block" : "none";
            
            if (setting_group_found)
            {
                modinput = nuseo_fetch_object("mod");
                if (modinput)
                    modinput.value = module_name;

                groupinput = nuseo_fetch_object("group");
                if (groupinput)
                    groupinput.value = settings_group_name;
            }
        } // for each group
    } // for each module
}


function nuseo_fetch_object( id )
{
	if (document.getElementById)
	{
		return document.getElementById(id);
	}
	else if (document.all)
	{
		return document.all[id];
	}
	else if (document.layers)
	{
		return document.layers[id];
	}
	else
	{
		return null;
	}
}

function nuseo_admin_init()
{
    nuseo_init_accordion();
}

function nuseo_init_accordion()
{
	  var stretchers = $$('div.ns-group-links');
	  var togglers = $$('div.ns-group-title');

	  stretchers.each( function(elem, i) { elem.style.height = "0"; elem.style.overflow = "hidden"; } );
  	
	  //the accordion
	  nuseo_fx_accordion = new Fx.Accordion(togglers, stretchers, {
		  'opacity': false,
		  'start': false,
		  'transition': Fx.Transitions.quadOut,
		  onActive: function(toggler){
			  //toggler.$tmp.fx.start('#e0542f');
			  //toggler.$tmp.first.setStyle('color', '#fff');
		  },
  	
		  onBackground: function(toggler){
			  //toggler.$tmp.fx.stop();
			  //toggler.setStyle('background-color', toggler.color).$tmp.first.setStyle('color', '#222');
		  }
	  });

    // expand first div  	
        nuseo_fx_accordion.showThisHideOpen( 0 );

    // Show appropriate module, based on url anchor
    module_name_elem = nuseo_fetch_object("mod");
    module_name = module_name_elem ? module_name_elem.value : '';
    
    group_name_elem = nuseo_fetch_object("group")
    group_name = group_name_elem  ? group_name_elem .value : '';
    
    if ((module_name != '') && (group_name != ''))
    {
        nuseo_show_settings_group( module_name, group_name );
    }
    
    // expand right-hand stretcher
    var selected_group_index = 0;
    var selected_module_id = 'ns_group_title_' + module_name;

    togglers.each( function(elem, i) { 
                if (elem.id == selected_module_id)
                {
                    selected_group_index  = i;
                }
            } );

    nuseo_fx_accordion.showThisHideOpen( selected_group_index );
}

function nuseo_toggle_module_state( module_name, constant_name )
{
    var state_input = document.getElementById( constant_name ); 
	if( state_input.value == 1 ) 
	{
		this.textContent='Disabled'; 
		state_input.value = 0;
	}
	else 
	{
		this.textContent='Enabled';
		state_input.value = 1;
	}
	var admin_form = document.getElementById('nuseo_admin_form')
	if ( admin_form )
	{
		document.getElementById('action').value = 'enable_disable';
		admin_form.submit();
	}
}

function nuseo_toggle_sitemap_state( action_url )
{
    window.location = action_url;
    return;
}

function nuseo_show_module_summary_ex( module_name, constant_name )
{
    var state_input = document.getElementById( constant_name ); 

	if( state_input && (state_input.value == 1) )
	{
	    var module_group_title = document.getElementById( 'ns_group_title_' + module_name ); 
	    if (module_group_title)
	    {
            var togglers = $$('div.ns-group-title');
            togglers.each( function(elem, i) { if (elem == module_group_title) nuseo_fx_accordion.showThisHideOpen( i ); } );
        }
        nuseo_show_module_summary( module_name );
	}
	else
		window.alert( module_name + ' is disabled.' );
}