<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/


error_reporting( E_ALL );
ini_set( 'display_errors', 1 );

set_error_handler( 'nuseo_error_handler' );

function nuseo_error_handler( $errno, $errstr, $errfile, $errline, $errcontext )
{
	echo "PHP Error: $errno, $errstr, $errfile, $errline, $errcontext<br/>\n";
}


//#define _NUSEO_ENTERPRISE_


    // nuseo high traffic optimizer defines
    
    
    





/***********************************************************************
* * Start File: nuhit_lib_debug.h
 * Description: nuhit_lib_debug.h contains NuHIT's Debug Library for nuhit_php_compiler
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 ************************************************************************/


//--------------------------------------------------------------------------
// _print and _print_r are the debug versions of print and print_r
// Under release these functions don't generate any code
//--------------------------------------------------------------------------
	
	





//--------------------------------------------------------------------------
// nu_print and nu_print_r are the release and debug version of print and print_r
// These macros/functions always generate code
//--------------------------------------------------------------------------

















































/***********************************************************************
* * End File: nuhit_lib_debug.h
 ************************************************************************/





/***********************************************************************
* * Start File: nuseo_common.h
 * Description: Contains common nuhit_php_compiler declarations for NuSEO.PHP
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/


  // Define loaders for debug files
  
  

  





if( !function_exists( "nu_microtime" ) )
{
    function nu_microtime()
    {
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }
}












































/***********************************************************************
* * End File: nuseo_common.h
\************************************************************************/



$nuseo_core_start_time = nu_microtime();
$nuseo_external_anchors = 0;
//$nuseo_vbulletin_urls = 0;

// Constants
define( 'NUSEO_VERSION',		'1.6' );
define( 'NUSEO_VERSION_MAJOR',	'1' );

define( 'NUSEO_SPACE', '1' );

define( 'NUSEO_ACTION_REDIRECT',	'redir' );
define( 'NUSEO_ACTION_EXECUTE',		'include' );
define( 'NUSEO_ACTION_ERROR',		'error' );

define( 'COPYRIGHT_PLACEHOLDER',	'<!-- NUSEO_COPYRIGHT -->' );
define( 'NUSEO_TIMENOW',			time() );
//

// NuSEO main()
$nuseo = array();
$nuseo_config = array();

if ( !isset( $nuseo_dir ) )
{
	$nuseo_dir = dirname(  __FILE__ );
}

$nuseo_config['dir'] = $nuseo_dir; 

$nuseo['debug_mode'] = !true;
$nuseo['debug_exit'] = true;			// exit if in debug mode.
$nuseo['debug_translation'] = !true;
$nuseo['debug_db'] = !true;
$nuseo['debug_profile'] = !true;
$nuseo['debug_trans_test'] = !true;
$nuseo['debug_nonsef']	= !true;


// Include nuseo_config.php, it may not exist if this is the first time NuSEO.PHP Admin CP is run.
$temp_error_level = error_reporting( E_ERROR );

include $nuseo_config[ 'dir' ] . "/nuseo_config.php";
error_reporting( $temp_error_level );
unset( $temp_error_level );







/***********************************************************************
* * Start File: nuseo_cache.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

function nuseo_cache_init( &$module, $cache_types )
{
	$module['cache_types'] = $cache_types;
	foreach ($cache_types as $cache_type)
	{
		$module[ "cache_$cache_type" ]			= array();
		$module[ "cache_{$cache_type}_ids" ]	= array();
		$module[ "cache_{$cache_type}_info" ]	= array();
	}
}

function nuseo_cache_flush( &$module, $cache_type )
{
	$module[ "cache_$cache_type" ] = array();
}

function nuseo_cache_add( &$module, $cache_type, $id, $value )
{
	$module[ "cache_$cache_type" ] [ $id ] = $value;
    
    if ( isset( $module[ "cache_{$cache_type}_ids" ][ $id ] )  )
    {
        unset( $module[ "cache_{$cache_type}_ids" ][ $id ] );
    }
}

function &nuseo_cache_fetch( &$module, $cache_type, $id, $getter = '' )
{
	$result = nuseo_cache_get( $module, $cache_type, $id );
    
    if ( $result === null )
	{
		global $nuseo, $nuseo_config;
		if ($nuseo['prefetch'])
		{	// if we are in prefetch mode, don't go to the DB, instead keep a list of ids for later retrieval.
			$module[ "cache_{$cache_type}_ids" ][ $id ] = $id;
			$module[ "cache_{$cache_type}_getter" ] = $getter;
			return $result;
		}

		if (!$module['db_conn'])
		{
			$db_conn = nuseo_get_db_connection( $module );
			if (!$db_conn)			// must load db connection, to retrieve table prefix information.
				return $result;
		}

		if ( $getter )
		{
			$result = $getter( $module, $cache_type, $id);
		}
		else 
		{
			//we try the generic getter here
			$result = nuseo_cache_get_from_db( $module, $cache_type, $id );
		}
	}
	return $result;
}

function &nuseo_cache_fetch_by_title( &$module, $cache_type, $title, $getter = '' )
{
	$result = null;

	// TODO: This function is currently a passthrough to the DB. Can be optimized.

	if (!$module['db_conn'])
	{
		$db_conn = nuseo_get_db_connection( $module );
		if (!$db_conn)			// must load db connection, to retrieve table prefix information.
			return $result;
	}

	if ($getter)
	{
		$result = $getter( $module, $cache_type, $title);
	}
	else
	{
		// default handler: check cache info record.
		$info_key = "cache_{$cache_type}_info";
		if (isset( $module[ $info_key ] ))
		{
			$cache_info =& $module[ $info_key ];
			
			if ( isset( $cache_info['title_name'] ) && isset( $cache_info['table_name'] ) && isset( $cache_info['sql_by_id'] ) )
			{
				$title_field_name	= $cache_info['title_name'];
				$table_name			= $cache_info[ 'table_name' ];
				$sql				= $cache_info[ 'sql_by_id' ];

				$additional_where	= isset( $cache_info['additional_where'] ) ? $cache_info[ 'additional_where' ] : false;
				$limit				= isset( $cache_info['limit'] ) ? $cache_info[ 'limit' ] : false;
				

				$result = nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $title, $sql, $table_name, 
											$title_field_name, $additional_where, $limit );
			}
		}
	}

	return $result;
}

function nuseo_cache_get( &$module, $cache_type, $id )
{
	$cache_key = "cache_$cache_type";
    
	if ( isset( $module[ $cache_key ] ) && isset( $module[ $cache_key ][ $id ] ) )
	{
		return $module[ $cache_key ][ $id ];
	}
	else
	{
		return null;
	}
}

//this function assumes that cache_type and id are table name and id 
function nuseo_cache_get_from_db( &$module, $cache_type, $id)
{
	global $nuseo, $nuseo_config;
	
	$info_loaded = false;

	$info_key = "cache_{$cache_type}_info";
	if (isset( $module[ $info_key ] ))
	{
		$cache_info =& $module[ $info_key ];
		
		if ( isset( $cache_info['id_name'] ) && isset( $cache_info['table_name'] ) && isset( $cache_info['sql_by_id'] ) )
		{
			$id_field_name	= $cache_info['id_name'];
			$table_name		= $cache_info[ 'table_name' ];
			$sql			= $cache_info[ 'sql_by_id' ];

			$additional_where	= isset( $cache_info['additional_where'] ) ? $cache_info[ 'additional_where' ] : false;
			$limit				= isset( $cache_info['limit'] ) ? $cache_info[ 'limit' ] : false;
			
			$info_loaded	= true;
		}
	}

	if (!$info_loaded)
	{
		$id_field_name	= $cache_type . 'id';
		$table_name		= 'the_table';
		$sql			=	"SELECT * FROM `" . $module['table_prefix'] . $cache_type . "` $table_name";
		$additional_where	= false;
		$limit			= false;
	}

	return nuseo_cache_get_from_db_common( $module, $cache_type, $id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_cache_get_from_db_common( &$module, $cache_type, $id, $sql, $table_name, $id_field_name, $additional_where, $limit, $db_conn_key = 'db_conn' )
{
	$db_conn = nuseo_get_db_connection( $module, $db_conn_key );
	if ( $db_conn )
	{
		if (is_array( $id ))
		{
			if (count( $id ) == 1)
				$where = "\n		WHERE $table_name.{$id_field_name} = " . reset($id);
			else
				$where = "\n		WHERE $table_name.{$id_field_name} IN (" . implode( ',', $id ) . ")";
		}
		else
			$where = "\n		WHERE $table_name.{$id_field_name} = {$id}";
			
		if ($additional_where)
			$where .= " AND " . $additional_where;
			
		$sql .=	$where;
		
		if ($limit)
			$sql .= ' ' . $limit;
		
		$return_row = false;
		
		$rows = $db_conn->execute_read( $sql );
		while ($row = $db_conn->fetch_array( $rows ))
		{
			nuseo_cache_add( $module, $cache_type, $row[ $id_field_name ], $row);
			$return_row = $row;
		}
		
		return $return_row;
	}
	else
	{
		return false;
	}
}

function nuseo_cache_get_from_db_by_title_common( &$module, $cache_type, $title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit, $db_conn_key = 'db_conn' )
{
	$db_conn = nuseo_get_db_connection( $module,$db_conn_key );
	if ( $db_conn )
	{
		$title_regexp = nuseo_str_to_regexp( $title );

		$where = "\n		WHERE $table_name.{$title_field_name} regexp '$title_regexp'";
	  
		if ($additional_where)
			$where .= " AND " . $additional_where;

		$sql .=	$where;

		if ($limit)
			$sql .= ' ' . $limit;

		$return_row = false;
		
        
		$rows = $db_conn->execute_read( $sql );
		while ($row = $db_conn->fetch_array( $rows ))
		{
			//nuseo_cache_add( $module, $cache_type, $row[ $id_field_name ], $row);		// FIXME, should we add this to the cache?
			$return_row = $row;
		}
		
		return $return_row;
	}
	else
	{
		return false;
	}
}


function nuseo_cache_execute_prefetch()
{
	global $nuseo, $nuseo_config;
	
	foreach ( array_keys($nuseo['modules']) as $module_key)
	{
		$module =& $nuseo['modules'][ $module_key ];
		if (!isset( $module['cache_types'] ))
			continue;
			
		$cache_types =& $module['cache_types'];

		foreach (array_keys($cache_types) as $type_key)
		{
			$cache_type =& $cache_types[ $type_key ];
			$cache_ids_key = "cache_{$cache_type}_ids";
			if (isset( $module[ $cache_ids_key ] ) && !empty( $module[ $cache_ids_key ] ))
			{
				if (!$module['db_conn'])
				{
					$db_conn = nuseo_get_db_connection( $module );
					if (!$db_conn)			// must load db connection, to retrieve table prefix information.
						break;
				}

				$getter = isset( $module[ "cache_{$cache_type}_getter" ] ) && $module[ "cache_{$cache_type}_getter" ]
								? $module[ "cache_{$cache_type}_getter" ] : 'nuseo_cache_get_from_db';

				$getter( $module, $cache_type, $module[ $cache_ids_key ] );
			}
		} // foreach cache_type
	} // foreach $module
}

/***********************************************************************
* * End File: nuseo_cache.nuphp
\************************************************************************/



	





/***********************************************************************
* * Start File: nuseo_smart_cache.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

class nuseo_cache
{
    function nuseo_cache()
    {
    }
    
    function shutdown()
    {
    }
    
    function get( $key )
    {
        return false;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
    }
    
    function flush()
    {
    }
	
	function get_array( $key )
	{
		$value = $this->get( $key );
		if (!empty( $value ))
		{
			$arr = unserialize( $value );
			return $arr;
		}
		else
		{
			return false;
		}
	}
	
	function add_array( $key, $arr, $timeout )
	{
		if (is_array( $arr ))
		{
			$value = serialize( $arr );
			$this->add( $key, $value, $timeout );
		}
		else
		{	// if $arr is not an array and it is not empty, then this is an error.
			$this->add( $key, false, $timeout );
		}
	}
}







/***********************************************************************
* * Start File: nuseo_cache_ram.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

class nuseo_cache_ram extends nuseo_cache
{
	var $_cache = array();
	var $_modified = false;

    function nuseo_cache_ram()
    {
        global $nuseo, $nuseo_config;
		
		if ($nuseo['debug_mode']) { echo( "Created nuseo_cache_ram instance.\n" ); };
    }
    
	function shutdown()
    {
		unset( $this->_cache );
    }
    
    function get( $key )
    {
		global $nuseo;

		if (isset( $this->_cache[ $key ] ))
			$result = $this->_cache[ $key ];
		else
			$result = false;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_ram::get( '$key' ) => '$result'\n" ); };
		return $result;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
		global $nuseo;

		if ($nuseo['debug_mode']) { echo( "nuseo_cache_ram::add( '$key', '$value', $timeout )\n" ); };
		$this->_cache[ $key ] = $value;
		$this->_modified = true;
    }
    
	function delete( $key, $timeout = 0 )
	{
		global $nuseo;

		if ($nuseo['debug_mode']) { echo( "nuseo_cache_ram::delete( '$key' )\n" ); };
		if (isset( $this->_cache[ $key ] ))
		{
			unset( $this->_cache[ $key ] );
			$this->_modified = true;
		}
	}

    function flush()
    {
		global $nuseo;

		if (!empty( $this->_cache ))
		{
			$this->_cache = array();
			$this->_modified = true;
		}
    }
}

/***********************************************************************
* * End File: nuseo_cache_ram.nuphp
\************************************************************************/










































































































/***********************************************************************
* * Start File: nuseo_cache_memcache.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

class nuseo_cache_memcache extends nuseo_cache
{
	// memcache limits:
	//		key		-> 250 bytes
	//		value	-> 1MB

	var $_memcache					= null;
	var $_connected					= false;
	var $_persistent_connections	= false;			// if set, we'll use Memcache::pconnect

	var $_use_compression			= false;
	var $_compress_threshold		= false;

    function nuseo_cache_memcache()
    {
		global $nuseo, $nuseo_config;

		// verify Memcache PECL extension is installed and loaded.
		if (!class_exists('Memcache'))
		{
			trigger_error( 'NuSEO.PHP: Memcache PECL extension not found.', E_USER_ERROR );
		}
        
        $this->_persistent_connections = $nuseo_config['memcached_persistent_connection'];
        $this->_use_compression = $nuseo_config['memcached_compression'];
        $this->_compress_threshold = $nuseo_config['memcached_compression_threshold'];
        
        if ( empty( $nuseo_config['memcached_server_list'] ) )
        {
            $nuseo_config['memcached_server_list'] = array( '127.0.0.1:11211' );
        }
		
		$this->_memcache = new Memcache();
		
		$this->connect_to_server();
	}
	
	function connect_to_server()
	{
		global $nuseo, $nuseo_config;

		if (empty( $nuseo_config['memcached_server_list'] ))
		{
			trigger_error( 'NuSEO.PHP: memcache server list empty, please configure in NuSEO.PHP Admin CP.', E_USER_ERROR );
		}
		
		$memcached_server_list =& $nuseo_config['memcached_server_list'];
		
		$server_pool_supported = method_exists($this->_memcache, 'addServer');	// added to Memcache v2.0.0
		$single_server = !$server_pool_supported || (count( $memcached_server_list ) == 1);
		
		foreach( $memcached_server_list as $server_info )
		{
			list($memcache_host, $memcache_port) = explode( ':', $server_info );
			if ($single_server)
			{	// TODO: Suppress PHP Notice if persistent connection is closed due to a server restart.
                if ( $this->_persistent_connections )
                {
                    $this->_connected = $this->_memcache->pconnect( $memcache_host, $memcache_port );
                }
                else
                {
				    $this->_connected = $this->_memcache->connect( $memcache_host, $memcache_port );
                }
				if (!$this->_connected)
				{
					trigger_error( "NuSEO.PHP: Could not connect to memcache server: $memcache_host:$memcache_port.", E_USER_ERROR );
				}
				break;
			}
			else
			{	// multiple servers
				$this->_memcache->addServer( $memcache_host, $memcache_port, $this->_persistent_connections );
				$this->_connected = true;		// should be done once, outside of loop. memcache will connect when needed.
			}
		}

		if ($this->_connected)
		{
			if ($this->_use_compression && $this->_compress_threshold)
			{
				if (method_exists( $this->_memcache, 'setCompressThreshold' ))
				{	// this was added to Memcache v2.0.0
					$this->_memcache->setCompressThreshold( $this->_compress_threshold );
				}
			}
		}
		else
		{	// couldn't connect
			$this->_memcache = null;
		}
    }

    function shutdown()
    {
 		global $nuseo, $nuseo_config;

       if ($this->_memcache)
		{
			$this->_connected = false;
			$this->_memcache->close();
			$this->_memcache = null;
		}
    }
    
	function get( $key )
    {
 		global $nuseo, $nuseo_config;

		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );

		if ($this->_memcache && $this->_connected)
		{
			$result = $this->_memcache->get( $key );
		}
		else
		{
			$result = null;
		}
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_memcache::get( '$key' ) => '$result'\n" ); };
		return $result;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
 		global $nuseo, $nuseo_config;

		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );

		if ($nuseo['debug_mode']) { echo( "nuseo_cache_memcache::add( '$key', '$value', $timeout )\n" ); };
		if ($this->_memcache && $this->_connected)
		{
			$this->_memcache->add( $key, $value, $this->_use_compression ? MEMCACHE_COMPRESSED : false, $timeout );
		}
    }
    
    function delete( $key, $timeout = 0 )
    {
 		global $nuseo, $nuseo_config;

		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );

		if ($nuseo['debug_mode']) { echo( "nuseo_cache_memcache::delete( '$key' )\n" ); };
		if ($this->_memcache && $this->_connected)
		{
			$this->_memcache->delete( $key, $timeout );
		}
    }
	
	function flush()
    {
 		global $nuseo, $nuseo_config;

		if ($this->_memcache && $this->_connected)
		{
			$this->_memcache->flush();
		}
    }
}

/***********************************************************************
* * End File: nuseo_cache_memcache.nuphp
\************************************************************************/








/***********************************************************************
* * Start File: nuseo_cache_eaccel.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/


class nuseo_cache_eaccel extends nuseo_cache
{
    function nuseo_cache_eaccel()
    {
		global $nuseo;
        // verify eaccelerator extension is installed and loaded
		if (!function_exists('eaccelerator_get'))
		{
			trigger_error( 'NuSEO.PHP: eAccelerator extension not found (http://eaccelerator.net/).', E_USER_ERROR );
		}
    }
    
    function shutdown()
    {
		global $nuseo;
        // shutdown cache: nothing to do.
    }
    
    function get( $key )
    {
		global $nuseo;
		$result = eaccelerator_get( $key );
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_eaccel::get( '$key' ) => '$result'\n" ); };
		
		return $result;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_eaccel::add( '$key', '$value', $timeout )\n" ); };

		// run garbage collection
		eaccelerator_gc();
		
		// lock key
		eaccelerator_lock( $key );
		
		// write to shared memory
		eaccelerator_put( $key, $value, $timeout );
		
		// unlock key
		eaccelerator_unlock( $key );
    }
    
	function delete( $key, $timeout = 0 )
	{
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_eaccel::delete( '$key' )\n" ); };
		// run garbage collection
		eaccelerator_gc();
		
		// lock key
		eaccelerator_lock( $key );
		
		// delete entry from shared memory
		eaccelerator_rm( $key );
		
		// unlock key
		eaccelerator_unlock( $key );
	}

    function flush()
    {
		global $nuseo;
		echo "function nuseo_cache_eaccel::flush not implemented <BR>";
    }
    
}
/***********************************************************************
* * End File: nuseo_cache_eaccel.nuphp
\************************************************************************/








/***********************************************************************
* * Start File: nuseo_cache_apc.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/


class nuseo_cache_apc extends nuseo_cache
{
    function nuseo_cache_apc()
    {
		global $nuseo;
        // verify apcerator extension is installed and loaded
		if (!function_exists('apc_store'))
		{
			trigger_error( 'NuSEO.PHP: PHP APC extension not found.', E_USER_ERROR );
		}
    }
    
    function shutdown()
    {
		global $nuseo;
        // shutdown cache: nothing to do.
    }
    
    function get( $key )
    {
		global $nuseo;
        
   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
        
		$result = apc_fetch( $key );
        
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_apc::get( '$key' ) => '$result'\n" ); };
		
		return $result;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_apc::add( '$key', '$value', $timeout )\n" ); };

   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
            
		// write to shared memory
		apc_store( $key, $value, $timeout );
    }
    
	function delete( $key, $timeout = 0 )
	{
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_apc::delete( '$key' )\n" ); };
        
   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
        
        
        apc_delete( $key );
		

	}

    function flush()
    {
		global $nuseo;
		echo "function nuseo_cache_apc::flush not implemented <BR>";
    }
    
}
/***********************************************************************
* * End File: nuseo_cache_apc.nuphp
\************************************************************************/








/***********************************************************************
* * Start File: nuseo_cache_xcache.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/


class nuseo_cache_xcache extends nuseo_cache
{
    function nuseo_cache_xcache()
    {
		global $nuseo;
        // verify apcerator extension is installed and loaded
		if (!function_exists('xcache_get'))
		{
			trigger_error( 'NuSEO.PHP: PHP XCache extension not found.', E_USER_ERROR );
		}
    }
    
    function shutdown()
    {
		global $nuseo;
        // shutdown cache: nothing to do.
    }
    
    function get( $key )
    {
		global $nuseo;
        
   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
        
		$result = xcache_get( $key );
        
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_xcache::get( '$key' ) => '$result'\n" ); };
		
		return $result;
    }
    
    function add( $key, $value, $timeout = 0 )
    {
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_xcache::add( '$key', '$value', $timeout )\n" ); };

   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
            
		// write to shared memory
		xcache_set( $key, $value, $timeout );
    }
    
	function delete( $key, $timeout = 0 )
	{
		global $nuseo;
		if ($nuseo['debug_mode']) { echo( "nuseo_cache_xcache::delete( '$key' )\n" ); };
        
   		if (strlen( $key ) > 250)
			$key = substr( $key, 0, 250 );
        
        xcache_unset( $key );

	}

    function flush()
    {
		global $nuseo;
		echo "function nuseo_cache_xcache::flush not implemented <BR>";
    }
    
}
/***********************************************************************
* * End File: nuseo_cache_xcache.nuphp
\************************************************************************/



// this is the nuseo_cache singleton
$nuseo_cache = null;

function &nuseo_get_cache_object()
{
    global $nuseo, $nuseo_config, $nuseo_cache;
    
    if ( ( null == $nuseo_cache ) && !empty($nuseo_config['cache_system_enabled']) )
    {
        switch ( $nuseo_config['cache_engine'] )
        {
            case 'apc':
                $nuseo_cache = new nuseo_cache_apc();
                break;
                
            case 'eaccelerator':
                $nuseo_cache = new nuseo_cache_eaccel();
                break;
                
            case 'memcache':
                $nuseo_cache = new nuseo_cache_memcache();
                break;
                
            case 'file':
                $nuseo_cache = new nuseo_cache_file();
                break;

            case 'ram':
                $nuseo_cache = new nuseo_cache_ram();
                break;
                
            case 'xcache':
                $nuseo_cache = new nuseo_cache_xcache();
                break;            

           default:
                $nuseo_cache = null;			// null cache
                break;
        }
    }
    return $nuseo_cache;
}
/***********************************************************************
* * End File: nuseo_smart_cache.nuphp
\************************************************************************/










/***********************************************************************
* * Start File: nuseo_db.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/



class nuseo_db_connection
{






















	var $_db_name = false;

	var $_db_link = false;
	
	var $_reset_db = false;

	var $_report_errors = true;
	var $_error = '';
	var $_error_number = '';

	
	function nuseo_db_connection()
	{






	}

	function connect( $server_name, $server_port, $db_username, $db_password, $_db_name



						)
	{
		$this->_db_name = $_db_name;


		$link = mysql_connect( "$server_name:$server_port", $db_username, $db_password, /* new_link */ true );




		if (!$link)
        {
			return false;
        }

		$this->_db_link = $link;

		if ( $this->_db_link && $_db_name)
        {
			$this->select_db( $_db_name );
        }

		return true;
	}

	function select_db( $_db_name )
	{

		return mysql_select_db( $_db_name, $this->_db_link );



	}

	function &execute_query( $buffered = true )
	{
		global $nuseo, $nuseo_config;
		
		if ($nuseo['debug_db'])
		{
			$nuseo['query_log'][] = $this->sql;
		}
		
		if ($this->_reset_db)
		{
			$this->select_db( $this->_db_name );
			$this->_reset_db = false;
		}


		if ( $buffered )
		{
			$result = mysql_query( $this->sql, $this->_db_link);
		}
		else
		{
			$result = mysql_unbuffered_query( $this->sql, $this->_db_link);
		}










		if ( $result )
		{
			return $result;
		}
		else
		{
			$this->display_error();
			return null;				// display_error may or may not exist
		}
	}

	function execute_write( $sql, $buffered = true )
	{
		$this->sql =& $sql;
		return $this->execute_query( $buffered );
	}

	function execute_read( $sql, $buffered = true )
	{
		$this->sql =& $sql;
		return $this->execute_query( $buffered );
	}

	function &get_one( $sql )
	{
		$this->sql =& $sql;
		
		$result = $this->execute_query();
		
		$returnarray = $this->fetch_array( $result );

		$this->free_result( $result );
		
		return $returnarray;
	}

	function num_rows( $result )
	{

		return @mysql_num_rows( $result );



	}

	function num_fields( $result )
	{

		return @mysql_num_fields( $result );



	}

	function insert_id()
	{

		return @mysql_insert_id( $this->_db_link );



	}

	function close()
	{

		return @mysql_close( $this->_db_link );



	}




















	function fetch_array( $result )
	{

		return @mysql_fetch_array( $result, MYSQL_ASSOC );



	}

	function fetch_row( $result )
	{

		return @mysql_fetch_row( $result );



	}

	function free_result( $result )
	{
		$this->sql = '';

		return @mysql_free_result( $result );



	}

	function affected_rows()
	{

		$this->rows = @mysql_affected_rows( $this->_db_link );



		return $this->rows;
	}

	function reset_db()
	{
		$this->_reset_db = true;
	}

	function error()
	{

		$this->_error = mysql_error( $this->_db_link );



		return $this->_error;
	}

	function error_number()
	{

		$this->_error_number = mysql_errno( $this->_db_link );



		return $this->_error_number;
	}

	function enable_error_reporting( $enable )
	{
		$this->_report_errors = $enable;
	}
	
	function display_error()
	{
		global $nuseo_config;
		
		if ($this->_report_errors)
		{
			if ( !empty($nuseo_config['log_enabled']) && !empty($nuseo_config['log_db_errors']) )
			{
				$error_str = "DB Error: " . $this->error_number() . " - " . $this->error() . "\n";
				$error_str .= $this->sql;
				nuseo_log_error( $error_str, 'db' );
			}
			else
			{
				$error_str = "DB Error: " . $this->error_number() . " - " . $this->error() . "<br/>\n<br/>\n";
				$error_str .= $this->sql;
				echo $error_str;
				if ( !empty($nuseo_config['halt_on_db_errors']) )
				{
					exit;
				}
			}
		}
	}
}

/***********************************************************************
* * End File: nuseo_db.nuphp
\************************************************************************/









/***********************************************************************
* * Start File: nuseo_log.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

function nuseo_log_file_not_found( $url )
{
	global $nuseo, $nuseo_config;

	if ($nuseo_config['log_type'] == 'db')
	{
		$url		= addslashes( $url );
		$referrer	= isset( $_SERVER['HTTP_REFERRER'] )	? addslashes( $_SERVER['HTTP_REFERRER'] )	: '';
		$ip			= isset( $_SERVER['REMOTE_ADDR'] )		? addslashes( $_SERVER['REMOTE_ADDR'] )		: '';
		$user_agent	= isset( $_SERVER['HTTP_USER_AGENT'] )	? addslashes( $_SERVER['HTTP_USER_AGENT'] )	: '';
		$dateadded	= date( 'Y-m-d H:i:s', NUSEO_TIMENOW );
		
		$sql = "INSERT INTO `nuseo_page_not_found` (url, referrer, ip, useragent, dateadded) 
				VALUES ( '$url', '$referrer', '$ip', '$user_agent', '$dateadded')";
		
		if (!isset( $nuseo['log_db_conn'] ) || !$nuseo['log_db_conn'])
		{
			nuseo_connect_to_log_db();
		}
		
		if ($nuseo['log_db_conn'])
		{
			$nuseo['log_db_conn']->execute_write( $sql );
		}
	}
	else
	{
		$url		=  $url;
		$referrer	= isset( $_SERVER['HTTP_REFERRER'] )	?  $_SERVER['HTTP_REFERRER']	: '';
		$ip			= isset( $_SERVER['REMOTE_ADDR'] )		?  $_SERVER['REMOTE_ADDR']		: '';
		$user_agent	= isset( $_SERVER['HTTP_USER_AGENT'] )	?  $_SERVER['HTTP_USER_AGENT']	: '';
		$dateadded	= date( 'Y-m-d H:i:s', NUSEO_TIMENOW );

		$log_line = "\"$dateadded\"	\"$ip\"	\"$url\"	\"$referrer\"	\"$user_agent\"\n";

		$today_str = date( 'Y-m-d', NUSEO_TIMENOW );

		$log_location = !empty($nuseo_config['log_file_location']) ? $nuseo_config['log_file_location'] : "./logs";
		$file_not_found_log_file_name = $log_location . "/not-found-$today_str.log";

		$fp = fopen( $file_not_found_log_file_name, "a" );
		if ($fp)
		{
			fwrite( $fp, $log_line );
			fclose( $fp );
		}
	}
}

function nuseo_connect_to_log_db()
{
	global $nuseo, $nuseo_config;
	
	if (!isset($nuseo['log_db_conn']) || !$nuseo['log_db_conn'])
	{
		$nuseo['log_db_conn'] = nuseo_connect_to_db( $nuseo_config['log_db_server_name'], 
				$nuseo_config['log_db_server_port'], $nuseo_config['log_db_username'], 
				$nuseo_config['log_db_password'], $nuseo_config['log_db_name'] );
	}
}

function nuseo_log_error( $error, $type )
{
	global $nuseo, $nuseo_config;

	if ($nuseo_config['log_type'] == 'db')
	{
		$error		= addslashes( $error );
		$type		= addslashes( $type );
		$referrer	= isset( $_SERVER['HTTP_REFERRER'] )	? addslashes( $_SERVER['HTTP_REFERRER'] )	: '';
		$ip			= isset( $_SERVER['REMOTE_ADDR'] )		? addslashes( $_SERVER['REMOTE_ADDR'] )		: '';
		$user_agent	= isset( $_SERVER['HTTP_USER_AGENT'] )	? addslashes( $_SERVER['HTTP_USER_AGENT'] )	: '';
		$dateadded	= date( 'Y-m-d H:i:s', NUSEO_TIMENOW );

		$sql = "INSERT INTO `nuseo_log` (error, referrer, ip, type, useragent, dateadded) 
						VALUES ( '$error', '$referrer', '$ip', '$type', '$user_agent', '$dateadded')";

		if (!isset( $nuseo['log_db_conn'] ) || !$nuseo['log_db_conn'])
		{
			nuseo_connect_to_log_db();
		}
		
		if ($nuseo['log_db_conn'])
		{
			$nuseo['log_db_conn']->enable_error_reporting( false );			// avoid recursion
			$nuseo['log_db_conn']->execute_write( $sql );
			$nuseo['log_db_conn']->enable_error_reporting( true );
		}
	}
	else
	{
		$referrer	= isset( $_SERVER['HTTP_REFERRER'] )	?  $_SERVER['HTTP_REFERRER']	: '';
		$ip			= isset( $_SERVER['REMOTE_ADDR'] )		?  $_SERVER['REMOTE_ADDR']		: '';
		$user_agent	= isset( $_SERVER['HTTP_USER_AGENT'] )	?  $_SERVER['HTTP_USER_AGENT']	: '';
		$dateadded	= date( 'Y-m-d H:i:s', NUSEO_TIMENOW );

		$log_line = "\"$dateadded\"	\"$ip\"	\"$error\"	\"$referrer\"	\"$user_agent\"	\"$type\"\n";

		$today_str = date( 'Y-m-d', NUSEO_TIMENOW );
		
		$log_location = !empty($nuseo_config['log_file_location']) ? $nuseo_config['log_file_location'] : "./logs";
		$log_file_name = $log_location . "/logs-$today_str.log";
		
		$fp = fopen( $log_file_name, "a" );
		if ($fp)
		{
			fwrite( $fp, $log_line );
			fclose( $fp );
		}
	}
}

/***********************************************************************
* * End File: nuseo_log.nuphp
\************************************************************************/









/***********************************************************************
* * Start File: nuhit_curl.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/


function nuhit_url_init()
{
	if ( !defined( 'CURLOPT_URL' ) )
	{
		$curl_ops = array( 'CURLOPT_URL', 
						   'CURLOPT_TIMEOUT',
						   'CURLOPT_RETURNTRANSFER',
						   'CURLOPT_REFERER', 
						   'CURLOPT_USERAGENT',
							'CURLOPT_FOLLOWLOCATION',
							'CURLOPT_HEADER' );
        
		$curl_opt_id = 0;
		foreach ( $curl_ops as $opt )
		{
			define( $opt, $curl_opt_id++ );
		}
	}
}

function nuhit_url_get(  $url, $options  )
{
	$content = false;
    
	nuhit_url_init();
    
	if ( function_exists( 'curl_init' ) )
	{
		$curl_handle = curl_init(  );
		if ( $curl_handle )
		{
			curl_setopt(  $curl_handle, CURLOPT_URL, $url  );
			curl_setopt(  $curl_handle, CURLOPT_TIMEOUT, 15  );
			curl_setopt(  $curl_handle, CURLOPT_RETURNTRANSFER, 1  );		// return content on success
			
			foreach ( $options as $key => $value )
				curl_setopt(  $curl_handle, $key, $value  );

			$content = curl_exec(  $curl_handle  );
			curl_close(  $curl_handle  );
		}
	}

	if ( $content === false )		// then CURL failed.
	{
		$url_info = parse_url(  $url  );
		
		$host = $url_info['host'];
		$port = isset( $url_info['port'] ) ? $url_info['port'] : 80;
		
		$resource = $url_info['path'] . '?' . $url_info['query'];
		
		$header = "GET $resource HTTP/1.0\r\n";
		$header .= "Host: $host\r\n";
		$header .= "Content-Length: " . 0 . "\r\n";
        
		foreach( $options as $key => $value )
		{
			if ( $key == CURLOPT_REFERER )
			{
				$header .=  "Referer: ". $value . "\r\n";
			}
			else if ( $key == CURLOPT_USERAGENT )
			{
				$header .= "User-Agent: " . $value . "\r\n";
			}
		}
       
		$header .= "\r\n";
        
		if ( $fp = fsockopen(  $host, $port, $errno, $errstr, 15 ) )
		{
			$iter_count = 0;
			socket_set_timeout( $fp, 15 );
			fwrite( $fp, $header );
			while ( !feof( $fp ) )
			{
				$retval = fgets( $fp, 1024 );
				if ( !$retval )
					break;
				$content .= $retval; 
				
				$iter_count++;
				if ( $iter_count > 1024 )			// maximum 1MB
					break;
			}
			fclose( $fp );
		}
		
		if ($content)
		{	// remove the response header
			$content_start = strpos( $content, "\r\n\r\n" );
			if ($content_start !== false)
				$content = substr( $content, $content_start + 4 );
		}
	}

	return $content;
}


/***********************************************************************
* * End File: nuhit_curl.nuphp
\************************************************************************/



if (!defined('NUSEO_ADMIN_CP'))
{
	// Load Defaults
	nuseo_load_defaults();
	
	if (defined( 'NUSEO_INIT_ONLY' ))				// if this is defined, we initialize, but do nothing else.
	{
		// Initialize
		nuseo_initialize();
		
		// Load Modules
		if ($nuseo_config[ 'enabled' ])
			nuseo_load_modules();

		// initialize with current script URL
		$request_url = $_SERVER['REQUEST_URI'];
		
		if ($nuseo['base_url_path'])
		{
			$base_len = strlen( $nuseo['base_href_path'] );
			$request_url = substr( $request_url, $base_len );
		}
		
		$url_ok = nuseo_set_reference_url( $request_url );
	}
	else
	{
		$script_file_name = nuseo_main();
		if (!$script_file_name || !file_exists( $script_file_name ))
			nuseo_print_page_not_found();
		
		// change current directory to script's
		$script_dir = dirname( $script_file_name );
		if ($script_dir)
			chdir( $script_dir );
		
		// Start buffering if global parser is enabled.
		if ($nuseo['global_parser'])
		{
			if (!$nuseo['use_ob_callback'])	// $nuseo['debug_translation']
			{
				if ( $nuseo['debug_profile'] )
				{
					$nuseo_core_time_before_include = nu_microtime();
					
					$nuseo_core_time_consumed_before_include = $nuseo_core_time_before_include - $nuseo_core_start_time;
					$nuseo_profile_output .= "NuSEO.PHP Startup (global parser, no callback): " . $nuseo_core_time_consumed_before_include . "<br />\n";
					
					ob_start();
					include "$script_file_name";
					$output = ob_get_contents();
					ob_end_clean();
					
					$nuseo_core_time_after_include = nu_microtime();
					$nuseo_core_time_in_script = $nuseo_core_time_after_include - $nuseo_core_time_before_include;
					$nuseo_profile_output .= "Script Execution (global parser, no callback): " . $nuseo_core_time_in_script . "<br />\n";  
				}
				else
				{
					ob_start();
					include "$script_file_name";
					$output = ob_get_contents();
					ob_end_clean();
				}
				
				$skip_global_parser = isset( $nuseo['skip_global_parser'] ) && $nuseo['skip_global_parser'];
				if (!$skip_global_parser && nuseo_is_response_html( $output ))
				{
					if ( $nuseo['debug_profile'] )
					{
						$nuseo_process_html_start_time = nu_microtime();
						nuseo_process_html( $output );
						$nuseo_process_html_total_time = nu_microtime() - $nuseo_process_html_start_time;
						
						global $nuseo_profile_output;
						$nuseo_profile_output .= "NuSEO.PHP Parser: " . $nuseo_process_html_total_time . "<br />\n"; 
					}
					else
					{
						nuseo_process_html( $output );
					}
				}

				echo $output;

				unset( $output );
			}
			else
			{
				if ( $nuseo['debug_profile'] )
				{
					$nuseo_core_time_before_include = nu_microtime();
					
					$nuseo_core_time_consumed_before_include = $nuseo_core_time_before_include - $nuseo_core_start_time;
					$nuseo_profile_output .= "NuSEO.PHP Startup (global parser, callback): " . $nuseo_core_time_consumed_before_include . "<br />\n";
					
					ob_start( 'nuseo_ob_callback' );
					include "$script_file_name";
					ob_end_flush();
					
					$nuseo_core_time_after_include = nu_microtime();
					$nuseo_core_time_in_script = $nuseo_core_time_after_include - $nuseo_core_time_before_include;
					$nuseo_profile_output .= "Script Execution (global parser, callback): " . $nuseo_core_time_in_script . "<br />\n";
				}
				else
				{
					ob_start( 'nuseo_ob_callback' );
					include "$script_file_name";
					ob_end_flush();                    
				}
				
				unset( $output );
			}
		}
		else	// else, buffering is not needed, handled by module
		{
			if ( $nuseo['debug_profile'] )
			{
				global $nuseo_core_time_before_include;
				$nuseo_core_time_before_include = nu_microtime();
				
				$nuseo_core_time_consumed_before_include = $nuseo_core_time_before_include - $nuseo_core_start_time;
				$nuseo_profile_output .= "NuSEO.PHP Startup (no global parser): " . $nuseo_core_time_consumed_before_include . "<br />";
				
				include "$script_file_name";
				
				//This line here is never executed due to vBulletin
				$nuseo_core_time_after_include = nu_microtime();
				$nuseo_core_time_in_script = $nuseo_core_time_after_include - $nuseo_core_time_before_include;
				$nuseo_profile_output .= "Script Execution (no global parser): " . $nuseo_core_time_in_script . "<br />";
			}
			else
			{
				include "$script_file_name";
			}
		}
		
		if ( $nuseo['debug_profile'] )
		{
			$nuseo_core_end_time = nu_microtime();
			$nuseo_core_total_time = $nuseo_core_end_time - $nuseo_core_start_time;
			
			$nuseo_profile_output .= "NuSEO.PHP Overhead: " . $nuseo_core_total_time - $nuseo_core_time_in_script. "<br />\n";
			$nuseo_profile_output .= "Total Execution: " . $nuseo_core_total_time . "<br />\n";
			
			echo "<br />\n" . $nuseo_profile_output;
			
			echo "<textarea cols=50 rows=10>" 
				. $nuseo_core_time_consumed_before_include . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_time_consumed_before_include/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_core_time_in_script . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_time_in_script/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_process_html_total_time . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_process_html_total_time/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_core_total_time . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_total_time/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. "</textarea>";
		}
		
		// exit current page
		nuseo_shutdown();
		
		exit;
	}
} // if !defined('NUSEO_ADMIN_CP')
//

function nuseo_main()
{
	global $nuseo, $nuseo_config, $nuseo_cache;

	nuseo_read_request_url();
	$rel_request_url = !empty($nuseo['virtual_rel_request_url']) ? $nuseo['virtual_rel_request_url'] : $nuseo['rel_request_url'];

	if (!$rel_request_url || ($rel_request_url[0] != '/'))
		$rel_request_url = '/' . $rel_request_url;

	if (strpos( $rel_request_url, $nuseo['redirect_to_url'] ) === 0)
	{	// we are redirecting to an external url.
		$external_url = substr( $rel_request_url, strlen( $nuseo['redirect_to_url'] ) );
		
		nuseo_redirect_to( $external_url, false );		// do not 301 this external url
		exit;
	}

	// Initialize & load modules
	nuseo_initialize();
	
	if ($nuseo['debug_mode']) { echo( "\n<span class=\"ns-debug-bold\">INPUT _SERVER: </span>\n" ); };
	if ($nuseo['debug_mode']) { print_r( $_SERVER ); };

	// read requested URL
	$nuseo['request_url'] = $nuseo['base_url_path'] . $rel_request_url;
	$request_url =& $nuseo['request_url']; 

	if ($nuseo['debug_mode'])
	{
		if ($nuseo['debug_mode']) { echo( "\nvirtual_rel_request_url = " . $nuseo['virtual_rel_request_url'] . "\n" ); };
		if ($nuseo['debug_mode']) { echo( "rel_request_url = " . $nuseo['rel_request_url'] . "\n" ); };
		if ($nuseo['debug_mode']) { echo( "\n<span class=\"ns-debug-bold\">request_url = " . $request_url . "</span>\n\n" ); };
	}

	$step_count = ($nuseo['step_count'] - $nuseo['timenow']) + $nuseo['nowload'];

	// Load Modules
	if ($nuseo_config[ 'enabled' ])
		nuseo_load_modules();
		
	if ($nuseo_config[ 'enabled' ])
	{
		if ($step_count)
		{
			// try custom redirects
			nuseo_process_custom_redirects( $request_url );
			
			// try custom path blanklist
			if (!empty( $nuseo_config['runtime_path_blacklist'] ))
				nuseo_process_path_blacklist( $request_url );
		}
		else
		{
			$nuseo_config['enabled'] = 2;
		}
	}

	// perform url rewrite

    $new_url_info = false;
	$url_retrieved_from_cache = false;
	if ($nuseo_config[ 'enabled' ] && $nuseo_cache && !empty($nuseo_config['cache_url_requests']) )
	{
		if ($step_count)
		{
			$url_cache_key = 'url-' . $_SERVER['HTTP_HOST'] . $request_url;
			$new_url_info = $nuseo_cache->get_array( $url_cache_key );
			
			$url_retrieved_from_cache = !empty( $new_url_info  );

			if ($url_retrieved_from_cache)
			{
				if ($nuseo['debug_mode']) { echo( "\nRetrieved new URL info from cache.\n" ); };

				// set reference url for base_href		
				/*$url_ok =*/ nuseo_set_reference_url( $request_url );
				
				// set other globals normally set by nuseo_get_new_url_info
				$nuseo['global_parser']		= $new_url_info[ 'global_parser' ];
				$nuseo['base_href']			= $new_url_info[ 'base_href' ];
				$nuseo['base_href_path']	= $new_url_info[ 'base_href_path' ];
			}
		}
	}




	if (!$new_url_info)
	{
		$new_url_info = nuseo_get_new_url_info( $request_url, $step_count );
	}

	if (!$new_url_info)
	{	// if not inited, it will default to include requested file.
		$new_url_info = array(	'new_url' => $nuseo['request_url'], 'action' => NUSEO_ACTION_EXECUTE );
	}
	

	if ($nuseo_cache && !$url_retrieved_from_cache && !empty($nuseo_config['cache_url_requests']))
	{
		if ($nuseo_config[ 'enabled' ])
		{
			if ($step_count)
			{
				// set other globals normally set by nuseo_get_new_url_info
				$new_url_info['global_parser']	= $nuseo[ 'global_parser' ];
				$new_url_info['base_href']		= $nuseo[ 'base_href' ];
				$new_url_info['base_href_path']	= $nuseo[ 'base_href_path' ];
				
				// add to cache
				$nuseo_cache->add_array( $url_cache_key, $new_url_info, $nuseo_config['cache_timeout'] );
			}
		}
	}


	if ($nuseo['debug_mode']) { echo( "<span class=\"ns-debug-bold\">\n\nnew_url_info = \n" ); }; 
	if ($nuseo['debug_mode']) { print_r( $new_url_info ); };
	if ($nuseo['debug_mode']) { echo( "</span>\n\n\n" ); };
	
	$new_script_filename = nuseo_execute_url_action( $new_url_info );	
	
	if ($nuseo['debug_mode']) { echo( "new _SERVER: " ); };
	if ($nuseo['debug_mode']) { print_r( $_SERVER ); };
	
	if ($nuseo['debug_mode'])
	{
		if (!$nuseo['debug_exit'])
		{
			if ($nuseo['debug_mode']) { echo( "</pre>\n\n\n" ); };
			$nuseo['debug_mode'] = false;		// reset debug mode.
		}
		else
		{
			nuseo_shutdown();
			exit;
		}
	}
	
	return $new_script_filename;
}

function nuseo_get_new_url_info( $request_url, $step_count )
{
	global $nuseo, $nuseo_config;
	
	$new_url_info = false;

	if ($nuseo_config[ 'enabled' ])
	{	// this could have been disabled due to a custom path blacklist
		if ($step_count && !$nuseo['debug_nonsef'])
		{
			// find out if we have the mapping cached
			// TODO: Implement DB Based global caching? Maybe controlled by modules.
			
			// break url into parts, parse query string
			$url_ok = nuseo_set_reference_url( $request_url );
			if ($url_ok)
			{
				$request_url_info =& $nuseo['request_url_info']; 
				
				// translate URL
				$request_url_domain = $_SERVER['HTTP_HOST'];
				$module_list = nuseo_get_module_list_for_url( $request_url, $request_url_domain );
				
				
				// try converting to non-sef
				$anchor_info = false;
				$non_sef_url = nuseo_translate_url_to_non_sef( $request_url, $request_url_info, $anchor_info, $module_list );
				
				if ($non_sef_url)
				{
					$new_url_info = array(	'new_url' => $non_sef_url, 'action' => NUSEO_ACTION_EXECUTE );
				}
				else
				{	// else, it was not a SEF URL, see if it is translatable non-SEF
					$is_GET_request = isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET');
					
					if ($is_GET_request)
					{
						$sef_url = nuseo_translate_url_to_sef( $request_url, $request_url_info, $anchor_info, $module_list );
						
						if ($sef_url)
						{
							$new_url_info = array(	'new_url' => $sef_url, 'action' => NUSEO_ACTION_REDIRECT, 
											'host' => (!empty( $request_url_info['host'] ) ? $request_url_info['host'] : '') );
						}
					}
				}
			} // if $url_ok
		}
		else	// if URL is SEF, then redirect to its non-SEF counterpart.
		{
			// break url into parts, parse query string
			$url_ok = nuseo_set_reference_url( $request_url );
			if ($url_ok)
			{
				$request_url_info =& $nuseo['request_url_info']; 
				
				// translate URL
				$request_url_domain = $_SERVER['HTTP_HOST'];
				$module_list = nuseo_get_module_list_for_url( $request_url, $request_url_domain );
				
				// try converting to non-sef
				$anchor_info = false;
				$non_sef_url = nuseo_translate_url_to_non_sef( $request_url, $request_url_info, $anchor_info, $module_list );
				
				if ($non_sef_url)
				{	// found non-SEF translation, REDIRECT there.
					$new_url_info = array(	'new_url' => $non_sef_url, 'action' => NUSEO_ACTION_REDIRECT );
				}
			}
		} // else (if $step_count)
	} // if $nuseo_config['enabled']
	
	return $new_url_info;
}

// This function may be called multiple times.
function nuseo_shutdown()
{
	global $nuseo, $nuseo_config, $nuseo_cache;
	
	if ( !empty($nuseo['inited']) )
	{

		if ($nuseo_cache)
		{
			$nuseo_cache->shutdown();
			$nuseo_cache = false;
		}

		$nuseo['inited'] = false;
	}
}

// Initialization and Modules
function nuseo_load_defaults()
{
	global $nuseo, $nuseo_config;
	
	// defaults for when nuseo_config.php is empty/not-found
	if (!isset( $nuseo_config['enabled'] ))
	{
		$nuseo_config['enabled'] = false;
		$nuseo_config['base_url_path'] = '';
		$nuseo_config['url_commands_enabled'] = false;
	}
	
	// Defaults
	$nuseo['global_parser'] = true;
	$nuseo['use_ob_callback'] = true;		 // default to use ob_callback, some scripts may abort execution...
	$nuseo['redirect_to_url'] = '/redirect-to/?redirect=';
	$nuseo['timenow'] = time();
	$nuseo['empty_module'] = false;
	$nuseo['mode'] = 'load';
	$nuseo['nowload'] = rand(0,1000);
	$nuseo['prefetch'] = false;
	$nuseo['translation_log'] = '';
	$nuseo['module_extensions'] = array();
	$nuseo['step_count'] = nuseo_get_step_count();
}

function nuseo_initialize()
{
	global $nuseo, $nuseo_config, $nuseo_profile_output, $nuseo_core_time_in_script;
	
	// Parse and Execute URL Commands, if any
	if ($nuseo_config['url_commands_enabled'] && isset($_REQUEST['nuseo_cmds']))
	{
		$ip_allowed = false;
		if ( empty( $nuseo_config['url_commands_ip_list'] ) )
		{
			$ip_allowed = true;
		}
		else	// else, there is an ip list
		{
			if ( is_array( $nuseo_config['url_commands_ip_list'] ) )
			{
				$ip_allowed = in_array( $_SERVER['REMOTE_ADDR'], $nuseo_config['url_commands_ip_list'] );
			}
		}

		if ($ip_allowed)
		{
			$commands = explode( '.', strtolower($_REQUEST['nuseo_cmds']) );
			foreach ($commands as $cmd_iter)
			{
				switch ($cmd_iter)
				{
					case 'debug':
					case 'debug1':	$nuseo['debug_mode'] = true;
						$nuseo['debug_exit'] = true;
						break;
					
					case 'debug2':	$nuseo['debug_mode'] = true;	
						$nuseo['debug_exit'] = false;
						break;
					
					case 'db':		$nuseo['debug_db'] = true;
						break;
					
					case 'trans':	$nuseo['debug_translation'] = true;
						break;
						
					case 'test':	$nuseo['debug_trans_test']	= true; 
						break;
						
					case 'nonsef':	$nuseo['debug_nonsef']	= true;
						break;
					
					case 'prof':
						$nuseo['debug_profile'] = true;
						$nuseo_profile_output = '';
						$nuseo_core_time_in_script = 0;
						
						break;
				}
			}
		}
	}
	
	if ($nuseo['debug_mode']) { echo( "<style> .ns-debug-bold { font-weight: bold; color: red; font-size: 1.25em; } </style> <pre>" ); };
	
	// Load settings..
	$nuseo['base_scheme']			= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']) ? 'https' : 'http';
	$http_host						= $_SERVER['HTTP_HOST'];
	$nuseo['base_host_and_port']	= $http_host;												// base_host_and_port => optionally includes port
	
	$port_pos = strpos( $http_host, ':' );
	$nuseo['base_host']	= $port_pos ? substr( $http_host, 0, $port_pos ) : $http_host;			// base_host => host name without port
	$nuseo['base_port']	= $port_pos ? substr( $http_host, $port_pos+1, $port_pos ) : $_SERVER['SERVER_PORT'];			// base_host => host name without port
	
	$nuseo['base_url_path'] = $nuseo_config[ 'base_url_path' ];
	
	$nuseo['base_dir'] = realpath( $nuseo_config[ 'dir' ]. "/.." );
	
	$nuseo['base_url'] = $nuseo['base_scheme'] . '://' . $nuseo['base_host_and_port'] . $nuseo['base_url_path'];			// HTTP_HOST includes port.
	
	// per-subdomain directory prefix and or directory index.php
	if ($nuseo['rel_request_url'] != $nuseo['virtual_rel_request_url'])
	{
		$virtual_query_pos = strpos( $nuseo['virtual_rel_request_url'], '?' );
		if ($virtual_query_pos !== false)
		{	// virtual = '/hello/?param=value' and rel = '/forums/hello/index.php?param=value'
			$clean_virtual_url = substr( $nuseo['virtual_rel_request_url'], 0, $virtual_query_pos );
		}
		else
		{
			$clean_virtual_url = $nuseo['virtual_rel_request_url'];
		}

		$rel_url_pos = strpos( $nuseo['rel_request_url'], $clean_virtual_url );
		if ($rel_url_pos !== false)
		{
			while ($rel_url_pos !== false)
			{
				$last_rel_url_pos = $rel_url_pos;
				$rel_url_pos = strpos( $nuseo['rel_request_url'], $clean_virtual_url, $last_rel_url_pos+1 );
			}
			$nuseo['subdomain_dir'] = substr( $nuseo['rel_request_url'], 0, $last_rel_url_pos );
		}
		else
		{
			$nuseo['subdomain_dir'] = false;
		}
	}
	else
	{
		$nuseo['subdomain_dir'] = false;
	}
	
	// Pre-process options
	if ( !isset($nuseo_config[ 'stopwords' ]) || !is_array($nuseo_config[ 'stopwords' ]) )
		$nuseo_config['stopwords'] = array();
	$nuseo_config['stopwords_and_empty'] = $nuseo_config['stopwords'];
	$nuseo_config['stopwords_and_empty'][] = '';					// remove empty words
	
	if ( !isset($nuseo_config[ 'add_nofollow_whitelist' ]) || !is_array($nuseo_config[ 'add_nofollow_whitelist' ]) )
		$nuseo_config[ 'add_nofollow_whitelist' ] = array();
	
	if ( !isset($nuseo_config[ 'add_nofollow_blacklist' ]) || !is_array($nuseo_config[ 'add_nofollow_blacklist' ]) )
		$nuseo_config[ 'add_nofollow_blacklist' ] = array();
	
	if ( !isset($nuseo_config[ 'add_nofollow_internal_urls' ]) || !is_array($nuseo_config[ 'add_nofollow_internal_urls' ]) )
		$nuseo_config['add_nofollow_internal_urls'] = array();
	
	if ( !isset($nuseo_config[ 'special_chars_map' ]) || !is_array($nuseo_config[ 'special_chars_map' ]) )
		$nuseo_config['special_chars_map'] = array();
	
	// Custom redirects
	if ( isset( $nuseo_config[ 'custom_redirects' ] ) && is_array( $nuseo_config[ 'custom_redirects' ] ) )
	{
		nuseo_sanitize_rewrite_rules( $nuseo_config[ 'custom_redirects' ] );
	}
	else
	{
		$nuseo_config['custom_redirects'] = array();
	}
	
	// Custom rewrite rules
	if ( isset( $nuseo_config[ 'custom_rewrite_rules' ] ) && is_array($nuseo_config[ 'custom_rewrite_rules' ]))
	{
		nuseo_sanitize_rewrite_rules( $nuseo_config[ 'custom_rewrite_rules' ] );
	}
	else
	{
		$nuseo_config['custom_rewrite_rules'] = array();
	}
	
	// Custom path blacklist
	if ( isset( $nuseo_config[ 'custom_path_blacklist' ] ) && is_array($nuseo_config[ 'custom_path_blacklist' ]))
	{	// make a copy, since modules can add to this list.
		$nuseo_config['runtime_path_blacklist'] = $nuseo_config[ 'custom_path_blacklist' ];
	}
	else
	{
		$nuseo_config['runtime_path_blacklist'] = array();
	}

	if ( !isset($nuseo_config[ 'base_domain_list' ]) || !is_array($nuseo_config[ 'base_domain_list' ]) )
		$nuseo_config['base_domain_list'] = array();

	if ($nuseo['debug_db'])
		$nuseo['query_log'] = array();
    
    //metatags and descriptions    
    $nuseo['meta_keywords_source'] = '';
    $nuseo['meta_description'] = '';       
	$nuseo['meta_description_length'] = 0; 
	

	// Instantiate $nuseo_cache singleton
	nuseo_get_cache_object();


	$nuseo['inited'] = true;
}

function nuseo_get_modules_files()
{
	global $nuseo, $nuseo_config;
	
	$result = array();
	
	//get module files from the debug folders
	
	$module_directory = $nuseo_config[ 'dir' ] . "/modules/";
	
	
	foreach (glob("$module_directory*.php") as $filename ) 
	{
		$matches = false;
		if ( preg_match('#^(?:.*)nuseo_(.*).php$#i', $filename, $matches ) )
		{
			$module_name = $matches[ 1 ];
			
			//skip debug modules
			if ( !preg_match('#^(.*)_d$#i', $module_name, $matches ) )
			{
				$result[ $module_name ] = $filename;
				//nu_print( "release module file found: $filename\n" );
			}
		}
	}
	
	
	//get module files from the debug folders
	
	$module_directory = $nuseo_config[ 'dir' ] . "/modules/";
	
	foreach( glob("$module_directory*_d.php") as $filename )
	{
		$matches = false;
		if ( preg_match('#^(?:.*)nuseo_(.*)_d.php$#i', $filename, $matches ) )
		{
			$module_name = $matches[ 1 ];
			if ($nuseo['debug_mode']) { echo( "debug module file found: $filename\n" ); };
			
			
			if ( array_key_exists( $module_name, $result ) )
			{
				if ($nuseo['debug_mode']) { echo( "debug module taking precedence over release module: " . $filename ); };
			}
			
			$result[ $module_name ] = $filename;
			
		}
	}
	
	return $result;
}

function nuseo_load_modules()
{
	global $nuseo, $nuseo_config, $nuseo_cache;
	
	$nuseo['modules'] = array();
	
	
	$module_files = nuseo_get_modules_files();
	
	//TODO: change it so we can load debug and non-debug modules 
	//$module_directory = $nuseo_config[ 'dir' ] . "/modules/";
	
	if ($nuseo['debug_mode']) { echo( "Loading Modules....\n" ); };
	
	foreach( $module_files as $key => $file )
	{
		$module_name = strtolower( $key );
		
		// check if this module is enabled
		$module_enabled_key = $module_name . "_enabled";
		if (!isset( $nuseo_config[ $module_enabled_key ] ) || !$nuseo_config[ $module_enabled_key ])
		{
			if ($nuseo['debug_mode']) { echo( "\tSkipping disabled module: $file\n" ); };
			continue;
		}
		
		if ($nuseo['debug_mode']) { echo( "\tLoading Module: $file\n" ); };
		
		// Load module
		include $file;

		// Initialize module
		$module = array( 
				// module info
				'name'					=> $module_name, 
				'url_base'				=> false,
				'domain_override'		=> false,
				'domain_override_list'	=> false,
				'sef_url_base_list'		=> false,
				'url_base_list'			=> false,
				'url_base_len_list'		=> false,
				'active_url_base'		=> false,
				'active_url_base_len'	=> false,
				'rules'					=> false,
				'global_parser' 		=> true,
				'rules_inited'			=> false,
				'processor_inited'		=> false,
				'is_extension'			=> false,
				'parent_module'			=> false,
				'db_conn'				=> false,
				
				// module handlers
				'module_load'			=> "nuseo_{$module_name}_load",
				'module_init_rules'		=> "nuseo_{$module_name}_init_rules",
				'module_init_processor'	=> "nuseo_{$module_name}_init_processor",
				'module_from_sef'		=> "nuseo_{$module_name}_from_sef",
				'module_connect_to_db'	=> "nuseo_{$module_name}_connect_to_db",
				'module_get_content_variables' => "nuseo_{$module_name}_get_content_variables",
				'module_loading_script'	=> "nuseo_{$module_name}_loading_script"
				);
		
		if (nuseo_initialize_module( $module ))		
		{
			$nuseo['modules'][ $module_name ] = $module;			// if module initialized, store it.
			$GLOBALS['nuseo_' . $module_name ] =& $nuseo['modules'][ $module_name ];		// use GLOBALS to assign reference in global scope.
		}
		else
		{
			unset( $module );						// invalid module. unload.
		}
	}
	if ($nuseo['debug_mode']) { echo( "\n" ); };
}

function nuseo_initialize_module( &$module )
{
	global $nuseo, $nuseo_config;
	
	if (!function_exists( $module['module_load'] ))
		$module['module_load'] = false;
	
	if (!function_exists( $module['module_init_rules'] ))
		$module['module_init_rules'] = false;
	
	if (!function_exists( $module['module_init_processor'] ))
		$module['module_init_processor'] = false;
	
	if (!function_exists( $module['module_from_sef'] ))
		$module['module_from_sef'] = false;
	
	if (!function_exists( $module['module_connect_to_db'] ))
		$module['module_connect_to_db'] = false;
	
	if (!function_exists( $module['module_get_content_variables'] ))
		$module['module_get_content_variables'] = false;        
	
	if (!function_exists( $module['module_loading_script'] ))
		$module['module_loading_script'] = false;        
	
	if (!$module['module_load'])
		return false;	
	
	// Initialize module
	$module['module_load']( $module );
	
	// Check URL Base for this module
	$module['url_base_list'] = array();
	$module['url_base_len_list'] = array();
	
	if ($module['url_base'])
	{
		if ($module['url_base'][0] != '/')							// make sure that url_base starts in /
			$module['url_base'] = '/' . $module['url_base'];

		if (substr( $module['url_base'], -1, 1 ) != '/')			// make sure that url_base ends in /
			$module['url_base'] .= '/';
		
		$module['url_base_list'][] = $module['url_base'];
		$module['url_base_len_list'][] = strlen( $module['url_base'] );
	}
	else
	{
		$module['url_base'] = '';
		$module['url_base_len'] = 0;
	}
	
	// check additional SEF URL Base paths for this module
	if ($module['sef_url_base_list'] || is_array($module['sef_url_base_list']) )
	{
		foreach ($module['sef_url_base_list'] as $key => $url_base)
		{
			if ($url_base[0] != '/')						// make sure that url_base starts in /
				$url_base = '/' . $url_base;

			if (substr( $url_base, -1, 1 ) != '/')			// make sure that url_base ends in /
				$url_base .= '/';
			
			$module['url_base_list'][] = $url_base;
			$module['url_base_len_list'][] = strlen( $url_base );
		}
	}
	
	return true;
}

function nuseo_sanitize_rewrite_rules( &$rules )
{
	if ($rules && is_array( $rules ))
	{
		foreach ($rules as $key => $value )
		{
			$rule =& $rules[ $key ];
			
			if (is_array( $rule ))		// then we have a full rule definition
			{
				if (isset( $rule['non_sef_pattern'] ))
					$rule['non_sef_pattern'] = '#^' . str_replace( '(.*)', '([^\/]*)', $rule['non_sef_pattern'] ) . '#i';
				else
					$rule['non_sef_pattern'] = false;
				
				if (isset( $rule['sef_pattern'] ))
					$rule['sef_pattern'] = '#^' . str_replace( '(.*)', '([^\/]*)', $rule['sef_pattern'] ) . '#i';
				else
					$rule['sef_pattern'] = false;
			}
			else
			{	// else rule was defined as 'showthread.php?t=$1' => 'thread-$1.html'
				$non_sef_pattern	= preg_replace( '#(\\\\\$[0-9]+)#', '(.*)', preg_quote($key) );
				$sef_pattern		= preg_replace( '#(\\\\\$[0-9]+)#', '(.*)', preg_quote($value) );
				
				$non_sef_pattern	= str_replace( '(.*)', '([^\/]*)', $non_sef_pattern );
				$sef_pattern		= str_replace( '(.*)', '([^\/]*)', $sef_pattern );
				
				$rule = array(
						
						'non_sef_pattern'	=> '#^' . $non_sef_pattern . '#i',
						'sef_target'		=> $value,
						
						'sef_pattern'		=> '#^' . $sef_pattern . '#i',
						'non_sef_target'	=> $key
						);
			}
			
		}
	}
	else	// else, empty rule set.
		$rules = array();
}

function nuseo_get_module_list_for_url( $url, $url_domain )
{
	global $nuseo, $nuseo_config;

	if ($nuseo['debug_mode']) { echo( "nuseo_get_module_list_for_url($url_domain$url)\n" ); };
	$module_list = array();
	
	$matching_module_key = false;
	$max_url_base_len = 0;

	// check if domain matches core base domains	
	$nuseo_base_domain_list =& $nuseo_config['base_domain_list'];
	$matches_base_domains = false;
	if ( !empty($nuseo_base_domain_list) )
	{
		foreach( $nuseo_base_domain_list as $base_domain_iter )
		{
			if ($base_domain_iter)
			{
				$matches_base_domains = strcasecmp( $url_domain, $base_domain_iter ) == 0;
				if ($nuseo['debug_mode']) { echo( "\t\tTesting core domain @ {$base_domain_iter}...($matches_base_domains)\n" ); };
				if ($matches_base_domains)
				{
					break;
				}
			}
		}
	}
	else
	{
		$matches_base_domains = true;		// no base domains specified, assume a match always
	}

	foreach (array_keys($nuseo['modules']) as $module_name)
	{
		$module_iter =& $nuseo['modules'][ $module_name ];
		if (!$module_iter['url_base'])
			continue;

		// now check domains.
		$domains_match = false;
		if ($url_domain)
		{
			if ( !empty($module_iter['domain_override']) )
			{
				if (!empty( $module_iter['domain_override_list'] ))
				{
					foreach( $module_iter['domain_override_list'] as $domain_override_iter )
					{
						$domains_match = strcasecmp( $url_domain, $domain_override_iter ) == 0;
						if ($nuseo['debug_mode']) { echo( "\tTesting domain [$module_name] @ '{$domain_override_iter}...($domains_match)'\n" ); };
						if ($domains_match)
						{
							break;
						}
					}
				}
				else	// single domain override
				{
					$domains_match = strcasecmp( $url_domain, $module_iter['domain_override'] ) == 0;
					if ($nuseo['debug_mode']) { echo( "\tTesting domain [$module_name] @ '{$module_iter['domain_override']}...($domains_match)'\n" ); };
				}
			}
			else
			{	// no per-module domain override specified, inherit core base domain match
				$domains_match = $matches_base_domains;
			}
		}
		else
		{	// $url_domain is empty, assumed it matched.... This is an error.
			$domains_match = true;
		}
		
		if (!$domains_match)
			continue;

		// Domains matched, check url_base_list
		foreach ($module_iter['url_base_list'] as $url_base_key => $url_base)
		{
			if ($nuseo['debug_mode']) { echo( "\tTesting path [$module_name] @ '{$url_base}'\n" ); };
			if (strpos( $url, $url_base ) === 0)
			{
				$add_this_module = false;
				
				$url_base_len = $module_iter['url_base_len_list'][ $url_base_key ];
				if ($url_base_len > $max_url_base_len)
				{
					$module_list = array();
					$max_url_base_len = $url_base_len;
					
					$add_this_module = true;
				}
				else if ($url_base_len == $max_url_base_len)
					$add_this_module = true;
				
				if ($add_this_module)
				{
					$module_iter['active_url_base']		= $url_base;
					$module_iter['active_url_base_len']	= $url_base_len;
					$module_list[] =& $module_iter;
				}
			}
		} // for each url_base
	} // for each module
	
	if ($nuseo['debug_mode'])
	{
		if ($nuseo['debug_mode']) { echo( "\t... returning [" . count($module_list) . "] (" ); };
		foreach ($module_list as $module_iter)
			if ($nuseo['debug_mode']) { echo( $module_iter['name'] . ' ' ); };
		if ($nuseo['debug_mode']) { echo( ")\n\n" ); };
	}
	return $module_list;
}

function nuseo_register_module_extension( &$module, $parent_module_name )
{
	global $nuseo, $nuseo_config;
	
	if (!isset( $nuseo['module_extensions'][ $parent_module_name ] ))
		$nuseo['module_extensions'][ $parent_module_name ] = array();
	
	$nuseo['module_extensions'][ $parent_module_name ][] = $module['name'];
}
//

// URL and URL Action Functions
function nuseo_read_request_url()
{
	global $nuseo;
	
	$rel_request_url = false;					// this is the relative URI, with subdomain folder if any.
	$virtual_rel_request_url = false;			// this is the REQUEST_URI

	if (isset( $_SERVER['REQUEST_URI'] ))
	{
		$virtual_rel_request_url = $_SERVER['REQUEST_URI'];
	}

	if (isset( $_SERVER['QUERY_STRING'] ))
	{
		$query = $_SERVER['QUERY_STRING'];
		$url = (strpos( $query, "nuseourl=" ) === 0) ? substr( $query, strlen( "nuseourl=" ) ) : $query;
		
		// fix & => ?
		$first_param_pos = strpos( $url, '&' );
		if ($first_param_pos !== false)
			$url[ $first_param_pos ] = '?';
		$rel_request_url = $url;		
	}
	else
	{
		if (isset( $_REQUEST['nuseourl'] ))
		{
			$rel_request_url = $_REQUEST['nuseourl'];
		}
		else if ($virtual_rel_request_url)
		{
			$rel_request_url = $virtual_rel_request_url;
		}
		else if (isset( $_SERVER['SCRIPT_URL'] ))
		{
			$rel_request_url = $_SERVER['SCRIPT_URL'];
		}
	}

	if (!$rel_request_url || ($rel_request_url[0] != '/'))
	{
		$rel_request_url = '/' . $rel_request_url;
	}

	if (!$virtual_rel_request_url)
	{
		$virtual_rel_request_url = $rel_request_url;
	}

	$nuseo['rel_request_url']			= $rel_request_url;	
	$nuseo['virtual_rel_request_url']	= $virtual_rel_request_url;	
}

function nuseo_set_reference_url( $request_url )
{
	global $nuseo, $nuseo_config;
	$request_url_info = nuseo_parse_url( $request_url, true, true );
	
	if ($request_url_info)
	{
		$nuseo['request_url_info'] =& $request_url_info; 
		
		if ($nuseo['debug_mode']) { print_r( $request_url_info ); };
		if ($nuseo['debug_mode']) { echo( "\n" ); };

		$request_path_parts = explode( '/', $request_url_info[ 'path' ] );
		array_pop( $request_path_parts );
		
		$nuseo[ 'request_path_base' ] = implode( '/', $request_path_parts );
		$nuseo['base_href'] = '';
		$nuseo['base_href_path'] = '';
	}
	return $request_url_info != false;
}

function nuseo_process_custom_redirects( &$request_url )
{
	global $nuseo, $nuseo_config;
	
	if (empty( $nuseo_config['custom_redirects'] ))
		return;
	
	$redirect_to = false;
	foreach ($nuseo_config['custom_redirects'] as $rule)
	{
		if (!isset( $rule['non_sef_pattern'] ) || !isset( $rule['sef_target'] ))
			continue;
		if (preg_match( $rule['non_sef_pattern'], $request_url ))	// found it
		{
			$redirect_to = preg_replace( $rule['non_sef_pattern'], $rule['sef_target'], $request_url );
			break;
		}
	}
	
	if ($redirect_to)
	{
		nuseo_redirect_to( $redirect_to );
		exit;
	}
}

function nuseo_process_path_blacklist( &$request_url )
{
	global $nuseo, $nuseo_config;
	
	if (empty( $nuseo_config['runtime_path_blacklist'] ))
		return;
	
	$is_in_black_list = false;
	foreach ($nuseo_config['runtime_path_blacklist'] as $path_iter)
	{
		if ($path_iter && (strpos( $request_url, $path_iter ) === 0))
		{
			$is_in_black_list = true;
			break;
		}
	}
	
	if ($is_in_black_list)
	{
		if ($nuseo['debug_mode']) { echo( "\nURL (" . $request_url . ") is in custom path blacklist ($path_iter)\n\n" ); };
		$nuseo_config['enabled'] = false;
	}
}

function nuseo_execute_url_action( &$new_url_info )
{
	global $nuseo, $nuseo_config;
	
	// Split URL and get script and query parts
	$new_url = $new_url_info['new_url'];
	
	$new_url_action = $new_url_info['action'];

	// if we are including the requested URL, then get the translated filename from $_SERVER	
	if ($new_url_action == NUSEO_ACTION_EXECUTE)
	{
		if ($new_url == $nuseo['virtual_rel_request_url'])
		{
			$new_url = $nuseo['rel_request_url'];
		}
	}

	// break new url into script + query
	$query_pos = strpos( $new_url, '?' );
	if ($query_pos === false)
		$query_pos = strpos( $new_url, '&' );
	if ($query_pos !== false)
	{
		$new_script_name = substr( $new_url, 0, $query_pos );
		$new_query_params = str_replace( '?', '&', substr( $new_url, $query_pos + 1 ) );		// fix ? => &
		$new_url = $new_script_name . '?' . $new_query_params;
	}
	else
	{
		$new_script_name = $new_url;
		$new_query_params = '';
	}
	
	if (!empty( $new_url_info['host'] ) && ($new_url_info['host'] != $nuseo['base_host']))
	{
		$new_full_url	= 'http://' . $new_url_info['host'] . $new_url;		// http://www.site.com/forums/forumdisplay.php?f=220
	}
	else
	{
		$new_full_url	= $nuseo['base_url'] . $new_url;					// http://www.site.com/forums/forumdisplay.php?f=220
	}

	// See if we have to redirect
	if ($new_url_action == NUSEO_ACTION_REDIRECT)
	{
		if ($nuseo['debug_mode'])
		{
			nuseo_shutdown();
			if ($nuseo['debug_mode']) { echo( "Redirecting to $new_full_url\n" ); };
			exit;
		}
		
		nuseo_redirect_to( $new_full_url );
		exit;
	}
	
	// set up vars
	//if ($nuseo['rel_request_url'] != $nuseo['virtual_rel_request_url'])

	if (!$new_script_name || (substr($new_script_name, -1, 1) == '/'))
	{
		$new_script_name .= 'index.php';		// if we got a /, then rewrite to index.php, subdomain .htaccess logic would stop normal behavior
	}

	$new_script_uri			= $nuseo['base_url'] . $new_script_name;			// http://site.com/forums/forumdisplay.php
	
	if (!empty($nuseo['subdomain_dir']))
	{	// then this URI is in a subdomain, and we have a sub-domain prefix directory.
		$new_script_url			= $nuseo['base_url_path'] . $nuseo['subdomain_dir'] . $new_script_name;		// /forums/forumdisplay.php
		$new_script_filename	= $nuseo['base_dir'] . $nuseo['subdomain_dir'] . $new_script_name;			// /home/site.com/public_html/forums/forumdisplay.php
	}
	else
	{
		$new_script_url			= $nuseo['base_url_path'] . $new_script_name;	// /forums/forumdisplay.php
		$new_script_filename	= $nuseo['base_dir'] . $new_script_name;		// /home/site.com/public_html/forums/forumdisplay.php
	}
	
	$new_request_uri		= $nuseo['base_url_path'] . $new_url;				// /forums/forumdisplay.php?f=220
	
	
	
	if ($nuseo['debug_mode'])
	{
		if ($nuseo['debug_mode']) { echo( "new_script_name = $new_script_name\n" ); };
		if ($nuseo['debug_mode']) { echo( "new_script_filename = $new_script_filename\n" ); };
		if ($nuseo['debug_mode']) { echo( "new_query_params = $new_query_params\n" ); };
	}
	
	// Get file absolute location.
	
	// Setup environment
	$_SERVER['SCRIPT_URL']		= $new_script_url;							// /forums/forumdisplay.php
	$_SERVER['SCRIPT_URI']		= $new_script_uri;							// http://www.site.com/forums/forumdisplay.php
	
	$_SERVER['SCRIPT_FILENAME']	= $new_script_filename;						// /home/site.com/public_html/forums/forumdisplay.php
	
	$_SERVER['SCRIPT_NAME']		= $new_script_url;							// /forums/forumdisplay.php
	$_SERVER['PHP_SELF']		= $new_script_url;							// /forums/forumdisplay.php
	
	$_SERVER['QUERY_STRING']	= $new_query_params;
	$_SERVER['REQUEST_URI']		= $new_request_uri;							// /forums/forumdisplay.php?f=220
	
	//putenv( "SCRIPT_FILENAME=$new_script_filename");
	//putenv( "SCRIPT_NAME=$new_script_url");
	//putenv( "PHP_SELF=$new_script_url");
	
	unset( $_SERVER['REDIRECT_SCRIPT_URL'] );
	unset( $_SERVER['REDIRECT_SCRIPT_URI'] );
	unset( $_SERVER['REDIRECT_STATUS'] );
	unset( $_SERVER['REDIRECT_QUERY_STRING'] );
	unset( $_SERVER['REDIRECT_URL'] );
	
	// Fill $_REQUEST
	$_GET = array();
	parse_str( $new_query_params, $_GET );
	
	// make sure we don't have any of our global variable names in a query param. Called software (e.g. vBulletin) may overwrite them.	
	unset( $_GET['nuseo'],		$_GET['nuseo_config'],		$_GET['nuseourl'] );
	unset( $_REQUEST['nuseo'],	$_REQUEST['nuseo_config'],	$_REQUEST['nuseourl'] );
	
	$_REQUEST = array_merge( $_REQUEST, $_GET );
	
	return $new_script_filename;
}
//

// URL Translation
function nuseo_url_to_sef( $url )
{
	global $nuseo, $nuseo_config;
	
	$url_info = nuseo_parse_url( $url, true, true );
	$anchor_info = false;
	$module_list = false;
	$sef_url = nuseo_translate_url_to_sef( $url_info['path_plus_query'], $url_info, $anchor_info, $module_list );
	
	$sef_url = $nuseo['base_url'] . $sef_url;
	return $sef_url;
}

function nuseo_translate_url_to_sef( $url, &$url_info, &$anchor_info, &$module_list )
{
	global $nuseo, $nuseo_config;
	
	$sef_url = false;
	
	if ($nuseo['debug_mode']) { echo( "\n\nnuseo_translate_url_to_sef. url = $url ($module_list)\n" ); };
	
	// Get module list for this URL
	if (empty($module_list))
	{
		$url_domain = ( !empty( $url_info ) && !empty( $url_info['host'] ) ) ? $url_info['host'] : false;
		$module_list = nuseo_get_module_list_for_url( $url, $url_domain );
		
		if (!empty($module_list))
			if ($nuseo['debug_mode']) { echo( "\tfound module for this url...\n" ); };
	}
	
	if (!empty($module_list))
	{
		$sef_url = nuseo_execute_modules_rules( $url, $url_info, $anchor_info, $module_list, 
				'non_sef_pattern', 'sef_target', 'translate_to_sef' );
	}
	
	if (!$sef_url)		// try global rewrite rules
	{
		$global_module = array();
		$sef_url = nuseo_execute_translation_rules( $nuseo_config['custom_rewrite_rules'], $url, $url_info, $anchor_info, $global_module, 
				'non_sef_pattern', 'sef_target', 'translate_to_sef' );
	}
	
	return $sef_url;
}

function nuseo_translate_url_to_non_sef( $url, &$url_info, &$anchor_info, &$module_list )
{
	global $nuseo, $nuseo_config;

	$non_sef_url = false;
	
	if ($nuseo['debug_mode']) { echo( "\n\nnuseo_translate_url_to_non_sef( '$url' )\n" ); };
	
	// Get module list for this URL
	if (!$module_list)
	{
		$url_domain = ( !empty( $url_info ) && !empty( $url_info['host'] ) ) ? $url_info['host'] : false;
		$module_list = nuseo_get_module_list_for_url( $url, $url_domain );
		
		if (!empty($module_list))
			if ($nuseo['debug_mode']) { echo( "\tfound module for this url...\n" ); };
	}
	
	if (!empty($module_list))
	{
		//nu_print_r( $module_list );

		$non_sef_url = nuseo_execute_modules_rules( $url, $url_info, $anchor_info, $module_list, 'sef_pattern', 'non_sef_target', 
				'translate_to_non_sef' );
		
		// check if this is a callback powered sef url
		if ( !$non_sef_url )
			$non_sef_url = nuseo_execute_modules_from_sef( $module_list, $url, $url_info, $anchor_info );
	}
	
	if (!$non_sef_url)		// try global rewrite rules
	{
		$global_module = array();
		$non_sef_url = nuseo_execute_translation_rules( $nuseo_config['custom_rewrite_rules'], $url, $url_info, $anchor_info, $global_module, 
				'sef_pattern', 'non_sef_target', 'translate_to_non_sef' );
	}
	return $non_sef_url;
}

function nuseo_execute_modules_rules( $url, &$url_info, &$anchor_info, &$module_list, $pattern_key, $replacement_key, $callback_key )
{
	global $nuseo, $nuseo_config;

	if ($nuseo['debug_mode']) { echo( "nuseo_execute_modules_rules( '$url' )\n" ); };
	$ret_url = false;
	
	foreach (array_keys($module_list) as $module_name)
	{
		$module =& $module_list[ $module_name ];
		if (!$module['rules_inited'] && $module['module_init_rules'])
		{
			if ($nuseo['debug_mode']) { echo( "\n\t" . $module['module_init_rules'] . "()\n" ); };
			
			// Init Module Rules
			$module['module_init_rules']( $module );
			
			// Sanitize Module Rules
			if ($module['rules'])
				nuseo_sanitize_rewrite_rules( $module['rules'] );
			$module['rules_inited'] = true;
		}
		
		if (!$module['processor_inited'] && $module['module_init_processor'] && ($nuseo['mode'] == 'process'))
		{
			if ($nuseo['debug_mode']) { echo( "\t" . $module['module_init_processor'] . "()\n" ); };
			$module['module_init_processor']( $module );
			
			$module['processor_inited'] = true;
		}
		
		if ($module['rules'])
		{
			$ret_url = nuseo_execute_translation_rules( $module['rules'], $url, $url_info, $anchor_info, $module, 
					$pattern_key, $replacement_key, $callback_key );
			
			if ($ret_url)
			{	// then URL was translated by this module, stop now.
				break;
			}
		}
	}
	return $ret_url;
}

function nuseo_execute_translation_rules( &$rules, $url, &$url_info, &$anchor_info, &$module, 
	$pattern_key, $replacement_key, $callback_key )
{
	global $nuseo, $nuseo_config;
	
	$rel_url = (isset($module['active_url_base_len']) && $module['active_url_base_len'])  ? substr( $url, $module['active_url_base_len'] ) : $url;
	
	if ($nuseo['debug_mode']) { echo( "\tnuseo_execute_translation_rules(), rel_url = '$rel_url'\n" ); };
	
	$rel_url_base = $module ? $module['url_base'] : '';		// use modules main' url_base always.
	
	$translated_url = false;
	
	$process_absolute_patterns = true;
	
	foreach ($rules as $rule)
	{
		$is_pattern_defined = isset( $rule[ $pattern_key ] ) && $rule[ $pattern_key ];
		
		$matches = false;
		if ($is_pattern_defined)
		{
			if ($nuseo['debug_mode']) { echo( "\tTesting $pattern_key = '{$rule[$pattern_key]}'\n" ); };
			
			if (isset( $rule[ $pattern_key . "_is_absolute" ] ) && $rule[ $pattern_key . "_is_absolute" ] )
			{	// then preg pattern is absolute
				if ($process_absolute_patterns)
				{
					$is_a_match = preg_match( $rule[ $pattern_key ], $url, $matches );
				}
				else
				{	// else, this is an absolute pattern, but we previously matched an absolute pattern, so we only want to check relative ones.
					$is_a_match = false;
				}
				$is_absolute_pattern = true;
			}
			else 
			{	// relative pattern
				$is_a_match = preg_match( $rule[ $pattern_key ], $rel_url, $matches );
				$is_absolute_pattern = false;
			}
		}
		else
			$is_a_match = false;
		
		if ( $is_pattern_defined && $is_a_match )
		{	// found a match, convert it.
			
			if ($nuseo['debug_mode']) { echo( "<b>Matched $pattern_key URL.</b>\n" ); };
			
			if ( isset( $rule[ $replacement_key ] ) )
			{
				$sef_url = preg_replace( $rule[ $pattern_key ], $rule[ $replacement_key ], $rel_url );
				
				$sef_url = str_replace( array( '/&amp;', '/&' ), '/?', $sef_url );
				
				$translated_url =  $rel_url_base . $sef_url;
			}
			else if ( isset( $rule[ $callback_key ] ) && $rule[ $callback_key ] )
			{
				// check if the rule callback requires custom args
				if (isset( $rule[ $callback_key . "_args" ] ))
				{
					$matches = array_merge( $matches, $rule[ $callback_key . "_args" ] );
				}
				if ($nuseo['debug_mode']) { echo( "Rule:\n" ); };
				if ($nuseo['debug_mode']) { print_r( $rule ); };
				if ($nuseo['debug_mode']) { echo( "RegEx Matches:\n" ); };
				if ($nuseo['debug_mode']) { print_r( $matches ); };
				if ($nuseo['debug_mode']) { echo( "\tcalling $callback_key:  {$rule[ $callback_key ]}\n" ); };

				// Call rule callback
				$sef_url = $rule[ $callback_key ]( $module, $rel_url, $url_info, $matches, $anchor_info );

				if ($sef_url !== false)
				{
					$translated_url = nuseo_rebuild_translated_url( $sef_url, $rel_url_base, $url_info );
				} // if callback returned something, either a translated URL or true.
			}
			else
			{	// else, this rule was matched, but it is not configured properly.
				//$translated_url = false;		// do not overwrite this, it may be a second pass on this same loop.
			}
			
			if ($is_absolute_pattern)
			{
				$process_absolute_patterns = false;		// we already matched an absolute pattern, skip the rest.
			}
			else
			{	// if pattern was standard (relative), then stop. If it was absolute, continue loop.
				break;		// we found a pattern match, we stop processing here, one way or another.
			}
		} // if is_a_match
	}	// foreach rule
	
	if ($nuseo['mode'] == 'load')
	{
		if ($translated_url)			// then init nuseo global settings from this module
		{
			$nuseo['global_parser']		= $module['global_parser'];
			if (!empty( $module['domain_override'] ))
			{
				$nuseo['base_href']			= 'http://' . $module['domain_override'] . $module['url_base'];
				$nuseo['base_href_host']	= $module['domain_override'];
			}
			else
			{
				$nuseo['base_href']			= $nuseo['base_url']		. $module['url_base'];
			}
			$nuseo['base_href_path']		= $nuseo['base_url_path']	. $module['url_base'];
		}
		else
		{
			if (isset($module['module_loading_script']) && $module['module_loading_script'])
			{	// give script a chance to init script-specific settings (e.g. global_parser)
				$module['module_loading_script']( $module, $rel_url, $url_info );
			}
		}
	}
	return $translated_url;
}

function nuseo_rebuild_translated_url( $sef_url, $rel_url_base, &$url_info )
{
	global $nuseo, $nuseo_config;

	if ($sef_url === true)		// then this call was interrupted due to a prefetch request
	{
		$translated_url = true;
	}
	else
	{
		if (!$sef_url || ($sef_url[0] != '/'))		// only add the url_base if the returned path was not absolute
			$sef_url = $rel_url_base . $sef_url;

		if (isset( $url_info['query_params'] ))
		{
			/*if ($nuseo_config['url_commands_enabled'])
			{
				if (isset($_REQUEST['nuseo_cmds']))
					$url_info['query_params']['nuseo_cmds'] = $_REQUEST['nuseo_cmds'];
			}*/
			
			$query_str = nuseo_build_query( $url_info['query_params'] );
			if ($query_str)
				$sef_url .= '?' . $query_str;
		}
		
		if ( isset( $url_info['fragment'] ) && $url_info['fragment'] )
			$sef_url .= '#' . $url_info['fragment'];
		
		$translated_url = $sef_url;
	}

	return $translated_url;
}

function nuseo_execute_modules_from_sef( &$module_list, &$url, &$url_info, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	$translated_url = false;
	
	foreach (array_keys($module_list) as $module_name)
	{
		$module =& $module_list[ $module_name ];
		if ($module['module_from_sef'])
		{
			$rel_url = $module['active_url_base_len'] ? substr( $url, $module['active_url_base_len'] ) : $url; 
			
			if ($nuseo['debug_mode']) { echo( "\t" . $module['module_from_sef'] . "()\n" ); };
			$non_sef_url = $module['module_from_sef']( $module, $rel_url, $url_info, $anchor_info );
			
			if ($non_sef_url !== false)
			{
				$translated_url = nuseo_rebuild_translated_url( $non_sef_url, $module['url_base'], $url_info );
				break;
			} // if callback returned something, either a translated URL or true.	
		}
	}
	return $translated_url;
}
//

function nuseo_print_page_not_found()
{
	global $nuseo, $nuseo_config;
	
	if ($nuseo_config['log_enabled'] && $nuseo_config['log_404'])
	{
		nuseo_log_file_not_found( $nuseo['request_url'] );
	}
	
	if ($nuseo_config['file_not_found_handler'] == 'home')
	{
		nuseo_redirect_to( "http://" . $nuseo['base_host_and_port'] . "/", true );			// HTTP_HOST includes port
	}
	else
	{
		header("HTTP/1.0 404 Not Found");
		if (file_exists( $nuseo_config['file_not_found_handler'] ))
			include $nuseo_config['file_not_found_handler'];
		else
			print( "Page not found." );
	}
	exit;
}

function nuseo_redirect_to( $url, $use_301 = true )
{
	global $nuseo, $nuseo_config;
	
	nuseo_shutdown();

	if ($use_301 && $nuseo_config[ 'use_301_redirects' ])
		header( "Location: $url", true, 301 );
	else
		header( "Location: $url" );
	exit;
}

// Buffering and Parsing
function nuseo_ob_callback( $output )
{
	global $nuseo, $nuseo_config;
	
	if ($nuseo['debug_mode'])
	{
		if ($nuseo['debug_mode']) { echo( '<pre>' ); };
	}
	
	$skip_global_parser = isset( $nuseo['skip_global_parser'] ) && $nuseo['skip_global_parser'];
	if (!$skip_global_parser)
	{
		if (nuseo_is_response_html( $output ))
		{
			if ( $nuseo['debug_profile'] )
			{
				global $nuseo_profile_output, $nuseo_process_html_total_time;
				
				$nuseo_process_html_start_time = nu_microtime();
				nuseo_process_html( $output );
				$nuseo_process_html_total_time = nu_microtime() - $nuseo_process_html_start_time;
				
				$nuseo_profile_output .= "Html Processing time: " . $nuseo_process_html_total_time . "<br />";
			}
			else
			{
				nuseo_process_html( $output );
			}
		}
	}
	
	return $output;
}

function nuseo_get_variables_from_modules()
{
	global $nuseo;
	$result = array();
	
	foreach (array_keys($nuseo['modules']) as $module_name )
	{
		$module =& $nuseo['modules'][ $module_name ];
		if ( $module['module_get_content_variables'] )
		{
			$module['module_get_content_variables']( $module, $result );
		}
	}
	return $result;
}

function nuseo_replace_content_variables( &$module_variable_values )
{
	global $nuseo_config;
	
	$result = array();
	
	foreach( $nuseo_config[ 'global_content_replacement_list' ] as $key => $content_string )
	{
		
		foreach( $module_variable_values as $variable_name => $value )
		{
			$enclosed_variable = '[' . $variable_name .']';
			$content_string = str_ireplace( $enclosed_variable, $value, $content_string );
		}
		
		$result[ $key ] = $content_string;        
	}
	
	return $result;
}

function nuseo_do_global_content_replacement( &$content_replacement_array, &$output )
{
	$marks = array();
	foreach( $content_replacement_array as $mark => $value )
	{
		$marks[] = "<!--" . $mark . "-->";
	}
	$output = str_replace( $marks, array_values( $content_replacement_array ), $output );
}

function nuseo_process_html( &$output )
{
	global $nuseo, $nuseo_config;
	
	if (!$nuseo_config[ 'enabled' ])
	{
		return;
	}
	
	$nuseo['mode'] = 'process';
	
	// check if there is a base href tag
	$step_count = ($nuseo['step_count'] - $nuseo['timenow']) + $nuseo['nowload'];

	$existing_base_href = false;

	// Split output into anchor list
	if ($step_count)
	{
		//$pregsplit = '#(\<(?:a[^<>]+(?:"[^"]*"|\'[^\']*\')?)+>.*\</a[^<>]*>)#siU';
		//$pregsplit = '#(<a(?!.*nuseo_rel="ignore")[^<>]+>.*</a[^<>]*>)#siU';
		$pregsplit = '#(<a(?![^>]*nuseo_rel="ignore"[^>]*>)[^<>]+>.*</a[^<>]*>)#siU';
		
		nuseo_reset_db_for_existing_connections();
		
		$output_parts = preg_split( $pregsplit, $output, -1, PREG_SPLIT_DELIM_CAPTURE );
		$part_count = count( $output_parts );
		
		$existing_base_href = nuseo_get_base_href_from_html( $output_parts[ 0 ] );
		
		$nuseo['prefetch'] = true;						// if we need to go to the DB, cache the ids, so we can combine SQL queries
		$nuseo['phase2_anchor_infos'] = array();
		
		if ( $nuseo['debug_profile'] )
		{
			global $nuseo_profile_output;
			
			$nuseo_profile_output .= "Anchor Count: " . intval( $part_count / 2 ) . "<br />";
			
			$anchors_output = array();
			
			for ($i = 0; $i < $part_count; $i++)
			{
				$is_anchor = ($i % 2) != 0;
				if (!$is_anchor)
				{
					continue;
				}
				
				nuseo_process_anchor( $output_parts[ $i ], $i );
				$anchors_output[] .= $output_parts[ $i ];
			}
			
			$nuseo_profile_output .= "External Anchors: " . $nuseo_external_anchors . "<br />";
		}
		else
		{
			for ($i = 0; $i < $part_count; $i++)
			{
				$is_anchor = ($i % 2) != 0;
				if (!$is_anchor)
				{
					continue;
				}
				
				nuseo_process_anchor( $output_parts[ $i ], $i );
			}        
		}

		$nuseo['prefetch'] = false;
		
		// Do a fetch of all delayed SQL queries
		nuseo_cache_execute_prefetch();
		
		// Now iterate through any anchors for which processing was delayed (due to prefetch)
		nuseo_process_delayed_anchors( /*ref*/$output_parts );
		
		_db_print_r( $output_parts );
	}
	
	if ($step_count)
	{
		// add base href (only if there is no existing base href, only operate on first output_part
		if (!$existing_base_href && $nuseo['base_href'])
		{
			$output_parts[0] = str_replace( array('<head>', '<HEAD>'), 
												"<head>\n\t<base href=\"{$nuseo['base_href']}\" />", 
												$output_parts[0] );
		}

		if ( !isset($nuseo['meta_keywords']) && isset($nuseo['meta_keywords_source']) )
		{	// then generate keywords from the source text provided
			
			$keywords_source = strtr( $nuseo['meta_keywords_source'], "\r\n\t.,;:\"`[]{}*", "                    " );
			$keywords_words = preg_split( '#\s+#', $keywords_source );
			
			// remove stop words
			//if ($nuseo_config[ 'remove_stopwords_from_urls' ])
			{
				$keywords_words_clean = array_diff( $keywords_words, $nuseo_config['stopwords_and_empty'] );
				if (!empty( $keywords_words_clean ))
                {
					$keywords_words = $keywords_words_clean;
                }
				unset( $keywords_words_clean );
			}			
			
			$max_keyword_count = 25;
			if (count( $keywords_words ) > $max_keyword_count)
			{
				$keywords_words = array_slice( $keywords_words, 0, $max_keyword_count );
			}
			$keywords_words_str = implode( ',', $keywords_words );
			
			$nuseo['meta_keywords'] = $keywords_words_str;
		}
		
		if (isset( $nuseo['meta_keywords'] ))
		{
			$meta_keywords_find		= '#<meta\s*name="keywords"\s*content="([^\"\>]*)"\s*/>#si';
			$meta_keywords_replace	= '<meta name="keywords" content="' . $nuseo['meta_keywords'] . ',\1" />';
			
			if (preg_match( $meta_keywords_find, $output_parts[0] ))
				$output_parts[0] = preg_replace( $meta_keywords_find, $meta_keywords_replace, $output_parts[0] );
			else
			{	// there was no keywords meta tag, add a new one
				$new_head = "<head>\n<meta name=\"keywords\" content=\"" . $nuseo['meta_keywords'] . "\" />";
				$output_parts[0] = str_replace( '<head>', $new_head, $output_parts[0] );
			}
		}

		
		if ( !empty( $nuseo['meta_description'] ) )
		{
			$meta_description = trim($nuseo['meta_description']);
			if ($meta_description)
			{
				// truncate description if requested
				if ($nuseo['meta_description_length'] > 0)
				{
					$current_description_length = strlen( $meta_description );
					if ($current_description_length > $nuseo['meta_description_length'])
					{
						$pointer = $nuseo['meta_description_length'];
						while ($pointer > 0)
						{
							if ($meta_description[ $pointer ] == ' ')
							{
								break;
							}
							$pointer--;
						}
						if ($pointer <= 0)
							$pointer = $nuseo['meta_description_length'];

						$meta_description = substr( $meta_description, 0, $pointer );
					}
				}

				// insert description tag
				$meta_description_find		= '#<meta\s*name="description"\s*content="([^\"\>]*)"\s*/>#si';
				$meta_description_replace	= '<meta name="description" content="' . $meta_description . '" />';
				
				if (preg_match( $meta_description_find, $output_parts[0] ))
					$output_parts[0] = preg_replace( $meta_description_find, $meta_description_replace, $output_parts[0] );
				else
				{	// there was no description meta tag, add a new one
					$new_head = "<head>\n<meta name=\"description\" content=\"" . $meta_description . "\" />";
					$output_parts[0] = str_replace( '<head>', $new_head, $output_parts[0] );
				}
			}
		}
		
		// Add analytics code if enabled.
		if ($nuseo_config[ 'urchin_enabled' ] || $nuseo_config[ 'analytics_custom_code' ])
		{
			$analytics_code = $nuseo_config[ 'analytics_custom_code' ];
			
			if ($nuseo_config[ 'urchin_enabled' ] && $nuseo_config[ 'urchin_code' ])
			{
				$urching_account = $nuseo_config[ 'urchin_code' ];
				
				$is_secure = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on');
				
				$analytics_url = $is_secure ? 'https://ssl.google-analytics.com/urchin.js' 
					: 'http://www.google-analytics.com/urchin.js';
				
				$analytics_code .= <<<CODE
	<script src="$analytics_url" type="text/javascript"></script>
	<script type="text/javascript">
		_uacct = "$urching_account";
		urchinTracker();
	</script>	
CODE;
			} // if urchin enabled
			
			if ($analytics_code)
			{
				$output_parts[ $part_count - 1 ] = str_replace( '</body>', "$analytics_code\n</body>", $output_parts[ $part_count - 1 ] );
			}
		}

		// Done, put it back together
		$output = implode( '', $output_parts );
	}
	
	
	//global content replacement
	if ( $nuseo_config[ 'global_content_replacement_enabled' ] )
	{
		
		//get variables from modules
		$module_variable_values = nuseo_get_variables_from_modules();
		
		if ( !empty( $module_variable_values ) )
		{
			// replace array content with variables        
			$content_replacement_array = nuseo_replace_content_variables( $module_variable_values );
			
			if ( !empty( $content_replacement_array  ) )
			{
				// replace output marks
				nuseo_do_global_content_replacement( $content_replacement_array, $output );
			}
		}
	}
	
	if ($step_count != 2)
	{
		nuseo_insert_copyright_notice( $output );
	}
	
	if ($nuseo['debug_translation'] && $nuseo['translation_log'])
	{
		$translation_log = <<<HTML
		<div style="text-align: left; background: #FFFFFF; color: #000; padding: 15px; width: 100% ">
			<style>
				.nuseo-trans { color: #000; }
				.nuseo-trans td { padding: 5px; }
				.nuseo-trans .trans { background: #ffffc0; }
			</style>
			<table class="nuseo-trans" width="100%" border="1" cellspacing="0" cellpadding="0">
HTML;
		$translation_log .= $nuseo['translation_log'] ;
		$translation_log .= <<<HTML
			</table>
		</div>
HTML;
		$output = $translation_log . $output;
	}
	
	if ($nuseo['debug_db'])
	{
		$output .= "<pre style=\"color:black; text-align: left;\">";
		$output .= "<div style=\"font-weight:bold; margin-bottom: 10px; border-bottom: 1px solid red;\">
				NuSEO.PHP: " . count($nuseo['query_log']) . " queries executed. </div>\n";
		$output .= implode( "<br />\n", $nuseo['query_log'] );
		$output .= "</pre>";
	}
	
	// we are done, call shutdown here, in case script exits execution
	nuseo_shutdown();
}

function nuseo_set_seo_content( &$seo_items, $flags )
{
    global $nuseo, $nuseo_config;

    foreach( $seo_items as $seo_item )
    {
        $nuseo['meta_keywords_source'] .= ( $flags['do_keywords'] ) ? $seo_item[ 'keywords' ] : '';
        $nuseo['meta_description'] .= ( $flags['do_descriptions'] ) ? $seo_item[ 'description' ] : '';
    }
}

function nuseo_process_anchor( &$anchor, $anchor_index )
{
	global $nuseo, $nuseo_config, $nuseo_cache;
	
	_db_print( "processing... $anchor<br />\n" );
	
	if (!$anchor)
		return;		// empty anchor
	
	// Parse Anchor
	$attrs = false;
	$misc_attrs = false;
	$title = false;
	nuseo_parse_anchor( $anchor, /*ref out*/$attrs, /*ref out*/$misc_attrs, /*ref out*/$title );
	
	$href = isset( $attrs['href'] ) ? $attrs['href'] : '';
	if (!$href)
		return;		// empty link (bookmark)
	
	if ((strpos( $href, 'javascript:' ) === 0) || (strpos( $href, 'mailto:' ) === 0))
		return;		// javascript or mailto link, nothing to do.
	
	// parse href and convert into absolute.
	$href_info = nuseo_parse_url( $href, true, true );
	if (!$href_info)
		return;					// do not process this anchor.


    if ($nuseo_cache && !empty($nuseo_config['cache_anchor_processing']))
    {
        $anchor_cache_key = 'a' . $href_info['url'] . $title;
        $anchor_process_info = $nuseo_cache->get_array( $anchor_cache_key );

	    if (!empty( $anchor_process_info ))
	    {
		    if ($nuseo['debug_mode'])
		    {
			    if ($nuseo['debug_mode']) { echo( "Got process info for anchor '$anchor':\n" ); };
			    if ($nuseo['debug_mode']) { print_r( $anchor_process_info ); };
		    }
		    $modified	= $anchor_process_info['modified'];
		    if ($modified)
		    {
			    $href		= $anchor_process_info['href'];
			    $attrs		= $anchor_process_info['attrs'];
			    $misc_attrs	= $anchor_process_info['misc_attrs'];

			    if ($anchor_process_info['title'])
			    {
				    $title	= $anchor_process_info['title'];
			    }
		    }
		    if ($nuseo['debug_translation'])
		    {
				nuseo_log_translation( 'from-cache', $href_info['path_plus_query'], $attrs['href'] );
		    }
	    }
	    else
	    {
		    $original_title = $title;

		    $processed = false;
		    $modified = nuseo_process_anchor_ex( $href, $href_info, $attrs, $misc_attrs, $title, $processed, $anchor_index );

		    if ($processed)
		    {
			    if ($modified)
			    {
				    $anchor_process_info = array(	'modified'	=> $modified,
												    'href'		=> $href, 
												    'attrs'		=> $attrs, 
												    'misc_attrs'=> $misc_attrs, 
												    'title'		=> ($original_title  != $title) ? $title : false );
			    }
			    else
			    {
				    $anchor_process_info = array( 'modified' => $modified );
			    }
			    $nuseo_cache->add_array( $anchor_cache_key, $anchor_process_info, $nuseo_config['cache_timeout']  );

			    if ($nuseo['debug_translation'])
			    {
					nuseo_log_translation( 'add-to-cache', $href_info['path_plus_query'], $attrs['href'] );
			    }
		    }
	    }
    }
    else
    {
	    $processed = false;
	    $modified = nuseo_process_anchor_ex( $href, $href_info, $attrs, $misc_attrs, $title, $processed, $anchor_index );        
    }





	// rebuild anchor if needed
	if ($modified)
		$anchor = nuseo_rebuild_anchor( $attrs, $misc_attrs, $title );
		
	/*if ($nuseo['debug_translation'])
	{
		$nuseo['translation_log'] .= "<br />\n";
	}*/
}

function nuseo_process_anchor_ex( &$href, &$href_info, &$attrs, &$misc_attrs, &$title, &$processed, $anchor_index )
{
	global $nuseo, $nuseo_config;

	$processed = true;		// only set to false on phase 2 anchors
	$modified = false;
	
	$rel = isset( $attrs['rel'] ) ? $attrs['rel'] : '';

	// Determine if URL is internal
	$host = isset( $href_info['host'] ) ? strtolower( $href_info['host'] ) : false;
	
	if ($host && (strpos( $host, 'www.' ) === 0))
		$host = substr( $host, 4 );
	
	$is_internal = $host && (strpos( $nuseo['base_host'], $host ) !== false);			// FIXME
	
	if ($is_internal)
	{
		// translate href to SEF
		$module_list = false;
		
		$anchor_info = array( 'rel' => $rel, 'title' => $title );
		
		$sef_url = nuseo_translate_url_to_sef( $href_info['path_plus_query'], $href_info, $anchor_info, $module_list );
		
		if ($sef_url === true)		// then this URL requires DB prefetching, postpone processing for second pass.
		{
			$phase2_anchor_info = array( 'anchor_index' => $anchor_index, 'href_info' => $href_info,
					'attrs' => $attrs, 'misc_attrs' => $misc_attrs, 'title' => $title );
			$nuseo['phase2_anchor_infos'][] = $phase2_anchor_info;
			
			$processed = false;		// phase 2 anchor will be processed later.
		}
		else if ($sef_url)
		{
			nuseo_process_translated_url( $sef_url, $href_info, $anchor_info, $title, $rel );
			
			$attrs['href'] = htmlentities( $sef_url );
			$modified = true;
		}
		else
		{
			$translated_url_logged = false;
			$is_jump_to_bookmark = $attrs['href'][0] == '#';
			if ($nuseo_config[ 'use_absolute_urls' ] && $href_info['is_relative'] || $is_jump_to_bookmark)
			{
				if ($nuseo['debug_translation'])
				{
					nuseo_log_translation( 'to-abs', $attrs['href'], $href_info['url'] );
					$translated_url_logged = true;
				}
				
				$attrs['href'] = $href_info['url'];		// href_info['url'] contains the absolute version of this url.
				$modified = true;
			}
			
			if ($nuseo['debug_translation'] && !$translated_url_logged)
			{
				nuseo_log_translation( 'int-skip', $attrs['href'], '' );
			}
			
			// further processing for internal URLs
			if (!empty($nuseo_config['add_nofollow_internal_urls']))
			{
				foreach( $nuseo_config['add_nofollow_internal_urls'] as $internal_url_find )
				{
					if ($internal_url_find && (strpos(  $href_info['path_plus_query'], $internal_url_find ) === 0))
					{
						$rel = 'nofollow';
						$modified = true;
						break;
					}
				}	
			}
		}
	}
	else	// else, this is an external URL
	{
		if (is_array($nuseo_config['add_nofollow_blacklist']) && in_array( $host, $nuseo_config['add_nofollow_blacklist'] ))
		{	// then this url is in add_nofollow_blacklist, add nofollow regardless of the other settings.
			$rel = 'nofollow';
			$modified = true;
		}
		else if ($nuseo_config[ 'add_nofollow_to_external_links' ])
		{	// and we are adding nofollow to external urls, and url is not in whitelist
			if (!$nuseo_config['add_nofollow_whitelist'] || !is_array($nuseo_config['add_nofollow_whitelist'])
					|| !in_array( $host, $nuseo_config['add_nofollow_whitelist'] ))
			{
				$rel = 'nofollow';			// then add nofollow
				$modified = true;
			}
		}
		
		if ($nuseo_config[ 'urchin_enabled' ] && $nuseo_config[ 'urchin_track_outgoing' ] && $nuseo_config[ 'urchin_outgoing_format' ] 
				&& !isset(  $attrs['onclick'] ))
		{
			$track_url = $nuseo_config[ 'urchin_outgoing_format' ] . $href_info['host'];
			$attrs['onclick'] = "javascript:urchinTracker('$track_url');";
			$modified = true;
		}
		
		if ($nuseo_config[ 'redirect_external_urls' ])
		{
			$attrs['href'] = $nuseo['base_url'] . $nuseo['redirect_to_url'] . $attrs['href'];
			$modified = true;
		}
		
		if ($nuseo['debug_translation'])
		{
			nuseo_log_translation( 'ext', $attrs['href'], '' );
		}

		if ( $nuseo['debug_profile'] )
		{
			global $nuseo_external_anchors;
			$nuseo_external_anchors++;
		}
	}
	
	if ($rel && (!isset( $attrs['rel'] ) || ($rel != $attrs['rel'])))
	{
		$attrs['rel'] = $rel;
		$modified = true;
	}
	
	return $modified;
}

function nuseo_parse_anchor( &$anchor, &$attrs, &$misc_attrs, &$title )
{
	$attrs = array();




































































































      $pregsplit = '#\<a\s+' .
                              '(?:(?P<attr1>\w+)\s*\=\s*(?P<value1>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?:(?P<attr2>\w+)\s*\=\s*(?P<value2>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?:(?P<attr3>\w+)\s*\=\s*(?P<value3>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?:(?P<attr4>\w+)\s*\=\s*(?P<value4>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?:(?P<attr5>\w+)\s*\=\s*(?P<value5>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?:(?P<attr6>\w+)\s*\=\s*(?P<value6>"[^"]*"|\'[^\']*\'|\w+)\s*)?' .
                              '(?P<misc>[^\<\>]*)\>(?P<title>.*)\</a[^<>]*>#si';
      
      $matches = false;
      $match_count = preg_match_all( $pregsplit, $anchor, $matches );

      for ($i=1; $i<=6; $i++)
      {
            $attr_name = strtolower( $matches[ "attr$i" ][0] );
            
            $value = $matches[ "value$i" ][0];
            $value_len = strlen( $value );
            if (($value_len >= 2) && (($value[0] == '"') || ($value[0] == "'")) )
            {
				$value = substr( $value, 1, $value_len - 2 );
            }

            if ($attr_name)
                  $attrs[ $attr_name ] = $value;
      }
      
      $misc_attrs = $matches['misc'][0];
      $title = $matches['title'][0];

}

function nuseo_rebuild_anchor( &$attrs, &$misc_attrs, &$title )
{
	foreach( $attrs as $name => $value )
		$attrs[ $name ] = "$name=\"$value\"";
		
	$anchor = "<a " . implode( ' ', $attrs ) . ' ' . $misc_attrs . ">$title</a>";
	return $anchor;
}

function nuseo_process_translated_url( &$sef_url, &$href_info, &$anchor_info, &$title, &$rel )
{
	global $nuseo, $nuseo_config;
	if ($nuseo_config[ 'use_absolute_urls' ])
	{
		$scheme	    = isset( $href_info['scheme'] ) ? $href_info['scheme'] : $nuseo['base_scheme'];
		$host	    = isset( $href_info['host'] ) ? $href_info['host'] : $nuseo['base_host'];
		$port_str	= isset( $href_info['port_str'] )  ? $href_info['port_str'] : '';

		$sef_url = "$scheme://{$host}{$port_str}{$sef_url}";
	}
	
	if ($nuseo['debug_translation'])
    {
		nuseo_log_translation( 'trans', $href_info['path_plus_query'], $sef_url );
    }

	if ($anchor_info['rel'] != $rel)
    {
		$rel = $anchor_info['rel'];
    }

	if ($anchor_info['title'] != $title)
    {
		$title = $anchor_info['title'];
    }
}

function nuseo_process_delayed_anchors( &$output_parts )
{
	global $nuseo, $nuseo_config, $nuseo_cache;
	
	$phase2_anchor_count = count( $nuseo['phase2_anchor_infos'] );
	
	if ($nuseo['debug_translation'])
    {
		nuseo_log_translation( 'txt', "<br />\nProcessing $phase2_anchor_count phase2 anchors...<br />\n", '', 3 );
    }
	
	for ($i=0; $i< $phase2_anchor_count; $i++)
	{
		$phase2_anchor_info =& $nuseo['phase2_anchor_infos'][ $i ];
		
		$modified = false;
		
		// Read store state
		$anchor_index = $phase2_anchor_info['anchor_index'];
		$href_info	=& $phase2_anchor_info['href_info'];
		$attrs		=& $phase2_anchor_info['attrs'];
		$misc_attrs =& $phase2_anchor_info['misc_attrs'];
		$title		=& $phase2_anchor_info['title'];
		
		$original_title = $title;
		
		$rel = isset( $attrs['rel'] ) ? $attrs['rel'] : '';

		// translate href to SEF
		$module_list = false;

		$anchor_info = array( 'rel' => $rel, 'title' => $title );
		

		$sef_url = nuseo_translate_url_to_sef( $href_info['path_plus_query'], $href_info, $anchor_info, $module_list );

		if ($sef_url)
		{
			nuseo_process_translated_url( $sef_url, $href_info, $anchor_info, $title, $rel );

			$attrs['href'] = htmlentities( $sef_url );
			
			if ($rel && (!isset( $attrs['rel'] ) || ($rel != $attrs['rel'])))
				$attrs['rel'] = $rel;

			$output_parts[ $anchor_index ] = nuseo_rebuild_anchor( $attrs, $misc_attrs, $title );
			
			$modified = true;
		}
		else
		{
			if ($nuseo['debug_translation'])
            {
				nuseo_log_translation( 'txt', "<br />" . $href_info['path_plus_query'] . " .... could not translate url.<br />\n", '', 3 );
            }
		}
		

		if ( $nuseo_cache && !empty($nuseo_config['cache_anchor_processing']) )
		{
			$anchor = $output_parts[ $anchor_index ];

			$anchor_cache_key = 'a' . $href_info['url'] . $title;
			
			if ($modified)
			{
				$anchor_process_info = array(	'modified'	=> $modified,
												'href'		=> $href, 
												'attrs'		=> $attrs, 
												'misc_attrs'=> $misc_attrs, 
												'title'		=> ($original_title  != $title) ? $title : false );
			}
			else
			{
				$anchor_process_info = array( 'modified' => $modified );
			}

			$nuseo_cache->add_array( $anchor_cache_key, $anchor_process_info, $nuseo_config['cache_timeout']  );
			if ($nuseo['debug_mode'])
			{
				if ($nuseo['debug_mode']) { echo( "Added process info for anchor '$anchor':\n" ); };
				if ($nuseo['debug_mode']) { print_r( $anchor_process_info ); };
			}
		}

	} // for each phase2_anchor_info
}

function nuseo_get_base_href_from_html( &$str )
{
	global $nuseo, $nuseo_config;

	$existing_base_href = false;
	
	$pos = 0;
	
	// let's assume that there is no other tag starting with <b
	$base_pos = strpos( $str, '<b' );
	if ($base_pos === false)
		$base_pos = strpos( $str, '<B' );
		
	if ($base_pos !== false)
	{
		if (isset( $str[ $base_pos + 5 ] ))
		{
			if (	(($str[ $base_pos+2 ] == 'a') || ($str[ $base_pos+3 ] == 'A'))
				&&	(($str[ $base_pos+3 ] == 's') || ($str[ $base_pos+4 ] == 'S'))
				&&	(($str[ $base_pos+4 ] == 'e') || ($str[ $base_pos+5 ] == 'E'))
				&&	(($str[ $base_pos+5 ] == ' ') || ($str[ $base_pos+6 ] == "\t"))		
				)
			{
				$base_start_pos	= $base_pos + 5;
				$base_end_pos	= strpos( $str, '>', $base_start_pos );

				$base_href_content = substr( $str, $base_start_pos, $base_end_pos - $base_start_pos );
				
				$matches = false;
				$match_count = preg_match( '#\s*href\s*=\s*["|\']([^"\'>]+)["|\']#si', $base_href_content, $matches );
				
				$existing_base_href = $match_count != 0 ? $matches[1] : false;
			}
		}
	}
	
	if ($existing_base_href)
	{	// existing base href found, extract path to be used when converting URLs relative to absolute
		$base_href_parts = parse_url( $existing_base_href );
		
		$nuseo['base_href'] = $existing_base_href;
		$nuseo['base_href_path'] = isset( $base_href_parts['path'] ) ? $base_href_parts['path'] : '';
		
		if (substr( $nuseo['base_href_path'], -9 ) == 'index.php')
		{
			$nuseo['base_href_path'] = substr( $nuseo['base_href_path'], 0, -9 );
		}
		else if (substr( $nuseo['base_href_path'], -1 ) != '/')
		{
			$nuseo['base_href_path'] .= '/';
		}
	}

	return $existing_base_href;
}
//

// Miscellaneous Functions
function nuseo_parse_url( $url, $make_absolute = false, $parse_query = false )
{
	global $nuseo, $nuseo_config;
	
	$explicit_fragment = strpos( $url, '#' ) !== false;

	if ($url && ($url[0] == '#') && isset($nuseo['request_url']))		// if URL is an in-page go to bookmark, then do nothing.
	{
		if (!isset( $nuseo['request_url_no_fragment'] ))
		{
			$existing_fragment = strpos( $nuseo['request_url'], '#' );
			if ($existing_fragment)
				$nuseo['request_url_no_fragment'] = substr( $nuseo['request_url'], $existing_fragment );
			else
				$nuseo['request_url_no_fragment'] = $nuseo['request_url'];
		}
		$url = $nuseo['request_url_no_fragment'] . $url;
	}

	$parts	= @parse_url( $url );

	if (!$parts)
		return false;

	$parts['original_url'] = $url;
	$parts['is_relative'] = false;

	if ( !isset( $parts['scheme'] ) )
	{
		$parts['scheme'] = $nuseo['base_scheme'];
	}

	if ( !isset( $parts['host'] ) )
	{
		$parts['host'] = $nuseo['base_host'];			// does not include port
		$parts['port'] = $nuseo['base_port'];		// default port as well.
		$parts['is_relative'] = true;
	}

	$port = isset( $parts['port'] )	? $parts['port'] : false;

	if ($parts['scheme'] == 'http')
	{
		if (!$port)
		{
			$port = 80;
			$parts['port'] = $port;
		}
		$parts['port_str'] = $port != 80 ? ':' . $port : '';
	}
	else if ($parts['scheme'] == 'https')
	{
		if (!$port)
		{
			$port = 443;
			$parts['port'] = $port;
		}
		$parts['port_str'] = $port != 443 ? ':' . $port : '';
	}
	else
	{
		if (!$port)
		{
			$port = $nuseo['base_port'];
			$parts['port'] = $port;
		}
		$parts['port_str'] = ':' . $port;
	}

	if (!isset( $parts['path'] ))
	{
		if (isset( $nuseo['request_url_info']['path'] ) )
		{
			$parts['path'] = $nuseo['request_url_info']['path'];
		}
		else
		{
			$parts['path'] = '';
		}
	}
	
	$path	= $parts['path'];
	
	// if url starts with ./ then it is relative, remove 
	$path_is_relative = false;
	if ($path)
	{
		if (($path[0] == '.') && isset($path[1]) && ($path[1] == '/'))
		{
			$path_is_relative = true;			// path starts with ./, hence it is relative
			$path = substr($path, 2);
		}
		else if ($path[0] != '/')
		{
			$path_is_relative = true;			// path doesn't start with /, hence it is relative
		}
	}
	else
		$path_is_relative = false;				// empty path, it is not relative

	if ($path_is_relative)
		$parts['is_relative'] = true;
	
	if ( $make_absolute && $path_is_relative )		// relative path append current path
	{
		$base_href_path = (isset($nuseo['base_href_path']) && $nuseo['base_href_path']) 
									? $nuseo['base_href_path'] : ($nuseo[ 'request_path_base' ] . '/');
		_db_print( "relative to $base_href_path\n" );
		$path = $base_href_path . $path;
		$parts['path'] = $path;
	}

	$parts['query_params'] = array();
	
	if ( $parse_query && isset($parts['query']) && $parts['query'] )
	{
		$query = html_entity_decode( urldecode( $parts['query'] ) );
		$query_parts = explode( '&', $query );
		
		foreach ($query_parts as $query_iter)
		{
			$param_parts = explode( '=', $query_iter );

			$varname = $param_parts[0];
			if (!$varname)
				continue;

			$value = count( $param_parts ) > 1 ? $param_parts[1] : '';

			$parts['query_params'][ $varname ] = $value;
		}
	}

	if ( !isset( $parts['query'] )	)
		$query = '';
	else
		$query = '?' . $parts['query'];
		
	$parts['path_plus_query'] = $parts['path'] . urldecode( $query );
	
	if (isset( $parts['fragment'] ))
	{
		$parts['path_plus_query'] .= '#' . $parts['fragment'];
	}
	else if ($explicit_fragment)
	{
		$parts['path_plus_query'] .= '#';		// a fragment was present, but it was empty
	}

	$url = "{$parts['scheme']}://{$parts['host']}{$parts['port_str']}{$parts['path_plus_query']}";

	$parts['url'] = $url;

	return $parts;
}

function nuseo_build_url( &$url_info )
{
	$url_info['path_plus_query'] = $url_info['path'];
	$query_str = isset($url_info['query_params']) ? nuseo_build_query( $url_info['query_params'] ) : '';
	if ($query_str)
	{
		if (strpos( $url_info['path'], '?' ) !== false)
			$url_info['path_plus_query'] .= "&" . $query_str;
		else
			$url_info['path_plus_query'] .= "?" . $query_str;
	}
	
	// add fragment
	if (isset( $url_info['fragment'] ))
		$url_info['path_plus_query'] .= '#' . $url_info['fragment'];
	
	$url = "{$url_info['scheme']}://{$url_info['host']}{$url_info['port_str']}{$url_info['path_plus_query']}";
	
	return $url;
}


function nuseo_build_query( &$query_params, $glue = '&' )
{
	foreach ($query_params as $key => $value)
		$query_params[ $key ] = $key . '=' . $value;
		
	return implode( $glue, $query_params );
}

function nuseo_str_to_url( $str )
{
	global $nuseo, $nuseo_config;
	
	$str = urldecode( html_entity_decode( $str ) );

	// lower case URL
	$str = strtolower( $str );

	// remove non characters and split into words
	if ($nuseo_config[ 'replace_special_chars' ])
	{
		$str = str_replace( array_keys( $nuseo_config[ 'special_chars_map' ] ) , $nuseo_config[ 'special_chars_map' ], $str );
	}
	$strip_delims = '#([^\w]+)#';
	
	$str_words = preg_split( $strip_delims, $str );
	
	// remove stop words
	if ($nuseo_config[ 'remove_stopwords_from_urls' ])
	{
		$clean_str_words = array_diff( $str_words, $nuseo_config['stopwords_and_empty'] );
	}
	else	// remove empty words
	{
		$clean_str_words = array_diff( $str_words, array( '' ) );
	}

	if (!empty( $clean_str_words ))
		$str_words = $clean_str_words;
	unset( $clean_str_words );

	// check max words
	if ($nuseo_config[ 'max_url_words' ] > 0)
	{
		$word_count = count( $str_words );
		while ($word_count > $nuseo_config[ 'max_url_words' ])
		{
			array_pop( $str_words );
			$word_count--;
		}
	}

	// now put url together.
	$url = implode( $nuseo_config[ 'separator' ], $str_words );
	return $url;
}

function nuseo_str_to_regexp( $str )
{
	global $nuseo, $nuseo_config;

	if ($nuseo_config[ 'replace_special_chars' ] && !isset($nuseo_config[ 'special_chars_reverse_map' ]) )
		nuseo_init_special_chars_reverse_map();

	$words = explode( $nuseo_config['separator'], $str );
	
	if ($nuseo_config[ 'remove_stopwords_from_urls' ])		// stopwords have an empty space at the end
		$whitespace_regexp = '((' . implode( '|', $nuseo_config['stopwords'] ) . ')?' . '([^a-z0-9]|\&[\\#0-9a-z]*\;))';
	else
		$whitespace_regexp = '([^a-z0-9]|\&[\\#0-9a-z]*\;)';

	$regexp = '^';
	
	$first_word = true;
	foreach ($words as $word)
	{
		if ($nuseo_config[ 'replace_special_chars' ])
		{
			$word = str_replace( array_keys( $nuseo_config[ 'special_chars_reverse_map' ] ) , 
							$nuseo_config[ 'special_chars_reverse_map' ], $word );
		}

		$regexp .= $whitespace_regexp;
		$regexp .= $first_word ? '*' : '+';
		$regexp .= $word;
		$first_word = false;
	}
	$regexp .=  $whitespace_regexp . '*$';
	return $regexp;
}

function nuseo_init_special_chars_reverse_map()
{
	global $nuseo, $nuseo_config;

	$reverse_map = array();
	foreach ($nuseo_config[ 'special_chars_map' ] as $special_char => $replacement_char)
	{
		if (!isset( $reverse_map[ $replacement_char ] ))
			$reverse_map[ $replacement_char ] = $special_char;
		else
			$reverse_map[ $replacement_char ] .= $special_char;
	}

	$chars_reverse_map1 = array();
	$chars_reverse_map2 = array();
	foreach ($reverse_map as $replacement_char => $special_chars)
	{
		$replacement_char_len = strlen($replacement_char);
		if ($replacement_char_len > 1)
		{
			$pattern = '([' . $special_chars . ']|';
			for ($i = 0; $i<$replacement_char_len; $i++)
			{
				$ch = $replacement_char[ $i ];
				if (isset( $reverse_map[ $ch ]  ))
					$pattern .= '[' . $ch . $reverse_map[ $ch ] . ']';
				else 
					$pattern .= $ch;
			}
			$pattern .= ')';
			$chars_reverse_map1[ $replacement_char ] = $pattern;
		}
		else
		{
			$pattern = '[' . $replacement_char . $special_chars . ']';
			$chars_reverse_map2[ $replacement_char ] = $pattern;
		}
	}
	$nuseo_config['special_chars_reverse_map'] = array_merge( $chars_reverse_map1, $chars_reverse_map2 );
}

function &nuseo_connect_to_db( $server_name, $server_port, $db_username, $db_password, $db_name )
{
	$conn = new nuseo_db_connection();
	
	$ok = $conn->connect( $server_name, $server_port, $db_username, $db_password, $db_name );
	if (!$ok)
		$conn = false;
		
	return $conn;
}

function &nuseo_get_db_connection( &$module, $db_conn_key = 'db_conn' )
{
	if (!$module[  $db_conn_key ] && $module['module_connect_to_db'])
		$module['module_connect_to_db']( $module );
		
	return $module[ $db_conn_key ];
}


function nuseo_convert_format_vars( $format_vars )
{
	global $nuseo, $nuseo_config;
	$format = str_replace(	'$', '\$',	$format_vars );
	$format = preg_replace( '#\[([\w_]+)\]#', '{\$info[\'\1\']}', $format );
	return $format;
}

function nuseo_get_pattern_from_format( $format, &$id_parts, $end_of_url = true )
{
	global $nuseo, $nuseo_config;
	$pattern = preg_replace( $id_parts, '(?P<\1>\d+)', $format );
	$pattern = preg_replace( '#\[([\w_]+)\]#', '(?P<\1>[\w\\' .  $nuseo_config[ 'separator' ] . ']+)', $pattern );
	
	if ($end_of_url)
	{
		$pattern_len = strlen( $pattern );
		if ($pattern_len && ($pattern[ $pattern_len-1 ] == '/'))
			$pattern .= '?';		// if pattern ends in directory, allow for the trailing slash to be omitted
		$pattern .= '(?:\#|\?|$)';
	}

	return $pattern;
}


//

// Adsense Targeting
function nuseo_adsense_target( &$text )
{
	if ($nuseo_config[ 'enable_adsense_targeting' ])
	{
		$text = '<!-- google_ad_section_start -->' . $text . '<!-- google_ad_section_end -->';
	}
}

function nuseo_adsense_ignore( &$text )
{
	$open_targeting = '';
	$close_targeting = '';
	
	if ($nuseo_config[ 'enable_adsense_targeting' ])
	{
		$open_targeting = '<!-- google_ad_section_start(weight=ignore) -->';
		$close_targeting = '<!-- google_ad_section_end -->';
	}
	if ($nuseo_config[ 'enable_yahoo_targeting' ])
	{
		$open_targeting .= '<span class="robots-nocontent">';
		$close_targeting .= '</span>';
	}
	
	if ($open_targeting)
		$text = $open_targeting . $text . $close_targeting;
}

function nuseo_insert_copyright_notice( &$output )
{
	global $nuseo, $nuseo_config;
	$copyright_options = array( 
		"<span style=\"color:#f00;font-weight:700;\">(UNREGISTERED)</span> Search Engine Friendly URLs by NuSEO.PHP %NUSEO_VERSION%",
        "Search Engine Friendly URLs by NuSEO.PHP %NUSEO_VERSION%",
        "Search Engine Optimization by NuSEO.PHP %NUSEO_VERSION%",
        "SEO by NuSEO.PHP %NUSEO_VERSION%",
        "Search Engine Friendly URLs by NuSEO.PHP %NUSEO_VERSION%  2006-2007, NuHIT, LLC. ",
        "Search Engine Optimization URLs by NuSEO.PHP %NUSEO_VERSION%  2006-2007, NuHIT, LLC. ",
        "SEO by NuSEO.PHP %NUSEO_VERSION%  2006-2007, NuHIT, LLC. " );
		
	$copyright_type = isset( $nuseo_config[ 'copyright_type' ] ) ? $nuseo_config[ 'copyright_type' ] : 0;
	
	if (($copyright_type < 0) || !isset( $copyright_options[ 1 + $copyright_type ] ))
		$copyright_type = 0;
		
	$step_count = ($nuseo['step_count'] - $nuseo['timenow']) + $nuseo['nowload'];
	if ($step_count > 1)
		return;		// this is a bfo, nothing to do.
	
	if (!$step_count)
		$copyright_type = -1;		// unregistered
		

	$copyright = str_replace(	'%NUSEO_VERSION%', 
								NUSEO_VERSION, 
								$copyright_options[ 1 + $copyright_type ] );

	// See if we have a copyright placeholder
	$placeholder_pos = strpos( $output, COPYRIGHT_PLACEHOLDER );
	if ($placeholder_pos)		// we could test for !== false, but might as well check for 0)
	{
		$output = str_replace( COPYRIGHT_PLACEHOLDER, $copyright, $output );
	}
	else
	{
		$output = str_replace( "</body>", "\n<div style=\"text-align: center\">$copyright</div>\n</body>", $output );
	}
}

function nuseo_is_response_html( &$output )
{
	$content_type = '';
	$content_encoding = '';

	if (function_exists('headers_list'))
	{
		$headers = headers_list();

		foreach ($headers as $header)
		{
			$header = strtolower( trim($header) );
			
			$header_parts = explode( ':', $header );
			if (count( $header_parts ) < 2 )
				continue;

			if ($header_parts[0] == 'content-type')
				$content_type = trim($header_parts[1]);
			else if ($header_parts[0] == 'content-encoding')
				$content_encoding = trim($header_parts[1]);
				
			if ($content_type && $content_encoding)
				break;
		}
		if ($content_encoding == 'gzip')
			return false;			// output is already gzipped
		
		// it is html if content_type is empty (e.g. phpFox 1.6.1) or it is text/html
		$is_html = !$content_type || (strpos( $content_type, 'text/html' ) === 0);
	}
	else	// PHP4
	{
		$html_head = strtolower( substr( $output, 0, 500 ) );
		
		$h_pos = strpos( $html_head, '<html' );
		
		$is_html = $h_pos !== false;
	}
	return $is_html;
}
//

// Logic


	
	
	
	
	
	
	

	
	
	
	
	
	
	
	
	

	
	

	
	
	








function nuseo_get_step_count()
{
	global $nuseo;
	$nuseo['coreload'] = 2000; // days
	$nowload = 1; // 1 - good, 2 - branding free, 0 - unregistred :)
	return $nowload;
}


	
	
	
	
	
	
	

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

	
	



function nuseo_get_domain_parent( $domain_name )
{
	// This function is duplicated in nuhit_license_functions.php, do not change.
	$parts = explode( '.', $domain_name );
	$part_count = count( $parts );
	if ($part_count <= 2)
		$domain_parent = $domain_name;
	else
	{
		// assume it is a it is a .com, .net, .org, etc.
		$domain_parent = $parts[ $part_count - 2 ] . '.' . $parts[ $part_count - 1 ];
		
		$last_part_len = strlen( $parts[ $part_count-1 ] );
		$one_to_last_part_len = strlen( $parts[ $part_count-2 ] );
		if (($last_part_len < 3) && ($one_to_last_part_len < 4))		// then it is a .co.uk or .com.de, etc
		{
			$domain_parent = $parts[ $part_count - 3 ] . '.' . $domain_parent;
		}

		/*
		if ($check_prefixes)
		{	// this is currently only done in license.php
			$common_prefixes = array( 'demo.', 'www.', 'ftp.', 'forum.', 'photos.', 'www1.', 'test.', 'dev.' );
			
			foreach ($common_prefixes as $prefix_iter)
			{
				if (strpos( $domain_parent, $prefix_iter ) === 0)
				{
					$domain_parent = substr( $domain_parent, strlen( $prefix_iter ) );
					break;
				}
			} // foreach
		} // if $check_prefixes
		*/
	} // else
	return $domain_parent;
}
//

function nuseo_reset_db_for_existing_connections()
{
	global $nuseo, $nuseo_config;
	
	foreach (array_keys($nuseo['modules']) as $module_name)
	{
		$module =& $nuseo['modules'][ $module_name ];
		
		if (!empty( $module['db_conn'] ))
		{
			$module['db_conn']->reset_db();
		}
	}
}

function nuseo_fetch_page_title( $url )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$title = false;
	
	nuhit_url_init();
	
	$page_html = nuhit_url_get( $url, array( CURLOPT_TIMEOUT => 10 ) );
	
	if ($page_html)
	{
		$title_start_pos = strpos( $page_html, '<title>' );
		if ($title_start_pos === false)
		{
			$title_start_pos = strpos( $page_html, '<TITLE>' );
		}
		
		if ($title_start_pos)
		{
			$title_end_pos = strpos( $page_html, '<', $title_start_pos + 7 );
			
			if ($title_end_pos)
			{
				$title_start_pos += 7;
				$title = trim(substr( $page_html, $title_start_pos, $title_end_pos - $title_start_pos ));
			}
		}
	}
	
	return $title;
}

function nuseo_log_translation( $type, $from, $to, $one_cell = false )
{
	global $nuseo, $nuseo_config;
	
	$nuseo['translation_log'] .= "<tr class=\"$type\">";
	
	if ($one_cell)
	{
		$nuseo['translation_log'] .= "	<td colspan=\"3\">" . $from . "</td>\n";
	}
	else
	{
		if ($nuseo['debug_trans_test'] && ($type == 'trans') && $to)
		{
			$non_sef_url = nuseo_test_sef_url( $to );
			
			if ( $non_sef_url == html_entity_decode($from) )
			{
				$from = "<span style=\"color:green; font-weight:bold;\">$from<br/>$non_sef_url</span>";
			}
			else
			{
				$from = "<span style=\"color:red; font-weight:bold;\">$from<br/>$non_sef_url</span>";
			}
		}

		if (!$to)
		{
			$to .= '&nbsp;'; 
		}
		$nuseo['translation_log'] .= "	<td>$type</td><td>$from</td><td>$to</td>\n";
	}
	
	$nuseo['translation_log'] .= "</tr>\n";
}

function nuseo_test_sef_url( $url, $deep = false )
{
	global $nuseo, $nuseo_config;
	
	$non_sef_url = false;
	
	if ($deep)
	{
		nuhit_url_init();

		$url .= (strpos( $url, '?' )) ? '&' : '?';
		$url .= 'nuseo_cmds=nonsef';

		$page = nuhit_url_get( $url, array( CURLOPT_TIMEOUT => 10, CURLOPT_FOLLOWLOCATION => false, CURLOPT_HEADER => true ) );
		
		if ($page)
		{
			$location_start_pos = strpos( $page, 'Location:' );
			if ($location_start_pos !== false)
			{
				$location_end_pos = strpos( $page, "\n", $location_start_pos );
				
				if ($location_end_pos)
				{
					$location_start_pos += 9;
					$non_sef_url = substr( $page, $location_start_pos, $location_end_pos - $location_start_pos );
					
					$non_sef_url = str_replace( array( '&nuseo_cmds=nonsef', 'nuseo_cmds=nonsef&' ), '', $redir_to_url );
				}
			}
		}
	}
	else
	{		// internal test

		$anchor_info = array();
		$module_list = null;
		$url_info = nuseo_parse_url( $url, true, true );
		$rel_url = $url_info['path'];
		$non_sef_url = nuseo_translate_url_to_non_sef( $rel_url, $url_info, $anchor_info, $module_list );
	}
	
	return $non_sef_url;
}