<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_zencart_load( &$module )
{
	global $nuseo, $nuseo_config;

	$module['global_parser'] = true;

	// set url base
	$module['url_base']			= $nuseo_config[ 'zencart_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'zencart_domain' ];
}

function nuseo_zencart_init_rules( &$module )
{
	nuseo_cache_init( $module, array( 'categories', 'products' ) );

	// pre-process URL formats
	nuseo_zencart_load_url_formats( $module );
	
	// populate module rules
	nuseo_zencart_load_rewrite_rules( $module );
}

function nuseo_zencart_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;

	$url_formats_defs = array(
		'category'				=> $nuseo_config[ 'zencart_category_format' ],
		'product'				=> $nuseo_config[ 'zencart_product_format' ]
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(product_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_zencart_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();

	// index.php?main_page=index&cPath=1 => sef
	$rules[] = array(	'non_sef_pattern'		=> 'index\.php', 
						'translate_to_sef'		=> 'nuseo_zencart_index_to_sef',

						'sef_pattern'			=> $module['category_sef_pattern'],
						'translate_to_non_sef'	=> 'nuseo_zencart_sef_to_index'
						);

	$rules[] = array(	'sef_pattern'			=> $module['product_sef_pattern'],
						'translate_to_non_sef'	=> 'nuseo_zencart_sef_to_index_product'
						);

	$module['rules'] = $rules;
}
//

// index.php
function nuseo_zencart_index_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $query_params['cPath'] )		? $query_params['cPath'] : 0;
	$main_page		= isset( $query_params['main_page'] )	? $query_params['main_page'] : '';
	$product_id		= isset( $query_params['products_id'] )	? $query_params['products_id'] : 0;

	if ($product_id)
	{
		$product	= nuseo_cache_fetch( $module, 'products', $product_id, 'nuseo_zencart_fetch_product' );
		if (!$product)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the product, fail.
		}
	}
	else
		$product = false;

	if ($product && !$category_id)
	{
		$category_id = $product['categories_id'];
	}

	if ($category_id)
	{
		$category	= nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_zencart_fetch_category' );
		if (!$category)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the category, fail.
		}
	}
	else
		$category = false;
	

	// add thread information
	$info = array();
	$info['category_id']		= $category_id;
	$info['category_title']		= $category ? nuseo_str_to_url( $category['categories_name'] ) : '';
	$info['product_id']			= $product_id;
	$info['product_title']		= $product ? nuseo_str_to_url( $product['products_name'] ) : '';

	if ( (($main_page == 'index') || !$main_page) && $category_id )
	{	// then showing a category
		$url_format = $module['category_url_format'];
		unset( $query_params['cPath'] );
	}
	else if ($main_page == 'product_info' && $product_id)
	{
		$url_format = $module['product_url_format'];
		unset( $query_params['cPath'], $query_params['products_id'] );
	}
	else
		return false;
	

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['main_page'] );

	return $sef_url;
}

function nuseo_zencart_sef_to_index( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];
	
	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;

	$product_id		= isset( $matches['product_id']	)		? $matches['product_id']		: false;
	$product_title	= isset( $matches['product_title']	)	? $matches['product_title']	: false;

	if (!$category_id && $category_title)
	{	// get category_id from category_title
		$category = nuseo_cache_fetch_by_title( $module, 'categories', $category_title, 'nuseo_zencart_fetch_category_by_title' );
		if ($category)
			$category_id = $category['categories_id'];
	}

	if (!$product_id && $product_title)
	{	// get $product_id from $product_title
		$product = nuseo_cache_fetch_by_title( $module, 'products', $product_title, 'nuseo_zencart_fetch_product_by_title' );
		if ($product)
			$product_id = $product['products_id'];
	}

	if ($category_id)
	{
		$query_params['cPath'] = $category_id;
	}

	if ($product_id)
	{
		$query_params['products_id'] = $product_id;
	}
	
	if (isset( $matches['main_page'] ))
	{
		$query_params['main_page'] = $matches['main_page'];
	}
	else
	{
		$query_params['main_page'] = 'index';
	}

	$non_sef_url = "index.php";
	return $non_sef_url;
}

function nuseo_zencart_sef_to_index_product( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$matches['main_page'] = 'product_info';
	return nuseo_zencart_sef_to_index( $module, $url, $url_info, $matches, $anchor_info  );
}
//

// Database Connectivity
function nuseo_zencart_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config;
	
	$zencart_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'includes/configure.php';
	if (file_exists( $zencart_config_filename ))
	{
		include $zencart_config_filename;
		
		// read DB connection vars
		$server_name			= DB_SERVER;
		$server_port			= 3306;
		$db_username			= DB_SERVER_USERNAME;			
		$db_password			= DB_SERVER_PASSWORD;
		$module['db_name']		= DB_DATABASE;
		$module['table_prefix']	= DB_PREFIX;
		
		$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
											$db_username, $db_password, $module['db_name'] );
											
		// do not store username/password in memory
		unset( $server_name, $server_port, $db_username, $db_password );
	}
	else
		$module['db_conn']		= false;
}

function nuseo_zencart_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'categories_id';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "categories` category
				LEFT OUTER JOIN `" . $module['table_prefix'] . "categories_description` category_description
					ON category.categories_id = category_description.categories_id";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_zencart_fetch_product( &$module, $cache_type, $product_id )
{
	$table_name = 'product';

	$id_field_name = 'products_id';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "products` product
				LEFT OUTER JOIN `" . $module['table_prefix'] . "products_description` product_description
					ON product.products_id = product_description.products_id
				LEFT OUTER JOIN `" . $module['table_prefix'] . "products_to_categories` product_to_cat
					ON product.products_id = product_to_cat.products_id";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $product_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_zencart_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category_description';

	$title_field_name = 'categories_name';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "categories` category
				LEFT OUTER JOIN `" . $module['table_prefix'] . "categories_description` category_description
					ON category.categories_id = category_description.categories_id";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_zencart_fetch_product_by_title( &$module, $cache_type, $product_title )
{
	$table_name = 'product_description';

	$title_field_name = 'products_name';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "products` product
				LEFT OUTER JOIN `" . $module['table_prefix'] . "products_description` product_description
					ON product.products_id = product_description.products_id
				LEFT OUTER JOIN `" . $module['table_prefix'] . "products_to_categories` product_to_cat
					ON product.products_id = product_to_cat.products_id";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $product_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

//