<?php 
/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

define( 'SOCIAL_BOOKMARKS_IN_THREADS',	1 );
define( 'SOCIAL_BOOKMARKS_IN_BOTH',		2 );




/***********************************************************************
* * Start File: nuhit_lib_debug.h
 * Description: nuhit_lib_debug.h contains NuHIT's Debug Library for nuhit_php_compiler
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 ************************************************************************/









	
	


//--------------------------------------------------------------------------
// nu_print and nu_print_r are the release and debug version of print and print_r
// These macros/functions always generate code
//--------------------------------------------------------------------------

















































/***********************************************************************
* * End File: nuhit_lib_debug.h
 ************************************************************************/





/***********************************************************************
* * Start File: nuseo_common.h
 * Description: Contains common nuhit_php_compiler declarations for NuSEO.PHP
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/








  
  


if( !function_exists( "nu_microtime" ) )
{
    function nu_microtime()
    {
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }
}












































/***********************************************************************
* * End File: nuseo_common.h
\************************************************************************/



// Initialization
// Initialize module 
function nuseo_vbulletin_load( &$module )
{
	global $nuseo, $nuseo_config;

	// disable global parser. vBulletin plugins will take care of this.
	$module['global_parser'] = false;		
	
	// set url base
	$module['url_base']			= $nuseo_config[ 'vbulletin_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'vbulletin_domain' ];

	if (!empty($module['url_base']) && (substr($module['url_base'], -1) != '/'))
		$module['url_base'] .= '/';
	
	// set additional sef urls
	if (!empty($nuseo_config[ 'vbulletin_custom_forum_url_list' ]))
	{
		$module['sef_url_base_list'] =& $nuseo_config[ 'vbulletin_custom_forum_url_list' ];
		$module['domain_override_list']	= $nuseo_config[ 'vbulletin_custom_forum_domain_list' ];
		$module['domain_override_list'][] = $nuseo_config[ 'vbulletin_domain' ];
	}

	// Load vBulletin specific custom path blacklist
	if (!defined('NUSEO_ADMIN_CP'))
	{
		nuseo_vbulletin_load_path_blacklist( $module );
	}
	
	// misc defaults	
	$module['guest_mode'] = false;
	$module['rebuild_forum_datastore'] = false;
	
	// Init cache
	nuseo_cache_init( $module, array( 'forum', 'user', 'thread', 'post', 'poll', 'announcement',
				'user_slug', 'thread_slug', 'poll_slug', 'announcement_slug' ) );
}

function nuseo_vbulletin_init_rules( &$module )
{
	global $nuseo, $nuseo_config;
	
	// pre-process url formats
	nuseo_vbulletin_load_url_formats( $module );
	
	// populate module rules
	nuseo_vbulletin_load_rewrite_rules( $module );
}

function nuseo_vbulletin_get_content_variables( &$module, &$result )
{
	global $vbulletin, $foruminfo, $threadinfo;
	
	$result['bb_title'] = ( isset( $vbulletin ) ) ? $vbulletin->options[ 'bbtitle' ] : '';
	$result['default_keywords'] = ( isset( $vbulletin ) ) ? $vbulletin->options[ 'keywords' ] : '';
	$result['forum_title'] = ( isset( $foruminfo ) ) ? $foruminfo[ 'title' ] : '';
	$result['forum_description'] = ( isset( $foruminfo ) ) ? $foruminfo[ 'description' ] : '';
	
	$result['thread_title'] = ( isset( $threadinfo ) ) ? $threadinfo[ 'title' ] : '';
	$result['first_post_intro'] = ( isset( $module[ 'first_post' ] ) ) ? $module[ 'first_post' ][ 'message' ] : '';
	
}

function nuseo_vbulletin_init_processor( &$module )
{
	global $nuseo, $nuseo_config;
	
	if ($nuseo_config[ 'vbulletin_add_nofollow_to_dynamic_links' ])
	{
		$nuseo_config['add_nofollow_internal_urls'][] = $module['url_base'] . 'editpost.php';
		$nuseo_config['add_nofollow_internal_urls'][] = $module['url_base'] . 'newreply.php';
		$nuseo_config['add_nofollow_internal_urls'][] = $module['url_base'] . 'newthread.php';
	}
	
	// Social Bookmarking
	nuseo_vbulletin_init_social_bookmarking( /*ref*/ $module );
	
	// URL Caches
	$module['member_url_cache'] = array();
    $module['thread_url_cache'] = array();
	$module['showpost_url_cache'] = array();
}

function nuseo_vbulletin_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;
	
	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
	else
		$script_name = $rel_url;
		
	
	$my_scripts = array(	'ajax.php', 'announcement.php', 'attachment.php', 'calendar.php', 'cron.php', 'editpost.php', 'external.php', 
							'faq.php', 'forumdisplay.php', 'image.php', 'index.php', 'info.php', 'infraction.php', 'inlinemod.php', 
							'joinrequests.php', 'login.php', 'member.php', 'memberlist.php', 'misc.php', 'moderation.php', 'moderator.php', 
							'newattachment.php', 'newreply.php', 'newthread.php', 'online.php', 'payment_gateway.php', 'payments.php', 
							'poll.php', 'postings.php', 'printthread.php', 'private.php', 'profile.php', 'register.php', 'report.php', 
							'reputation.php', 'search.php', 'sendmessage.php', 'showgroups.php', 'showpost.php', 'showthread.php', 
							'subscription.php', 'threadrate.php', 'topratings.php', 'trial-signup.php', 'usercp.php', 'usernote.php' );
							
	if (in_array( $script_name, $my_scripts ))
	{
		$nuseo['global_parser'] = false;
	}
}

function nuseo_vbulletin_init_social_bookmarking( &$module )
{
	global $nuseo, $nuseo_config;

	if (isset( $module['social_bookmarks'] ))
		return;

	$module['social_bookmarks'] = array();
	if ($nuseo_config[ 'vbulletin_social_bookmarks_mode' ])
	{
		if ($nuseo_config[ 'vbulletin_digg_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.digg.com/submit?phase=2&url=[url]&title=[title]',
													'img'		=> 'digg.gif',
													'thread'	=> 'Digg this Thread!',
													'post'		=> 'Digg this Post!' );

		if ($nuseo_config[ 'vbulletin_delicious_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://del.icio.us/post?url=[url]&title=[title]',
													'img'		=> 'delicious.gif',
													'thread'	=> 'Add Thread to del.icio.us',
													'post'		=> 'Add Post to del.icio.us' );

		if ($nuseo_config[ 'vbulletin_technorati_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://technorati.com/faves/?add=[url]&title=[title]',
													'img'		=> 'technorati.gif',
													'thread'	=> 'Bookmark Thread in Technorati',
													'post'		=> 'Bookmark Post in Technorati' );

		if ($nuseo_config[ 'vbulletin_furl_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://furl.net/storeIt.jsp?u=[url]&t=[title]',
													'img'		=> 'furl.gif',
													'thread'	=> 'Furl this Thread!',
													'post'		=> 'Furl this Post!' );

		if ($nuseo_config[ 'vbulletin_connotea_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.connotea.org/add?continue=return&uri=[url]&title=[title]',
													'img'		=> 'connotea.gif',
													'thread'	=> 'Bookmark this Thread in Connotea',
													'post'		=> 'Bookmark this Post in Connotea' );

		if ($nuseo_config[ 'vbulletin_google_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.google.com/bookmarks/mark?op=edit&bkmk=[url]&title=[title]',
													'img'		=> 'google.gif',
													'thread'	=> 'Bookmark this Thread in Google',
													'post'		=> 'Bookmark this Post in Google' );

		if ($nuseo_config[ 'vbulletin_magnolia_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://ma.gnolia.com/bookmarklet/add?url=[url]&title=[title]',
													'img'		=> 'magnolia.gif',
													'thread'	=> 'Bookmark this Thread in ma.gnolia',
													'post'		=> 'Bookmark this Post in ma.gnolia' );

		if ($nuseo_config[ 'vbulletin_netscape_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.netscape.com/submit/?U=[url]&T=[title]',
													'img'		=> 'netscape.gif',
													'thread'	=> 'Bookmark this Thread in Netscape',
													'post'		=> 'Bookmark this Post in Netscape' );

		if ($nuseo_config[ 'vbulletin_netvouz_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.netvouz.com/action/submitBookmark?url=[url]&title=[title]&popup=no',
													'img'		=> 'netvouz.png',
													'thread'	=> 'Bookmark this Thread in Netvouz',
													'post'		=> 'Bookmark this Post in Netvouz' );

		if ($nuseo_config[ 'vbulletin_newsvine_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.newsvine.com/_wine/save?popoff=0&u=[url]&h=[title]',
													'img'		=> 'newsvine.gif',
													'thread'	=> 'Bookmark this Thread in Newsvine',
													'post'		=> 'Bookmark this Post in Newsvine' );

		if ($nuseo_config[ 'vbulletin_rawsugar_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.rawsugar.com/pages/tagger.faces?turl=[url]&tttl=[title]',
													'img'		=> 'rawsugar.png',
													'thread'	=> 'Bookmark this Thread in RawSugar',
													'post'		=> 'Bookmark this Post in RawSugar' );

		if ($nuseo_config[ 'vbulletin_recommendzit_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.dehsoftware.com/recommendzit/submit.php?url=[url]&title=[title]&description=',
													'img'		=> 'recommendzit.gif',
													'thread'	=> 'Bookmark this Thread in RecommendzIt',
													'post'		=> 'Bookmark this Post in RecommendzIt' );

		if ($nuseo_config[ 'vbulletin_reddit_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://reddit.com/submit?url=[url]&title=[title]',
													'img'		=> 'reddit.gif',
													'thread'	=> 'Bookmark this Thread in reddit',
													'post'		=> 'Bookmark this Post in reddit' );

		if ($nuseo_config[ 'vbulletin_scuttle_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://scuttle.org/bookmarks.php/pass?action=add&address=[url]&title=[title]',
													'img'		=> 'scuttle.gif',
													'thread'	=> 'Bookmark this Thread in Scuttle',
													'post'		=> 'Bookmark this Post in Scuttle' );

		if ($nuseo_config[ 'vbulletin_shadows_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.shadows.com/features/tcr.htm?url=[url]&title=[title]',
													'img'		=> 'shadows.gif',
													'thread'	=> 'Bookmark this Thread in Shadows',
													'post'		=> 'Bookmark this Post in Shadows' );

		if ($nuseo_config[ 'vbulletin_simpy_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://simpy.com/simpy/LinkAdd.do?note=[title]&href=[url]',
													'img'		=> 'simpy.png',
													'thread'	=> 'Bookmark this Thread in Simpy',
													'post'		=> 'Bookmark this Post in Simpy' );

		if ($nuseo_config[ 'vbulletin_spurl_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.spurl.net/spurl.php?url=[url]&title=[title]',
													'img'		=> 'spurl.gif',
													'thread'	=> 'Bookmark this Thread in Spurl',
													'post'		=> 'Bookmark this Post in Spurl' );

		if ($nuseo_config[ 'vbulletin_stumbleupon_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.stumbleupon.com/submit?url=[url]&title=[title]',
													'img'		=> 'stumbleupon.gif',
													'thread'	=> 'Bookmark this Thread in StumbleUpon',
													'post'		=> 'Bookmark this Post in StumbleUpon' );

		if ($nuseo_config[ 'vbulletin_wink_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://www.wink.com/_/tag?url=[url]&doctitle=[title]',
													'img'		=> 'wink.png',
													'thread'	=> 'Bookmark this Thread in Wink',
													'post'		=> 'Bookmark this Post in Wink' );

		if ($nuseo_config[ 'vbulletin_yahoomyweb_enabled' ])
			$module['social_bookmarks'][] = array(	'url'		=> 'http://myweb2.search.yahoo.com/myresults/bookmarklet?t=[title]&u=[url]',
													'img'		=> 'yahoomyweb.png',
													'thread'	=> 'Bookmark this Thread in Yahoo! MyWeb',
													'post'		=> 'Bookmark this Post in Yahoo! MyWeb' );
			
		// read custom bookmarks, if any
		if (isset($nuseo_config[ 'vbulletin_custom_social_bookmarks' ]))
		{
			$custom_bookmarks =& $nuseo_config[ 'vbulletin_custom_social_bookmarks' ];

			if (isset( $custom_bookmarks ) && !empty($custom_bookmarks) && is_array($custom_bookmarks))
			{
				foreach ( $custom_bookmarks as $bookmark_info )
				{
					$parts = explode( ',', $bookmark_info );
					$part_count = count($parts);
					if ($part_count < 2)
						continue;
						
					$url = $parts[0];
					$img = $parts[1];
					$thread_msg = $part_count > 2 ? $parts[2] : '';
					$post_msg = $part_count > 3 ? $parts[3] : '';
					
					$module['social_bookmarks'][] = array( 'url' => $url, 'img' => $img, 
															'thread' => $thread_msg, 'post' => $post_msg );
				}
			}
		}
	}
}
//

// forumdisplay
function nuseo_vbulletin_forumdisplay_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{	
	global $nuseo, $nuseo_config;
	
	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$forumid = isset( $query_params['f'] ) ? $query_params['f'] : 
					(isset( $query_params['forumid'] ) ? $query_params['forumid'] : 0);
					
	$page = intval( isset( $query_params['page'] ) ? $query_params['page'] :	
						(isset( $query_params['pageno'] ) ? $query_params['pageno'] : 0) );

	$order = isset( $query_params['order'] ) ? $query_params['order'] : '';

	if (!$forumid && isset( $matches['forum_id'] ))
		$forumid = $matches['forum_id'];
		
	$sef_url = nuseo_vbulletin_get_forum_url_ex( $forumid, $page, $url_info );
	
	if ($sef_url && ($sef_url !== true))
	{
		// Now build url back.
		unset( $query_params['f'] );
		unset( $query_params['page'] );
		if (!$order || ($order = 'desc'))
			unset( $query_params['order'] );
	}
	return $sef_url;
}

function nuseo_vbulletin_get_forum_url( $forumid, $page = 1 )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	$url_info = array();
	$sef_url = nuseo_vbulletin_get_forum_url_ex( $forumid, $page, $url_info );
	
	if ($sef_url)
	{
		if (isset( $url_info['host'] ))
		{
			if ($sef_url[0] == '/')
			{
				$sef_url = 'http://' . $url_info['host'] . $sef_url;
			}
			else
			{
				$sef_url = 'http://' . $url_info['host'] . $nuseo_vbulletin['url_base'] . $sef_url;
			}
		}
	}
	else	// not translated
	{
		$sef_url = 'forumdisplay.php?f=' . $forumid;
		if ($page)
		{
			$sef_url .= '&page=' . $page;
		}
	}
	return $sef_url;
}

function nuseo_vbulletin_get_forum_url_ex( $forumid, $page, &$url_info )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	if (!$forumid)
		return false;
	
	$info = nuseo_vbulletin_get_forum_info( $nuseo_vbulletin, $forumid );

	if (!$info)
		return false;

	if ($page <= 1)
	{
		$sef_url = $info['forum_sef_url'];
	}
	else		// we are in page 2+
	{
		$url_format = $nuseo_vbulletin['forum_pages_url_format'];

		$info['forum_page'] = $page;
		eval( '$sef_url = "' . $url_format . '";' );
	}
	
	if (!empty($info['forum_domain']))
	{	// support for domain overrides per forum
		$url_info['host'] = $info['forum_domain'];
	}
	else if (!empty( $nuseo_config['vbulletin_domain'] ))
	{
		$url_info['host'] = $nuseo_config['vbulletin_domain'];
	}

	return $sef_url;
}

function nuseo_vbulletin_sef_to_forumdisplay( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
	
	if (!$nuseo_config[ 'vbulletin_rewrite_forum_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$forum_id		= isset( $matches['forum_id']		) ? $matches['forum_id']		: false;
	$forum_title	= isset( $matches['forum_title']	) ? $matches['forum_title']		: false;
	$forum_path		= isset( $matches['forum_path']		) ? $matches['forum_path']		: false;
	
	if (!$forum_id && $forum_title)
	{
		$forum_id = nuseo_vbulletin_get_forum_id_from_title( $module, $forum_title );
		
		if (!$forum_id)
		{
			$forum_title_len = strlen( $forum_title );
			if ($forum_title[ $forum_title_len - 1 ] == '/')
			{
				$forum_title = substr( $forum_title, 0, $forum_title_len-1 );
				$forum_id = nuseo_vbulletin_get_forum_id_from_title( $module, $forum_title );
			}
		}
	}
	
	if (!$forum_id && $forum_path)
	{
		$forum_id = nuseo_vbulletin_get_forum_id_from_path( $module, $forum_path );

		if (!$forum_id)
		{
			$forum_path_len = strlen( $forum_path );
			if ($forum_path[ $forum_path_len - 1 ] == '/')
			{
				$forum_path = substr( $forum_path, 0, $forum_path_len-1 );
				$forum_id = nuseo_vbulletin_get_forum_id_from_path( $module, $forum_path );
			}
		}
	}

	if (!$forum_id)
		return false;
	
	$forum_page	= isset( $matches['forum_page']	) ? $matches['forum_page']		: false;

	$query_params['f'] = $forum_id;

	if ($forum_page > 1)
		$query_params['page'] = $forum_page;

	$non_sef_url = "forumdisplay.php";
	return $non_sef_url;
}
//

// showthread
function nuseo_vbulletin_showthread_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$threadid = intval( isset( $query_params['t'] ) ? $query_params['t'] :	
						(isset( $query_params['threadid'] ) ? $query_params['threadid'] : 0) );

	$postid = intval( isset( $query_params['p'] ) ? $query_params['p'] :	
						(isset( $query_params['postid'] ) ? $query_params['postid'] : 0) );

	$goto = isset( $query_params['goto'] ) ? $query_params['goto'] : '';

	$page = intval( isset( $query_params['page'] ) ? $query_params['page'] :	
						(isset( $query_params['pageno'] ) ? $query_params['pageno'] : 0) );

	if (!$threadid && isset( $matches['thread_id'] ))
		$threadid = $matches['thread_id'];
	
	$sef_url = nuseo_vbulletin_get_thread_url_ex( $threadid, /*ref*/ $url_info, /*ref*/ $anchor_info, $postid, $goto, $page );
	
	if ($sef_url && ($sef_url !== true))
	{
		if (!$threadid && $postid)
		{
			unset( $query_params['p'] );
		}
		
		unset( $query_params['threadid'] );
		unset( $query_params['postid'] );
		unset( $query_params['goto'] );
		unset( $query_params['page'] );
		unset( $query_params['t'] );

		if ($postid)
			$url_info['fragment'] = "post$postid";
	}

	return $sef_url;
}

function nuseo_vbulletin_get_thread_url( $threadid, $extra_params = false, $postid = 0, $goto = false, $page = 1 )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
    
    $thread_url_key = $threadid . $extra_params . $postid . $goto . $page;
    
    $thread_url_cache = &$nuseo_vbulletin['thread_url_cache'];
    
    if ( !isset( $thread_url_cache[ $thread_url_key ] ) )
    {
		$url_info = array();
	    $anchor_info = array();
	    $sef_url = nuseo_vbulletin_get_thread_url_ex( $threadid, $url_info, $anchor_info, $postid, $goto, $page);

	    if (!$sef_url || ($sef_url===true))		// if we couldn't get the URL in the first pass, fall back
	    {
		    $sef_url = 'showthread.php?';

		    if ($postid)
			    $sef_url .= "p=$postid";
		    else 
			    $sef_url .= "t=$threadid";
    			
		    if ($goto)
			    $sef_url .= "&goto=$goto";

		    if ($page)
			    $sef_url .= "&page=$page";
	    }
		else
		{	// else, this was a SEF url where a host override was specified.
			if (isset( $url_info['host'] ))
			{
				if ($sef_url[0] == '/')
				{
					$sef_url = 'http://' . $url_info['host'] . $sef_url;
				}
				else
				{
					$sef_url = 'http://' . $url_info['host'] . $nuseo_vbulletin['url_base'] . $sef_url;
				}
			}
		}
    	
	    if ($extra_params)
		{
			$query_params_pos = strpos( $sef_url, '?' );
			
			$sef_url .= ( $query_params_pos === false ) ? '?' : '&';

			if ($extra_params[0] == '&')
			{	// if extra_params starts with &, e.g. &highlight=xxx, then skip it.
				if (strpos( $extra_params, '&amp;' ) === 0)
				{
					$sef_url .= substr( $extra_params, 5 );
				}
				else
				{
					$sef_url .= substr( $extra_params, 1 );
				}
			}
			else
			{
				$sef_url .= $extra_params;
			}
		}
    		
	    if ($postid)
		    $sef_url .= "#post$postid";
            
        $thread_url_cache[ $thread_url_key ] = $sef_url;
    }
    else
    {
        $sef_url = $thread_url_cache[ $thread_url_key ];
    }

	return $sef_url;
}

function nuseo_vbulletin_get_thread_url_ex( $threadid, &$url_info, &$anchor_info, $postid = 0, $goto = false, $page = 1 )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	if (!$threadid && $postid)
	{
		$post = nuseo_cache_fetch( $nuseo_vbulletin, 'post', $postid );
		if (!$post && $nuseo['prefetch'])
			return true;

		if ($post)
		{
			$threadid = $post['threadid'];
		}
	}
	
	if (!$threadid)
		return false;

	$thread = nuseo_cache_fetch( $nuseo_vbulletin, 'thread', $threadid );
	

	if (!$thread)
	{
		if ($nuseo['prefetch'])
			return true;				// we are in prefetch mode, we'll be back later
		else
			return false;				// else, we didn't find the thread, fail.
	}

	if (!$thread['title'])
		$thread['title'] = $thread['threadtitle'];

	$forumid = $thread['forumid'];

	if (!$nuseo_config['vbulletin_rewrite_restricted_threads'])
	{	// if we should not rewrite restricted threads, check viewing permissions now.
		if (!nuseo_vbulletin_can_user_view_forum( $nuseo_vbulletin, $forumid ))
			return false;
	}

	// Start with the forum information
	$info = nuseo_vbulletin_get_forum_info( $nuseo_vbulletin, $forumid );

	// add thread information
	$info['thread_id']		= $threadid;
	$info['thread_title']	= nuseo_str_to_url( $thread['title'] );
	$info['post_id']		= $postid;

	if (!empty( $nuseo_config['vbulletin_reversed_thread_patterns'] ))
	{
		$trail_pattern = '#([0-9]' . $nuseo_config['vbulletin_reversed_thread_patterns'] . ')$#siU';
		if (preg_match( $trail_pattern, $info['thread_title'] ))
		{
			$info['thread_title'] .= $nuseo_config[ 'separator' ]. 'a';			// fix for titles ending in numbers, getting confused with page number.
		}
	}

	$update_thread_slug		= false;

	// Determine url_format
	if ($goto == 'nextoldest')										
	{
		$url_format = $nuseo_vbulletin['previous_thread_url_format'];		// Go to next thread
	}
	else if ($goto == 'nextnewest')								
	{
		$url_format = $nuseo_vbulletin['next_thread_url_format'];			// Go to next thread
	}
	else if ($goto == 'newpost')								
	{
		$url_format = $nuseo_vbulletin['thread_new_post_url_format'];		// Go to new post
	}
	else if ($goto == 'lastpost')								
	{
		$url_format = $nuseo_vbulletin['thread_last_post_url_format'];		// Go to last post
	}
	else if ($postid)
	{
		if ($page <= 1)
			$url_format = $nuseo_vbulletin['go_to_post_url_format'];			// Go to post
		else
			$url_format = $nuseo_vbulletin['go_to_post_pages_url_format'];	// Go to post multi-page
	}
	else
	{
		if ($nuseo_config['vbulletin_expand_thread_url_title'])
		{
			$anchor_title_equals_url = isset($anchor_info['title']) && isset($url_info['url'])
										&& ($anchor_info['title'] == $url_info['url']);
			if ($anchor_title_equals_url)
			{
				$anchor_info['title'] = $thread['title'];
			}
		}

		if ($page <= 1)
		{
			$url_format = $nuseo_vbulletin['thread_url_format'];				// Go to thread
			$update_thread_slug = true;
		}
		else
			$url_format = $nuseo_vbulletin['thread_pages_url_format'];		// Go to thread multi-page
	}

	$info['thread_page'] = $page;
	$info['page'] = $page;

	eval( '$sef_url = "' . $url_format . '";' );

	if ($nuseo['debug_mode'])
	{
		if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_get_thread_url_ex. generating SEF url:\n" ); };
		if ($nuseo['debug_mode']) { print_r( $info ); };
	}

	if ($update_thread_slug && (isset( $thread['nuseo_slug'] ) && ($thread['nuseo_slug'] != $sef_url)))
		nuseo_vbulletin_update_slug( $nuseo_vbulletin, 'thread', $threadid, $sef_url );

	if (!empty( $info['forum_domain'] ))
	{
		$url_info['host'] = $info['forum_domain'];
	}
	else if (!empty( $nuseo_config['vbulletin_domain'] ))
	{
		$url_info['host'] = $nuseo_config['vbulletin_domain'];
	}

	return $sef_url;
}

function nuseo_vbulletin_sef_to_showthread( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_thread_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$thread_id		= isset( $matches['thread_id']		) ? $matches['thread_id']		: false;
	$thread_title	= isset( $matches['thread_title']	) ? $matches['thread_title']	: false;
	$forum_id		= isset( $matches['forum_id']		) ? $matches['forum_id']		: false;
	$forum_title	= isset( $matches['forum_title']	) ? $matches['forum_title']		: false;
	$forum_path		= isset( $matches['forum_path']		) ? $matches['forum_path']		: false;
	$post_id		= isset( $matches['post_id']		) ? $matches['post_id']			: false;
	$thread_page	= isset( $matches['thread_page']	) ? $matches['thread_page']		: false;
	
	if (!$thread_id && $post_id)
	{
		//$post = nuseo_vbulletin_fetch_post( $post_id );
		$post = nuseo_cache_fetch( $module, 'post', $post_id );
		if ($post)
			$thread_id = $post['threadid'];
	}
	
	if (!$thread_id)		// then try nuseo_slug
	{
		$thread = nuseo_vbulletin_get_object_from_slug( $module, 'thread', $url );
		if ($thread)
			$thread_id = $thread['threadid'];
	}

	if (!$thread_id)
		return false;
		
	if (!$post_id)
	{
		$query_params['t'] = $thread_id;
	}

	$fragment = '';

	if ($post_id)
	{
		$query_params['p'] = $post_id;
		$fragment = '#post' . $post_id;
	}

	if ($thread_page > 1)
		$query_params['page'] = $thread_page;

	$non_sef_url = "showthread.php";
	return $non_sef_url;
}

function nuseo_vbulletin_sef_to_showthread_goto_previous( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$query_params['goto'] = 'nextoldest';
	return nuseo_vbulletin_sef_to_showthread( $module, $url, $url_info, $matches, $anchor_info );
}

function nuseo_vbulletin_sef_to_showthread_goto_next( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$query_params['goto'] = 'nextnewest';
	return nuseo_vbulletin_sef_to_showthread( $module, $url, $url_info, $matches, $anchor_info );
}

function nuseo_vbulletin_sef_to_showthread_goto_new_post( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$query_params['goto'] = 'newpost';
	return nuseo_vbulletin_sef_to_showthread( $module, $url, $url_info, $matches, $anchor_info );
}

function nuseo_vbulletin_sef_to_showthread_goto_last_post( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$query_params['goto'] = 'lastpost';
	return nuseo_vbulletin_sef_to_showthread( $module, $url, $url_info, $matches, $anchor_info );
}

//

// showpost
function nuseo_vbulletin_showpost_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$postid = intval( isset( $query_params['p'] ) ? $query_params['p'] :	
						(isset( $query_params['postid'] ) ? $query_params['postid'] : 0) );

	$postcount = isset( $query_params['postcount'] ) ? intval( $query_params['postcount'] ) : 0;
	$page = isset( $query_params['page'] ) ? intval( $query_params['page'] ) : 0;

	if (!$postid)
		return false;

	$url_format = $module['showpost_url_format'];

	$info = array( 'post_id' => $postid, 'post_count' => $postcount, 'post_page' => $page );

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['p'] );
	unset( $query_params['postid'] );
	unset( $query_params['postcount'] );

	if ($nuseo_config[ 'vbulletin_nofollow_show_posts' ])
	{
		if (!empty($anchor_info))
			$anchor_info['rel'] = 'nofollow';
	}

	return $sef_url;
}

function nuseo_vbulletin_sef_to_showpost( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_showpost_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$post_id		= isset( $matches['post_id']		) ? $matches['post_id']		: false;
	$post_count		= isset( $matches['post_count']		) ? $matches['post_count']	: false;

	if (!$post_id)
		return false;
	
	$query_params['p'] = $post_id;
	
	if ($post_count)
		$query_params['postcount'] = $post_count;
	
	$non_sef_url = "showpost.php";
	
	return $non_sef_url;
}
//

// poll
function nuseo_vbulletin_poll_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$pollid = intval( isset( $query_params['pollid'] ) ? $query_params['pollid'] :	0 );

	$do = isset( $query_params['do'] ) ? $query_params['do'] : 'showresults';
	
	if (!$pollid)
		return false;
	
	$poll = nuseo_cache_fetch( $module, 'poll', $pollid, 'nuseo_vbulletin_fetch_poll');

	if (!$poll)
	{
		if ($nuseo['prefetch'])
			return true;
		else
			return false;
	}

	$forumid = $poll['forumid'];

	// Start with the forum information
	$info = nuseo_vbulletin_get_forum_info( $module, $forumid );
	
	$info['poll_id']	= $pollid;
	$info['poll_title']	= nuseo_str_to_url($poll['question']);

	$url_format = $module['poll_url_format'];

	eval( '$sef_url = "' . $url_format . '";' );
	
	if (isset( $poll['nuseo_slug'] ) && ($poll['nuseo_slug'] != $sef_url))
		nuseo_vbulletin_update_slug( $module, 'poll', $pollid, $sef_url );
	
	unset( $query_params['pollid'] );
	if ($do == 'showresults')
		unset( $query_params['do'] );

	if (!empty( $info['forum_domain'] ))
	{
		$url_info['host'] = $info['forum_domain'];
	}
	else if (!empty( $nuseo_config['vbulletin_domain'] ))
	{
		$url_info['host'] = $nuseo_config['vbulletin_domain'];
	}

	return $sef_url;
}

function nuseo_vbulletin_sef_to_poll( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_poll_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$poll_id			= isset( $matches['poll_id']		) ? $matches['poll_id']		: false;
	$poll_title			= isset( $matches['poll_title']		) ? $matches['poll_title']	: false;

	if (!$poll_id)		// then try nuseo_slug
	{
		$poll = nuseo_vbulletin_get_object_from_slug( $module, 'poll', $url );
		if ($poll)
			$poll_id = $poll['pollid'];
	}

	if (!$poll_id)
		return false;
	
	$query_params['pollid'] = $poll_id;
	
	if (!isset( $query_params['do'] ))
		$query_params['do'] = 'showresults';
	
	$non_sef_url = "poll.php";
	
	return $non_sef_url;
}
//

// memberlist
function nuseo_vbulletin_memberlist_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$letter	= isset( $query_params['ltr'	] ) ? $query_params['ltr'] : false;
	$order	= isset( $query_params['order'	] ) ? strtolower($query_params['order']) : false;
	$sort	= isset( $query_params['sort'	] ) ? strtolower($query_params['sort']) : false;
	$page	= isset( $query_params['page'	] ) ? intval( $query_params['page'] ) : 1;
	$pp		= isset( $query_params['pp'		] ) ? intval( $query_params['pp'] ) : false;
	$do		= isset( $query_params['do'		] ) ? $query_params['do'] : false;

	if ($letter)
	{
		$url_format = $module['memberlist_letter_url_format'];
		if ($letter == '#')
			$letter = '0';
	}
	else if ($page > 1)
		$url_format = $module['memberlist_pages_url_format'];
	else
		$url_format = $module['memberlist_url_format'];

	$info = array( 'page' => $page, 'letter' => $letter );

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['ltr'] );
	unset( $query_params['page'] );
	if (!$sort || ($sort == 'username'))
		unset( $query_params['sort'] );

	if (!$order || ($order == 'asc'))
		unset( $query_params['order'] );
		
	if (!$pp)
		unset( $query_params['pp'] );
		
	if ($do == 'getall')
		unset( $query_params['do'] );

	return $sef_url;
}

function nuseo_vbulletin_sef_to_memberlist( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_member_list_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$page	= isset( $matches['page'] ) ? intval( $matches['page'] ) : 1;
	$letter	= isset( $matches['letter'] ) ? $matches['letter'] : false;
	
	$query_params['page'] = $page;
	if ($letter)
		$query_params['ltr'] = $letter == '0' ? '#' : $letter;
		
	if (!isset( $query_params['sort'] ))
		$query_params['sort'] = 'username';
	
	if (!isset( $query_params['order'] ))
		$query_params['order'] = 'asc';
		
	if (!isset( $query_params['pp'] ))
		$query_params['pp'] = 0;
		
	if (($page > 1) && !isset( $query_params['do'] ))
		$query_params['do'] = 'getall';
		
	$non_sef_url = "memberlist.php";
	return $non_sef_url;
}
//

// member
function nuseo_vbulletin_member_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	if (defined('THIS_SCRIPT'))
	{
		if ((THIS_SCRIPT == 'showthread') || (THIS_SCRIPT == 'showpost'))
		{	// then we are in postbit
			if ($nuseo_config[ 'vbulletin_add_nofollow_to_member_links_from_postbit' ]&& !empty($anchor_info) )
				$anchor_info['rel'] = 'nofollow';
		}
		else if (THIS_SCRIPT == 'index')
		{
			if ($nuseo_config[ 'vbulletin_add_nofollow_to_member_links_from_forumhome' ]&& !empty($anchor_info) )
				$anchor_info['rel'] = 'nofollow';
		}
	}
	
	$userid = 0;

	if ( isset( $query_params['u'] ))
	{
		$userid = $query_params['u'];
		$user = nuseo_cache_fetch( $module, 'user', $userid );
		if (!$user && $nuseo['prefetch'])
			return true;
	}
	else if ( isset($query_params['find']) && ($query_params['find'] == 'lastposter') )
	{
		//try lastposter
		if ( isset($query_params['f']) )
		{
			$forumid = $query_params['f'];
			$user = nuseo_cache_get( $module, 'user', 'f' . $forumid );
		}
		else if ( isset($query_params['t']) )
		{
			$threadid = $query_params['t'];
			$user = nuseo_cache_get( $module, 'user', 't' . $threadid );
		}
		else
			$user = false;
		
		if ($user)
			$userid = $user['userid'];
			
		unset( $query_params['f'] );
		unset( $query_params['t'] );
		unset( $query_params['find'] );
	}

	if (!$user)
		return false;
		
	$url_format = $module['member_url_format'];

	$info = array( 'user_name' => nuseo_str_to_url( $user['username'] ), 'user_id' => $user['userid'] );

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['u'] );

	if ($userid && 	(isset( $user['nuseo_slug'] ) && ($user['nuseo_slug'] != $sef_url)))
		nuseo_vbulletin_update_slug( $module, 'user', $userid, $sef_url );

	if (!empty( $nuseo_config['vbulletin_domain'] ))
	{
		$url_info['host'] = $nuseo_config['vbulletin_domain'];
	}
	return $sef_url;
}

function nuseo_vbulletin_sef_to_member( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_member_urls' ])
		return false;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$user_name	= isset( $matches['user_name'] ) ? $matches['user_name'] : false;
	$user_id	= isset( $matches['user_id'] ) ? intval( $matches['user_id'] ) : 0;
	
	if (!$user_id)		// then try nuseo_slug
	{
		$user = nuseo_vbulletin_get_object_from_slug( $module, 'user', $url );
		if ($user)
			$user_id = $user['userid'];
	}

	if (!$user_id)
		return false;
		
	$query_params['u'] = $user_id;
		
	$non_sef_url = "member.php";
	return $non_sef_url;
}
//

// announcement
function nuseo_vbulletin_announcement_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$forum_id			= isset( $query_params['f'] ) ? intval( $query_params['f'] ) : 0;
	$announcement_id	= isset( $query_params['a'] ) ? intval( $query_params['a'] ) : 0;
	
	if (!$forum_id && !$announcement_id)
		return false;
	
	if ($announcement_id > 0)
	{
		$announcement = nuseo_cache_fetch( $module, 'announcement', $announcement_id );
		
		if (!$announcement)
		{
			if ($nuseo['prefetch'])
				return true;
			else
				return false;
		}
		if ($announcement['forumid'])
			$forum_id = $announcement['forumid'];
	}
	
	if ($forum_id > 0)
	{
		$info = nuseo_vbulletin_get_forum_info( $module, $forum_id );
		if (!$info)
			$info = array( 'forum_title' => 'general', 'forum_path' => 'general' );		// TODO: phrase this
	}
	else
		$info = array( 'forum_title' => 'general', 'forum_path' => 'general' );

	if ($announcement_id > 0)
	{
		$url_format = $module['announcement_url_format'];
		$info['announcement_title'] = nuseo_str_to_url( $announcement['title'] );
	}
	else
		$url_format = $module['all_announcements_url_format'];

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['f'] );
	unset( $query_params['a'] );
	
	if ($announcement_id && (isset( $announcement['nuseo_slug'] ) && ($announcement['nuseo_slug'] != $sef_url)))
		nuseo_vbulletin_update_slug( $module, 'announcement', $announcement_id, $sef_url );

	if (!empty( $info['forum_domain'] ))
	{
		$url_info['host'] = $info['forum_domain'];
	}
	else if (!empty( $nuseo_config['vbulletin_domain'] ))
	{
		$url_info['host'] = $nuseo_config['vbulletin_domain'];
	}

	return $sef_url;
}

function nuseo_vbulletin_sef_to_announcement( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'vbulletin_rewrite_announcement_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$forum_id			= isset( $matches['forum_id'] ) ? intval( $matches['forum_id'] ) : 0;
	$announcement_id	= isset( $matches['announcement_id'] ) ? intval( $matches['announcement_id'] ) : 0;

	$forum_title		= isset( $matches['forum_title'] ) ? $matches['forum_title'] : 0;
	$forum_path			= isset( $matches['forum_path']	) ? $matches['forum_path']		: false;
	
	$announcement_title	= isset( $matches['announcement_title'] ) ? $matches['announcement_title'] : 0;
	
	if (!$announcement_id && $announcement_title)		// then try nuseo_slug
	{
		$announcement = nuseo_vbulletin_get_object_from_slug( $module, 'announcement', $url );
		if ($announcement)
			$announcement_id = $announcement['announcementid'];
	}
	
	if (!$forum_id && $forum_title)
	{
		if ($forum_title == 'general')
			$forum_id = false;
		else
			$forum_id = nuseo_vbulletin_get_forum_id_from_title( $module, $forum_title );
	}

	if (!$forum_id && $forum_path)
	{
		if ($forum_path == 'general')
			$forum_id = false;
		else
			$forum_id = nuseo_vbulletin_get_forum_id_from_path( $module, $forum_path );
	}

	if (!$forum_id && !$announcement_id)
		return false;

	if ($forum_id)	
		$query_params['f'] = $forum_id;
		
	if ($announcement_id)	
		$query_params['a'] = $announcement_id;

	$non_sef_url = "announcement.php";
	
	return $non_sef_url;
}
//

// forumhome
function nuseo_vbulletin_forumhome_to_sef(  &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	// check if we are not already there.
	if (!isset($_SERVER['REQUEST_URI']))
		return false;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$sef_target_path = $nuseo['base_url_path'] . $module['url_base'];
	
	$request_uri = $_SERVER['REQUEST_URI'];
	$query_pos = strpos( $request_uri, '?' );
	if ($query_pos !== false)
		$request_uri = substr( $request_uri, 0, $query_pos );
		
	if ($sef_target_path == $request_uri)
	{
		return false;		// already there
	}
			
	$sef_url = '';
	
	return $sef_url;
}
//

// Misc Functions
function nuseo_vbulletin_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config;

	$vbulletin_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'includes/config.php';
	if (file_exists( $vbulletin_config_filename ))
	{
		$config = array();
		include $vbulletin_config_filename;
		
		// read DB connection vars
		$server_name			= $config['MasterServer']['servername'];
		$server_port			= $config['MasterServer']['port'];
		$db_username			= $config['MasterServer']['username'];
		$db_password			= $config['MasterServer']['password'];
		$module['db_name']		= $config['Database']['dbname'];
		$module['table_prefix']	= $config['Database']['tableprefix'];
		$module['datastore_class'] = isset( $config['Datastore']['class'] ) ? $config['Datastore']['class'] : '';
		
		$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
											$db_username, $db_password, $module['db_name'] );

		// do not store username/password in memory
		unset( $server_name, $server_port, $db_username, $db_password );
	}
	else
		$module['db_conn']		= false;
}

function nuseo_vbulletin_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;

	$url_formats_defs = array(
		'forum'				=> $nuseo_config[ 'vbulletin_forum_format' ],
		'forum_pages'		=> $nuseo_config[ 'vbulletin_forum_pages_format' ],
		'thread'			=> $nuseo_config[ 'vbulletin_thread_format' ],
		'thread_pages'		=> $nuseo_config[ 'vbulletin_thread_pages_format' ],
		'previous_thread'	=> $nuseo_config[ 'vbulletin_previous_thread_format' ],
		'next_thread'		=> $nuseo_config[ 'vbulletin_next_thread_format' ],
		'go_to_post'		=> $nuseo_config[ 'vbulletin_go_to_post_format' ],
		'go_to_post_pages'	=> $nuseo_config[ 'vbulletin_go_to_post_pages_format' ],
		'thread_new_post'	=> $nuseo_config[ 'vbulletin_thread_new_post_format' ],
		'thread_last_post'	=> $nuseo_config[ 'vbulletin_thread_last_post_format' ],
		'showpost'			=> $nuseo_config[ 'vbulletin_show_post_format' ],
		'poll'				=> $nuseo_config[ 'vbulletin_poll_format' ],
		'memberlist'		=> $nuseo_config[ 'vbulletin_member_list_format' ],
		'memberlist_pages'	=> $nuseo_config[ 'vbulletin_member_list_pages_format' ],
		'memberlist_letter'	=> $nuseo_config[ 'vbulletin_member_list_letter_format' ],
		'member'			=> $nuseo_config[ 'vbulletin_member_format' ],
		'announcement'		=> $nuseo_config[ 'vbulletin_announcement_format' ],
		'all_announcements'	=> $nuseo_config[ 'vbulletin_all_announcement_format' ],
		'forum_path_bit'	=> $nuseo_config[ 'vbulletin_forum_path_bit' ]
	);
	
	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_vbulletin_get_pattern_from_format( $format_str ); 
	}
}

function nuseo_vbulletin_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();

	if ($nuseo_config[ 'vbulletin_rewrite_forum_urls' ])
	{
		// process custom absolute forum paths first
		if (isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ] ) && !empty($nuseo_config[ 'vbulletin_custom_forum_url_list' ]))
		{
			// forumdisplay.php => sef
			$rules[] = array(	'sef_pattern'				=> $module['forum_sef_pattern'],
								'translate_to_non_sef'		=> 'nuseo_vbulletin_sef_to_forumdisplay',
								'sef_pattern_is_absolute'	=> true
							);
			// variants of forumdisplay.php 
			$rules[] = array(	'sef_pattern'				=> $module['forum_pages_sef_pattern'],
								'translate_to_non_sef'		=> 'nuseo_vbulletin_sef_to_forumdisplay',
								'sef_pattern_is_absolute'	=> true
							);
		}

		// forumdisplay.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'forumdisplay\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_forumdisplay_to_sef',

							'sef_pattern'			=> $module['forum_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_forumdisplay'
						);
		// variants of forumdisplay.php 
		$rules[] = array(	'sef_pattern'			=> $module['forum_pages_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_forumdisplay'
						);
						
		/*	-- this is no longer needed. using generic pattern for absolute urls above.
		// support custom forum urls
		foreach ($nuseo_config[ 'vbulletin_custom_forum_urls' ] as $forumid => $custom_forum_url)
		{
			$custom_forum_format = nuseo_vbulletin_set_url_root( $nuseo_config[ 'vbulletin_forum_format' ], $custom_forum_url );
			$custom_forum_sef_pattern = nuseo_vbulletin_get_pattern_from_format( $custom_forum_format );
			$rules[] = array(	'sef_pattern'				=> $module['forum_sef_pattern'],
								'sef_pattern_is_absolute'	=> true,
								'translate_to_non_sef'		=> 'nuseo_vbulletin_sef_to_forumdisplay',
								'translate_to_non_sef_args' => array( 'forum_id' => $forumid )
							);
			// variants of forumdisplay.php 
			$custom_forum_pages_format = nuseo_vbulletin_set_url_root( $nuseo_config[ 'vbulletin_forum_pages_format' ], $custom_forum_url );
			$custom_forum_pages_sef_pattern = nuseo_vbulletin_get_pattern_from_format( $custom_forum_pages_format );
			$rules[] = array(	'sef_pattern'				=> $custom_forum_pages_sef_pattern,
								'sef_pattern_is_absolute'	=> true,
								'translate_to_non_sef'		=> 'nuseo_vbulletin_sef_to_forumdisplay',
								'translate_to_non_sef_args' => array( 'forum_id' => $forumid )
							);
		}
		*/
	}

	if ($nuseo_config[ 'vbulletin_rewrite_thread_urls' ])
	{
		// process custom absolute forum paths first
		if (isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ] ) && !empty($nuseo_config[ 'vbulletin_custom_forum_url_list' ]))
		{
			// variants of showthread.php
			$rules[] = array(	'sef_pattern'			=> $module['previous_thread_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_previous',
								'sef_pattern_is_absolute'	=> true
							);

			$rules[] = array(	'sef_pattern'			=> $module['next_thread_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_next',
								'sef_pattern_is_absolute'	=> true
							);

			$rules[] = array(	'sef_pattern'			=> $module['thread_new_post_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_new_post',
								'sef_pattern_is_absolute'	=> true
							);
							
			$rules[] = array(	'sef_pattern'			=> $module['thread_last_post_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_last_post',
								'sef_pattern_is_absolute'	=> true
							);
							
			$rules[] = array(	'sef_pattern'			=> $module['go_to_post_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread',
								'sef_pattern_is_absolute'	=> true
							);
							
			$rules[] = array(	'sef_pattern'			=> $module['go_to_post_pages_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread',
								'sef_pattern_is_absolute'	=> true
							);

			// showthread.php ==> sef
			$rules[] = array(	'sef_pattern'			=> $module['thread_pages_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread',
								'sef_pattern_is_absolute'	=> true
							);

			$rules[] = array(	'sef_pattern'			=> $module['thread_sef_pattern'],
								'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread',
								'sef_pattern_is_absolute'	=> true
							);
		}
		
		// variants of showthread.php
		$rules[] = array(	'sef_pattern'			=> $module['previous_thread_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_previous'
						);

		$rules[] = array(	'sef_pattern'			=> $module['next_thread_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_next'
						);

		$rules[] = array(	'sef_pattern'			=> $module['thread_new_post_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_new_post'
						);

		$rules[] = array(	'sef_pattern'			=> $module['thread_last_post_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread_goto_last_post'
						);

		$rules[] = array(	'sef_pattern'			=> $module['go_to_post_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread'
						);
						
		$rules[] = array(	'sef_pattern'			=> $module['go_to_post_pages_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread'
						);

		// showthread.php ==> sef
		$rules[] = array(	'sef_pattern'			=> $module['thread_pages_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread'
						);

		$rules[] = array(	'non_sef_pattern'		=> 'showthread\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_showthread_to_sef',

							'sef_pattern'			=> $module['thread_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showthread'
						);
	}

	if ($nuseo_config[ 'vbulletin_rewrite_showpost_urls' ])
	{
		// showpost.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'showpost\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_showpost_to_sef',

							'sef_pattern'			=> $module['showpost_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_showpost'
						);
	}
	
	if ($nuseo_config[ 'vbulletin_rewrite_poll_urls' ])
	{
		// showpost.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'poll\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_poll_to_sef',

							'sef_pattern'			=> $module['poll_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_poll'
						);
	}
	
	if ($nuseo_config[ 'vbulletin_rewrite_member_list_urls' ])
	{
		// memberlist.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'memberlist\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_memberlist_to_sef',

							'sef_pattern'			=> $module['memberlist_pages_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_memberlist'
						);
						
		$rules[] = array(	'sef_pattern'			=> $module['memberlist_letter_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_memberlist'
						);

		$rules[] = array(	'sef_pattern'			=> $module['memberlist_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_memberlist'
						);
	}

	if ($nuseo_config[ 'vbulletin_rewrite_member_urls' ])
	{
		// member.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'member\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_member_to_sef',

							'sef_pattern'			=> $module['member_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_member'
						);
	}

	if ($nuseo_config[ 'vbulletin_rewrite_announcement_urls' ])
	{
		// announcement.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'announcement\.php', 
							'translate_to_sef'		=> 'nuseo_vbulletin_announcement_to_sef',

							'sef_pattern'			=> $module['announcement_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_announcement'
						);
						
		$rules[] = array(	'sef_pattern'			=> $module['all_announcements_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbulletin_sef_to_announcement'
						);
	}

	if ($nuseo_config[ 'vbulletin_redir_archive' ])
	{
		// archive/index.php/f-[forum_id].html => sef
		$rules[] = array(	'non_sef_pattern'		=> 'archive/index\.php/f-(?P<forum_id>\d+).html', 
							'translate_to_sef'		=> 'nuseo_vbulletin_forumdisplay_to_sef' );

		// archive/index.php/t-[thread_id].html => sef
		$rules[] = array(	'non_sef_pattern'		=> 'archive/index\.php/t-(?P<thread_id>\d+).html', 
							'translate_to_sef'		=> 'nuseo_vbulletin_showthread_to_sef' );
	}
	
	if ($nuseo_config[ 'vbulletin_forum_root_as_homepage' ])
	{
		$forum_home_script = 'index.php';		// $module['vb_forumhome'];
		$rules[] = array(	'non_sef_pattern'		=>  str_replace('.', '\.', $forum_home_script),
							'translate_to_sef'		=> 'nuseo_vbulletin_forumhome_to_sef' );
							
		if ($forum_home_script != 'index.php')
			$rules[] = array(	'sef_pattern'		=>  'index\.php', 
								'non_sef_target'	=> $forum_home_script );
	}

	// Add rules for help.php, misc.php, sendmessage.php, ajax.php when called from javascript
	$rules[] = array(	'non_sef_pattern'		=> '.*/misc\.php\?(.*)',
						'sef_target'			=> 'misc.php?$1' );
	
	$rules[] = array(	'non_sef_pattern'		=> '.*/ajax\.php\?(.*)',
						'sef_target'			=> 'ajax.php?$1' );
	
	$rules[] = array(	'non_sef_pattern'		=> '.*/sendmessage\.php\?(.*)',
						'sef_target'			=> 'sendmessage.php?$1' );
	
	$rules[] = array(	'non_sef_pattern'		=> '.*/help\.php\?(.*)',
						'sef_target'			=> 'help.php?$1' );

	$rules[] = array(	'non_sef_pattern'		=> '.+/showthread\.php\?(.*)',
						'sef_target'			=> 'showthread.php?$1' );

	$rules[] = array(	'non_sef_pattern'		=> '.+/forumdisplay\.php\?(.*)',
						'sef_target'			=> 'forumdisplay.php?$1' );

	$module['rules'] = $rules;
}

function nuseo_vbulletin_load_path_blacklist( &$module )
{
	global $nuseo, $nuseo_config;
	
	if (is_array( $nuseo_config['runtime_path_blacklist'] ))
	{
		$nuseo_config['runtime_path_blacklist'][] = $module['url_base'] . 'login.php';
		$nuseo_config['runtime_path_blacklist'][] = $module['url_base'] . 'admincp/';
		$nuseo_config['runtime_path_blacklist'][] = $module['url_base'] . 'modcp/';
	}
}


function nuseo_vbulletin_load_datastore( &$module )
{
	global $nuseo, $nuseo_config, $vbulletin;

	if (isset($module['vb_forumcache']) && $module['vb_forumcache'])
	{
		if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_load_datastore.. vb_forumcache populated.\n" ); };
		return;
	}

	$module['vb_forumcache']	= false;

	if (isset($vbulletin))		// then read forum cache from vbulletin
	{
		$module['vb_forumcache'] =& $vbulletin->forumcache;
		if (!empty($vbulletin->pt_projects))
		{
			$module['vb_pt_projects'] =& $vbulletin->pt_projects;
		}
		else
		{
			$module['vb_pt_projects'] = array();
		}
		if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_load_datastore.. getting vb_forumcache from vbulletin\n" ); };
	}
	else
	{
		$db_conn = nuseo_get_db_connection( $module );
		if ($db_conn)
		{
			if (empty( $module['datastore_class'] ) || ($module['datastore_class'] == 'vB_Datastore'))
			{
				nuseo_vbulletin_load_datastore_from_db( $module, $db_conn );
			}

			// check memcached, APC, XCache, etc.

			if (empty( $module['vb_forumcache']) && !empty( $module['datastore_class'] ))
			{
				//if ($module['datastore_class'] == 'vB_Datastore_Memcached')
				{
					nuseo_vbulletin_load_datastore_from_cache( $module, $db_conn );
				}
			}


			if (empty( $module['vb_forumcache']))		// couldn't get it from vb_datastore or datastore servers
			{
				nuseo_vbulletin_load_datastore_from_forums( $module, $db_conn );
			}

			if ($nuseo['debug_mode']) { print_r( array_keys($module['vb_forumcache']) ); };
		}
	}
}

function nuseo_vbulletin_load_datastore_from_db( &$module, &$db_conn )
{
	global $nuseo, $nuseo_config, $vbulletin;

	if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_load_datastore.. getting vb_forumcache from DB datastore\n" ); };
	
	$sql = "SELECT * FROM `" . $module['table_prefix'] . "datastore` ";

	if ( !empty($nuseo['projecttools_enabled']) )
	{
		$sql .= " WHERE title IN ('forumcache', 'pt_projects')";
	}
	else
	{
		$sql .= " WHERE title = 'forumcache'";
	}
	$rows = $db_conn->execute_read( $sql );
	while ($row = $db_conn->fetch_array( $rows ))
		$module['vb_' . $row['title'] ] = unserialize( $row['data'] );
}


function nuseo_vbulletin_load_datastore_from_cache( &$module, &$db_conn )
{
	global $nuseo, $nuseo_config, $vbulletin, $nuseo_cache;

	if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_load_datastore.. getting vb_forumcache from in-memory datastore\n" ); };
	
	if ($nuseo_cache)
	{
		$key = 'forumcache';
		$vb_forumcache = $nuseo_cache->get_array( 'forumcache' );
		
		if (!empty($vb_forumcache) && is_array( $vb_forumcache ))
		{
			$module['vb_forumcache'] = $vb_forumcache;
		}

		if ( !empty($nuseo['projecttools_enabled']) )
		{
			$key = 'pt_projects';
			$vb_pt_projects = $nuseo_cache->get_array( 'forumcache' );
			
			if (!empty($vb_pt_projects) && is_array( $vb_pt_projects ))
			{
				$module['vb_pt_projects'] = $vb_forumcache;
			}
		}
	}
}


function nuseo_vbulletin_load_datastore_from_forums( &$module, &$db_conn )
{
	global $nuseo, $nuseo_config, $vbulletin;

	if ($nuseo['debug_mode']) { echo( "nuseo_vbulletin_load_datastore.. getting vb_forumcache from forum table..\n" ); };				

	$vb_forumcache = array();
	
	$sql = "SELECT * FROM `" . $module['table_prefix'] . "forum`";
	$rows = $db_conn->execute_read( $sql );
	while ($forum = $db_conn->fetch_array( $rows ))
	{
		$forumid = $forum['forumid'];
		$vb_forumcache[ $forumid ] = $forum;
	}
	
	$module['vb_forumcache'] = $vb_forumcache;
}

function nuseo_vbulletin_load_forum_information( &$module )
{
	global $nuseo, $nuseo_config;

	$module['in_mem_forum_info'] = array();

	if (!isset( $module['vb_forumcache'] ))
	{
		nuseo_vbulletin_load_datastore( $module );
		if (!$module['vb_forumcache'] )
			return;
	}

	$vb_forumcache =& $module['vb_forumcache'];

	if ($vb_forumcache && is_array( $vb_forumcache ))
	{
		$update_this_forum = array();
		foreach (array_keys($vb_forumcache) as $forumid)
		{
			$forum =& $vb_forumcache[ $forumid ];
			$update_this_forum = false;

			$info = array();
			$info['forum_id'] = $forum['forumid'];

			if (!isset($forum['nuseo_title']) || !$forum['nuseo_title'])
			{
				if (isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ] ) && isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ][$forumid] ))
				{	// if this is a forum with a custom URL, replace its title with the custom URL.

					$forum_custom_url = $nuseo_config[ 'vbulletin_custom_forum_url_list' ][ $forumid ];
					$forum_custom_domain = !empty( $nuseo_config[ 'vbulletin_custom_forum_domain_list' ][ $forumid ] ) 
											? $nuseo_config[ 'vbulletin_custom_forum_domain_list' ][ $forumid ] : '';
					
					$forum['nuseo_title'] = $forum_custom_url;
					if (substr( $forum_custom_url, -1 ) == '/')
						$forum['nuseo_title'] = substr( $forum_custom_url, 0, -1 );		// if $forum['nuseo_title'] ends in a slash, remove it.
						
					$forum['nuseo_domain'] = $forum_custom_domain;
				}
				else
				{	// else, regular forum, clean up forum title and domain.
					$forum['nuseo_title'] = nuseo_str_to_url( $forum['title'] );
					$forum['nuseo_domain'] = '';
				}
				$update_this_forum = true;
			}
			
			if (empty( $forum['nuseo_domain'] ))
			{
				$forum['nuseo_domain'] = '';
			}

			$info['forum_title']	= $forum['nuseo_title'];
			$info['forum_domain']	= $forum['nuseo_domain'];

			if (!isset($forum['nuseo_path']) || !$forum['nuseo_path'])
			{
				$update_this_forum = true;	// wait till all forum titles are processed before we build this forum_path
			}
			else
				$info['forum_path']	= $forum['nuseo_path'];

			if (!isset($forum['nuseo_slug']) || !$forum['nuseo_slug'])
			{
				$update_this_forum = true;	// wait till all forum titles and paths are processed before we build this forum_path
			}
			else
				$info['forum_sef_url'] = $forum['nuseo_slug'];

			$module['in_mem_forum_info'][ $forumid ] = $info;
			
			if ($update_this_forum)
				$forums_to_update[] = $forumid;
		} // foreach
		
		// Update any forum that needs updating
		if (!empty( $forums_to_update ))
		{
			$db_conn = nuseo_get_db_connection( $module );
			if ($db_conn)
			{
				foreach ($forums_to_update as $forumid)
				{
					if (!$forumid)
						continue;
					$forum =& $vb_forumcache[ $forumid ];
					// check forum's forum path, since its generation may have been postponed
					if (!isset($forum['nuseo_path']) || !$forum['nuseo_path'])
					{
						if (isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ] ) && isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ][$forumid] ))
						{	// if this is a forum with a custom URL, replace its forum_path with the custom URL.

							$forum_custom_url = $nuseo_config[ 'vbulletin_custom_forum_url_list' ][ $forumid ];
							$forum_custom_domain = !empty( $nuseo_config[ 'vbulletin_custom_forum_domain_list' ][ $forumid ] ) 
													? $nuseo_config[ 'vbulletin_custom_forum_domain_list' ][ $forumid ] : '';

							$forum_path = $forum_custom_url;
							if (substr( $forum_path, -1 ) == '/')
								$forum_path = substr( $forum_path, 0, -1 );		// if $forum_path ends in a slash, remove it.
						}
						else
						{	// else, generate forum path for regular forums.
							$forum_path = nuseo_vbulletin_generate_forum_path( $module, $forumid, $vb_forumcache );
						}
						$forum['nuseo_path'] = $forum_path;
						$module['in_mem_forum_info'][ $forumid ]['forum_path'] = $forum_path;
					}
					
					if (!isset($forum['nuseo_slug']) || !$forum['nuseo_slug'])
					{
						// Evaluate SEF URL
						$info = array( 'forum_id' => $forumid, 'forum_title' => $forum['nuseo_title'], 
										'forum_path' => $forum['nuseo_path'] );
						eval( '$sef_url = "' . $module['forum_url_format'] . '";' );
						$forum['nuseo_slug'] = str_replace( '//', '/', $sef_url );
						$module['in_mem_forum_info'][ $forumid ]['forum_sef_url'] = $sef_url;
					}
					
					
					$sql = "UPDATE `" . $module['table_prefix'] . "forum`
							SET nuseo_title = '" . addslashes( $forum['nuseo_title'] ) . "',
								nuseo_path = '"  . addslashes( $forum['nuseo_path'] ) . "',
								nuseo_slug = '" . addslashes( $forum['nuseo_slug'] ) . "',
								nuseo_domain = '" . addslashes( $forum['nuseo_domain'] ) . "'
							WHERE forumid = $forumid";
					$db_conn->execute_write( $sql );
				} // foreach forum to be updated
			} // if db_conn
			$module['rebuild_forum_datastore'] = true;			// we'll need to rebuild vBulletin's forumcache datastore
		} // if !empty( $forumds_to_update )
	} // if vb_forumcache and is_array
}

function nuseo_vbulletin_generate_forum_path( &$module, $forumid, &$vb_forumcache )
{
	global $nuseo, $nuseo_config;

	$forum_path_bit_format = $module['forum_path_bit_url_format'];

	$forum_bits = array();

	while ($forumid > 0)
	{
		if (!isset( $vb_forumcache[ $forumid ] ))
			break;

		$forum =& $vb_forumcache[ $forumid ];

		$info = array( 'forum_id' => $forumid, 'forum_title' => $forum['nuseo_title'] );


		eval( '$forum_bit = "' . $forum_path_bit_format . '";' );

		$forum_bits[] = $forum_bit;

		if ($forum['nuseo_title'] && ($forum['nuseo_title'][0] == '/'))
		{	// if this forum has an absolute path set, stop here.
			break;
		}

		$forumid = $forum['parentid'];
	}

	// reverse and concat
	$forum_bits = array_reverse( $forum_bits );

	$forum_path = implode( '', $forum_bits );
	
	$forum_path = str_replace( '//', '/', $forum_path );
	
	if (substr( $forum_path, -1 ) == '/')
		$forum_path = substr( $forum_path, 0, -1 );		// if forum_path ends in a slash, remove it.

	return $forum_path;
}

function nuseo_vbulletin_get_forum_info( &$module, $forumid )
{
	if (!isset( $module['in_mem_forum_info'] ) || !is_array( $module['in_mem_forum_info'] ))
		nuseo_vbulletin_load_forum_information( /*ref*/ $module );

	if ( !isset( $module['in_mem_forum_info'][ $forumid ] ) )
		return false;
		
	return $module['in_mem_forum_info'][ $forumid ];
}

function nuseo_vbulletin_get_forum_id_from_title( &$module, $forum_title )
{	
	if (!isset( $module['in_mem_forum_info'] ) || !is_array( $module['in_mem_forum_info'] ))
		nuseo_vbulletin_load_forum_information( /*ref*/ $module );
	
	foreach ($module['in_mem_forum_info'] as $forumid => $info)
	{
		if ($info['forum_title'] == $forum_title )
			return $forumid;
	}
	return false;
}

function nuseo_vbulletin_get_forum_id_from_path( &$module, $forum_path )
{	
	if (!isset( $module['in_mem_forum_info'] ) || !is_array( $module['in_mem_forum_info'] ))
		nuseo_vbulletin_load_forum_information( /*ref*/ $module );
	
	foreach ($module['in_mem_forum_info'] as $forumid => $info)
	{
		if ($info['forum_path'] == $forum_path )
			return $forumid;
	}
	return false;
}

function nuseo_vbulletin_get_pattern_from_format( $format, $end_of_url = true )
{
	global $nuseo, $nuseo_config;

	$id_parts	= array(	'#\[(forum_id)\]#',		'#\[(thread_id)\]#',	'#\[(post_id)\]#', 
							'#\[(forum_page)\]#',	'#\[(thread_page)\]#',	'#\[(post_count)\]#',
                            '#\[(poll_id)\]#',	'#\[(user_id)\]#',	'#\[(announcement_id)\]#',
                            );

	
	if (isset( $nuseo_config[ 'vbulletin_custom_forum_url_list' ] ) && !empty($nuseo_config[ 'vbulletin_custom_forum_url_list' ]))
	{	// then we are using custom absolute paths for some forums, allow forum_title to contain slashes
		$path_parts	= array(	'#\[(forum_path)\]#', '#\[(forum_title)\]#'		);			// these can include slashes
	}
	else
	{
		$path_parts	= array(	'#\[(forum_path)\]#' );			// these can include slashes
	}

	$pattern = preg_replace( $id_parts, '(?P<\1>\d+)', $format );
	$pattern = preg_replace( $path_parts, '(?P<\1>[\w/\\' .  $nuseo_config[ 'separator' ]. ']+)', $pattern );
	$pattern = preg_replace( '#\[([\w_]+)\]#', '(?P<\1>[\w\\' .  $nuseo_config[ 'separator' ]. ']+)', $pattern );
	
	if ($end_of_url)
	{
		$pattern_len = strlen( $pattern );
		if ($pattern_len && ($pattern[ $pattern_len-1 ] == '/'))
			$pattern .= '?';		// if pattern ends in directory, allow for the trailing slash to be omitted

		$pattern .= '(?:\#|\?|$)';
	}

	return $pattern;
}

function nuseo_vbulletin_set_url_root( $url, $new_root )
{
	$first_slash = strpos( $url, '/' );
	if ($first_slash !== false)
		$url = $new_root . substr( $url, $first_slash+1 );
	else
		$url = $new_root . $url;
	return $url;
}

function nuseo_vbulletin_can_user_view_forum( &$module, $forumid )
{
	global $nuseo, $nuseo_config, $vbulletin;

	$can_view_forum = true;

	if (!isset( $module['vb_forumcache'] ))
	{
		nuseo_vbulletin_load_datastore( $module );
	}

	if (isset($module['vb_forumcache']))
	{
		$vb_forumcache =& $module['vb_forumcache'];

		if (isset( $vb_forumcache[ "$forumid" ] ))
		{
			$foruminfo =& $vb_forumcache[ "$forumid" ];

			/*
			// Check if forum is active. If it is not, it is private, yet it is still accessible.
			global $vbulletin;
			$active_constant = (isset( $vbulletin ) && isset( $vbulletin->bf_misc_forumoptions )) 
								? $vbulletin->bf_misc_forumoptions['active'] : 1;
			$forum_is_active = ($foruminfo['options'] & $active_constant);
			*/
			
			$usergroup_id = 1;		// 1 == unregistered/not logged in users
			
			$forumperms = (isset($foruminfo['permissions']) && isset($foruminfo['permissions'][ "$usergroup_id" ]))
							? $foruminfo['permissions'][ "$usergroup_id" ] : 0;
			
			if (isset($vbulletin) && isset($vbulletin->bf_ugp_forumpermissions))
			{
				$constant_canview			= $vbulletin->bf_ugp_forumpermissions['canview'];
				$constant_canviewothers		= $vbulletin->bf_ugp_forumpermissions['canviewothers'];
				$constant_canviewthreads	= $vbulletin->bf_ugp_forumpermissions['canviewthreads'];
			}
			else
			{
				$constant_canview			= 1;
				$constant_canviewothers		= 2;
				$constant_canviewthreads	= 524288;
			}
			
			if (!($forumperms & $constant_canview))
				$can_view_forum = false;				// user cannot view forum
			else if (!($forumperms & $constant_canviewothers))
				$can_view_forum = false;				// user cannot view other's threads
			else if (!($forumperms & $constant_canviewthreads))
				$can_view_forum = false;				// user cannot view threads
			else
				$can_view_forum = true;
		}
	}
	return $can_view_forum;
}

//

// vBulletin DB Interface
function nuseo_vbulletin_fetch_poll( &$module, $cache_type, $pollid )
{
	$table_name = 'poll';

	$id_field_name = 'pollid';

	$sql = "SELECT thread.*, poll.* FROM `" . $module['table_prefix'] . "poll` poll 
				LEFT OUTER JOIN `" . $module['table_prefix'] . "thread` thread ON thread.pollid = poll.pollid";

	$additional_where = "thread.open <> 10";
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $pollid, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_vbulletin_update_slug( &$module, $table_name, $id, &$sef_url )
{
	global $nuseo, $nuseo_config;

	$slug_cache_name = $table_name . "_slug";
	$previously_updated = nuseo_cache_get( $module, $slug_cache_name, $id );
	if ($previously_updated)
		return;

	$db_conn = nuseo_get_db_connection( $module );
	if ($db_conn)
	{
		$id_field = $table_name . "id";
		$sql = "UPDATE `" . $module['table_prefix'] . $table_name . "` SET nuseo_slug = '" . addslashes( $sef_url ) . "'
					WHERE $id_field = $id";
		$db_conn->execute_write( $sql );
	}	
	nuseo_cache_add( $module, $slug_cache_name, $id, true );		// we store whether we updated this slug previously in this session
}

function nuseo_vbulletin_get_object_from_slug( &$module, $table_name, $url )
{
	global $nuseo, $nuseo_config;

	$slug_cache_name = $table_name . "_slug";

	// get sef_url from $url
	$params_pos = strpos( $url, '?' );
	if ($params_pos === 0)
		return false;

	if ($params_pos !== false)
		$sef_url = substr( $url, 0, $params_pos );
	else
		$sef_url = $url;
		
	$object = nuseo_cache_get( $module, $slug_cache_name, $sef_url );
	if ($object)
		return $object;

	$db_conn = nuseo_get_db_connection( $module );
	if ($db_conn)
	{
		$id_field = $table_name . "id";
		$sql = "SELECT * FROM `" . $module['table_prefix'] . $table_name . "` the_table 
					WHERE nuseo_slug = '" . addslashes( $sef_url ) . "'";
		$object = $db_conn->get_one( $sql );
	}

	if ($object)
	{
		nuseo_cache_add( $module, $slug_cache_name, $sef_url, $object );
		
		// Add to corresponding object cache
		$id = isset( $object[ $id_field ] ) ? $object[ $id_field ] : 0;
		if ($id)
			nuseo_cache_add( $module, $table_name, $id, $object );
	}

	return $object;
}
//

// vBulletin Plugins - Initialization and Global
function nuseo_vbulletin_style_fetch()
{
	global $vbulletin, $nuseo, $nuseo_vbulletin;
	
	$nuseo_vbulletin['guest_mode'] = $vbulletin->userinfo['userid'] == 0;
}

function nuseo_vbulletin_global_start()
{
	global $nuseo, $nuseo_config, $vbulletin, $nuseo_vbulletin, $threadinfo, $postinfo, $userinfo, $headinclude, $vbphrase;
    
    
    $postbit_name = $vbulletin->options['legacypostbit'] ? 'postbit_legacy' : 'postbit';

	$social_bookmarks_mode = $nuseo_config[ 'vbulletin_social_bookmarks_mode' ];
    
	if (($social_bookmarks_mode == SOCIAL_BOOKMARKS_IN_BOTH) && (THIS_SCRIPT == 'showthread'))
	{
		nuseo_vbulletin_init_social_bookmarking( /*ref*/ $nuseo_vbulletin );
		if (!empty($nuseo_vbulletin['social_bookmarks']) && count($nuseo_vbulletin['social_bookmarks']))
		{

			$postbit_template = fetch_template( $postbit_name );

			$nuseo_social_ctr = '<div style=\"float:left\">$post[nuseo_social]</div>';

			if (strpos( $postbit_template, '<!-- NUSEO_SOCIAL_BOOKMARKS -->' ) !== false)
				$vbulletin->templatecache[ $postbit_name ] = str_replace( '<!-- NUSEO_SOCIAL_BOOKMARKS -->', $nuseo_social_ctr, 
																		$postbit_template );
			else
				$vbulletin->templatecache[ $postbit_name ] = str_replace( '<!-- controls -->', "<!-- controls -->$nuseo_social_ctr", 
																		$postbit_template );
		}
	}
    
    //copyright mark
    $vbphrase[ 'powered_by_vbulletin'] .= "<br /> " . COPYRIGHT_PLACEHOLDER;
    
    
    if ( $nuseo_config[ 'vbulletin_h1_in_navbar' ] || $nuseo_config[ 'vbulletin_h2_for_post_title' ] )
    {
        
        $header_style = <<<NUSEO_HTML
<style>
	.nuseo_hx { display: inline; color: inherit; border: none; font-size: 1em; font-color: inherit; font-weight: inherit; padding: 0px; margin: 0px; }
</style>
NUSEO_HTML;
        
        $headinclude_template = fetch_template( "headinclude" );
        $headinclude_template = str_replace( '$style[css]', $header_style . '$style[css]', $headinclude_template  );
        
        $vbulletin->templatecache[ "headinclude" ] = $headinclude_template;        
        
        if ( $nuseo_config[ 'vbulletin_h1_in_navbar' ] )
        {
            $navbar_template = fetch_template( "navbar" );
            $navbar_template = str_replace( '$navbits[lastelement]', '<h1 class=nuseo_hx>$navbits[lastelement]</h1>', $navbar_template  );
            
            $vbulletin->templatecache[ "navbar" ] = $navbar_template;
            
        }
        
        if ( $nuseo_config[ 'vbulletin_h2_for_post_title' ] && (THIS_SCRIPT == 'showthread') )
        {
            $postbit_template = fetch_template( $postbit_name );

	        $vbulletin->templatecache[ $postbit_name ] = str_replace( '$post[title]', '<h2 class=nuseo_hx>$post[title]</h2>', $postbit_template );
        }
    }

    
    nuseo_vbulletin_optimize_templates();
    
	// logged in user 
	nuseo_vbulletin_add_user_to_cache( $vbulletin->userinfo );

	// add threadinfo to cache, if set
	if (isset( $threadinfo ))
		nuseo_vbulletin_add_thread_to_cache( $threadinfo );

	// add $postinfo to cache, if set
	if (isset( $postinfo ))
		nuseo_vbulletin_add_post_to_cache( $postinfo );

	// add $userinfo to cache, if set
	if (isset( $userinfo ))
		nuseo_vbulletin_add_user_to_cache( $userinfo );
}

function nuseo_vbulletin_global_complete( &$output )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
    
    
    if ( $nuseo['debug_profile'] )
    {
        global $nuseo_core_time_before_include, $nuseo_profile_output, $nuseo_core_time_in_script;
        $nuseo_core_time_after_include = nu_microtime();
        $nuseo_core_time_in_script = $nuseo_core_time_after_include - $nuseo_core_time_before_include;
        $nuseo_profile_output .= "Script Execution (vBulletin): " . $nuseo_core_time_in_script . "<BR>";
    }

	// Set up meta tags
	if ($nuseo_config[ 'vbulletin_replace_keywords' ]|| $nuseo_config[ 'vbulletin_replace_description' ])
	{
        $meta_keywords_source = "";
        $meta_description = "";
        
		if (THIS_SCRIPT == 'forumdisplay')
		{
			global $foruminfo;
			$meta_keywords_source	= $foruminfo['title'];
			$meta_description		= $foruminfo['title']  . ' - ' .  $foruminfo['description'];
		}
		else if (THIS_SCRIPT == 'showthread')
		{
			global $threadinfo;
			$meta_keywords_source	= $threadinfo['title'];
            
			// get thread description from first post
			if (isset( $nuseo_vbulletin['first_post'] ))
			{
				//$nuseo['meta_description']		= preg_replace( '#[^\w\,\.\-\_]+#', ' ', 
				//					strip_tags( $nuseo_vbulletin['first_post']['message'] ) );
				$meta_description		= $threadinfo['title'] . ' - ' . $nuseo_vbulletin['first_post']['message'];
			}
		}
		else if ((THIS_SCRIPT == 'member') && $nuseo_config[ 'vbulletin_member_description_format' ])
		{
			global $vbulletin, $userinfo;
			
			$usertitle = strip_tags( $userinfo['usertitle'] );
			
			// build user description
			$info = array(
				'[username]'	=>	$userinfo['username'],
				'[usertitle]'	=>	$usertitle,
				'[bbtitle]'		=>	$vbulletin->options['bbtitle']
			);

			$meta_description = str_replace( array_keys( $info ), array_values( $info ), 
														$nuseo_config[ 'vbulletin_member_description_format' ]);
			$meta_keywords_source = $userinfo['username'];
		}

		if ($nuseo_config[ 'vbulletin_max_description_length' ] > 0)
		{
			$nuseo['meta_description_length'] = $nuseo_config[ 'vbulletin_max_description_length' ];
		}

        if ($nuseo_config[ 'vbulletin_replace_keywords' ] )
        {
            $nuseo['meta_keywords_source'] .=  strip_tags( $meta_keywords_source );
        }
        
        if ($nuseo_config[ 'vbulletin_replace_description' ] )
        {
            $nuseo['meta_description'] .=  strip_tags( $meta_description );
        }        
	}
	
	// Insert Copyright_placeholder
	if (!strpos( $output, COPYRIGHT_PLACEHOLDER ))
		$output = str_replace( "Jelsoft Enterprises Ltd.", "Jelsoft Enterprises Ltd.<br />" . COPYRIGHT_PLACEHOLDER, $output );

    if ( $nuseo['debug_profile'] )
    {
        $nuseo_process_html_start_time = nu_microtime();
        nuseo_process_html( $output );
        $nuseo_process_html_total_time = nu_microtime() - $nuseo_process_html_start_time;
        
        global $nuseo_profile_output;
        $nuseo_profile_output .= "NuSEO.PHP Parser: " . $nuseo_process_html_total_time . "<br />\n";
    }
    else
    {
	    nuseo_process_html( /*ref*/ $output );
    }
	
	// rebuild forum datastore if needed (e.g. to save new forum slugs)
	if ($nuseo_vbulletin['rebuild_forum_datastore'])
	{
		require_once(DIR . '/includes/adminfunctions.php');
		build_forum_permissions( /*$rebuild_genealogy*/ false);
	}

	// shutdown engine, vBulletin exits on its own
	nuseo_shutdown();

    if ( $nuseo['debug_profile'] )
    {
        global $nuseo_core_start_time, $nuseo_profile_output, $nuseo_core_time_consumed_before_include, $nuseo_core_time_in_script;
        $nuseo_core_total_time = nu_microtime() - $nuseo_core_start_time;
        $nuseo_profile_output .= "Total Execution:  " . $nuseo_core_total_time . "<br />\n";
        $output .= "<br />\n" . $nuseo_profile_output;

		$output .= "<textarea cols=50 rows=10>" 
				. $nuseo_core_time_consumed_before_include . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_time_consumed_before_include/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_core_time_in_script . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_time_in_script/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_process_html_total_time . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_process_html_total_time/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. $nuseo_core_total_time . "\t" . ( ($nuseo_core_time_in_script > 0) ? (($nuseo_core_total_time/$nuseo_core_time_in_script)) : 0 ) . "\n" 
				. "</textarea>";
					
    }    

	$nuseo['skip_global_parser'] = true;

}
//

// vBulletin Plugins - Forum Home

function nuseo_vbulletin_do_users_birthdays()
{
	global $vbulletin, $nuseo_config, $forumbits, $nuseo_vbulletin;
    
    if ( !empty( $vbulletin->birthdaycache['users1']) || !empty( $vbulletin->birthdaycache['users2'] ) )
    {
        $users_array = array( "users1" => $vbulletin->birthdaycache['users1'], "users2" => $vbulletin->birthdaycache['users2'] );
        
        foreach( $users_array as $key => $users )
        {
            $user_info_matches = false;
            if ( preg_match_all( "#(?:.*)member\.php\?u=(\d+)\">(\w+)<#siU", $users, $user_info_matches ) )
            {
                $ids = &$user_info_matches[ 1 ];
                $usernames = &$user_info_matches[ 2 ];
                for( $i = 0; $i < count( $ids ); ++$i )
                {
                    $user_info = array( 'userid' => $ids[ $i ], 'username' => $usernames[ $i ] );
                    nuseo_cache_add( $nuseo_vbulletin, 'user', $ids[ $i ], $user_info );
                }
            }
        }
    }
}

function nuseo_vbulletin_forumhome_complete()
{
	global $vbulletin, $nuseo_config, $forumbits, $nuseo_vbulletin, $newuserid, $newusername;
	
	nuseo_adsense_target( $forumbits );
    
    //cache newest member
    $user_info = array ( 'userid' => $newuserid, 'username' => $newusername );
    nuseo_cache_add( $nuseo_vbulletin, 'user', $newuserid, $user_info );

    //cache users birthday
    if ( $vbulletin->options[ 'showbirthdays' ] ) 
    {
        nuseo_vbulletin_do_users_birthdays();
    }

}

function nuseo_vbulletin_forumjump()
{
	global $vbulletin, $nuseo_config, $show, $nuseo_vbulletin;

	// if Guest and we should disable forumjump, then hide it.
	if ($nuseo_config[ 'vbulletin_remove_forum_jump_for_guests' ]&& $nuseo_vbulletin['guest_mode'])
		$show['enableforumjump'] = false;
}

function nuseo_vbulletin_forumbit_display( &$forum, &$lastpostinfo )
{
	global $vbulletin, $nuseo_config, $nuseo_vbulletin;
	
	nuseo_vbulleting_add_forum_to_cache( $forum );
	if (isset( $lastpostinfo ) && ($lastpostinfo['forumid'] != $forum['forumid']))
		nuseo_vbulleting_add_forum_to_cache( $lastpostinfo );
}

function nuseo_vbulletin_forumhome_loggedinuser( /*ref*/ &$loggedin )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	nuseo_vbulletin_add_user_to_cache( $loggedin );
}

function nuseo_vbulletin_forumdisplay_loggedinuser( /*ref*/ &$loggedin )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	nuseo_vbulletin_add_user_to_cache( $loggedin );
}

//

// vBulletin Plugins - Showthread
function nuseo_vbulletin_postbit_display_complete( &$post )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin, $vbulletin;
	
	nuseo_vbulletin_add_post_to_cache( $post );
	
	// copy the first post processed to be used in the dynamic description meta tag
	if ($nuseo_config[ 'vbulletin_replace_description' ] || $nuseo_config[ 'global_content_replacement_enabled' ] )
	{
		if (!isset( $nuseo_vbulletin['first_post'] ))
        {
			$nuseo_vbulletin['first_post'] = $post;
        }
	}
	
	if (($nuseo_config[ 'vbulletin_social_bookmarks_mode' ] == SOCIAL_BOOKMARKS_IN_BOTH) && 
		!empty($nuseo_vbulletin['social_bookmarks']) && count($nuseo_vbulletin['social_bookmarks']))
	{
		global $threadinfo;
	
		$thread_url = $nuseo_vbulletin['url_base'] . "showthread.php?t=" . $threadinfo['threadid'];
		$thread_url = nuseo_url_to_sef( $thread_url );

		//populate bookmarks for post
		$post_url = $thread_url . "#post" . $post['postid'];

		$post['nuseo_social'] = nuseo_vbulletin_get_social_bookmarks_html( $threadinfo['title'], $post_url, 'post' );
	}
	
	if ($nuseo_config[ 'enable_adsense_targeting' ])
	{
		$ad_section_start = '<!-- google_ad_section_start -->';
		$ad_section_end = '<!-- google_ad_section_end -->';
		
		// target these
		if ($post['title'])
			$post['title']		= $ad_section_start . $post['title'] . $ad_section_end;
	
		if ($post['message'])
			$post['message']	= $ad_section_start . $post['message'] . $ad_section_end;
		
		// ignore these
		if ($post['musername'])
			$post['musername']	= '<!-- google_ad_section_start(weight=ignore) -->' . $post['musername'] . $ad_section_end;
	
		if ($post['signature'])
			$post['signature']	= '<!-- google_ad_section_start(weight=ignore) -->' . $post['signature'] . $ad_section_end;
	}
	
	if ($nuseo_config[ 'enable_yahoo_targeting' ])
	{
		// ignore these
		if ($post['musername'])
			$post['musername']	= '<span class="robots-nocontent">' . $post['musername'] . '</span>';
	
		if ($post['signature'])
			$post['signature']	= '<span class="robots-nocontent">' . $post['signature'] . '</span>';
	}
}

function nuseo_vbulletin_showthread_query( &$hook_query_fields, &$hook_query_joins, &$hook_query_where )
{
	//$hook_query_fields .= ", nuseo_slug";
}

function nuseo_vbulletin_showthread_similarthreadbit( &$simthread )
{
	nuseo_vbulletin_add_thread_to_cache( $simthread );
}

function nuseo_vbulletin_showthread_complete()
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$social_bookmarks_mode = $nuseo_config[ 'vbulletin_social_bookmarks_mode' ];
	if ($social_bookmarks_mode)
	{
		nuseo_vbulletin_init_social_bookmarking( /*ref*/ $nuseo_vbulletin );

		if (!empty($nuseo_vbulletin['social_bookmarks']) && count($nuseo_vbulletin['social_bookmarks']))
		{
			global $navbar, $threadinfo;

			$thread_url = $nuseo_vbulletin['url_base'] . "showthread.php?t=" . $threadinfo['threadid'];
			$thread_url = nuseo_url_to_sef( $thread_url );

			$social_html = nuseo_vbulletin_get_social_bookmarks_html( $threadinfo['title'], $thread_url, 'thread' );
			$nuseo_social_ctr = "<div style=\"float:right\">$social_html</div>";

			if (strpos( $navbar, '<!-- NUSEO_SOCIAL_BOOKMARKS -->' ) !== false)
				$navbar = str_replace( '<!-- NUSEO_SOCIAL_BOOKMARKS -->', $nuseo_social_ctr, $navbar );
			else
			{
				$pos = strpos( $navbar, '<td class="navbar"' );
				if ($pos !== false)
				{
					$cell_start = strpos( $navbar, '>', $pos );
					if ($cell_start)
						$navbar = substr( $navbar, 0, $cell_start+1 ) . $nuseo_social_ctr . substr( $navbar, $cell_start+1 );
				}
			}
		} 
	} // if should add social bookmarks to threads
}

function nuseo_vbulletin_get_social_bookmarks_html( $title, $url, $text_key )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$title = urlencode( $title );
	$url = urlencode( $url );

	$social_html = '';
	foreach ($nuseo_vbulletin['social_bookmarks'] as $bookmark_info)
	{
		$social_url = str_replace( '[title]', $title, $bookmark_info['url'] );
		$social_url = str_replace( '[url]', $url, $social_url );

		$social_img = $nuseo['base_url'] . '/nuseo/images/' . $bookmark_info['img'];
		$social_text = $bookmark_info[ $text_key];
		
		$social_html .= <<<HTML
<a nuseo_rel="ignore" rel="nofollow" href="$social_url" target="_blank"><img src="$social_img" border="0" alt="$social_text" /></a>
HTML;
	}
	return $social_html;
}
//

// vBulletin Plugins - Forumdisplay
function nuseo_vbulletin_forumdisplay_announcement( /*ref*/ &$announcement )
{
	global $nuseo_vbulletin, $nuseo_config;
	
	//add userinfo row to cache
	if (isset( $announcement['nuseo_slug'] ))	// only add this to cache if we have nuseo_slug populated, otherwise fetch from DB later.
		nuseo_cache_add( $nuseo_vbulletin, 'announcement', $announcement['announcementid'], $announcement );
}

function nuseo_vbulletin_threadbit_display( &$thread )
{
	global $nuseo_vbulletin, $nuseo_config, $show;
	
	nuseo_vbulletin_add_thread_to_cache( $thread );

	if ($nuseo_vbulletin['guest_mode'])
	{
		if ($nuseo_config[ 'vbulletin_remove_thread_preview_for_guests' ])
			$thread['preview'] = '';
		if ($nuseo_config[ 'vbulletin_hide_goto_new_post_for_guests' ])
			$show['gotonewpost'] = false;
	}
}

function nuseo_vbulletin_forumdisplay_query( &$hook_query_fields, &$hook_query_joins, &$hook_query_where )
{
	$hook_query_fields .= ", nuseo_slug";
}

function nuseo_vbulletin_forumdisplay_complete()
{
	global $vbulletin, $nuseo, $nuseo_config, $forumbits, $threadbits, $threadbits_sticky;
	
	nuseo_adsense_target( $forumbits );
	nuseo_adsense_target( $threadbits_sticky );
	nuseo_adsense_target( $threadbits );
}

//

// vBulletin Plugins - Misc
function nuseo_vbulletin_archive_complete( &$output )	
{
	global $nuseo, $nuseo_config;
	if ($nuseo_config[ 'vbulletin_redir_archive' ])
		nuseo_process_html( /*ref*/ $output );
}

function nuseo_vbulletin_mail_send( &$message )		
{
	global $nuseo, $nuseo_config;
	if ($nuseo_config[ 'vbulletin_rewrite_email_urls' ])
		nuseo_process_html( /*ref*/ $message );
}

function nuseo_vbulletin_postdata_presave( /*ref*/ &$dataman )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	if (!empty($nuseo_config['vbulletin_expand_external_url_title']))
	{
		nuseo_vbulletin_expand_url_title( $dataman );
	}
}

function nuseo_vbulletin_threadfpdata_presave( /*ref*/ &$dataman )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	if (!empty($nuseo_config['vbulletin_expand_external_url_title']))
	{
		nuseo_vbulletin_expand_url_title( $dataman );
	}
}

function nuseo_vbulletin_expand_url_title( /*ref*/ &$dataman )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	if ( isset($dataman) && isset($dataman->post) )
	{
		$post_text =& $dataman->post['pagetext'];
		
		$url_expansion = array();
		
		$pregfind = '#(\[url\]([^\[]*)\[/url\])#siU';
		$matches = false;
		$match_count = preg_match_all( $pregfind, $post_text, $matches, PREG_SET_ORDER );
		
		for ($match_ix = 0; $match_ix < $match_count; $match_ix++)
		{
			if (isset( $matches[ $match_ix ] ))
			{
				$full_match	= $matches[ $match_ix ][1];
				$url		= $matches[ $match_ix ][2];

				$title = nuseo_fetch_page_title( $url );
				if ($title)
				{
					$new_url_bbcode = '[url=' . $url . ']' . $title . '[/url]';
					$url_expansion[ $full_match ] = $new_url_bbcode;
				}
			}
		}
		
		if (!empty( $url_expansion ))
		{
			$post_text = str_replace( array_keys( $url_expansion ), $url_expansion, $post_text );
		}
	}
}


function nuseo_vbulletin_memberlist_bit( /*ref*/ &$userinfo )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	//add userinfo row to cache
	nuseo_vbulletin_add_user_to_cache( $userinfo );
}

function nuseo_vbulletin_bbcode_parse_complete( &$bbcode_parser, &$text )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

//	Do not process message body, since this gets saved into DB. May want to expand anchor titles.
//	if ($bbcode_parser->options['cachable'])
//	{
//		nuseo_process_html( $bbcode_parser->cached['text'] );
//	}
}
//

// Search Plugins
function nuseo_vbulletin_search_results_threadbit( &$thread )
{
	nuseo_vbulletin_add_thread_to_cache( $thread );
}

function nuseo_vbulletin_search_results_postbit( &$post )
{
	nuseo_vbulletin_add_post_to_cache( $post );
}
//

// Cache Helper Functions
function nuseo_vbulleting_add_forum_to_cache( &$forum )
{
	global $vbulletin, $nuseo_config, $nuseo_vbulletin;

	//add forum row to cache
	$forum_info = array( 'forumid' => $forum['forumid'], 'title' => $forum['title'], 'parentid' => $forum['parentid'],
					'nuseo_title' => $forum['nuseo_title'], 'nuseo_slug' => $forum['nuseo_slug'], 'nuseo_path' => $forum['nuseo_path'] );
	nuseo_cache_add( $nuseo_vbulletin, 'forum', $forum['forumid'], $forum_info );

	// Add forum's last poster to user cache
	$user_info = array( 'userid' => 0, 'username' => $forum['lastposter'] );
	nuseo_cache_add( $nuseo_vbulletin, 'user', 'f' . $forum['forumid'], $user_info );

	//threads
	$thread = array( 'threadid' => $forum['lastthreadid'], 'title' => $forum['lastthread' ], 'forumid' => $forum['forumid'] );
	nuseo_cache_add( $nuseo_vbulletin, 'thread', $thread['threadid'], $thread );
	
	//post
	$post = array( 'postid' => $forum['lastpostid'], 'threadid' => $forum['lastthreadid' ]);
	nuseo_cache_add( $nuseo_vbulletin, 'post', $post['postid'], $post );
}

function nuseo_vbulletin_add_thread_to_cache( &$thread )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	// add thread row to cache
	if ($thread['open'] == 10)					// thread was moved.
		unset( $thread['nuseo_slug'] );			// keep showthread_to_sef from updateing nuseo_slug, since it was not loaded.

	$thread_info = array( 'threadid' => $thread['threadid'], 'forumid' => $thread['forumid'],
							'title' => $thread['title'] ? $thread['title'] : $thread['threadtitle'] );
	if (isset( $thread['nuseo_slug'] ))
		$thread_info[ 'nuseo_slug' ] = $thread['nuseo_slug'];
	nuseo_cache_add( $nuseo_vbulletin, 'thread', $thread['threadid'], $thread_info );

	// add thread's last post to post cache
	$post = array( 'postid' => $thread['lastpostid'], 'threadid' => $thread['threadid' ]);
	nuseo_cache_add( $nuseo_vbulletin, 'post', $post['postid'], $post );

	// Add thread's post user to user cache
	$user_info = array( 'userid' => $thread['postuserid'], 'username' => $thread['postusername'] );
	nuseo_cache_add( $nuseo_vbulletin, 'user', $user_info['userid'], $user_info );

	// Add thread's last poster to user cache
	$user_info = array( 'userid' => $thread['lastpostid'], 'username' => $thread['lastposter'] );
	nuseo_cache_add( $nuseo_vbulletin, 'user', 't' . $thread['threadid'], $user_info );
}

function nuseo_vbulletin_add_post_to_cache( &$post )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	//add post row to cache
	$post_info = array( 'postid' => $post['postid'], 'threadid' => $post['threadid'], 
							'userid' => $post['userid'], 'username' => $post['username']  );
	nuseo_cache_add( $nuseo_vbulletin, 'post', $post['postid'], $post_info );
	
	// add post's user to user cache
	$user_info = array( 'userid' => $post['userid'], 'username' => $post['username'], 'nuseo_slug' => $post['nuseo_slug'] );
	nuseo_cache_add( $nuseo_vbulletin, 'user',$user_info['userid'], $user_info );
}
	
function nuseo_vbulletin_add_user_to_cache( &$user )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	$user_info = array( 'userid' => $user['userid'], 'username' => $user['username'] );
    
	if (isset( $user['nuseo_slug'] ))
		$user_info[ 'nuseo_slug' ] = $user['nuseo_slug'];
        
	nuseo_cache_add( $nuseo_vbulletin, 'user', $user['userid'], $user_info );
}
//

// Template Optimizer
function nuseo_vbulletin_optimize_templates()
{
	global $nuseo, $nuseo_config, $vbulletin, $nuseo_vbulletin;
	
	if (!empty($nuseo_config['vbulletin_domain']) && ($nuseo_config['vbulletin_domain'] != $_SERVER['HTTP_HOST']))
	{	// we are in the wrong sub-domain
		return;
	}
   
    if ($nuseo_config['vbulletin_optimize_showthread'])
    {
		nuseo_vbulletin_optimize_showthread();
	}
    
    $do_forumdisplay_optimization = ( (THIS_SCRIPT == 'forumdisplay') && ( $nuseo_config['vbulletin_optimize_forumdisplay']) );
    $do_home_optimization = ( (THIS_SCRIPT == 'index') && ( $nuseo_config['vbulletin_optimize_home']) );
	
	if ( ( $do_forumdisplay_optimization || $do_home_optimization )
			&& (isset( $vbulletin->templatecache[ 'forumhome_forumbit_level1_nopost'  ] ) ) )
	{
		$ignore_href_list = array(
			'href=\\"#\\"'					=> 'nuseo_rel=\\"ignore\\" href=\\"#\\"',
			'href=\\"#top\\"'				=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',
			'href=\\"subscription.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"subscription.php',

			'href=\\"forumdisplay.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "f=$forum[forumid]\\"'
				=> 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_forum_url( $forum[\'forumid\'] ) . "\\"',
		);
		
		$template_name_list = array( 'forumhome_forumbit_level1_nopost', 'forumhome_forumbit_level1_post', 
										'forumhome_forumbit_level2_nopost', 'forumhome_forumbit_level2_post' );
		
		foreach( $template_name_list  as $template_name )
		{
			if ( isset( $vbulletin->templatecache[ $template_name ] ) )
			{
				$template_html = $vbulletin->templatecache[ $template_name ];
				
				$vbulletin->templatecache[ $template_name ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );
			}
		}
	}
    
    
    if ( $nuseo_config['vbulletin_optimize_forumdisplay'] )
    {
	
	    if ( isset( $vbulletin->templatecache[ 'threadbit'  ] ) )
	    {
		    $ignore_href_list = array(
			    'href=\\"#\\"'					=> 'nuseo_rel=\\"ignore\\" href=\\"#\\"',
			    'href=\\"#top\\"'				=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',

			    'href=\\"subscription.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"subscription.php',
			    'href=\\"postings.php'    		=> 'nuseo_rel=\\"ignore\\" href=\\"postings.php',
			    'href=\\"newreply.php'     		=> 'nuseo_rel=\\"ignore\\" href=\\"newreply.php',
			    'href=\\"misc.php'     			=> 'nuseo_rel=\\"ignore\\" href=\\"misc.php',

			    'href=\\"forumdisplay.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "f=$thread[forumid]\\"'
							    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_forum_url( $thread[\'forumid\'] ) . "\\"',

			    'href=\\"showthread.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "goto=newpost&amp;t=$thread[threadid]\\"'
							    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_thread_url( $thread[\'threadid\'], false, 0, \'newpost\', 1 ) . "\\"',
				
			    'href=\\"showthread.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "t=$thread[threadid]$thread[highlight]\\"'
							    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_thread_url( $thread[\'threadid\'], "$thread[highlight]", 0, \'\', 1 ) . "\\"',
				
			    'href=\\"showthread.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "t=$thread[threadid]&amp;page=$thread[totalpages]$thread[highlight]\\"'
							    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_thread_url( $thread[\'threadid\'], "$thread[highlight]", 0, \'\', $thread[\'totalpages\'] ) . "\\"',

			    'href=\\"showthread.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "p=$thread[lastpostid]$thread[highlight]#post$thread[lastpostid]\\"'
							    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_thread_url( 0, "$thread[highlight]", $thread[\'lastpostid\'], \'\', 1 ) . "\\"',
		    );
		    $template_html = $vbulletin->templatecache[ 'threadbit' ];
		    $vbulletin->templatecache[ 'threadbit' ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );			
	    }
    }


    // TOCHECK: these optimizations aren't classified yet
    // so we are doing them if any of the optimization flags are set
    if ( $nuseo_config['vbulletin_optimize_home'] || $nuseo_config['vbulletin_optimize_forumdisplay'] || $nuseo_config['vbulletin_optimize_showthread'] )
    {
		if (isset( $vbulletin->templatecache[ 'navbar' ] ))
		{
			$ignore_href_list = array(
				'href=\\"#\\"'					=> 'nuseo_rel=\\"ignore\\" href=\\"#\\"',
				'href=\\"#top\\"'				=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',
				
				'href=\\"usercp.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"usercp.php',
				'href=\\"register.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"register.php',
				'href=\\"faq.php'			=> 'nuseo_rel=\\"ignore\\" href=\\"faq.php',
				'href=\\"calendar.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"calendar.php',
				'href=\\"search.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"search.php',
				'href=\\"forumdisplay.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "do=markread'				
										=> 'nuseo_rel=\\"ignore\\" href=\\"forumdisplay.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "do=markread',
				'href=\\"login.php'			=> 'nuseo_rel=\\"ignore\\" href=\\"login.php',
				'href=\\"profile.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"profile.php',
				'href=\\"private.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"private.php',
				'href=\\"subscription.php'	=> 'nuseo_rel=\\"ignore\\" href=\\"subscription.php',
				'href=\\"online.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"online.php'
			);
			$template_html = $vbulletin->templatecache[ 'navbar' ];
			$vbulletin->templatecache[ 'navbar' ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );			
		}


        if ( !$vbulletin->session->vars['sessionurl'] )
        {
            $vbulletin->templatecache = str_replace( '" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "', "", $vbulletin->templatecache );
        }
    }
}

function nuseo_vbulletin_optimize_showthread()
{
	global $nuseo, $nuseo_config, $vbulletin, $nuseo_vbulletin;

    $postbit_name = $vbulletin->options['legacypostbit'] ? 'postbit_legacy' : 'postbit';

    if (isset( $vbulletin->templatecache[ $postbit_name ] ))
    {
	    global $vbphrase;
		
	    $ignore_href_list = array(
		    'href=\\"#\\"'					=> 'nuseo_rel=\\"ignore\\" href=\\"#\\"',
		    'href=\\"#top\\"'				=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',
			
		    'href=\\"reputation.php'  		=> 'nuseo_rel=\\"ignore\\" href=\\"reputation.php',
		    'href=\\"infraction.php'  		=> 'nuseo_rel=\\"ignore\\" href=\\"infraction.php',      
		    'href=\\"report.php'      		=> 'nuseo_rel=\\"ignore\\" href=\\"report.php',    
		    'href=\\"private.php'     		=> 'nuseo_rel=\\"ignore\\" href=\\"private.php',         
		    'href=\\"sendmessage.php' 		=> 'nuseo_rel=\\"ignore\\" href=\\"sendmessage.php',
		    'href=\\"search.php'      		=> 'nuseo_rel=\\"ignore\\" href=\\"search.php',
		    'href=\\"profile.php'     		=> 'nuseo_rel=\\"ignore\\" href=\\"profile.php',
		    'href=\\"$post[editlink]' 		=> 'nuseo_rel=\\"ignore\\" href=\\"$post[editlink]',
		    'href=\\"$post[replylink]'		=> 'nuseo_rel=\\"ignore\\" href=\\"$post[replylink]',
		    'href=\\"postings.php'    		=> 'nuseo_rel=\\"ignore\\" href=\\"postings.php',

		    'href=\\"member.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "u=$post[userid]\\"' 
										    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_member_url( $post[userid] ) . "\\"',
											
		    'href=\\"showpost.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "p=$post[postid]&amp;postcount=$post[postcount]\\"'
										    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_showpost_url( $post[postid], $post[postcount] ) . "\\"',



























	    );
            
	    $template_name_list = array( $postbit_name, 'postbit_ip' );

	    foreach( $template_name_list  as $template_name )
	    {
		    if ( isset( $vbulletin->templatecache[ $template_name ] ) )
		    {
			    $template_html = $vbulletin->templatecache[ $template_name ];

			    $vbulletin->templatecache[ $template_name ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );
		    }
	    }
		
	    if (isset( $vbulletin->templatecache[ 'bbcode_quote' ] ))
	    {
		    $ignore_href_list = array(
				    'href=\\"showthread.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "p=$postid#post$postid\\"'
						    => 'nuseo_rel=\\"ignore\\" href=\\"" . nuseo_vbulletin_get_thread_url( 0, false, $postid, false, 1 ) . "\\"',
		    );
			
		    $template_html = $vbulletin->templatecache[ 'bbcode_quote' ];
		    $vbulletin->templatecache[ 'bbcode_quote' ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );			
	    }
		
		
    }

    if (isset( $vbulletin->templatecache[ 'SHOWTHREAD' ] ))
    {
	    $ignore_href_list = array(
		    'href=\\"#\\"'					=> 'nuseo_rel=\\"ignore\\" href=\\"#\\"',
		    'href=\\"#top\\"'				=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',
			
		    'href=\\"newreply.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"newreply.php',
		    'href=\\"#top\\"'			=> 'nuseo_rel=\\"ignore\\" href=\\"#top\\"',
		    'href=\\"search.php'		=> 'nuseo_rel=\\"ignore\\" href=\\"search.php',
		    'href=\\"printthread.php'	=> 'nuseo_rel=\\"ignore\\" href=\\"printthread.php',
		    'href=\\"sendmessage.php'	=> 'nuseo_rel=\\"ignore\\" href=\\"sendmessage.php',
		    'href=\\"subscription.php'	=> 'nuseo_rel=\\"ignore\\" href=\\"subscription.php',
	    );

	    $template_html = $vbulletin->templatecache[ 'SHOWTHREAD' ];
	    $vbulletin->templatecache[ 'SHOWTHREAD' ] = str_replace( array_keys( $ignore_href_list ), $ignore_href_list, $template_html );			
    }
}

function nuseo_vbulletin_get_member_url( $userid )
{
	global $nuseo, $nuseo_vbulletin, $nuseo_config, $vbulletin;

	if (isset( $nuseo_vbulletin['member_url_cache'][ $userid ] ))
	{
		$new_member_url = $nuseo_vbulletin['member_url_cache'][ $userid ];
	}
	else	// doesn't exist, calculate it
	{
		$session =& $vbulletin->session->vars;
		$member_non_sef_url = "member.php?{$session['sessionurl']}u=$userid";
		$query_params = array( 'u' => $userid );
		if ($session['dbsessionhash'])
			$query_params[ 's' ] = $session['dbsessionhash'];
		
		$url_info = array( 'query_params' => $query_params );
		$matches = array();
		$anchor_info = array();

		$sef_url = nuseo_vbulletin_member_to_sef( $nuseo_vbulletin, $member_non_sef_url, $url_info, $matches, $anchor_info );
		
		if ($sef_url)
		{
			$new_member_url = $sef_url;
		}
		else
		{
			$new_member_url = $member_non_sef_url;
		}
		
		if (!empty( $nuseo_config['vbulletin_domain'] ))
		{
			$new_member_url = 'http://' . $nuseo_config['vbulletin_domain'] . $new_member_url;
		}
		
		if (isset( $anchor_info['rel'] ))
		{
			$new_member_url .= '" rel="' . $anchor_info['rel'];		// TRICK: close href's quote and add rel="xxx" here.
		}
		
		// add it to cache
		$nuseo_vbulletin['member_url_cache'][ $userid ] = $new_member_url;
	}
	
	return $new_member_url;
}

function nuseo_vbulletin_get_showpost_url( $postid, $postcount )
{
	global $nuseo, $nuseo_vbulletin, $nuseo_config, $vbulletin;

	$cache_key = "$postid-$postcount";
	if (isset( $nuseo_vbulletin['showpost_url_cache'][ $cache_key ] ))
	{
		$new_showpost_url = $nuseo_vbulletin['showpost_url_cache'][ $cache_key ];
	}
	else	// doesn't exist, calculate it
	{
		$session =& $vbulletin->session->vars;
		$showpost_non_sef_url = "showpost.php?{$session['sessionurl']}p=$postid&amp;postcount=$postcount";
		$query_params = array( 'p' => $postid, 'postcount' => $postcount );
		if ($session['dbsessionhash'])
			$query_params[ 's' ] = $session['dbsessionhash'];
		
		$url_info = array( 'query_params' => $query_params );
		$matches = array();
		$anchor_info = array();

		$sef_url = nuseo_vbulletin_showpost_to_sef( $nuseo_vbulletin, $showpost_non_sef_url, $url_info, $matches, $anchor_info );
		
		if ($sef_url)
		{
			$new_showpost_url = $sef_url;
		}
		else
		{
			$new_showpost_url = $showpost_non_sef_url;
		}

		if (!empty( $nuseo_config['vbulletin_domain'] ))
		{
			$new_showpost_url = 'http://' . $nuseo_config['vbulletin_domain'] . $new_showpost_url;
		}

		// add it to cache
		$nuseo_vbulletin['showpost_url_cache'][ $cache_key ] = $new_showpost_url;
	}
	
	return $new_showpost_url;
}
//