<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This ad may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This ad is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_vbclassified_load( &$module )
{ 
	global $nuseo, $nuseo_config;

	$module['global_parser'] = false;		// taken care of by vBulletin Plugins

	// set url base
	$module['url_base']			= $nuseo_config[ 'vbclassified_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'vbclassified_domain' ];
	
	// register this as an extension for vBulletin's module
	nuseo_register_module_extension( $module, 'vbulletin' );
}

function nuseo_vbclassified_init_rules( &$module )
{
	// initialize cache
	nuseo_cache_init( $module, array( 'category', 'ad', 'user' ) );

	// pre-process URL formats
	nuseo_vbclassified_load_url_formats( $module );
	
	// populate module rules
	nuseo_vbclassified_load_rewrite_rules( $module );
}

function nuseo_vbclassified_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;

	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
    {
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
    }
	else
    {
		$script_name = $rel_url;
    }

	if ( $script_name == 'vbclassified.php' )
	{
		$nuseo['global_parser'] = false;
	}
}

function nuseo_vbclassified_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
        'home'				    => $nuseo_config[ 'vbclassified_home_format' ],
		'category'				=> $nuseo_config[ 'vbclassified_category_format' ],
		'ad'					=> $nuseo_config[ 'vbclassified_ad_format' ],
		'user'					=> $nuseo_config[ 'vbclassified_user_format' ]
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(ad_id)\]#',	'#\[(user_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_vbclassified_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> 'vbclassified\.php', 
						'translate_to_sef'		=> 'nuseo_vbclassified_vbclassified_to_sef' );

	if ($nuseo_config[ 'vbclassified_rewrite_category_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbclassified_sef_to_vbclassified'
					);
	}
    
    
	if ($nuseo_config[ 'vbclassified_rewrite_home_url' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['home_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbclassified_sef_to_vbclassified'
						);
	}    

	if ($nuseo_config[ 'vbclassified_rewrite_ad_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['ad_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbclassified_sef_to_vbclassified'
						);
	}

	if ($nuseo_config[ 'vbclassified_rewrite_user_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['user_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbclassified_sef_to_vbclassified'
						);
	}

	$module['rules'] = $rules;
}
//

// index.php
function nuseo_vbclassified_vbclassified_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$do				= isset( $query_params['do']			)	? $query_params['do'] : false;
	$category_id	= isset( $query_params['categoryid']	)	? intval( $query_params['categoryid'] ) : 0;
	$ad_id			= isset( $query_params['adid']			)	? intval( $query_params['adid'] ) : 
						(isset( $query_params['id']			)	? intval( $query_params['id'] ) : 0);
	$user_id		= isset( $query_params['userid']		)	? intval( $query_params['userid'] ) : 0;

	$url_format		= false;

	$ad				= false;
	$category		= false;
	$user			= false;

	if (($do =='ad') && $ad_id)
	{
		if (!$nuseo_config['vbclassified_rewrite_ad_urls'])
			return false;

		$ad = nuseo_cache_fetch( $module, 'ad', $ad_id, 'nuseo_vbclassified_fetch_ad' );
		if (!$ad)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the ad, fail.
		}

		$url_format = $module['ad_url_format'];
		unset( $query_params['adid'], $query_params['id'], $query_params['do'] );

		if (!$category_id)
		{
			$category_id = $ad['categoryid'];
			$category = array( 'categoryid' => $category_id, 'title' => $ad['category_title'] );
			nuseo_cache_add( $module, 'category', $category_id, $category );
		}
	}
	
	if ($category_id)
	{
		if (!$ad && !$nuseo_config['vbclassified_rewrite_category_urls'])
			return false;		// category rewrite is disabled.

		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbclassified_fetch_category' );
			if (!$category)
			{
				if ($nuseo['prefetch'])
					return true;				// we are in prefetch mode, we'll be back later
				else
					return false;				// else, we didn't find the category, fail.
			}
		}
		
		if ($do == 'category')
		{
			$url_format = $module['category_url_format'];
			unset( $query_params['categoryid'], $query_params['do'] );
		}
		unset( $query_params['categoryid'] );
	}
	
	if ($user_id)
	{
		if (($do == 'user') && !$nuseo_config['vbclassified_rewrite_user_urls'])
			return false;		// user rewrite is disabled.

		if (!$user)
		{
			$user = nuseo_cache_fetch( $module, 'user', $user_id, 'nuseo_vbclassified_fetch_user' );
			if (!$user)
			{
				if ($nuseo['prefetch'])
					return true;				// we are in prefetch mode, we'll be back later
				else
					return false;				// else, we didn't find the user, fail.
			}
		}
		
		if ($do == 'user')
		{
			$url_format = $module['user_url_format'];
			unset( $query_params['userid'], $query_params['do'] );
		}
		unset( $query_params['userid'] );
	}

	if (!$url_format)
    {
        if ( $nuseo_config['vbclassified_rewrite_home_url'])
        {
            $url_format = $nuseo_config['vbclassified_home_format'];
        }
        else
        {
		    return false;
        }
    }

	// add thread information
	$info = array();
	$info['category_id']	= $category_id;
	$info['category_title']	= $category ? nuseo_str_to_url( $category['title'] ) : '';
	$info['ad_id']			= $ad_id;
	$info['ad_title']		= $ad ? nuseo_str_to_url( $ad['title'] ) : '';
	$info['user_id']		= $user_id;
	$info['user_name']		= $user ? nuseo_str_to_url( $user['username'] ) : '';

	eval( '$sef_url = "' . $url_format . '";' );

	return $sef_url;
}

function nuseo_vbclassified_sef_to_vbclassified( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	//if (!isset( $url_info['query_params'] ))
	//	return false;
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$ad_id			= isset( $matches['ad_id']			) ? $matches['ad_id']			: false;
	$ad_title		= isset( $matches['ad_title']		) ? $matches['ad_title']		: false;
	$user_id		= isset( $matches['user_id']		) ? $matches['user_id']			: false;
	$user_name		= isset( $matches['user_name']		) ? $matches['user_name']		: false;

	if (!$ad_id && $ad_title)
	{
		$ad = nuseo_cache_fetch_by_title( $module, 'ad', $ad_title, 'nuseo_vbclassified_fetch_ad_by_title' );
		if ($ad)
			$ad_id = $ad['classifiedid'];
	}

	if (!$category_id && $category_title)
	{
		$category = nuseo_cache_fetch_by_title( $module, 'category', $category_title, 'nuseo_vbclassified_fetch_category_by_title' );
		if ($category)
			$category_id = $category['categoryid'];
	}

	if ($ad_id)
	{
		$query_params['id'] = $ad_id;
		if (!isset( $query_params['do'] ))
			$query_params['do'] = 'ad';
	}
	else if ($user_id)
	{
		$query_params['userid'] = $user_id;
		if (!isset( $query_params['do'] ))
			$query_params['do'] = 'user';
	}
	else if ($category_id)
	{
		$query_params['categoryid'] = $category_id;
		if (!isset( $query_params['do'] ))
			$query_params['do'] = 'category';
	}
	//else
	//	return false;
        
   //seo content
    if ( $nuseo_config['vbclassified_replace_keywords'] || $nuseo_config['vbclassified_replace_description'])
    {
        $seo_items = array ();
        
        if ( $category_id )
        {
            if ( !isset( $category ) || !$category )
            {
                $category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbclassified_fetch_category' );
            }
                        
            $seo_items['category'] = array();
            $seo_items['category']['keywords'] = $category['title'] . "," . $category['description'];
            $seo_items['category']['description'] = $category['title'] . " - " . $category['description'];
        }
        
        if ( $ad_id )
        {
            if ( !isset( $ad ) || !$ad )
            {
                $ad = nuseo_cache_fetch( $module, 'ad', $ad_id, 'nuseo_vbclassified_fetch_ad' );
            }
                        
            $seo_items['ad'] = array();
            $seo_items['ad']['keywords'] = $ad['title']  . "," . $ad['message']  . "," . $ad['comments'];
            $seo_items['ad']['description'] = $ad['title'];
            
        }
        
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'vbclassified_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'vbclassified_replace_description' ] ) );
        }
    }        

	$non_sef_url = 'vbclassified.php';
	return $non_sef_url;
}
//

// Database Connectivity
function nuseo_vbclassified_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$module['db_conn']		= false;
	$module['table_prefix']	= false;

	if (isset($nuseo_vbulletin))
	{	// reuse vBulletin Module's DB Connection
		$db_conn = nuseo_get_db_connection( $nuseo_vbulletin );
		
		$module['table_prefix'] = $nuseo_vbulletin['table_prefix'];

		$module['db_conn'] =& $db_conn;
	}
	
	if (!$module['db_conn'])
	{
		$vbulletin_config_adname = $nuseo['base_dir'] . $module['url_base'] . 'includes/config.php';
		if (ad_exists( $vbulletin_config_adname ))
		{
			$config = array();
			include $vbulletin_config_adname;
			
			// read DB connection vars
			$server_name			= $config['MasterServer']['servername'];
			$server_port			= $config['MasterServer']['port'];
			$db_username			= $config['MasterServer']['username'];
			$db_password			= $config['MasterServer']['password'];
			$module['db_name']		= $config['Database']['dbname'];
			
			$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
												$db_username, $db_password, $module['db_name'] );

			$module['table_prefix'] = $config['Database']['tableprefix'];
			
			// do not store username/password in memory
			unset( $server_name, $server_port, $db_username, $db_password, $config );
		}
	}
}

function nuseo_vbclassified_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'categoryid';

	$sql = "SELECT * FROM `{$module['table_prefix']}vbclassified_category` category";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_vbclassified_fetch_ad( &$module, $cache_type, $ad_id )
{
	$table_name = 'ad';

	$id_field_name = 'classifiedid';

	$sql = "SELECT ad.*, category.title AS category_title FROM `{$module['table_prefix']}vbclassified` ad
				LEFT OUTER JOIN `{$module['table_prefix']}vbclassified_category` category ON category.categoryid = ad.categoryid";

	$additional_where = false;

	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $ad_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_vbclassified_fetch_user( &$module, $cache_type, $user_id )
{
	$table_name = 'user';

	$id_field_name = 'userid';

	$sql = "SELECT * FROM `{$module['table_prefix']}user` user";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_common( $module, $cache_type, $user_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_vbclassified_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category';

	$title_field_name = 'title';

	$sql = "SELECT * FROM `{$module['table_prefix']}vbclassified_category` category";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_vbclassified_fetch_ad_by_title( &$module, $cache_type, $ad_title )
{
	$table_name = 'ad';

	$title_field_name = 'title';

	$sql = "SELECT ad.*, category.title AS category_title FROM `{$module['table_prefix']}vbclassified` ad
				LEFT OUTER JOIN `{$module['table_prefix']}vbclassified_category` category ON category.categoryid = ad.categoryid";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $ad_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_vbclassified_fetch_user_by_name( &$module, $cache_type, $user_name )
{
	$table_name = 'user';

	$name_field_name = 'username';

	$sql = "SELECT * FROM `{$module['table_prefix']}user` user";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_name_common( $module, $cache_type, $user_name, $sql, $table_name, 
						$name_field_name, $additional_where, $limit );
}
//