<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_vbadvancedlinks_load( &$module )
{
    //echo "*** nuseo_vbadvancedlinks_load*** <BR>";
    
	global $nuseo, $nuseo_config;

	$module['global_parser'] = false;		// taken care of by vBulletin Plugins

	// set url base
	$module['url_base']			= $nuseo_config[ 'vbadvancedlinks_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'vbadvancedlinks_domain' ];

	// register this as an extension for vBulletin's module
	nuseo_register_module_extension( $module, 'vbulletin' );
}

function nuseo_vbadvancedlinks_init_rules( &$module )
{
//    echo "*** nuseo_vbadvancedlinks_init_rules*** <BR>";
    
    global $nuseo;
    
    // If NuSEO is initing vBulletin's Rules, then the URL is within vBulletin's directory.
	// Even if the page is not overwritten, we don't want NuSEO's global parser enabled.
	$nuseo['global_parser'] = false;
    
	// initialize cache
	nuseo_cache_init( $module, array( 'category', 'link' ) );

	// pre-process URL formats
	nuseo_vbadvancedlinks_load_url_formats( $module );
	
	// populate module rules
	nuseo_vbadvancedlinks_load_rewrite_rules( $module );
}

function nuseo_vbadvancedlinks_load_url_formats( &$module )
{
    
//    echo "*** nuseo_vbadvancedlinks_load_url_formats*** <BR>";
    
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
		'category'				=> $nuseo_config[ 'vbadvancedlinks_category_format' ],
		'link'					=> $nuseo_config[ 'vbadvancedlinks_link_format' ],
        'letter'				=> $nuseo_config[ 'vbadvancedlinks_link_letter_format' ],
        
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(link_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_vbadvancedlinks_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;
	
	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
    {
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
    }
	else
    {
		$script_name = $rel_url;
    }
	
	$my_scripts = array( 'addlink.php', 'browselinks.php', 'index.php', 'managecats.php', 
                         'misc.php', 'moderate.php', 'newreply.php', 'search.php', 'showlink.php'  );
							
	if (in_array( $script_name, $my_scripts ))
	{
		$nuseo['global_parser'] = false;
	}
}





function nuseo_vbadvancedlinks_load_rewrite_rules( &$module )
{
//    echo "*** nuseo_vbadvancedlinks_load_rewrite_rules *** <BR>";
    
	global $nuseo, $nuseo_config;

	$rules = array();
	
	
	$rules[] = array(	'non_sef_pattern'		=> "browselinks.php",
						'translate_to_sef'		=> 'nuseo_vbadvancedlinks_browselinks_to_sef' );
                        
                        
    $rules[] = array(	'non_sef_pattern'		=> "showlink.php",
						'translate_to_sef'		=> 'nuseo_vbadvancedlinks_showlink_to_sef' );

	if ($nuseo_config[ 'vbadvancedlinks_rewrite_category_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbadvancedlinks_sef_to_browselinks'
					);
	}

	if ($nuseo_config[ 'vbadvancedlinks_rewrite_link_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['link_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbadvancedlinks_sef_to_showlink'
						);
	}
    
	if ($nuseo_config[ 'vbadvancedlinks_rewrite_link_letters' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['letter_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbadvancedlinks_sef_to_browselinks'
						);
	}
    
    //print_r( $module );
    //print_r( $rules );die;
    
	$module['rules'] = $rules;
}
//

// browselinks translators
function nuseo_vbadvancedlinks_browselinks_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;
    
	if (!$module || !isset( $url_info['query_params'] ) )
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];
    
    if ( isset( $query_params['do'] ) || isset( $query_params['orderby'] ) )
    {
        return false;
    }
   
    //sef strings
	$info = array();
        
	$url_format = false;    
    
    //get letter
    if ( isset( $query_params['ltr'] ) )
    {
        $letter = $query_params['ltr'];
        $url_format = $module['letter_url_format'];
        
        //they use a different name for letter: "catid" instead of "c"
        $category_id = ( isset( $query_params['catid'] ) ) ? $query_params['catid'] : false;
        $info[ 'letter' ] = $letter;
    }
    
    //get category
    if ( !$category_id )
    {
        $category_id = ( isset( $query_params['c'] ) ) ? $query_params['c'] : false;
    }
    
	$category	= false;
    
    if ( $category_id )
	{
		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbadvancedlinks_fetch_category' );
            //$category[ 'id' ] = $category[ 'catid' ];
            
			if (!$category)
			{
                //return true or false deppending on the mode
                return $nuseo['prefetch'];
			}
		}
        
        
		if ( !$url_format )
        {
            $url_format = $module['category_url_format'];
        }
        
	    $info['category_id']	= $category_id;
	    $info['category_title']	= $category ? nuseo_str_to_url( $category['title'] ) : '';
        
	}
    
   
	if ( !$url_format )
    {
		return false;
    }
    
    
	eval( '$sef_url = "' . $url_format . '";' );
    
    if ( isset( $sef_url ) )
    {
        //remove id from query string
        unset( $query_params['c'] );
        if ( isset ( $query_params['ltr'] ) )
        {
            unset( $query_params['ltr'] );
            unset( $query_params['catid'] );
        }

    }
    
	return $sef_url;
}

function nuseo_vbadvancedlinks_sef_to_browselinks( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
    $letter         = isset( $matches['letter']	        ) ? $matches['letter']		    : false;
    
	if (!$category_id && $category_title)
	{
		$category = nuseo_cache_fetch_by_title( $module, 'category', $category_title, 'nuseo_vbadvancedlinks_fetch_category_by_title' );
        
		if ( $category )
        {
			$category_id = $category['catid'];
        }
	}
    
    
    if ( $letter )
    {
        $query_params['ltr'] = $letter;
        $query_params['catid'] = $category_id;
    }
	else if ( $category_id )
	{
		$query_params['c'] = $category_id;
	}
    
    
    //seo content
    if ( $nuseo_config['vbadvancedlinks_replace_keywords'] || $nuseo_config['vbadvancedlinks_replace_description'])
    {
        $seo_items = array ();
        
        if ( $category_id )
        {
            if ( !isset( $category ) || !$category )
            {
                $category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbadvancedlinks_fetch_category' );
            }
                        
            $seo_items['category'] = array();
            $seo_items['category']['keywords'] = $category['title'] . "," . $category['description'];
            $seo_items['category']['description'] = $category['title'] . " - " . $category['description'];
        }
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'vbadvancedlinks_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'vbadvancedlinks_replace_description' ] ) );
        }
    }
    
    
	$non_sef_url = 'browselinks.php';
	return $non_sef_url;
}
//

// showlink translators

function nuseo_vbadvancedlinks_showlink_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module || !isset( $url_info['query_params'] ) )
    {
		return false;
    }
   
	$query_params =& $url_info['query_params'];
    
    //sef strings
	$info = array();
        
	$url_format = false;
    
    //get linkid
    $link_id = ( isset( $query_params['l'] ) ) ? $query_params['l'] : false;
    
    //get category
    $category_id = ( isset( $query_params['catid'] ) ) ? $query_params['catid'] : false;
    
	$link		= false;
	$category	= false;

	if ( $link_id )
	{
		$link = nuseo_cache_fetch( $module, 'link', $link_id, 'nuseo_vbadvancedlinks_fetch_link' );
        
		if (!$link)
		{
            //return true or false deppending on the mode
            return $nuseo['prefetch'];
		}
		
        if ( !$url_format )
        {
		    $url_format = $module['link_url_format'];
        }
        
	    $info['link_id'] = $link_id;
	    $info['link_title'] = $link ? nuseo_str_to_url( $link['name'] ) : ''; 
        
        //fill category id/info from link table and add it to cache
        $category_id = $link['catid'];
		$category = array( 'catid' => $category_id, 'title' => $link['cat_name'] );
        
		nuseo_cache_add( $module, 'category', $category_id, $category );

	}
    
    if ( $category_id )
	{
		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbadvancedlinks_fetch_category' );
            
			if (!$category)
			{
                //return true or false deppending on the mode
                return $nuseo['prefetch'];
			}
		}
        
		if ( !$url_format )
        {
            $url_format = $module['category_url_format'];
        }
        
	    $info['category_id']	= $category_id;
	    $info['category_title']	= $category ? nuseo_str_to_url( $category['title'] ) : '';
        
	}
    
   
	if ( !$url_format )
    {
		return false;
    }
    
	eval( '$sef_url = "' . $url_format . '";' );
    
    if ( isset( $sef_url ) )
    {
        //remove id from query string
		unset( $query_params['l'] );
        unset( $query_params['catid'] );
    }
    
	return $sef_url;
}

function nuseo_vbadvancedlinks_sef_to_showlink( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$link_id		= isset( $matches['link_id']		) ? $matches['link_id']		    : false;
	$link_title		= isset( $matches['link_title']	    ) ? $matches['link_title']		: false;
    
	if (!$link_id && $link_title)
	{
		$link = nuseo_cache_fetch_by_title( $module, 'link', $link_title, 'nuseo_vbadvancedlinks_fetch_link_by_title' );
        
		if ( $link )
        {
			$link_id = $link['linkid'];
        }
	}

	if (!$category_id && $category_title)
	{
		$category = nuseo_cache_fetch_by_title( $module, 'category', $category_title, 'nuseo_vbadvancedlinks_fetch_category_by_title' );
        
		if ( $category )
        {
			$category_id = $category['catid'];
        }
	}
    
    if ( $link_id )
	{
		$query_params['l'] = $link_id;
	}
    
	if ( $category_id )
	{
		$query_params['catid'] = $category_id;
	}

    //seo content
    if ( $nuseo_config['vbadvancedlinks_replace_keywords'] || $nuseo_config['vbadvancedlinks_replace_description'])
    {
        $seo_items = array ();
        
        if ( $category_id )
        {
            if ( !isset( $category ) || !$category )
            {
                $category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_vbadvancedlinks_fetch_category' );
            }
                        
            $seo_items['category'] = array();
            $seo_items['category']['keywords'] = $category['title'] . "," . $category['description'];
            $seo_items['category']['description'] = $category['title'] . " - " . $category['description'];
        }        
        
        if ( $link_id )
        {
            if ( !isset( $link ) || !$link )
            {
                $link = nuseo_cache_fetch( $module, 'link', $link_id, 'nuseo_vbadvancedlinks_fetch_link' );
            }
                        
            $seo_items['link'] = array();
            $seo_items['link']['keywords'] = $link['name'] . "," . $link['description'];
            $seo_items['link']['description'] = $link['name'] . " - " . $link['description'];
        }
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'vbadvancedlinks_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'vbadvancedlinks_replace_description' ] ) );
        }
    }    
    
	$non_sef_url = 'showlink.php';
	return $non_sef_url;
}

//



// Database Connectivity
function nuseo_vbadvancedlinks_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$module['db_conn'] = false;

	if (isset($nuseo_vbulletin))
	{	// reuse vBulletin Module's DB Connection
		$db_conn =& nuseo_get_db_connection( $nuseo_vbulletin );

		$module['db_conn'] =& $db_conn;
		$module['table_prefix'] = $nuseo_vbulletin['table_prefix'];
	}
	
	if (!$module['db_conn'])
	{
		$vbulletin_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'includes/config.php';
		if (file_exists( $vbulletin_config_filename ))
		{
			$config = array();
			include $vbulletin_config_filename;
			
			// read DB connection vars
			$server_name			= $config['MasterServer']['servername'];
			$server_port			= $config['MasterServer']['port'];
			$db_username			= $config['MasterServer']['username'];
			$db_password			= $config['MasterServer']['password'];
			$module['db_name']		= $config['Database']['dbname'];
			$module['table_prefix']	= $config['Database']['tableprefix'];
			
			$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
												$db_username, $db_password, $module['db_name'] );

			// do not store username/password in memory
			unset( $server_name, $server_port, $db_username, $db_password );
		}
	}
}

function nuseo_vbadvancedlinks_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'catid';

	$sql = "SELECT category.*
                FROM `{$module['table_prefix']}adv_links_categories` category";

                
	$additional_where = false;
		
	$limit = false;
    
	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );

}

function nuseo_vbadvancedlinks_fetch_link( &$module, $cache_type, $link_id )
{
	$table_name = 'link';

	$id_field_name = 'linkid';

	$sql = "SELECT link.*,  category.title as cat_name FROM `{$module['table_prefix']}adv_links` link
                LEFT OUTER JOIN `{$module['table_prefix']}adv_links_categories` category 
                    ON category.catid = link.catid";
                //WHERE file.id = {$file_id}";

	$additional_where = false;

	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $link_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}


function nuseo_vbadvancedlinks_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category';

	$title_field_name = 'title';

    $sql = "SELECT category.catid, category.title
                FROM `{$module['table_prefix']}adv_links_categories` category";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_vbadvancedlinks_fetch_link_by_title( &$module, $cache_type, $file_title )
{
	$table_name = 'link';

	$sql = "SELECT link.* FROM `{$module['table_prefix']}adv_files` link";
    
	$title_field_name = 'name';

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $file_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

//