<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_vbadvanced_load( &$module )
{
	global $nuseo, $nuseo_config;

	// set url base
	$module['url_base'] = '/';
	$module['global_parser'] = false;		// disable global parser. vBulletin plugins will take care of this.
	
	// Parse vbAdvanced CMPS URL
	$url_parts = explode( '/', $nuseo_config[ 'vbadvanced_cmps_url' ]);
	
	$module['cmps_index.php']	= array_pop( $url_parts );
	$module['url_base']			= implode( '/', $url_parts );
	$module['domain_override']	= $nuseo_config[ 'vbadvanced_domain' ];
	
	if ((empty($module['url_base'])) || ($module['url_base'][0] != '/'))
    {
		$module['url_base'] = '/' . $module['url_base'];
    }
}

function nuseo_vbadvanced_init_rules( &$module )
{
	nuseo_vbadvanced_load_url_formats( $module );
    
	// populate module rules
	nuseo_vbadvanced_load_rewrite_rules( $module );
}

function nuseo_vbadvanced_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;
	
	$extension_pos = strpos( $rel_url, '.php' );
    
	if ($extension_pos)
    {
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
    }
	else
    {
		$script_name = $rel_url;
    }
	
	if ($script_name == $module['cmps_index.php'])
	{
		$nuseo['global_parser'] = false;
	}
}

//


// Rules and formats
function nuseo_vbadvanced_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
        //'home' => $nuseo_config[ 'vbadvanced_home_format' ],
        'page' => str_replace( 'page-title', 'page_title', $nuseo_config[ 'vbadvanced_page_format' ] ),
	);

	$id_keywords	= array();

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_vbadvanced_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
    
    $non_sef_script = $module['cmps_index.php'];
    
    if ( $non_sef_script == "index.php" )
    {
        $non_sef_pattern = "(?:" . preg_quote( $non_sef_script ) . "|\#|\?|$)";
    }
    else
    {
        $non_sef_pattern = preg_quote( $non_sef_script );
    }
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> $non_sef_pattern,
						'translate_to_sef'		=> 'nuseo_vbadvanced_cmps_index_to_sef' );
                        
                        
	if ( $nuseo_config[ 'vbadvanced_rewrite_page_urls' ] )
	{
		$rules[] = array(	'sef_pattern'			=> $module['page_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbadvanced_sef_to_cmps_index'
						);
	}
    
/*    if ( $nuseo_config[ 'vbadvanced_rewrite_home_url' ] )
	{
		$rules[] = array(	'sef_pattern'			=> $module['home_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_vbadvanced_sef_to_cmps_index'
						);
	}            
*/
	$module['rules'] = $rules;
}
//


function nuseo_vbadvanced_cmps_index_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
    global $nuseo, $nuseo_config;
    
	if (!$module)
    {
		return false;
    }
        
	$query_params =& $url_info['query_params'];
    
    $page_title = isset( $query_params[ $nuseo_config[ 'vbadvanced_page_variable' ] ] ) ? 
                    $query_params[ $nuseo_config[ 'vbadvanced_page_variable' ] ] : false;
                    
                    
   
    if ( $page_title )
    {

        $url_format = $module['page_url_format'];
        
       	$info = array();
        
        //we write both for backward compatibility        
        $info['page_title'] = $page_title;
       
        unset( $query_params[ $nuseo_config[ 'vbadvanced_page_variable' ] ] );
        
    }
/*    else if ( $nuseo_config[ 'vbadvanced_rewrite_page_urls' ] )
    {
        $url_format = $module['home_url_format'];
    }
*/
    else
    {
         return false;
    }

    
    eval( '$sef_url = "' . $url_format . '";' );
    
	return $sef_url;    

}

function nuseo_vbadvanced_sef_to_cmps_index( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    global $nuseo, $nuseo_config;
   
	$query_params =& $url_info['query_params'];

	$page_title	= isset( $matches['page-title'] ) ? $matches['page-title'] : false;
    
    if ( !$page_title )
    {
        $page_title	= isset( $matches['page_title'] ) ? $matches['page_title'] : false;    
    }
    
    if ( $page_title )
    {
        $query_params[ $nuseo_config[ 'vbadvanced_page_variable' ] ] = $page_title;
    }
    
    $non_sef_url = $module[ 'cmps_index.php' ];
	return $non_sef_url;
}