<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This ad may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This ad is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_projecttools_load( &$module )
{ 
	global $nuseo, $nuseo_config;

	$module['global_parser'] = false;		// taken care of by vBulletin Plugins

	// set url base
	$module['url_base']			= $nuseo_config[ 'projecttools_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'projecttools_domain' ];

	// register this as an extension for vBulletin's module
	nuseo_register_module_extension( $module, 'vbulletin' );
}

function nuseo_projecttools_init_rules( &$module )
{
	// initialize cache
	nuseo_cache_init( $module, array( 'project', 'issuetype', 'issue' ) );

	// pre-process URL formats
	nuseo_projecttools_load_url_formats( $module );
	
	// populate module rules
	nuseo_projecttools_load_rewrite_rules( $module );
}

function nuseo_projecttools_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;

	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
	else
		$script_name = $rel_url;

	if ( $script_name == 'project.php' )
	{
		$nuseo['global_parser'] = false;
	}
}

function nuseo_projecttools_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
		'home'					=> $nuseo_config[ 'projecttools_home_format' ],
		'project'				=> $nuseo_config[ 'projecttools_project_format' ],
		'issuetype'				=> $nuseo_config[ 'projecttools_issuetype_format' ],
		'issue'					=> $nuseo_config[ 'projecttools_issue_format' ]
	);

	$id_keywords	= array(	'#\[(project_id)\]#',		'#\[(issue_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_projecttools_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> 'project\.php', 
						'translate_to_sef'		=> 'nuseo_projecttools_project_to_sef' );

	if ($nuseo_config[ 'projecttools_rewrite_project_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['project_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_projecttools_sef_to_project'
					);
	}

	if ($nuseo_config[ 'projecttools_rewrite_issuetype_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['issuetype_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_projecttools_sef_to_project'
						);
	}

	if ($nuseo_config[ 'projecttools_rewrite_issue_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['issue_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_projecttools_sef_to_project'
						);
	}

	if ($nuseo_config[ 'projecttools_rewrite_home_url' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['home_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_projecttools_sef_to_project'
						);
	}

	$module['rules'] = $rules;
}
//

// index.php
function nuseo_projecttools_project_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$do				= isset( $query_params['do']			)	? $query_params['do'] : false;
	$project_id		= isset( $query_params['projectid']		)	? intval( $query_params['projectid'] ) : 0;
	$issuetype_id	= isset( $query_params['issuetypeid']	)	? $query_params['issuetypeid'] : 0;
	$issue_id		= isset( $query_params['issueid']		)	? intval( $query_params['issueid'] ) : 0;

	$url_format		= false;

	$project		= false;
	$issuetype		= false;
	$issue			= false;

	if ($issue_id)
	{
		if (!$nuseo_config['projecttools_rewrite_issue_urls'])
			return false;

		$issue = nuseo_cache_fetch( $module, 'issue', $issue_id, 'nuseo_projecttools_fetch_issue' );
		if (!$issue)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the ad, fail.
		}

		$url_format = $module['issue_url_format'];
		unset( $query_params['issueid'] );

		if (!$project_id)
		{
			$project_id = $issue['projectid'];
			$project = array( 'projectid' => $project_id, 'title' => $issue['project_title'] );
			nuseo_cache_add( $module, 'project', $project_id, $project );
		}
		
		if (!$issuetype_id)
		{
			$issuetype_id = $issue['issuetypeid'];
		}
	}

	if ($project_id)
	{
		$showing_project_url = !$issue_id && !$issuetype_id;
		if ($showing_project_url && !$nuseo_config['projecttools_rewrite_project_urls'])
			return false;		// project rewrite is disabled.

		if (!$project)
		{
			global $nuseo_vbulletin;
			if ( !empty($nuseo_vbulletin) && !empty($nuseo_vbulletin['vb_pt_projects']) )
			{
				if ( isset( $nuseo_vbulletin['vb_pt_projects'][ $project_id ] ) )
				{
					$project = $nuseo_vbulletin['vb_pt_projects'][ $project_id ];
				}
			}

			if (!$project)
			{
				$project = nuseo_cache_fetch( $module, 'project', $project_id, 'nuseo_projecttools_fetch_project' );
				if (!$project)
				{
					if ($nuseo['prefetch'])
						return true;				// we are in prefetch mode, we'll be back later
					else
						return false;				// else, we didn't find the project, fail.
				}
			}
		}

		if ($showing_project_url)
		{
			$url_format = $module['project_url_format'];
		}
		unset( $query_params['projectid'] );
	}
	
	if ($issuetype_id)
	{
		$showing_issuetype_url = $do == 'issuelist';
		if ($showing_issuetype_url && !$nuseo_config['projecttools_rewrite_issuetype_urls'])
			return false;

		if ($showing_issuetype_url)
		{
			$url_format = $module['issuetype_url_format'];
			unset( $query_params['do'] );
		}
		
		unset( $query_params['issuetypeid'] );
	}
	
	if (!$url_format && $nuseo_config[ 'projecttools_rewrite_home_url' ])
	{
		$url_format = $nuseo_config['projecttools_home_format'];
	}

	if (!$url_format)
		return false;

	// add thread information
	$info = array();
	$info['project_id']		= $project_id;
	$info['project_title']	= $project ? nuseo_str_to_url( $project['title'] ) : '';
	$info['issuetype_id']	= $issuetype_id;
	$info['issue_title']	= $issue ? nuseo_str_to_url( $issue['title'] ) : '';
	$info['issue_id']		= $issue_id;

	eval( '$sef_url = "' . $url_format . '";' );

	return $sef_url;
}

function nuseo_projecttools_sef_to_project( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$project_id		= isset( $matches['project_id']		) ? $matches['project_id']		: false;
	$project_title	= isset( $matches['project_title']	) ? $matches['project_title']	: false;
	$issuetype_id	= isset( $matches['issuetype_id']	) ? $matches['issuetype_id']	: false;
	$issue_title	= isset( $matches['issue_title']	) ? $matches['issue_title']		: false;
	$issue_id		= isset( $matches['issue_id']		) ? $matches['issue_id']		: false;

	if (!$issue_id && $issue_title)
	{
		$issue = nuseo_cache_fetch_by_title( $module, 'issue', $issue_title, 'nuseo_projecttools_fetch_issue_by_title' );
		if ($issue)
			$issuetype_id = $issue['issueid'];
	}

	if (!$project_id && $project_title)
	{
		$project = nuseo_cache_fetch_by_title( $module, 'project', $project_title, 'nuseo_projecttools_fetch_project_by_title' );
		if ($project)
			$project_id = $project['projectid'];
	}
	
	if ($issue_id)
	{
		$query_params['issueid'] = $issue_id;
	}
	else if ($issuetype_id && $project_id && !$issue_id)
	{
		if (!isset( $query_params['do'] ))
		{
			$query_params['do'] = 'issuelist';
		}
		$query_params['projectid'] = $project_id;
		$query_params['issuetypeid'] = $issuetype_id;
	}
	else if ($project_id)
	{
		$query_params['projectid'] = $project_id;
	}
    
//seo content
    if ( $nuseo_config['projecttools_replace_keywords'] || $nuseo_config['projecttools_replace_description'])
    {
        $seo_items = array ();
        
        if ( $project_id )
        {
            if ( !isset( $project ) || !$project )
            {
                $project = nuseo_cache_fetch( $module, 'project', $project_id, 'nuseo_projecttools_fetch_project' );
            }
                        
            $seo_items['project'] = array();
            $seo_items['project']['keywords'] = $project['title'] . "," . $project['summary'];
            $seo_items['project']['description'] = $project['title'] . " - " . $project['summary'];
        }
        
        if ( $issue_id )
        {
            if ( !isset( $issue ) || !$issue )
            {
                $issue = nuseo_cache_fetch( $module, 'issue', $issue_id, 'nuseo_projecttools_fetch_issue' );
            }
                        
            $seo_items['issue'] = array();
            $seo_items['issue']['keywords'] = $issue['title'] . "," . $issue['summary'];
            $seo_items['issue']['description'] = $issue['title'] . " - " . $issue['summary'];
            
        }
        
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'projecttools_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'projecttools_replace_description' ] ) );
        }
    }

	$non_sef_url = 'project.php';
	return $non_sef_url;
}
//

// Database Connectivity
function nuseo_projecttools_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$module['db_conn']		= false;
	$module['table_prefix']	= false;

	if (isset($nuseo_vbulletin))
	{	// reuse vBulletin Module's DB Connection
		$db_conn = nuseo_get_db_connection( $nuseo_vbulletin );
		
		$module['table_prefix'] = $nuseo_vbulletin['table_prefix'];

		$module['db_conn'] =& $db_conn;
	}
	
	if (!$module['db_conn'])
	{
		$vbulletin_config_adname = $nuseo['base_dir'] . $module['url_base'] . 'includes/config.php';
		if (ad_exists( $vbulletin_config_adname ))
		{
			$config = array();
			include $vbulletin_config_adname;
			
			// read DB connection vars
			$server_name			= $config['MasterServer']['servername'];
			$server_port			= $config['MasterServer']['port'];
			$db_username			= $config['MasterServer']['username'];
			$db_password			= $config['MasterServer']['password'];
			$module['db_name']		= $config['Database']['dbname'];
			
			$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
												$db_username, $db_password, $module['db_name'] );

			$module['table_prefix'] = $config['Database']['tableprefix'];
			
			// do not store username/password in memory
			unset( $server_name, $server_port, $db_username, $db_password, $config );
		}
	}
}

function nuseo_projecttools_fetch_project( &$module, $cache_type, $project_id )
{
	$table_name = 'project';

	$id_field_name = 'projectid';

	$sql = "SELECT * FROM `{$module['table_prefix']}pt_project` project";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_common( $module, $cache_type, $project_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_projecttools_fetch_issue( &$module, $cache_type, $issuetype_id )
{
	$table_name = 'issue';

	$id_field_name = 'issueid';

	$sql = "SELECT issue.*, project.title AS project_title FROM `{$module['table_prefix']}pt_issue` issue
				LEFT OUTER JOIN `{$module['table_prefix']}pt_project` project ON project.projectid = issue.projectid";

	$additional_where = false;

	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $issuetype_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_projecttools_fetch_project_by_title( &$module, $cache_type, $project_title )
{
	$table_name = 'project';

	$title_field_name = 'title';

	$sql = "SELECT * FROM `{$module['table_prefix']}pt_project` project";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $project_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_projecttools_fetch_issue_by_title( &$module, $cache_type, $issue_title )
{
	$table_name = 'issue';

	$title_field_name = 'title';

	$sql = "SELECT issue.*, project.title AS project_title FROM `{$module['table_prefix']}pt_issue` issue
				LEFT OUTER JOIN `{$module['table_prefix']}pt_project` project ON project.projectid = issue.projectid";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $issue_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}


//