<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );



/***********************************************************************
* * Start File: nuhit_lib_debug.h
 * Description: nuhit_lib_debug.h contains NuHIT's Debug Library for nuhit_php_compiler
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 ************************************************************************/









	
	


//--------------------------------------------------------------------------
// nu_print and nu_print_r are the release and debug version of print and print_r
// These macros/functions always generate code
//--------------------------------------------------------------------------

















































/***********************************************************************
* * End File: nuhit_lib_debug.h
 ************************************************************************/



// Initialization
// Initialize module 
function nuseo_phpfox_load( &$module )
{
	global $nuseo, $nuseo_config;

	// set url base
	$module['url_base']			= $nuseo_config[ 'phpfox_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'phpfox_domain' ];
	
	nuseo_cache_init( $module, array( 'gallery', 'user', 'blog', 'post', 'forum', 'topic',
				'poll', 'group_category', 'group', 'group_forum', 'listing', 'quiz', 'event' ) );
	
	nuseo_phpfox_load_config_files( $module );
	
	if (empty( $nuseo_config['phpfox_reserved_dir_list'] ))
		$nuseo_config['phpfox_reserved_dir_list'] = array();

	if (!empty( $nuseo_config['phpfox_reserved_name_list'] ))
	{
		if (!empty( $module['url.reserved_names'] ))
		{
			$nuseo_config['phpfox_reserved_name_list'] = array_merge( $nuseo_config['phpfox_reserved_name_list'], $module['url.reserved_names'] );
			unset( $module['url.reserved_names'] );
		}
	}
	else
	{
		$nuseo_config['phpfox_reserved_dir_list'] = array();
	}
		
	if (!empty( $module['app.areas'] ))
	{
		$nuseo_config['phpfox_app_areas'] = $module['app.areas'];
		unset( $module['app.areas'] );
	}
	else
	{
		$nuseo_config['phpfox_app_areas'] = array( 'public', 'admin' );
	}
	
	$nuseo_config['phpfox_default_area'] = reset( $nuseo_config['phpfox_app_areas'] );
}

function nuseo_phpfox_init_rules( &$module )
{
	global $nuseo, $nuseo_config;

	// pre-process url formats
	nuseo_phpfox_load_url_formats( $module );

	// populate module rules
	nuseo_phpfox_load_rewrite_rules( $module );
}

function nuseo_phpfox_init_processor( &$module )
{
	global $nuseo, $nuseo_config;
}
//

// phpFox default .htaccess
function nuseo_phpfox_from_sef( &$module, $url, &$url_info, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
	$query_params =& $url_info['query_params'];
	
	$is_sef_url = false;		// assume that all urls are non_sef

	$query_pos = strpos( $url, '?' );
	if ($query_pos !== false)
		$url = substr( $url, 0, $query_pos );
	
	if ($url)
	{
		if ($url[0] == '/')
		{
			$url = substr( $url, 1 ); 
		}

		$slash_pos = strpos( $url, '/' );
		if ($slash_pos)
		{
			$first_part = substr( $url, 0, $slash_pos );
		}
		else
		{
			$first_part = $url;			// no ending slash
		}

		//$query_params['original_url'] = $first_part;
			
		if ($first_part == 'index.php')
		{
			$url = substr( $url, $slash_pos+1 );
			$is_sef_url = false;		// this is not a sef URL
		}
		else
		{
			if (in_array( $first_part, $nuseo_config['phpfox_reserved_dir_list'] ))
			{
				$is_sef_url = false;
			}
			else
			{
				$is_sef_url = true;

				if (!in_array( $first_part, $nuseo_config['phpfox_app_areas'] ))
				{	// if it is not prefixed with an area, use default (public)
					$url = $nuseo_config['phpfox_default_area'] . '/' . $url;
				}
			}
		}
	}
	else		// $url is empty, then this is phpFox's root.
	{
		$is_sef_url = true;
		
		// if it is not prefixed with an area, use default (public)
		$url = $nuseo_config['phpfox_default_area'] . '/';
	}

	if ($is_sef_url)
	{
		$do = '/' . $url;
		if (isset( $query_params['do'] ))
		{
			$query_params['do'] = $do . $query_params['do'];
		}
		else
		{
			$query_params['do'] = $do;
		}

		$non_sef_url = 'index.php';
	}
	else
	{
		$non_sef_url = false;
	}
	
	return $non_sef_url;
}
//

// index
function nuseo_phpfox_index_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info   )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];

	$do			= isset( $query_params['do'] ) ? $query_params['do'] : false;
	
	$url_format = false;
	$info = array();
	
	// remove / and public from $do
	$parts_to_remove = array( '/' . $nuseo_config['phpfox_default_area'] . '/', $nuseo_config['phpfox_default_area'] . '/', '/' );
	foreach ($parts_to_remove as $part_iter)
	{
		if (strpos( $do, $part_iter ) === 0)
		{
			$do = substr( $do, strlen( $part_iter ) );
			break;
		}
	}
	
	// Split do param and extract level0 and level1
	$do_parts = explode( '/', $do );
	
	if (isset( $do_parts[0] ))
    {
	    $level0 = $do_parts[ 0 ];
	    $level1 = isset( $do_parts[ 1 ] ) ? $do_parts[ 1 ] : '';
		
		$do_parts = array_slice( $do_parts, 2 );
    }
    else
    {
        $level0 = 'home';
        $level1 = '';
    }

	if ($nuseo['debug_mode']) { echo( "phpFox: level0=$level0, level1=$level1\n" ); };

	$do_params = nuseo_phpfox_split_params( $do_parts );
    
    switch( $level0 )
    {
     
		 case 'gallery':
			nuseo_phpfox_gallery_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;
        
		case 'blog':
			nuseo_phpfox_blog_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;

		case 'user':
			nuseo_phpfox_user_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;

		case 'forum':
			nuseo_phpfox_forum_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;

		case 'poll':
			nuseo_phpfox_poll_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;

		case 'groups':
			nuseo_phpfox_groups_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;

		case 'listing':
			nuseo_phpfox_listing_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;
	        
		//case 'quiz':
		//	nuseo_phpfox_quiz_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
		//	break;
	        
		case 'event':
			nuseo_phpfox_event_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
			break;        
	        
		default:
			break;
    }

	if ($url_format === true)
	{
		$sef_url = true;		// we are in pre-fetch mode, we'll come back
	}
	else
	{
		if ($url_format)
		{
			eval( '$sef_url = "' . $url_format . '";' );
			
			// rebuild $do
			if ( empty( $do_params ) )
			{
				unset( $query_params[ 'do'] );
			}
			else
			{
				foreach ($do_params as $key => $value)
				{
					if ( ($key == '___') && !$value )
					{
						$do_params[ $key ] = $key;
					}
					else
					{
						$do_params[ $key ] = $key . '_' . $value;
					}
				}
				$do = implode( '/', $do_params );
				$do = str_replace( 'view_/', 'view/', $do );
				if (substr($sef_url, -1, 1) == '/')
				{
					$sef_url .= $do;
					unset( $query_params[ 'do'] );
				}
				else
				{
					$query_params[ 'do' ] = $do;
				}
			}
		}
		else
		{	// then we are not rewriting this URL, make it SEF using $do
			if ($do)
			{
				$sef_url = $do;			// this is relative to phpfox's root.
			}
			else
			{
				$sef_url = $module['url_base'];
			}
			unset( $query_params[ 'do'] );
		}
	}

	return $sef_url;
}

function nuseo_phpfox_sef_to_index( &$module, $url, &$url_info, &$matches, &$anchor_info, $do_command = ''  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];

	$do			= isset( $matches['do']		) ? $matches['do']		: 
						(isset( $query_params['do']	) ? $query_params['do']	: '' );
	
	$do_parts = array();

	if (!empty(  $nuseo_config['phpfox_default_area']  ))
		$do_parts[] =  $nuseo_config['phpfox_default_area'];
		
	if ($do_command)
		$do_parts[] = trim($do_command, '/');

	if (!empty( $do_parts ))
	{
		$new_do = '/' . implode( '/', $do_parts ) . '/';
	}
	else
	{
		$new_do = '';
	}
	
	if (!empty( $do ))
	{
		$new_do .= trim( $do, '/' ) . '/';
	}

	if (empty( $new_do ))
	{
		$new_do = '/' . $nuseo_config['phpfox_default_area'] . '/';
	}
	
	$query_params['do'] = $new_do;

	$non_sef_url = "index.php";
	return $non_sef_url;
}

function nuseo_phpfox_sef_to_item( &$module, $url, &$url_info, &$matches, &$anchor_info, $id_tag, $title_tag, $do_prefix, $object_type  )
{
	global $nuseo, $nuseo_config;
	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];
	
	$id		= ($id_tag		&& isset( $matches[$id_tag]		) ) ? intval( $matches[$id_tag] ) : false;
	$title	= ($title_tag	&& isset( $matches[$title_tag]	) ) ? $matches[$title_tag] : false;
	
	$do				= isset( $query_params['do'] ) ? $query_params['do'] : false;
	
	$do_parts = explode( '/', $do );
	$do_params = nuseo_phpfox_split_params( $do_parts );
	
	// Connect to DB if needed
	if (!$module['db_conn'])
	{
		$db_conn = nuseo_get_db_connection( $module );
	}
	
	$object_cache_info_key = "cache_{$object_type}_info";
	$object = false;
	if ( isset( $module[ $object_cache_info_key ] ) )
	{
		
		$id_name			= isset( $module[ $object_cache_info_key ][ 'id_name' ] ) ? $module[ $object_cache_info_key ][ 'id_name' ] : false;
		$title_name			= isset( $module[ $object_cache_info_key ][ 'title_name' ] ) ? $module[ $object_cache_info_key ][ 'title_name' ] : false;
		$description_name	= isset( $module[ $object_cache_info_key ][ 'description_name' ] ) ? $module[ $object_cache_info_key ][ 'description_name' ] : false;
	}
	else
	{
		$id_name			= false;
		$title_name			= false;
		$description_name	= false;
	}

	if (!$id && $title)
	{
		// fetch id from title
		$object = nuseo_cache_fetch_by_title( $module, $object_type, $title );
		if ($object)
		{
			if ( $id_name && isset( $object[ $id_name ] ) )
			{
				$id = $object[ $id_name ];
			}
		}
	}

	if ($id)
	{
		// Meta tags.
		if ( $nuseo_config['phpfox_replace_keywords'] || $nuseo_config['phpfox_replace_description'])
		{
			phpfox_populate_meta_tags( $module, $id, $title, $object, $object_type,
										"[$title_name] - [$description_name]", "[$title_name],[$description_name]" );
		}

		$do_command = $do_prefix . $id;

		$non_sef_url = nuseo_phpfox_sef_to_index( $module, $url, $url_info, $matches, $anchor_info, $do_command );
	}
	else
	{
		$non_sef_url = false;
	}
	
	return $non_sef_url;
}
//

// Gallery
function nuseo_phpfox_gallery_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;
	if ($nuseo_config['phpfox_rewrite_gallery_urls'])
	{
		if ($level1 == 'view')
		{
			// Read params
			$gallery_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;
			$gallery_field	= isset( $do_params[ 'field' ]	) ? $do_params[ 'field' ] : '';

			if ($gallery_id)
			{
				// Load gallery record
				$gallery = nuseo_cache_fetch( $module, 'gallery', $gallery_id );
				
				if ($gallery)
				{
					// Fill $info
					$info['gallery_id']		= $gallery_id;
					$info['gallery_title']	= isset( $gallery['text'] ) ? nuseo_str_to_url( $gallery[ 'text' ] ) : '';
					
					// url format
					$url_format = $module['gallery_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
					
					if ($gallery_field == 'time')
					{
						unset( $do_params[ 'field' ] );
					}
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_gallery( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'gallery_id';
	$title_tag	= 'gallery_title';
	$do_prefix	= 'gallery/view/id_';
	$object_type = 'gallery';

/*	// default to field_time	
	$field_param_specified = false;
	if (!empty( $url_info['query_params'] ))
	{
		$query_params =& $url_info['query_params'];
		if ( !empty( $query_params['do'] ) )
		{
			$field_param_specified = strpos( $query_params['do'], 'field_' ) !== false;
			if (!$field_param_specified)
			{
				$query_params['do'] = '/field_time/' . $query_params['do'];
			}
		}
		else	// we have query_params, but no 'do'
		{
			$query_params['do'] = '/field_time/';
		}
	}
	else		// we don't even have a query_params field
	{
		$url_info['query_params'] = array( 'do' => '/field_time/' );
	}
*/
	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// Quizzes
/*function nuseo_phpfox_quiz_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'view')
	{
		if ($nuseo_config['phpfox_rewrite_quiz_urls'])
		{
			// Read params
			$quiz_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;
			$quiz_field	= isset( $do_params[ 'field' ]	) ? $do_params[ 'field' ] : '';

			if ($quiz_id)
			{
				// Load quiz record
				$quiz = nuseo_cache_fetch( $module, 'quiz', $quiz_id );
				
				if ($quiz)
				{
					// Fill $info
					$info['quiz_id']		= $quiz_id;
					$info['quiz_title']	= isset( $quiz['title'] ) ? nuseo_str_to_url( $quiz[ 'title' ] ) : '';
					
					// url format
					$url_format = $module['quiz_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
					
					if ($quiz_field == 'time')
					{
						unset( $do_params[ 'field' ] );
					}
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}*/
//

// Listings
function nuseo_phpfox_listing_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'view')
	{
		if ($nuseo_config['phpfox_rewrite_listing_urls'])
		{
			// Read params
			$listing_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;
			$listing_field	= isset( $do_params[ 'field' ]	) ? $do_params[ 'field' ] : '';

			if ($listing_id)
			{
				// Load listing record
				$listing = nuseo_cache_fetch( $module, 'listing', $listing_id );
				
				if ($listing)
				{
					// Fill $info
					$info['listing_id']		= $listing_id;
					$info['listing_title']	= isset( $listing['title'] ) ? nuseo_str_to_url( $listing[ 'title' ] ) : '';
					
					// url format
					$url_format = $module['listing_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
					
					if ($listing_field == 'time')
					{
						unset( $do_params[ 'field' ] );
					}
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_listing( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'listing_id';
	$title_tag	= 'listing_title';
	$do_prefix	= 'listing/view/id_';
	$object_type = 'listing';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

//

// Events
function nuseo_phpfox_event_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'view')
	{
		if ($nuseo_config['phpfox_rewrite_event_urls'])
		{
			// Read params
			$event_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;
			$event_field	= isset( $do_params[ 'field' ]	) ? $do_params[ 'field' ] : '';

			if ($event_id)
			{
				// Load event record
				$event = nuseo_cache_fetch( $module, 'event', $event_id );
				
				if ($event)
				{
					// Fill $info
					$info['event_id']		= $event_id;
					$info['event_title']	= isset( $event['title'] ) ? nuseo_str_to_url( $event[ 'title' ] ) : '';
					
					// url format
					$url_format = $module['event_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
					
					if ($event_field == 'time')
					{
						unset( $do_params[ 'field' ] );
					}
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_event( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'event_id';
	$title_tag	= 'event_title';
	$do_prefix	= 'event/view/id_';
	$object_type = 'event';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// Blogs
function nuseo_phpfox_blog_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'view')
	{
		if ($nuseo_config['phpfox_rewrite_blog_urls'])
		{
			// Read params
			$blog_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;
			$blog_field	= isset( $do_params[ 'field' ]	) ? $do_params[ 'field' ] : '';

			if ($blog_id)
			{
				// Load blog record
				$blog = nuseo_cache_fetch( $module, 'blog', $blog_id );
				
				if ($blog)
				{
					// Fill $info
					$info['blog_id']		= $blog_id;
					$info['blog_title']	= isset( $blog['title'] ) ? nuseo_str_to_url( $blog[ 'title' ] ) : '';
					
					// url format
					$url_format = $module['blog_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
					
					if ($blog_field == 'time')
					{
						unset( $do_params[ 'field' ] );
					}
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_blog( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'blog_id';
	$title_tag	= 'blog_title';
	$do_prefix	= 'blog/view/id_';
	$object_type = 'blog';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// User
function nuseo_phpfox_user_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;
    
    
    if ( ( $level1 == 'blogs') || ( $level1 == 'gallery' ) || ( $level1 == 'guestbook' ) || 
         ( $level1 == 'friends' ) || ( $level1 == 'favorites' ) )
	{
		nuseo_phpfox_user_section_to_sef( $module, $level0, $level1, $do_params, $url_format, $info );
    }
	else
	{
		// name_xxxx is now in $level1
		if (strpos( $level1, 'name_' ) === 0)
		{
			$do_params['name'] = substr( $level1, 5 );
		}

		if ($nuseo_config['phpfox_rewrite_user_urls'])
		{
			// Read params
			$user_name	= isset( $do_params[ 'name' ]		) ? $do_params[ 'name' ] : '';
			if ($user_name)
			{
				// Fill $info
				$info['user_name']		= $user_name; // nuseo_str_to_url( $user_name );

				// url format
				$url_format = $module['user_url_format'];

				// clean fields used
				unset( $do_params[ 'name' ] );
			}
		}
	}
}

function nuseo_phpfox_sef_to_user( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$user_name = isset( $matches['user_name'] ) ? $matches['user_name'] : '';
	
	if (in_array( $user_name, $nuseo_config['phpfox_reserved_name_list'] ) || in_array( $user_name, $nuseo_config['phpfox_reserved_dir_list'] ))
	{
		$non_sef_url = false;
	}
	else
	{
		// Meta tags.
		if ( $nuseo_config['phpfox_replace_keywords'] || $nuseo_config['phpfox_replace_description'])
		{
			$user_id = 0;
			$object = false;
			$object_type = 'user';
			phpfox_populate_meta_tags( $module, $user_id, $user_name, $object, $object_type,
										$nuseo_config['phpfox_member_description_format'], $nuseo_config['phpfox_member_keywords_format'] );
		}

		$do_command = 'user/name_' . $user_name;
		$non_sef_url = nuseo_phpfox_sef_to_index( $module, $url, $url_info, $matches, $anchor_info, $do_command );
	}
	return $non_sef_url;
}
//

// User Section To Sef
function nuseo_phpfox_user_section_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;
	
	if ($nuseo_config["phpfox_rewrite_user_{$level1}_urls"])
	{
		$user_name	= isset( $do_params[ 'name' ] ) ? $do_params[ 'name' ] : '';

		if ($user_name)
		{
			// Fill $info
			$info['user_name']		= $user_name;

			// url format
			$url_format = $module[ "user_{$level1}_url_format" ];
				
			// clean fields used
			unset( $do_params[ 'name' ] );
		}
	}
}
//

// Sef to User Section 
function nuseo_phpfox_sef_to_user_section( &$module, $url, &$url_info, &$matches, &$anchor_info, $section  )
{
	global $nuseo, $nuseo_config;
	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];

	$user_name = isset( $matches['user_name'] ) ? $matches['user_name'] : '';
	
	if (in_array( $user_name, $nuseo_config['phpfox_reserved_name_list'] ) || in_array( $user_name, $nuseo_config['phpfox_reserved_dir_list'] ))
	{
		$non_sef_url = false;
	}
	else
	{
		$subcommand = '';
		$do_extra = isset( $matches['do'] ) ? $matches['do'] : '';
		if ($do_extra)
		{
			if (strpos( $do_extra, 'view/' ) === 0)
			{
				$subcommand = 'view/';
				$do_extra = substr( $do_extra, strlen( 'view/' ) );
			}
			else if (strpos( $do_extra, '/view/' ) !== false )
			{
				$subcommand = 'view/';
				$do_extra = str_replace( '/view/', '/', $do_extra );
			}
			$matches['do'] = $do_extra;
		}
		
		// Meta tags.
		if ( $nuseo_config['phpfox_replace_keywords'] || $nuseo_config['phpfox_replace_description'])
		{
			$user_id = 0;
			$object = false;
			$object_type = 'user';
			phpfox_populate_meta_tags( $module, $user_id, $user_name, $object, $object_type,
										$nuseo_config['phpfox_member_description_format'], $nuseo_config['phpfox_member_keywords_format'] );
		}

		$do_command = "user/{$section}/{$subcommand}name_" . $user_name;
		$non_sef_url = nuseo_phpfox_sef_to_index( $module, $url, $url_info, $matches, $anchor_info, $do_command );
	}
	return $non_sef_url;
}

function nuseo_phpfox_sef_to_user_gallery( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    return nuseo_phpfox_sef_to_user_section( $module, $url, $url_info, $matches, $anchor_info, "gallery" );
}

function nuseo_phpfox_sef_to_user_blogs( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    return nuseo_phpfox_sef_to_user_section( $module, $url, $url_info, $matches, $anchor_info, "blogs" );
}

function nuseo_phpfox_sef_to_user_guestbook( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    return nuseo_phpfox_sef_to_user_section( $module, $url, $url_info, $matches, $anchor_info, "guestbook" );
}

function nuseo_phpfox_sef_to_user_friends( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    return nuseo_phpfox_sef_to_user_section( $module, $url, $url_info, $matches, $anchor_info, "friends" );
}

function nuseo_phpfox_sef_to_user_favorites( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
    return nuseo_phpfox_sef_to_user_section( $module, $url, $url_info, $matches, $anchor_info, "favorites" );
}
//

// Forums
function nuseo_phpfox_forum_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'topics')
	{
		// confusing params. 
		//		/index.php?do=/public/forum/topics/id_2/ shows all threads in forum with id=2	( forumdisplay )
		//		/index.php?do=/public/forum/posts/id_2/ shows posts in thread with id=2			( showthread )
		
		if ($nuseo_config['phpfox_rewrite_forum_urls'])
		{
			// Read params
			$forum_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;

			if ($forum_id)
			{
				// Load forum record
				$forum = nuseo_cache_fetch( $module, 'forum', $forum_id );
				
				if ($forum)
				{
					// Fill $info
					$info['forum_id']		= $forum_id;
					$info['forum_title']	= isset( $forum['forum_title'] ) ? nuseo_str_to_url( $forum[ 'forum_title' ] ) : '';
					
					// url format
					$url_format = $module['forum_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
	else if ($level1 == 'posts')
	{	
		if ($nuseo_config['phpfox_rewrite_forum_urls'])
		{
			// Read params
			$topic_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;

			if ($topic_id)
			{
				// Load topic record
				$topic = nuseo_cache_fetch( $module, 'topic', $topic_id );
				
				if ($topic)
				{
					// Fill $info
					$info['forum_id']		= isset( $topic['forum_id'] ) ? $topic[ 'type' ] : 0;
					$info['forum_title']	= isset( $topic['forum_title'] ) ? nuseo_str_to_url( $topic[ 'forum_title' ] ) : '';
					$info['topic_id']		= $topic_id;
					$info['topic_title']	= isset( $topic['title'] ) ? nuseo_str_to_url( $topic[ 'title' ] ) : '';
					
					// url format
					$url_format = $module['topic_url_format'];
					
					// clean fields used
					unset( $do_params[ 'id' ] );
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_forum( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'forum_id';
	$title_tag	= 'forum_title';
	$do_prefix	= 'forum/topics/id_';
	$object_type = 'forum';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_topic( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'topic_id';
	$title_tag	= 'topic_title';
	$do_prefix	= 'forum/posts/id_';
	$object_type = 'topic';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// Polls
function nuseo_phpfox_poll_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;

	if ($level1 == 'view')
	{	
		if ($nuseo_config['phpfox_rewrite_poll_urls'])
		{
			// Read params
			$poll_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;

			if ($poll_id)
			{
				// Load topic record
				$poll = nuseo_cache_fetch( $module, 'poll', $poll_id );
				
				if ($poll)
				{
					// Fill $info
					$info['poll_id']		= $poll_id;
					$info['poll_title']		= isset( $poll['poll'] ) ? nuseo_str_to_url( $poll[ 'poll' ] ) : '';
					
					// url format
					$url_format = $module['poll_url_format'];

					// clean fields used
					unset( $do_params[ 'id' ] );
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
	}
}

function nuseo_phpfox_sef_to_poll( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'poll_id';
	$title_tag	= 'poll_title';
	$do_prefix	= 'poll/view/id_';
	$object_type = 'poll';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// Groups
function nuseo_phpfox_groups_to_sef( &$module, &$level0, &$level1, &$do_params, &$url_format, &$info )
{
	global $nuseo, $nuseo_config;
	if ($nuseo_config['phpfox_rewrite_group_urls'])
	{
		if ($level1 == 'browse')
		{
			// Read params
			$category_id		= isset( $do_params[ 'type' ]		) ? intval($do_params[ 'type' ]) : 0;

			if ($category_id)
			{
				// Load forum record
				$group_category = nuseo_cache_fetch( $module, 'group_category', $category_id );
				
				if ($group_category)
				{
					// Fill $info
					$info['category_id']		= $category_id;
					$info['category_title']		= isset( $group_category['name'] ) ? nuseo_str_to_url( $group_category[ 'name' ] ) : '';
					
					// url format
					$url_format = $module['group_category_url_format'];
					
					// clean fields used
					unset( $do_params[ 'type' ] );
				}
				else if ($nuseo['prefetch'])
				{
					$url_format = true;
				}
			}
		}
		else
		{
			if ($level1 == 'forum')
			{
				if (isset( $do_params['topic'] ))		// then this is a groups forum topic
				{	// a topic link is a 'newthread' url for a group forum
					$level1 = 'topic';
					unset( $do_params[ 'topic' ] );
				}
				elseif  (isset( $do_params['posts'] ))		// then this is a groups forum posts
				{
					$level1 = 'posts';
					unset( $do_params[ 'posts' ] );
				}
			}
			
			if (($level1 == 'view') || ($level1 == 'members') || ($level1 == 'gallery') || ($level1 == 'forum') || ($level1 == 'topic'))
			{	
				// Read params
				$group_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;

				if ($group_id)
				{
					// Load topic record
					$group = nuseo_cache_fetch( $module, 'group', $group_id );
					
					if ($group)
					{
						// Fill $info
						$info['category_id']	= isset( $group['type'] ) ? $group['type'] : 0;
						$info['category_title']	= isset( $group['category_title'] ) ? nuseo_str_to_url( $group[ 'category_title' ] ) : '';
						$info['group_id']		= $group_id;
						$info['group_title']	= isset( $group['title'] ) ? nuseo_str_to_url( $group[ 'title' ] ) : '';
						
						// url format. view = group_url_format, gallery => group_gallery_url_format
						$format_key = $level1 == 'view' ? '' : $level1 . '_';
						$url_format = $module[ "group_{$format_key}url_format" ];
						
						// clean fields used
						unset( $do_params[ 'id' ] );
					}
					else if ($nuseo['prefetch'])
					{
						$url_format = true;
					}
				}
			} // else, if level == view
			else if ($level1 == 'posts')
			{	
				// Read params
				$forum_id		= isset( $do_params[ 'id' ]		) ? intval($do_params[ 'id' ]) : 0;

				if ($forum_id)
				{
					// Load topic record
					$group_forum = nuseo_cache_fetch( $module, 'group_forum', $forum_id );
					
					if ($group_forum)
					{
						// Fill $info
						$info['category_id']	= isset( $group_forum['category_id'] ) ? $group_forum['category_id'] : 0;
						$info['category_title']	= isset( $group_forum['category_title'] ) ? nuseo_str_to_url( $group_forum[ 'category_title' ] ) : '';
						$info['group_id']		= isset( $group_forum['group_id'] ) ? $group_forum['group_id'] : 0;
						$info['group_title']	= isset( $group_forum['title'] ) ? nuseo_str_to_url( $group_forum[ 'title' ] ) : '';
						$info['forum_id']		= $forum_id;
						$info['forum_title']	= isset( $group_forum['title'] ) ? nuseo_str_to_url( $group_forum[ 'title' ] ) : '';

						$url_format = $module[ "group_posts_url_format" ];

						// clean fields used
						unset( $do_params[ 'id' ], $do_params[ 'posts' ] );
					}
					else if ($nuseo['prefetch'])
					{
						$url_format = true;
					}
				}
			} // else, if level == view	} // if group urls enabled
		}
	}
}

function nuseo_phpfox_sef_to_group_category( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'category_id';
	$title_tag	= 'category_title';
	$do_prefix	= 'groups/browse/type_';
	$object_type = 'group_category';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'group_id';
	$title_tag	= 'group_title';
	$do_prefix	= 'groups/view/id_';
	$object_type = 'group';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group_forum( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'group_id';
	$title_tag	= 'group_title';
	$do_prefix	= 'groups/forum/id_';
	$object_type = 'group';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group_topic( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'group_id';
	$title_tag	= 'group_title';
	$do_prefix	= 'groups/forum/topic/id_';
	$object_type = 'group';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group_posts( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'forum_id';
	$title_tag	= 'forum_title';
	$do_prefix	= 'groups/forum/posts/id_';
	$object_type = 'group';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group_members( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'group_id';
	$title_tag	= 'group_title';
	$do_prefix	= 'groups/members/id_';
	$object_type = 'group';

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}

function nuseo_phpfox_sef_to_group_gallery( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$id_tag		= 'group_id';
	$title_tag	= 'group_title';
	$object_type = 'group';
	
	$sub_command = false;
	
	$do_param = isset( $matches['do'] ) ? $matches['do'] : '';
	
	if (!empty( $do_param ))
	{
		if (strpos( $do_param, 'upload_' ) !== false )
		{
			$sub_command = 'upload/';
			$do_param = str_replace( 'upload_', '', $do_param );
			if (!empty( $do_param ))
			{
				$matches['do'] = $do_param;
			}
			else
			{
				unset( $matches['do'] );
			}
		}
	}

	$do_prefix	= "groups/gallery/{$sub_command}id_";

	return nuseo_phpfox_sef_to_item( $module, $url, $url_info, $matches, $anchor_info, $id_tag, $title_tag, $do_prefix, $object_type );
}
//

// Misc Functions
function nuseo_phpfox_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config;
	
	if ( empty( $module['config_files_loaded'] ) )
	{
		nuseo_phpfox_load_config_files();
	}
	
	if ( !empty( $module['config_files_loaded'] ) )
	{
		// read DB connection vars
		$server_name			= $module['sett.db.host'];
		$server_port			= 3306;
		$db_username			= $module['sett.db.user'];
		$db_password			= $module['sett.db.pass'];
		
		$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
											$db_username, $db_password, $module['db_name'] );

		// do not store username/password in memory
		unset( $server_name, $server_port, $db_username, $db_password, 
					$module['sett.db.host'], $module['sett.db.user'], $module['sett.db.pass']);
	}
	else
		$module['db_conn']		= false;
}

function nuseo_phpfox_load_config_files( &$module )
{
	global $nuseo, $nuseo_config;
	
	if ( empty( $module['config_files_loaded'] ) )
	{
		$phpfox_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'include/settings/server.sett.php';
		if (file_exists( $phpfox_config_filename ))
		{
			include $phpfox_config_filename;
		
			$phpfox_common_filename = $nuseo['base_dir'] . $module['url_base'] . 'include/settings/common.sett.php';
			if (file_exists( $phpfox_common_filename ))
			{
				include $phpfox_common_filename;
			}

			global $_CONF;
			// read DB connection vars
			$module['sett.db.host']	= $_CONF['db']['host'];
			$module['sett.db.port']	= 3306;
			$module['sett.db.user']	= $_CONF['db']['user'];
			$module['sett.db.pass']	= $_CONF['db']['pass'];

			$module['db_name']		= $_CONF['db']['name'];
			$module['table_prefix']	= isset( $_CONF['db']['prefix'] ) ? $_CONF['db']['prefix'] : '';
			
			// phpfox rewrite settings
			$module['phpfox_rewrite_engine']	= $_CONF['rewrite_engine'];
			$module['phpfox_path_translated']	= $_CONF['path_translated'];
			
			// areas and reserved names
			$module['app.areas']			= (!empty( $_CONF['app.areas'] )) ? $_CONF['app.areas'] : array();
			$module['url.reserved_names']	= (!empty( $_CONF['url.reserved_names'] )) ? $_CONF['url.reserved_names'] : array();

			// Load cache fetch information
			$module[ 'cache_gallery_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'text',
						'description_name'	=> '',
						'table_name'		=> 'main', 
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "main` main" );
	                    
			$module[ 'cache_user_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'user',
						'description_name'	=> 'me',
						'table_name'		=> 'user', 
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "user` user" );
	                    
			$module[ 'cache_blog_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'text',
						'table_name'		=> 'journal', 
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "journal` journal" );
						
			$module[ 'cache_forum_info' ] = array( 
						'id_name'			=> 'forum_id',
						'title_name'		=> 'forum_title',
						'description_name'	=> 'forum_info',
						'table_name'		=> 'forum', 
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "forum` forum" );

			$module[ 'cache_topic_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'text',
						'table_name'		=> 'topic', 
						'sql_by_id'			=> "SELECT topic.*, forum.forum_title AS forum_title, forum.forum_id AS forum_id
													FROM `" . $module['table_prefix'] . "forum_topic` topic
													LEFT OUTER JOIN `" . $module['table_prefix'] . "forum` forum
														ON forum.forum_id = topic.type" );

			$module[ 'cache_event_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'short',
						'table_name'		=> 'events',
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "events` events" );
	                    
			$module[ 'cache_poll_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> '',
						'table_name'		=> 'polls',
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "polls` polls" );                    
	                    
			$module[ 'cache_listing_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'text',
						'table_name'		=> 'listing_main',
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "listing_main` listing_main" );

			$module[ 'cache_group_category_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'name',
						'description_name'	=> '',
						'table_name'		=> 'group_category',
						'sql_by_id'			=> "SELECT * FROM `" . $module['table_prefix'] . "group_name` group_category" );

			$module[ 'cache_group_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'headline',
						'table_name'		=> 'group_table',
						'sql_by_id'			=> "SELECT group_table.*, group_category.name AS category_title
													FROM `" . $module['table_prefix'] . "group_main` group_table
													LEFT OUTER JOIN `" . $module['table_prefix'] . "group_name` group_category
														ON group_table.type = group_category.id" );

			$module[ 'cache_group_forum_info' ] = array( 
						'id_name'			=> 'id',
						'title_name'		=> 'title',
						'description_name'	=> 'text',
						'table_name'		=> 'group_forum_table',
						'sql_by_id'			=> "SELECT group_forum_table.*, group_table.title AS group_title, 
														group_table.type AS category_id, group_category.name AS category_title
													FROM `" . $module['table_prefix'] . "group_forum` group_forum_table
													LEFT OUTER JOIN `" . $module['table_prefix'] . "group_main` group_table
														ON group_forum_table.group_id = group_table.id
													LEFT OUTER JOIN `" . $module['table_prefix'] . "group_name` group_category
														ON group_table.type = group_category.id" );

			$module['config_files_loaded'] = true;
		}	
	}
}

function nuseo_phpfox_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	

	$url_formats_defs = array(
        
		'gallery'			=> $nuseo_config[ 'phpfox_gallery_format' ],

		'user'				=> $nuseo_config[ 'phpfox_user_format' ],
		'user_gallery'		=> $nuseo_config[ 'phpfox_user_gallery_format' ],
		'user_blogs'		=> $nuseo_config[ 'phpfox_user_blogs_format' ],
		'user_guestbook'	=> $nuseo_config[ 'phpfox_user_guestbook_format' ],
		'user_friends'		=> $nuseo_config[ 'phpfox_user_friends_format' ],
		'user_favorites'	=> $nuseo_config[ 'phpfox_user_favorites_format' ],

		'blog'				=> $nuseo_config[ 'phpfox_blog_format' ],

		'forum'				=> $nuseo_config[ 'phpfox_forum_format' ],
		'topic'				=> $nuseo_config[ 'phpfox_topic_format' ],

		'poll'				=> $nuseo_config[ 'phpfox_poll_format' ],

		'group_category'	=> $nuseo_config[ 'phpfox_group_category_format' ],
		'group'				=> $nuseo_config[ 'phpfox_group_format' ],
		'group_forum'		=> $nuseo_config[ 'phpfox_group_forum_format' ],
		'group_topic'		=> $nuseo_config[ 'phpfox_group_topic_format' ],
		'group_posts'		=> $nuseo_config[ 'phpfox_group_posts_format' ],
		'group_members'		=> $nuseo_config[ 'phpfox_group_members_format' ],
		'group_gallery'		=> $nuseo_config[ 'phpfox_group_gallery_format' ],

		'listing'			=> $nuseo_config[ 'phpfox_listing_format' ],

		//'quiz'				=> $nuseo_config[ 'phpfox_quiz_format' ],
        
		'event'				=> $nuseo_config[ 'phpfox_event_format' ],
	);

	$id_keywords = array(	'#\[(user_id)\]#',		'#\[(blog_id)\]#',		'#\[(forum_id)\]#',		'#\[(topic_id)\]#',		
							'#\[(poll_id)\]#',		'#\[(group_id)\]#',		'#\[(listing_id)\]#',	'#\[(quiz_id)\]#',		
							'#\[(event_id)\]#' );

	$extra_do_pattern = '(?P<do>[\w\\' .  $nuseo_config[ 'separator' ] . '/]+)?';

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		
		if ( (strpos( $key, 'user' ) === 0) || (strpos( $key, 'group' ) === 0) )
		{	// then this is a user or a group format, allow for additional do at the end.

			$user_format_str = $format_str;

			if (substr( $user_format_str, -1, 1 ) == '/')
			{
				$user_format_str .= '?';
			}

			$user_format_str .= $extra_do_pattern;

			$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $user_format_str, $id_keywords ); 
		}
		else
		{
			$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
		}
	}
}

function nuseo_phpfox_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> 'index\.php', 
						'translate_to_sef'		=> 'nuseo_phpfox_index_to_sef' );

    // Gallery
	if ($nuseo_config[ 'phpfox_rewrite_gallery_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['gallery_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_gallery'
					);
	}
    
    // Blog
	if ($nuseo_config[ 'phpfox_rewrite_blog_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['blog_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_blog'
					);
	}

    // Events
	if ($nuseo_config[ 'phpfox_rewrite_event_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['event_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_event'
					);
	}    
	
    // Forums
	if ($nuseo_config[ 'phpfox_rewrite_forum_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['forum_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_forum'
					);

		$rules[] = array(	'sef_pattern'			=> $module['topic_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_topic'
					);
	}

    // Polls
	if ($nuseo_config[ 'phpfox_rewrite_poll_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['poll_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_poll'
					);
	}

    // Groups
	if ($nuseo_config[ 'phpfox_rewrite_group_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['group_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group'
					);

		$rules[] = array(	'sef_pattern'			=> $module['group_topic_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_topic'
					);

		$rules[] = array(	'sef_pattern'			=> $module['group_posts_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_posts'
					);

		// must be after posts and topics
		$rules[] = array(	'sef_pattern'			=> $module['group_forum_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_forum'
					);


		$rules[] = array(	'sef_pattern'			=> $module['group_members_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_members'
					);

		$rules[] = array(	'sef_pattern'			=> $module['group_gallery_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_gallery'
					);

		// do this last.					
		$rules[] = array(	'sef_pattern'			=> $module['group_category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_group_category'
					);
	}

    // Listing URLs
	if ($nuseo_config[ 'phpfox_rewrite_listing_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['listing_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_listing'
					);
	}

    // Quizes
	//if ($nuseo_config[ 'phpfox_rewrite_quiz_urls' ])
	//{
	//}

	// Important: Process users last, in case the user_url_format is [user_name]/  (i.e. no prefix)
	// User
	if ($nuseo_config[ 'phpfox_rewrite_user_urls' ])
	{
		// User Sections rewrite rules
		$user_sections = array( "gallery", "blogs", "guestbook", "friends", "favorites" );
		foreach( $user_sections as $section )
		{
			if ($nuseo_config[ "phpfox_rewrite_user_{$section}_urls" ])
			{
				$rules[] = array(	'sef_pattern'			=> $module[ "user_{$section}_sef_pattern" ],
									'translate_to_non_sef'	=> "nuseo_phpfox_sef_to_user_{$section}"
							);
			}
		}

		// Users must be processed after user sections
		$rules[] = array(	'sef_pattern'			=> $module['user_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_phpfox_sef_to_user'
					);
	}

	$module['rules'] = $rules;
}

function nuseo_phpfox_split_params( &$do_parts )
{
	global $nuseo, $nuseo_config;

	$do_params = array();

	foreach ($do_parts as $part)
	{
        $first_underscore = strpos( $part, "_", 0 );
        
		if ($first_underscore)
		{
			$key = substr( $part, 0, $first_underscore );
			$value = substr( $part, $first_underscore + 1 );
		}
		else
		{
			$key = $part;
			$value = '';
		}
        
		if (!empty( $key ))
		{
			$do_params[ $key ] = $value;
		}
	}

	return $do_params;
}

function phpfox_populate_meta_tags( &$module, $id, $title, &$object, $object_type, $description_format, $keywords_format )
{
	global $nuseo, $nuseo_config;

	if ( $nuseo_config['phpfox_replace_keywords'] || $nuseo_config['phpfox_replace_description'])
	{
		// Connect to DB if needed
		if (!$module['db_conn'])
		{
			$db_conn = nuseo_get_db_connection( $module );
		}

		$object_cache_info_key = "cache_{$object_type}_info";

		if ( isset( $module[ $object_cache_info_key ] ) )
		{
			$id_name			= isset( $module[ $object_cache_info_key ][ 'id_name' ] ) ? $module[ $object_cache_info_key ][ 'id_name' ] : false;
			$title_name			= isset( $module[ $object_cache_info_key ][ 'title_name' ] ) ? $module[ $object_cache_info_key ][ 'title_name' ] : false;
			$description_name	= isset( $module[ $object_cache_info_key ][ 'description_name' ] ) ? $module[ $object_cache_info_key ][ 'description_name' ] : false;
		}
		else
		{
			$id_name			= false;
			$title_name			= false;
			$description_name	= false;
		}

		if (!$object)
		{
			if ($id)
			{
				$object = nuseo_cache_fetch( $module, $object_type, $id );
			}
			
			if (!$object && $title)
			{
				$object = nuseo_cache_fetch_by_title( $module, $object_type, $title );
			}
		}

		if ($object)
		{
			$description_format	= str_replace('[]', '', $description_format ); 
			$keywords_format	= str_replace('[]', '', $keywords_format ); 
			
			$description_format	= nuseo_convert_format_vars( $description_format ); 
			$keywords_format	= nuseo_convert_format_vars( $keywords_format ); 

			$info =& $object;
			eval( '$description_tag = "' . $description_format . '";' );
			eval( '$keywords_tag = "' . $keywords_format . '";' );

			if ($description_tag || $keywords_tag)
			{
				$seo_items = array();
				$seo_items[ $object_type ] = array();
				$seo_items[ $object_type ]['keywords']		= strip_tags( $keywords_tag );
				$seo_items[ $object_type ]['description']	= strip_tags( $description_tag );
				
				if ( $nuseo_config['phpfox_max_description_length'] > 0)
				{
					$nuseo['meta_description_length'] = $nuseo_config['phpfox_max_description_length'];
				}

				nuseo_set_seo_content( $seo_items, array( 'do_keywords'		=> $nuseo_config[ 'phpfox_replace_keywords' ],
														'do_descriptions'	=> $nuseo_config[ 'phpfox_replace_description' ] ) );
			} // if ($description_tag || $keywords_tag)
		} // if $object
	} // if meta tags enabled.
}
//