<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

define( 'NUSEO_PHOTOPOST_MEMBER_GALLERY_ID', 500 );

// Initialization
// Initialize module
function nuseo_photopost_load( &$module )
{
	global $nuseo, $nuseo_config;

	$GLOBALS['nuseo_photopost'] =& $module;		// use GLOBALS to assign reference in global scope.

	$module['global_parser'] = true;

	// set url base
	$module['url_base']			= $nuseo_config[ 'photopost_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'photopost_domain' ];
}

function nuseo_photopost_init_rules( &$module )
{
	// initialize cache
	nuseo_cache_init( $module, array( 'categories', 'photos', 'users' ) );

	// pre-process URL formats
	nuseo_photopost_load_url_formats( $module );
	
	// populate module rules
	nuseo_photopost_load_rewrite_rules( $module );
}

function nuseo_photopost_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
		'category'				=> $nuseo_config[ 'photopost_category_format' ],
		'photo'					=> $nuseo_config[ 'photopost_photo_format' ],
		'gallery_list'			=> $nuseo_config[ 'photopost_gallery_list_format' ],
		'gallery_list_letter'	=> $nuseo_config[ 'photopost_gallery_list_letter_format' ],
		'member_gallery'		=> $nuseo_config[ 'photopost_member_gallery_format' ],
		'member'				=> $nuseo_config[ 'photopost_member_format' ],
		'album_index'			=> $nuseo_config[ 'photopost_album_index_format' ],
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(photo_id)\]#',	'#\[(user_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_photopost_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	if ($nuseo_config[ 'photopost_rewrite_category_urls' ])
	{
		// showgallery.php?cat=501 => sef
		$rules[] = array(	'non_sef_pattern'		=> 'showgallery\.php', 
							'translate_to_sef'		=> 'nuseo_photopost_showgallery_to_sef',

							'sef_pattern'			=> $module['category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_showgallery'
						);
	}

	if ($nuseo_config[ 'photopost_rewrite_photo_urls' ])
	{
		// showphoto.php?photo=2 => sef
		$rules[] = array(	'non_sef_pattern'		=> 'showphoto\.php', 
							'translate_to_sef'		=> 'nuseo_photopost_showphoto_to_sef',

							'sef_pattern'			=> $module['photo_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_showphoto'
						);
	}

	if ($nuseo_config[ 'photopost_rewrite_member_galleries_urls' ])
	{
		// showgallery.php?cat=xxx&ppuser=xxx			(Photopost mixed urls here, we just follow suit)
		$rules[] = array(	'sef_pattern'			=> $module['member_gallery_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_showgallery_member'
				);
		// showmembers.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'showmembers\.php', 
							'translate_to_sef'		=> 'nuseo_photopost_showmembers_to_sef',
				
							'sef_pattern'			=> $module['gallery_list_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_showmembers'
				);
		$rules[] = array(	'sef_pattern'			=> $module['gallery_list_letter_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_showmembers'
				);

	}
	
	if ($nuseo_config[ 'photopost_rewrite_member_urls' ])
	{
		// member.php => sef
		$rules[] = array(	'non_sef_pattern'		=> 'member\.php', 
							'translate_to_sef'		=> 'nuseo_photopost_member_to_sef',
				
							'sef_pattern'			=> $module['member_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photopost_sef_to_member'
				);
	}

	if ($nuseo_config[ 'photopost_rewrite_album_index_url' ])
	{
		// misc.php?action=showalbums => album-index/
		$rules[ 'misc.php?action=showalbums' ] = $module['album_index_url_format'];
	}
	$module['rules'] = $rules;
}
//

// showgallery.php
function nuseo_photopost_showgallery_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$category_id = isset( $query_params['cat'] ) ? intval( $query_params['cat'] ) : 0;
	$user_id = isset( $query_params['ppuser'] ) ? intval( $query_params['ppuser'] ) : 0;
	
	if (!$category_id)
		return false;

	$category = nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_photopost_fetch_category' );
	if (!$category)
	{
		if ($nuseo['prefetch'])
			return true;				// we are in prefetch mode, we'll be back later
		else
			return false;				// else, we didn't find the category, fail.
	}
		
	if ($user_id)
	{
		//$user = nuseo_cache_fetch( $module, 'users', $user_id, 'nuseo_photopost_fetch_user' );
		$user = nuseo_photopost_user_cache_fetch( $module, $user_id );
		if (!$user && !$nuseo['prefetch'])
			return true;				// prefetching... we'll be back later.
	}
	else
		$user = false;

	// add thread information
	$info = array();
	$info['category_id']		= $category_id;
	$info['category_title']		= nuseo_str_to_url( $category['catname'] );
	$info['user_id']			= $user_id;
	$info['user_name']			= $user ? nuseo_str_to_url( $user['username'] ) : '';

	if (($category_id == NUSEO_PHOTOPOST_MEMBER_GALLERY_ID) && $user_id)
	{	// then showing a member's gallery
		$url_format = $module['member_gallery_url_format'];
		unset( $query_params['ppuser'] );
	}
	else
	{
		$url_format = $module['category_url_format'];
	}
	
	if (!$user_id && isset( $query_params['ppuser'] ))
		unset( $query_params['ppuser'] );

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['cat'] );
	
	return $sef_url;
}

function nuseo_photopost_sef_to_showgallery( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$user_id		= isset( $matches['user_id']		) ? $matches['user_id']			: false;
	
	if (!$category_id && $category_title)
	{	// get category_id from category_title
		$category = nuseo_cache_fetch_by_title( $module, 'categories', $category_title, 'nuseo_photopost_fetch_category_by_title' );
		if ($category)
        {
			$category_id = $category['id'];
        }
	}

	if ($category_id)
	{
		$query_params['cat'] = $category_id;
	}

	if ($user_id)
	{
		$query_params['ppuser'] = $user_id;
	}
    
    //seo items
    if ( $nuseo_config['photopost_replace_keywords'] || $nuseo_config['photopost_replace_description'])
    {
        $seo_items = array ();
        
        if ( $category_id )
        {
            if ( !isset( $category ) || !$category )
            {
                $category = nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_photopost_fetch_category' );
            }
                        
            $seo_items['category'] = array();
            $seo_items['category']['keywords'] = $category['catname'];
            $seo_items['category']['description'] = $category['catname'] . " - " . $category['description'];
        }
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'photopost_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'photopost_replace_description' ] ) );
        }        
    }
    
    
    
    
    //set the script
	if ( !$user_id && ($category_id == NUSEO_PHOTOPOST_MEMBER_GALLERY_ID || $category_id == MOBILE_CAT) )
    {
		$non_sef_url = "showmembers.php";
    }
	else
    {
		$non_sef_url = "showgallery.php";
    }
    
	return $non_sef_url;
}

function nuseo_photopost_sef_to_showgallery_member( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	$matches['category_id'] = NUSEO_PHOTOPOST_MEMBER_GALLERY_ID;
	return nuseo_photopost_sef_to_showgallery( $module, $url, $url_info, $matches, $anchor_info  );
}
//

// showphoto.php
function nuseo_photopost_showphoto_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$photo_id = isset( $query_params['photo'] ) ? intval( $query_params['photo'] ) : 0;

	if (!$photo_id)
		return false;

	//$thread = nuseo_vbulletin_fetch_thread( $module, $threadid );
	$photo = nuseo_cache_fetch( $module, 'photos', $photo_id, 'nuseo_photopost_fetch_photo' );
	
	if (!$photo)
	{
		if ($nuseo['prefetch'])
			return true;				// we are in prefetch mode, we'll be back later
		else
			return false;				// else, we didn't find the photo, fail.
	}

	// add thread information
	$info['photo_id']		= $photo_id;
	$info['photo_title']	= nuseo_str_to_url( $photo['title'] );
	$info['photo_user']		= nuseo_str_to_url( $photo['user'] );
	$info['category_id']	= $photo['cat'];
	$info['category_title']	= nuseo_str_to_url( $photo['catname'] );

	{
		$url_format = $module['photo_url_format'];
	}

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['photo'] );
	unset( $query_params['cat'] );
	
	return $sef_url;
}

function nuseo_photopost_sef_to_showphoto( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!$nuseo_config[ 'photopost_rewrite_photo_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$photo_id		= isset( $matches['photo_id']	) ? $matches['photo_id']		: false;
	$photo_title	= isset( $matches['photo_title']	) ? $matches['photo_title']	: false;

	if (!$photo_id && $photo_title)
	{	// get $photo_id from category_title
		$photo = nuseo_cache_fetch_by_title( $module, 'photos', $photo_title, 'nuseo_photopost_fetch_photo_by_title' );
		if ($photo)
			$photo_id = $photo['id'];
	}

	if (!$photo_id)
		return false;
	
	$query_params['photo'] = $photo_id;
    
    //seo items
    if ( $nuseo_config['photopost_replace_keywords'] || $nuseo_config['photopost_replace_description'])
    {
        $seo_items = array();
        
        if ( $photo_id )
        {
            if ( !isset( $photo ) || !$photo )
            {
                $photo = nuseo_cache_fetch( $module, 'photos', $photo_id, 'nuseo_photopost_fetch_photo' );
            }
                        
            $seo_items['photo'] = array();
            $seo_items['photo']['keywords'] = $photo['keywords'] . "," . $photo['title'] . "," . $photo['description'];
            $seo_items['photo']['description'] = $photo['title'] . " - " . $photo['description'];
        }
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'photopost_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'photopost_replace_description' ] ) );
        }        
    }    
	
	$non_sef_url = "showphoto.php";
	return $non_sef_url;
}
//

// showmembers.php
function nuseo_photopost_showmembers_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;
	
	if (!$module)
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];
	
	$cat_id = isset( $query_params['cat'] ) ? intval( $query_params['cat'] ) : 0;
	$letter = isset( $query_params['sl'] ) ? htmlentities( $query_params['sl'] ) : '';	
	
	if ($letter)
	{
		$url_format = $module['gallery_list_letter_url_format'];
		unset( $query_params['sl'] );
	}
	else if (!$cat_id || ($cat_id == NUSEO_PHOTOPOST_MEMBER_GALLERY_ID))
	{
		$url_format = $module['gallery_list_url_format'];
		unset( $query_params['cat'] );
	}
	else
		return false;

	$info = array();
	
	$info['letter']	= $letter;
	
	eval( '$sef_url = "' . $url_format . '";' );
	
	return $sef_url;
}

function nuseo_photopost_sef_to_showmembers( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
	
	if (!$nuseo_config[ 'photopost_rewrite_photo_urls' ])
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];
	
	$letter		= isset( $matches['letter']	) ? $matches['letter']		: false;
	
	if ($letter)
		$query_params['sl'] = $letter;

	$nuseo['use_ob_callback'] = true;			// member.php aborts execution

	$non_sef_url = "showmembers.php";
	return $non_sef_url;
}
//

// member.php
function nuseo_photopost_member_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;
	
	if (!$module)
		return false;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];
	
	$user_id = isset( $query_params['uid'] ) ? intval( $query_params['uid'] ) : 0;
	
	if (!$user_id)
		return false;
		
	//$user = nuseo_cache_fetch( $module, 'users', $user_id, 'nuseo_photopost_fetch_user' );
	$user = nuseo_photopost_user_cache_fetch( $module, $user_id );
	if (!$user)
	{
		if ($nuseo['prefetch'])
			return true;				// we are in prefetch mode, we'll be back later
		else
			return false;				// else, we didn't find the user, fail.
	}
	

	{
		$url_format = $module['member_url_format'];
		unset( $query_params['uid'] );
	}

	$info = array();
	
	$info['user_id']	= $user_id;
	$info['user_name']	= nuseo_str_to_url( $user['username'] );
	
	eval( '$sef_url = "' . $url_format . '";' );

	return $sef_url;
}

function nuseo_photopost_sef_to_member( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
	
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];
	
	$user_id		= isset( $matches['user_id']		) ? $matches['user_id']			: false;
	$user_name		= isset( $matches['user_name']		) ? $matches['user_name']		: false;

	if (!$user_id && $user_name)
	{	// get $photo_id from category_title
		$user = nuseo_cache_fetch_by_title( $module, 'users', $user_name, 'nuseo_photopost_fetch_user_by_title' );
		if ($user)
			$user_id = $user['userid'];
	}
	
	$query_params['uid'] = $user_id;	
	
	$nuseo['use_ob_callback'] = true;			// member.php aborts execution
	
	$non_sef_url = "member.php";
	return $non_sef_url;
}
//

// Database Connectivity
function nuseo_photopost_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config;
	
	$module['use_vb3_integration'] = false;
	
	$photopost_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'config-inc.php';
	if (file_exists( $photopost_config_filename ))
	{
		$skip_exheader = true;
		$error_level = error_reporting( E_ALL ^ E_NOTICE );
		include $photopost_config_filename;
		error_reporting( $error_level );
		
		// read DB connection vars
		$server_name			= $host;
		$server_port			= 3306;
		$db_username			= $mysql_user;			
		$db_password			= $mysql_password;
		$module['db_name']		= $database;
		$module['table_prefix']	= $pp_db_prefix;
		
		$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
											$db_username, $db_password, $module['db_name'] );
											
		// do not store username/password in memory
		unset( $server_name, $server_port, $db_username, $db_password );
	}
	else
		$module['db_conn']		= false;
		
	// Now see if we are integrated into vBulletin.
	$photopost_config_int_filename = $nuseo['base_dir'] . $module['url_base'] . 'config-int.php';
	if (file_exists( $photopost_config_int_filename ))
	{
		$skip_exheader = true;
		$error_level = error_reporting( E_ALL ^ E_NOTICE );
		include $photopost_config_int_filename;
		error_reporting( $error_level );
		
		if (defined('VB3_INTEGRATION') && isset($vbpath))
		{
			$vbulletin_config_filename = $vbpath . "/includes/config.php";

			if (file_exists( $vbulletin_config_filename ))
			{
				include $vbulletin_config_filename;
				
				// read DB connection vars
				$vb_server_name			= $config['MasterServer']['servername'];
				$vb_server_port			= $config['MasterServer']['port'];
				$vb_db_username			= $config['MasterServer']['username'];
				$vb_db_password			= $config['MasterServer']['password'];
				$vb_db_name				= $config['Database']['dbname'];
				$vb_table_prefix		= $config['Database']['tableprefix'];
				
				$module['user_db_conn'] = nuseo_connect_to_db( $vb_server_name, $vb_server_port, 
													$vb_db_username, $vb_db_password, $vb_db_name );

				// use vBulletin users table.
				$module['user_table_name'] = $vb_table_prefix . 'user';
				
				$module['use_vb3_integration'] = true;

				// do not store username/password in memory
				unset( $vb_server_name, $svb_erver_port, $vb_db_username, $vb_db_password, $vb_db_name, $vb_table_prefix );
			}			
		}
 	}
	
	if (!isset( $module['user_db_conn'] ))
	{
		if ($module['db_conn'])
		{
			$module['user_db_conn'] =& $module['db_conn'];
			$module['user_table_name'] = $module['table_prefix'] . 'users';
		}
		else
			$module['user_db_conn'] = false;
	}
}

function nuseo_photopost_user_cache_fetch( &$module, $user_id )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	if ( !empty( $nuseo_vbulletin ) && !empty( $nuseo_config['photopost_enable_vb3_integration'] ) )
	{	// then use vBulletin's user cache
		$user = nuseo_cache_fetch( $nuseo_vbulletin, 'user', $user_id );
	}
	else
	{
		$user = nuseo_cache_fetch( $module, 'users', $user_id, 'nuseo_photopost_fetch_user' );
	}
	return $user;
}

function nuseo_photopost_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'id';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "categories` category";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_photopost_fetch_photo( &$module, $cache_type, $photo_id )
{
	$table_name = 'photo';

	$id_field_name = 'id';

	$sql = "SELECT photo.*, category.catname FROM `" . $module['table_prefix'] . "photos` photo
				LEFT OUTER JOIN `" . $module['table_prefix'] . "categories` category ON category.id = photo.cat";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $photo_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_photopost_fetch_user( &$module, $cache_type, $user_id )
{
	$table_name = 'user';

	$id_field_name = 'userid';

	$sql = "SELECT * FROM `" . $module['user_table_name'] . "` user";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $user_id, $sql, $table_name, $id_field_name, $additional_where, $limit, 'user_db_conn' );
}

function nuseo_photopost_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category';

	$title_field_name = 'catname';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "categories` category";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_photopost_fetch_photo_by_title( &$module, $cache_type, $photo_title )
{
	$table_name = 'photo';

	$title_field_name = 'title';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "photos` photo";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $photo_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_photopost_fetch_user_by_title( &$module, $cache_type, $user_title )
{
	$table_name = 'user';

	$title_field_name = 'username';

	$sql = "SELECT * FROM `" . $module['user_table_name'] . "` user";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $user_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit, 'user_db_conn' );
}
//