<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_photoplog_load( &$module )
{
	global $nuseo, $nuseo_config;

	$GLOBALS['nuseo_photoplog'] =& $module;		// use GLOBALS to assign reference in global scope.

	$module['global_parser'] = false;			// taken care of by vBulletin Plugins

	// set url base
	$module['url_base']			= $nuseo_config[ 'photoplog_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'photoplog_domain' ];
}

function nuseo_photoplog_init_rules( &$module )
{
	// initialize cache
	nuseo_cache_init( $module, array( 'categories', 'photos', 'user' ) );

	// pre-process URL formats
	nuseo_photoplog_load_url_formats( $module );
	
	// populate module rules
	nuseo_photoplog_load_rewrite_rules( $module );
}

function nuseo_photoplog_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;
	
	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
	else
		$script_name = $rel_url;

	$my_scripts = array(	'index.php', 'file.php' );
	
	if (in_array( $script_name, $my_scripts ))
	{
		$nuseo['global_parser'] = false;
	}
}

function nuseo_photoplog_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
        //'home'				    => $nuseo_config[ 'photoplog_home_format' ],
		'category'				=> $nuseo_config[ 'photoplog_category_format' ],
		'photo'					=> $nuseo_config[ 'photoplog_photo_format' ],
		'gallery_list_letter'	=> $nuseo_config[ 'photoplog_gallery_list_letter_format' ],
		'member_gallery'		=> $nuseo_config[ 'photoplog_member_gallery_format' ],
		//'file'					=> $nuseo_config[ 'photoplog_file_format' ]
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(photo_id)\]#',	'#\[(user_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_photoplog_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> 'index\.php', 
						'translate_to_sef'		=> 'nuseo_photoplog_index_to_sef' );
                        
                        
/*	if ($nuseo_config[ 'photoplog_rewrite_home_url' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['home_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_index'
						);
	}                          
*/						
	if ($nuseo_config[ 'photoplog_rewrite_category_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_index'
					);
	}

	if ($nuseo_config[ 'photoplog_rewrite_photo_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['photo_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_index'
						);

//		Disabled, requires processing of IMG tags...
//		$rules[] = array(	'non_sef_pattern'		=> 'file\.php', 
//							'translate_to_sef'		=> 'nuseo_photoplog_file_to_sef',
//							'sef_pattern'			=> $module['file_sef_pattern'],
//							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_file'
//				);
	}

	if ($nuseo_config[ 'photoplog_rewrite_member_galleries_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['member_gallery_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_index'
				);
		$rules[] = array(	'sef_pattern'			=> $module['gallery_list_letter_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_photoplog_sef_to_index'
				);
	}
	
	$module['rules'] = $rules;
}
//

// index.php
function nuseo_photoplog_index_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	if (!$module)
    {
		return false;
    }
		
	//if (!isset( $url_info['query_params'] ))
	//	return false;
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $query_params['c'] ) ? intval( $query_params['c'] ) : 0;
	$photo_id		= isset( $query_params['n'] ) ? intval( $query_params['n'] ) : 0;
	$user_id		= isset( $query_params['u'] ) ? intval( $query_params['u'] ) : 0;
	$letter			= isset( $query_params['q'] ) ? $query_params['q'] : false;

	$url_format		= false;
	
	$photo		= false;
	$category	= false;
	$user		= false;

	if ($photo_id)
	{
		if (!$nuseo_config['photoplog_rewrite_photo_urls'])
			return false;

		$photo = nuseo_cache_fetch( $module, 'photos', $photo_id, 'nuseo_photoplog_fetch_photo' );
		if (!$photo)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the photo, fail.
		}
		
		$url_format = $module['photo_url_format'];
		unset( $query_params['n'] );
		
		if (!$category_id)
		{
			$category_id = $photo['catid'];
			$category = array( 'catid' => $category_id, 'title' => $photo['category_title'] );
			nuseo_cache_add( $module, 'categories', $category_id, $category );
		}

		if (!$user_id)
		{
			$user_id = $photo['userid'];
			$user = array( 'userid' => $user_id, 'username' => $photo['username'] );
			if (!empty( $nuseo_vbulletin ))
			{
				nuseo_cache_add( $nuseo_vbulletin, 'user', $user_id, $user );
			}
			else
			{
				nuseo_cache_add( $module, 'user', $user_id, $user );
			}
		}
	}
	
	if ($category_id)
	{
		if (!$photo && !$nuseo_config['photoplog_rewrite_category_urls'])
			return false;		// category rewrite is disabled.

		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_photoplog_fetch_category' );
			if (!$category)
			{
				if ($nuseo['prefetch'])
					return true;				// we are in prefetch mode, we'll be back later
				else
					return false;				// else, we didn't find the category, fail.
			}
		}
		
		if (!$photo)
		{
			$url_format = $module['category_url_format'];
			unset( $query_params['c'] );
		}
	}

	if ($user_id)
	{
		if (!$photo && !$category && !$nuseo_config['photoplog_rewrite_member_galleries_urls'])
			return false;		// member_galleries rewrite is disabled.

		if (!$user)
		{
			if (!empty( $nuseo_vbulletin ))
			{
				$user = nuseo_cache_fetch( $nuseo_vbulletin, 'user', $user_id );
			}
			else
			{
				$user = nuseo_cache_fetch( $module, 'user', $user_id, 'nuseo_photoplog_fetch_user' );
			}
			if (!$user)
			{
				if ($nuseo['prefetch'])
					return true;				// prefetching... we'll be back later.
				else
					return false;				// couldn't find user, fail.
			}
		}

		if (!$photo && !$category)
		{
			$url_format = $module['member_gallery_url_format'];
			unset( $query_params['u'] );
		}
	}
		
	if (!$url_format && $letter)
	{
		$url_format = $module['gallery_list_letter_url_format'];
		unset( $query_params['q'] );
	}
	
	if (!$url_format)
    {
/*        //could it be home?
        if ( $nuseo_config['photoplog_rewrite_home_url'] )
        {
            $url_format = $nuseo_config['photoplog_home_format'];
        }
        else
*/
        {
		    return false;
        }
    }

	// add thread information
	$info = array();
	$info['category_id']		= $category_id;
	$info['category_title']		= $category ? nuseo_str_to_url( $category['title'] ) : '';
	$info['photo_id']			= $photo_id;
	$info['photo_title']		= $photo ? nuseo_str_to_url( $photo['title'] ) : '';
	$info['user_id']			= $user_id;
	$info['user_name']			= $user ? nuseo_str_to_url( $user['username'] ) : '';
	$info['letter']				= $letter;

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['cat'] );
	
	return $sef_url;
}

function nuseo_photoplog_sef_to_index( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$photo_id		= isset( $matches['photo_id']		) ? $matches['photo_id']		: false;
	$photo_title	= isset( $matches['photo_title']	) ? $matches['photo_title']		: false;
	$user_id		= isset( $matches['user_id']		) ? $matches['user_id']			: false;
	$user_name		= isset( $matches['user_name']		) ? $matches['user_name']		: false;
	$letter			= isset( $matches['letter']			) ? $matches['letter']			: false;

	if (!$category_id && $category_title)
	{	
        // get category_id from category_title
		$category = nuseo_cache_fetch_by_title( $module, 'categories', $category_title, 'nuseo_photoplog_fetch_category_by_title' );
		if ($category)
        {
			$category_id = $category['catid'];
            
        }
	}

	if (!$photo_id && $photo_title)
	{	
        // get $photo_id from category_title
		$photo = nuseo_cache_fetch_by_title( $module, 'photos', $photo_title, 'nuseo_photoplog_fetch_photo_by_title' );
		if ($photo)
        {
			$photo_id = $photo['fileid'];
        }
	}

	if (!$user_id && $user_name)
	{	
        // get $photo_id from category_title
		$user = nuseo_cache_fetch_by_title( $module, 'user', $user_name, 'nuseo_photoplog_fetch_user_by_title' );
		if ($user)
        {
			$user_id = $user['userid'];
        }
	}

	if ($photo_id)
	{
		$query_params['n'] = $photo_id;
	}
	else if ($category_id)
	{
		$query_params['c'] = $category_id;
	}
	else if ($user_id)
	{
		$query_params['u'] = $user_id;
	}
	else if ($letter)
	{
		$query_params['q'] = $letter;
	}
    else
    {
        //this should be home sef-url
    }

	$non_sef_url = "index.php";
	return $non_sef_url;
}
//

// file.php
function nuseo_photoplog_file_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;

	if (!$module)
		return false;
		
	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $query_params['c'] ) ? intval( $query_params['c'] ) : 0;
	$photo_id		= isset( $query_params['n'] ) ? intval( $query_params['n'] ) : 0;
	$user_id		= isset( $query_params['u'] ) ? intval( $query_params['u'] ) : 0;
	$letter			= isset( $query_params['q'] ) ? $query_params['q'] : false;

	$url_format		= false;
	
	$photo		= false;
	$category	= false;
	$user		= false;

	if ($photo_id)
	{
		if (!$nuseo_config['photoplog_rewrite_photo_urls'])
			return false;

		$photo = nuseo_cache_fetch( $module, 'photos', $photo_id, 'nuseo_photoplog_fetch_photo' );
		if (!$photo)
		{
			if ($nuseo['prefetch'])
				return true;				// we are in prefetch mode, we'll be back later
			else
				return false;				// else, we didn't find the photo, fail.
		}
		
		$url_format = $module['file_url_format'];
		unset( $query_params['n'] );
		
		if (!$category_id)
		{
			$category_id = $photo['catid'];
			$category = array( 'catid' => $category_id, 'title' => $photo['category_title'] );
			nuseo_cache_add( $module, 'categories', $category_id, $category );
		}

		if (!$user_id)
		{
			$user_id = $photo['userid'];
			$user = array( 'userid' => $user_id, 'username' => $photo['username'] );

			if (!empty( $nuseo_vbulletin ))
			{
				nuseo_cache_add( $nuseo_vbulletin, 'user', $user_id, $user );
			}
			else
			{
				nuseo_cache_add( $module, 'user', $user_id, $user );
			}
		}
	}
	
	if ($category_id)
	{
		if (!$photo && !$nuseo_config['photoplog_rewrite_category_urls'])
			return false;		// category rewrite is disabled.

		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_photoplog_fetch_category' );
			if (!$category)
			{
				if ($nuseo['prefetch'])
					return true;				// we are in prefetch mode, we'll be back later
				else
					return false;				// else, we didn't find the category, fail.
			}
		}
	}

	if ($user_id)
	{
		if (!$photo && !$category && !$nuseo_config['photoplog_rewrite_member_galleries_urls'])
			return false;		// member_galleries rewrite is disabled.

		if (!$user)
		{
			if (!empty( $nuseo_vbulletin ))
			{
				nuseo_cache_add( $nuseo_vbulletin, 'user', $user_id, $user );
			}
			else
			{
				$user = nuseo_cache_fetch( $module, 'user', $user_id, 'nuseo_photoplog_fetch_user' );
			}

			if (!$user)
			{
				if ($nuseo['prefetch'])
					return true;				// prefetching... we'll be back later.
				else
					return false;				// couldn't find user, fail.
			}
		}

		if (!$photo && !$category)
		{
			$url_format = $module['member_gallery_url_format'];
			unset( $query_params['u'] );
		}
	}
		
	if (!$url_format)
		return false;

	// add thread information
	$info = array();
	$info['category_id']		= $category_id;
	$info['category_title']		= $category ? nuseo_str_to_url( $category['title'] ) : '';
	$info['photo_id']			= $photo_id;
	$info['photo_title']		= $photo ? nuseo_str_to_url( $photo['title'] ) : '';
	$info['user_id']			= $user_id;
	$info['user_name']			= $user ? nuseo_str_to_url( $user['username'] ) : '';
	$info['letter']				= $letter;

	eval( '$sef_url = "' . $url_format . '";' );

	unset( $query_params['cat'] );

	return $sef_url;
}

function nuseo_photoplog_sef_to_file( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;

	if (!isset( $url_info['query_params'] ))
		return false;
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$photo_id		= isset( $matches['photo_id']		) ? $matches['photo_id']		: false;
	$photo_title	= isset( $matches['photo_title']	) ? $matches['photo_title']		: false;
	$user_id		= isset( $matches['user_id']		) ? $matches['user_id']			: false;
	$user_name		= isset( $matches['user_name']		) ? $matches['user_name']		: false;
	$letter			= isset( $matches['letter']			) ? $matches['letter']			: false;
    
	if (!$category_id && $category_title)
	{	// get category_id from category_title
		$category = nuseo_cache_fetch_by_title( $module, 'categories', $category_title, 'nuseo_photoplog_fetch_category_by_title' );
		if ($category)
			$category_id = $category['catid'];
	}

	if (!$photo_id && $photo_title)
	{	// get $photo_id from category_title
		$photo = nuseo_cache_fetch_by_title( $module, 'photos', $photo_title, 'nuseo_photoplog_fetch_photo_by_title' );
		if ($photo)
			$photo_id = $photo['fileid'];
	}

	if (!$user_id && $user_name)
	{	// get $photo_id from category_title
		$user = nuseo_cache_fetch_by_title( $module, 'user', $user_name, 'nuseo_photoplog_fetch_user_by_title' );
		if ($user)
			$user_id = $user['userid'];
	}
    
    
	if ($photo_id)
	{
		$query_params['n'] = $photo_id;
	}
	else if ($category_id)
	{
		$query_params['c'] = $category_id;
	}
	else if ($user_id)
	{
		$query_params['u'] = $user_id;
	}
	else if ($letter)
	{
		$query_params['q'] = $letter;
	}
    
    
    if ( $nuseo_config['photoplog_replace_keywords'] || $nuseo_config['photoplog_replace_description'])
    {
        $seo_items = array();
        if ($photo_id)
	    {
			if ( !$photo)
			{
				$photo = nuseo_cache_fetch( $module, 'photos', $photo_id, 'nuseo_photoplog_fetch_photo' );
			}
	
            $seo_items['photo'] = array();
            $seo_items['photo']['keywords'] = $photo['title'];
            $seo_items['photo']['description'] = $photo['description'];
	    }
	    if ($category_id)
	    {
			if (!$category)
			{
				$category = nuseo_cache_fetch( $module, 'categories', $category_id, 'nuseo_photoplog_fetch_category' );
			}
						
		    $seo_items['category'] = array();
            $seo_items['category']['keywords'] = $category['title'];
            $seo_items['category']['description'] = $category['description'];
	    }
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'photoplog_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'photoplog_replace_description' ] ) );
        }

        
    }    

	$non_sef_url = "file.php";
	return $non_sef_url;
}
//

// Database Connectivity
function nuseo_photoplog_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config;
	
	$module['db_conn']		= false;
	
	if (!defined('PHOTOPLOG_FWD'))
	{
		$photoplog_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'config.php';
		if (file_exists( $photoplog_config_filename ))
		{
			include $photoplog_config_filename;
		}
	}
	
	if (defined('PHOTOPLOG_FWD'))
	{
		$vbulletin_config_filename = PHOTOPLOG_FWD . '/includes/config.php';
		if (file_exists( $vbulletin_config_filename ))
		{
			$config = array();
			include $vbulletin_config_filename;
			
			// read DB connection vars
			$server_name			= $config['MasterServer']['servername'];
			$server_port			= $config['MasterServer']['port'];
			$db_username			= $config['MasterServer']['username'];
			$db_password			= $config['MasterServer']['password'];
			$module['db_name']		= $config['Database']['dbname'];
			$module['table_prefix']	= $config['Database']['tableprefix'];
			
			$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
												$db_username, $db_password, $module['db_name'] );

			// do not store username/password in memory
			unset( $server_name, $server_port, $db_username, $db_password );
		}
	}
}

function nuseo_photoplog_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'catid';

	$sql = "SELECT * FROM `photoplog_categories` category";

	$additional_where = false;
		
	$limit = false;
	
	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_photoplog_fetch_photo( &$module, $cache_type, $photo_id )
{
	$table_name = 'photo';

	$id_field_name = 'fileid';

	$sql = "SELECT photo.*, category.title AS category_title FROM `photoplog_fileuploads` photo
				LEFT OUTER JOIN `photoplog_categories` category ON category.catid = photo.catid";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $photo_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_photoplog_fetch_user( &$module, $cache_type, $user_id )
{
	$table_name = 'user';

	$id_field_name = 'userid';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "user` user";

	$additional_where = false;
		
	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $user_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}

function nuseo_photoplog_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category';

	$title_field_name = 'title';

	$sql = "SELECT * FROM `photoplog_categories` category";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_photoplog_fetch_photo_by_title( &$module, $cache_type, $photo_title )
{
	$table_name = 'photo';

	$title_field_name = 'title';

	$sql = "SELECT photo.*, category.title AS category_title FROM `photoplog_fileuploads` photo
				LEFT OUTER JOIN `photoplog_categories` category ON category.catid = photo.catid";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $photo_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_photoplog_fetch_user_by_title( &$module, $cache_type, $user_title )
{
	$table_name = 'user';

	$title_field_name = 'username';

	$sql = "SELECT * FROM `" . $module['table_prefix'] . "user` user";

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $user_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}
//