<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO and cannot be called directly.' );

// Initialization
// Initialize module
function nuseo_downloads2_load( &$module )
{
	global $nuseo, $nuseo_config;

	$module['global_parser'] = false;		// taken care of by vBulletin Plugins

	// set url base
	$module['url_base']			= $nuseo_config[ 'downloads2_url_base' ];
	$module['domain_override']	= $nuseo_config[ 'downloads2_domain' ];

	// register this as an extension for vBulletin's module
	nuseo_register_module_extension( $module, 'vbulletin' );
}

function nuseo_downloads2_init_rules( &$module )
{
	// initialize cache
	nuseo_cache_init( $module, array( 'category', 'file' ) );

	// pre-process URL formats
	nuseo_downloads2_load_url_formats( $module );
	
	// populate module rules
	nuseo_downloads2_load_rewrite_rules( $module );
}

function nuseo_downloads2_loading_script( &$module, $rel_url, &$url_info )
{
	global $nuseo, $nuseo_config;
	
	$extension_pos = strpos( $rel_url, '.php' );
	if ($extension_pos)
		$script_name = substr( $rel_url, 0, $extension_pos + 4 );
	else
		$script_name = $rel_url;
	
	if ($script_name == 'downloads.php')
	{
		$nuseo['global_parser'] = false;
	}
}

function nuseo_downloads2_load_url_formats( &$module )
{
	global $nuseo, $nuseo_config;
	$url_formats_defs = array(
        'home'				    => $nuseo_config[ 'downloads2_home_format' ],
		'category'				=> $nuseo_config[ 'downloads2_category_format' ],
		'file'					=> $nuseo_config[ 'downloads2_file_format' ]
	);

	$id_keywords	= array(	'#\[(category_id)\]#',		'#\[(file_id)\]#',	'#\[(user_id)\]#' );

	foreach ( $url_formats_defs as $key => $format_str )
	{
		$module[ $key . '_url_format' ]		= nuseo_convert_format_vars( $format_str ); 
		$module[ $key . '_sef_pattern' ]	= nuseo_get_pattern_from_format( $format_str, $id_keywords ); 
	}
}

function nuseo_downloads2_load_rewrite_rules( &$module )
{
	global $nuseo, $nuseo_config;

	$rules = array();
	
	// index.php => sef
	$rules[] = array(	'non_sef_pattern'		=> "downloads.php",
						'translate_to_sef'		=> 'nuseo_downloads2_downloads_to_sef' );
                        
                        
	if ($nuseo_config[ 'downloads2_rewrite_home_url' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['home_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_downloads2_sef_to_downloads'
						);
	}                        

	if ($nuseo_config[ 'downloads2_rewrite_category_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['category_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_downloads2_sef_to_downloads'
					);
	}

	if ($nuseo_config[ 'downloads2_rewrite_file_urls' ])
	{
		$rules[] = array(	'sef_pattern'			=> $module['file_sef_pattern'],
							'translate_to_non_sef'	=> 'nuseo_downloads2_sef_to_downloads'
						);
	}

	$module['rules'] = $rules;
}
//

// index.php
function nuseo_downloads2_downloads_to_sef( &$module, $url, &$url_info, &$matches, &$anchor_info )
{
	global $nuseo, $nuseo_config;
    
	if (!$module)
    {
		return false;
    }
	/*	
	if (!isset( $url_info['query_params'] ))
    {
		return false;
    }*/
        
	$query_params =& $url_info['query_params'];
    
    //get category and file id
    $do_argument = isset( $query_params['do'] ) ? $query_params['do'] : false;
    $item_id = ( isset( $query_params['id'] ) ) ? $query_params['id'] : false;
    
    $category_id  = ( $do_argument === "cat" ) ? $item_id : false;
    
    $file_id  = ( $do_argument === "file" || 
                  $do_argument === "edit" ||  
                  $do_argument === "manfiles" ) ? $item_id : false;
                
	$url_format		= false;

	$file		= false;
	$category	= false;
	$user		= false;
    
	//sef strings
	$info = array();

	if ( $file_id )
	{
        

		if (!$nuseo_config['downloads2_rewrite_file_urls'])
			return false;

		$file = nuseo_cache_fetch( $module, 'file', $file_id, 'nuseo_downloads2_fetch_file' );
		if (!$file)
		{
			if ($nuseo['prefetch'])
            {
				return true;				// we are in prefetch mode, we'll be back later
            }
			else
            {
				return false;				// else, we didn't find the file, fail.
            }
		}
        else
        {
        }
		
		$url_format = $module['file_url_format'];
        
	    $info['file_id']		= $file_id;
	    $info['file_title']		= $file ? nuseo_str_to_url( $file['name'] ) : '';        
        
        //fill category id/info from file table and add it to cache
        $category_id = $file['category'];
		$category = array( 'id' => $category_id, 'name' => $file['cat_name'] );
		nuseo_cache_add( $module, 'category', $category_id, $category );

	}
    
    if ( $category_id )
	{
		if ( !$nuseo_config['downloads2_rewrite_category_urls'] )
        {
			return false;		// category rewrite is disabled.
        }
            
		if (!$category)
		{
			$category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_downloads2_fetch_category' );
			if (!$category)
			{
				if ($nuseo['prefetch'])
                {
					return true;				// we are in prefetch mode, we'll be back later
                }
				else
                {
					return false;				// else, we didn't find the category, fail.
                }
			}
		}
        
		if ( !$file_id )
        {
            //get url format of category if we arent doing file
            $url_format = $module['category_url_format'];
        }   
        
	    $info['category_id']	= $category_id;
	    $info['category_title']	= $category ? nuseo_str_to_url( $category['name'] ) : '';
        
	}
    
	if (!$url_format)
    {
        if ( $nuseo_config['downloads2_rewrite_home_url'] )
        {
            $url_format = $url_format = !empty($module['home_url_format']) ? $module['home_url_format'] : $module['url_base'];
        }
        else
        {
		    return false;
        }
    }
    
	eval( '$sef_url = "' . $url_format . '";' );
    
    //eliminate the common query string for files and categories
    if ( isset( $sef_url ) )
    {
        //remove id from query string
		unset( $query_params['id'] );
        
        if ( $do_argument === "file" || $do_argument === "cat" ) 
        {
            unset( $query_params['do'] );
        }
    }
    
	return $sef_url;
}

function nuseo_downloads2_sef_to_downloads( &$module, $url, &$url_info, &$matches, &$anchor_info  )
{
	global $nuseo, $nuseo_config;
    /*
	if (!isset( $url_info['query_params'] ))
    {
        //echo "here";
		return false;
    }*/
    
	$query_params =& $url_info['query_params'];

	$category_id	= isset( $matches['category_id']	) ? $matches['category_id']		: false;
	$category_title	= isset( $matches['category_title']	) ? $matches['category_title']	: false;
	$file_id		= isset( $matches['file_id']		) ? $matches['file_id']		    : false;
	$file_title		= isset( $matches['file_title']	    ) ? $matches['file_title']		: false;
    
	if (!$file_id && $file_title)
	{
		$file = nuseo_cache_fetch_by_title( $module, 'file', $file_title, 'nuseo_downloads2_fetch_file_by_title' );
        
		if ( $file )
        {
			$file_id = $file['id'];
        }
	}

	if (!$category_id && $category_title)
	{
		$category = nuseo_cache_fetch_by_title( $module, 'category', $category_title, 'nuseo_downloads2_fetch_category_by_title' );
        
		if ( $category )
        {
			$category_id = $category['id'];
        }
	}

	if ( $file_id )
	{
		$query_params['id'] = $file_id;
        if ( !isset( $query_params['do'] ) )
        {
            $query_params['do'] = 'file';
        }        
	}
	else if ( $category_id )
	{
		$query_params['id'] = $category_id;
        
        if ( !isset( $query_params['do'] ) )
        {
            $query_params['do'] = 'cat';
        }        
	}
    else
    {
        
    }
    
    
    //seo content
    if ( $nuseo_config['downloads2_replace_keywords'] || $nuseo_config['downloads2_replace_description'])
    {
        $seo_items = array ();
        
        if ( $category_id )
        {
            if ( !isset( $category ) || !$category )
            {
                $category = nuseo_cache_fetch( $module, 'category', $category_id, 'nuseo_downloads2_fetch_category' );
            }
                        
            $seo_items['category'] = array();
            //$seo_items['category']['id'] = $category_id;
            $seo_items['category']['keywords'] = $category['name'];
            $seo_items['category']['description'] = $category['description'];
        }
        
        if ( $file_id )
        {
            if ( !isset( $file ) || !$file )
            {
                $file = nuseo_cache_fetch( $module, 'file', $file_id, 'nuseo_downloads2_fetch_file' );
            }
                        
            $seo_items['file'] = array();
            //$seo_items['file']['id'] = $file_id;
            $seo_items['file']['keywords'] = $file['name'];
            $seo_items['file']['description'] = $file['description'];
            
        }
        
        
        if ( !empty( $seo_items ) )
        {
            nuseo_set_seo_content( $seo_items, array( 'do_keywords' => $nuseo_config[ 'downloads2_replace_keywords' ],
                                                      'do_descriptions' => $nuseo_config[ 'downloads2_replace_description' ] ) );
        }
    }
	
    
    $non_sef_url = 'downloads.php';   
	return $non_sef_url;
}
//


// Database Connectivity
function nuseo_downloads2_connect_to_db( &$module )
{
	global $nuseo, $nuseo_config, $nuseo_vbulletin;
	
	$module['db_conn'] = false;

	if (isset($nuseo_vbulletin))
	{	// reuse vBulletin Module's DB Connection
		$db_conn =& nuseo_get_db_connection( $nuseo_vbulletin );

		$module['db_conn'] =& $db_conn;
		$module['table_prefix'] = $nuseo_vbulletin['table_prefix'];
	}
	
	if (!$module['db_conn'])
	{
		$vbulletin_config_filename = $nuseo['base_dir'] . $module['url_base'] . 'includes/config.php';
		if (file_exists( $vbulletin_config_filename ))
		{
			$config = array();
			include $vbulletin_config_filename;
			
			// read DB connection vars
			$server_name			= $config['MasterServer']['servername'];
			$server_port			= $config['MasterServer']['port'];
			$db_username			= $config['MasterServer']['username'];
			$db_password			= $config['MasterServer']['password'];
			$module['db_name']		= $config['Database']['dbname'];
			$module['table_prefix']	= $config['Database']['tableprefix'];
			
			$module['db_conn'] = nuseo_connect_to_db( $server_name, $server_port, 
												$db_username, $db_password, $module['db_name'] );

			// do not store username/password in memory
			unset( $server_name, $server_port, $db_username, $db_password );
		}
	}
}

function nuseo_downloads2_fetch_category( &$module, $cache_type, $category_id )
{
	$table_name = 'category';

	$id_field_name = 'id';

	$sql = "SELECT category.id, category.name, category.description
                FROM `{$module['table_prefix']}dl_cats` {$table_name}";
                //WHERE category.id = {$category_id}";
                
	$additional_where = false;
		
	$limit = false;
    
	return nuseo_cache_get_from_db_common( $module, $cache_type, $category_id, $sql, $table_name, $id_field_name, $additional_where, $limit );

}

function nuseo_downloads2_fetch_file( &$module, $cache_type, $file_id )
{
	$table_name = 'file';

	$id_field_name = 'id';

	$sql = "SELECT file.*,  category.name as cat_name FROM `{$module['table_prefix']}dl_files` file
                LEFT OUTER JOIN `{$module['table_prefix']}dl_cats` category 
                    ON category.id = file.category";
                //WHERE file.id = {$file_id}";

	$additional_where = false;

	$limit = false;
		
	return nuseo_cache_get_from_db_common( $module, $cache_type, $file_id, $sql, $table_name, $id_field_name, $additional_where, $limit );
}


function nuseo_downloads2_fetch_category_by_title( &$module, $cache_type, $category_title )
{
	$table_name = 'category';

	$title_field_name = 'name';

    $sql = "SELECT category.id, category.name, category.description
                FROM `{$module['table_prefix']}dl_cats` category";    

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $category_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

function nuseo_downloads2_fetch_file_by_title( &$module, $cache_type, $file_title )
{
	$table_name = 'file';

	$sql = "SELECT file.* FROM `{$module['table_prefix']}dl_files` file";
    
	$title_field_name = 'name';

	$additional_where = false;
		
	$limit = false;

	return nuseo_cache_get_from_db_by_title_common( $module, $cache_type, $file_title, $sql, $table_name, 
						$title_field_name, $additional_where, $limit );
}

//