<?php 

/************************************************************************\
 *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

$nuseo_language_strings[ 'english' ][ 'name' ] = "English";

$nuseo_language_strings[ 'english' ][ 'vbulletin:description' ] = "These settings control NuSEO's vBulletin Search Engine Optimization Engine.";

#region General URLS
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:title' ] = "General Settings";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:description' ] = "vBulletin Forum URL Path, Sub-domains and Fourm Home settings.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_url_base:title' ] = "vBulletin URL Base";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_url_base:description' ] = "Enter the Base URL for vBulletin. <br/>
	<br/>
	Examples: <br/>
	&nbsp;&nbsp;If vBulletin is installed at <em>www.domain.com/forums</em>, then the URL Base is <b>/forums/</b><br/>
	&nbsp;&nbsp;If vBulletin is installed at <em>www.domain.com/</em>, then the URL Base is <b>/</b>";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_domain:title' ] = "vBulletin Domain Override";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_domain:description' ] = "If vBulletin is installed in a subdomain different from your main site, enter it here, otherwise leave this setting blank.<br/>
		<br/>
		Example:<br/>
		<em>forums.domain.com</em>";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_forum_root_as_homepage:title' ] = "Forum Root as homepage?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_general:vbulletin_forum_root_as_homepage:description' ] = "If enabled, NuSEO will use the forum root as home page.";



$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_reversed_thread_words:title' ] = 'Reserved Thread Words.';
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_reversed_thread_words:description' ] = 'Enter a list of reserved words for the thread titles.';

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_reversed_thread_patterns:title' ]= 'Reserved Thread Patterns.';
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_reversed_thread_patterns:description' ] = 'Reserved Thread Patterns.';

#endregion

#region template optimizer
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:title' ] = "vBulletin Optimizer";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:description' ] = "NuSEO.PHP vBulletin Optimizer.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_h1_in_navbar:title' ] = "Enable H1 Tags for Navigation Bar?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_h1_in_navbar:description' ] = "Add H1 Tags to forum or thread title in navigation bar (navbar)";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_h2_for_post_title:title' ] = "Enable H2 Tags for Post Titles?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_h2_for_post_title:description' ] = "Add H2 Tags to Post Titles in when viewing a thread (showthread.php)";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_home:title' ] = "Enable NuSEO.PHP vBulletin Optimizer for Forum Home Page (index.php)?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_home:description' ] = "If enabled, NuSEO.PHP will optimize vBulletin's forum home for enhanced performance.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_forumdisplay:title' ] = "Enable NuSEO.PHP vBulletin Optimizer for Forum Display (forumdisplay.php)?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_forumdisplay:description' ] = "If enabled, NuSEO.PHP will optimize vBulletin's forum display for enhanced performance.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_showthread:title' ] = "Enable NuSEO.PHP vBulletin Optimizer for Thread Pages (showthread.php)?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vbulletin_optimizer:vbulletin_optimize_showthread:description' ] = "If enabled, NuSEO.PHP will optimize vBulletin's thread pages for enhanced performance.";
#endregion




#region Forum URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:title' ] = "Forums URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:description' ] = "Format and Settings for vBulletin's Forum URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_rewrite_forum_urls:title' ] = "Rewrite forum URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_rewrite_forum_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin forum URLs as specified below.<br/>
<br/>
<span class=\"ns-red-bold\">Important: </span>If you change any of the Forum URL Formats, 
remember to log into <em>vBulletin's Admin CP</em> and execute the '<b>Reset Forum Slugs</b>' command within the NuSEO.PHP group.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_path_bit:title' ] = "Forum Path parts format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_path_bit:description' ] = "
		This is the format used for each forum and sub-forum when using the [forum_path] tag in any URL format (e.g. Forum URLs, Thread URLs, etc).<br/>
		[forum_path] is used to include the forum and all parent forums in a URL format.
		";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_format:title' ] = "Forum URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_format:description' ] = "
		Format to be used for vBulletin Forum URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[forum_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous forums, threads or posts, or different forums with the same name, it is recommended that the Forum URLs Format include the <span class=\"ns-bold-italic\">[forum_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		</ul>
		<br/>
		Use [forum_path] to create a multi-level forum path (e.g. /forums/cars/mercedes-benz/), or [forum_title] for a single level URL (e.g. /forums/mercedes-benz/).";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_pages_format:title' ] = "Forum Index Page URL Format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_forum_pages_format:description' ] = "
		Format to be used for vBulletin Forum Index URLs (page 2, 3, etc)<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[forum_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous forums, threads or posts, or different forums with the same name, it is recommended that the Forum URLs Format include the <span class=\"ns-bold-italic\">[forum_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[forum_page]</li>
		</ul>
		<br/>
		Use [forum_path] to create a multi-level forum path (e.g. /forums/cars/mercedes-benz/), or [forum_title] for a single level URL (e.g. /forums/mercedes-benz/).";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_urls:title' ] = "Custom URL paths per Forum";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_urls:description' ] = "
		Specify custom URL path roots for forums, one per line. <br/>
		<br/>Syntax:<br/>
		&nbsp;&nbsp;&nbsp;<em>forum_id => /custom_path/</em><br/><br/>
		<br/>
		Example<br/>
		50 => /nuwiki/<br/>
		65 => /tutorials/<br/>
		
		<span class=\"ns-red-bold\">Important: </span>If you change this setting be sure to log into vBulletin's Admin CP and click on 'Reset NuSEO.PHP Forum Slugs'.
		";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_url_list:title' ] = "Custom URL paths per Forum - Clean";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_url_list:description' ] = "This is an internal setting.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_domain_list:title' ] = "Custom URL paths per Forum - Clean";
$nuseo_language_strings[ 'english' ][ 'vbulletin:forum_url_settings:vbulletin_custom_forum_domain_list:description' ] = "This is an internal setting.";
#endregion
		
#region Thread URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:title' ] = "Threads URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:description' ] = "Format for vBulletin's Thread URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_expand_thread_url_title:title' ] = "Add Thread Title to Thread URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_expand_thread_url_title:description' ] = "If enabled, NuSEO will add the thread's title to all thread links without a title.";
		
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_rewrite_restricted_threads:title' ] = "Rewrite Restricted Threads?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_rewrite_restricted_threads:description' ] = "If enabled, NuSEO will rewrite all threads, regardless if unregistered users can view them or not. This does not affect vBulletin's built-in permissions.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_rewrite_thread_urls:title' ] = "Rewrite thread URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_rewrite_thread_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin thread URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_format:title' ] = "Thread URL Format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_format:description' ] = "
		Format to be used for vBulletin Thread URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_pages_format:title' ] = "Multiple Page Thread URL Format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_pages_format:description' ] = "
		Format to be used for vBulletin individual Thread Page URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		<li>[thread_page]</li>
		</ul>
		<br/>
		";


$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_new_post_format:title' ] = "First Unread Post in Thread URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_new_post_format:description' ] = "
		Format to be used for vBulletin's First Unread Post in Thread URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_last_post_format:title' ] = "Go To Last Post in Thread URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_thread_last_post_format:description' ] = "
		Format to be used for vBulletin's Go To Last Post in Thread URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";


$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_previous_thread_format:title' ] = "Previous Thread URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_previous_thread_format:description' ] = "
		Format to be used for vBulletin's Previous Thread URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_next_thread_format:title' ] = "Next Thread URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_next_thread_format:description' ] = "
		Format to be used for vBulletin's Next Thread URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_go_to_post_format:title' ] = "Go to Post URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_go_to_post_format:description' ] = "
		Format to be used for vBulletin's Go to Post URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance. 
		Also, the [post_id] tag must be used.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[post_id]</li>
		<li>[thread_title]</li>
		</ul>
		<br/>
";

$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_go_to_post_pages_format:title' ] = "Multiple Page Go to Post URL Format.";
$nuseo_language_strings[ 'english' ][ 'vbulletin:thread_url_settings:vbulletin_go_to_post_pages_format:description' ] = "
		Format to be used for vBulletin's Multiple Page Go to Post URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[thread_id]</span> tag to ensure high performance. 
		Also, the [post_id] tag must be used.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[thread_id]</li>
		<li>[post_id]</li>
		<li>[thread_title]</li>
		<li>[thread_page]</li>
		</ul>
		<br/>
";

#endregion

#region Post URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:title' ] = "Posts URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:description' ] = "Format for vBulletin's Post URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_rewrite_showpost_urls:title' ] = "Rewrite post URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_rewrite_showpost_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin post URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_show_post_format:title' ] = "Post URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_show_post_format:description' ] = "
		Format to be used for vBulletin's Post URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>The <span class=\"ns-bold-italic\">[post_id]</span> and <span class=\"ns-bold-italic\">[post_count]</span> tags must be used in the URL Format.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[post_id]</li>
		<li>[post_count]</li>
		</ul>
		<br/>
		";
		
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_nofollow_show_posts:title' ] = "Add rel=\"nofollow\" to links to show post page?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:post_url_settings:vbulletin_nofollow_show_posts:description' ] = "If enabled, NuSEO will add rel=\"nofollow\" to links that show individual posts. 
Since the post content is already included in their corresponding threads, adding rel=\"nofollow\" to these links will avoid Duplicate Content in your site.";
#endregion

#region Poll URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:title' ] = "Polls URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:description' ] = "Format for vBulletin's Poll URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:vbulletin_rewrite_poll_urls:title' ] = "Rewrite poll URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:vbulletin_rewrite_poll_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin poll URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:vbulletin_poll_format:title' ] = "Poll URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:poll_url_settings:vbulletin_poll_format:description' ] = "
		Format to be used for vBulletin's Poll URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[poll_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[forum_path]</li>
		<li>[poll_id]</li>
		<li>[poll_title]</li>
		</ul>
		<br/>
";
#endregion

#region Member URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:title' ] = "Members URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:description' ] = "Format for vBulletin's Member URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_rewrite_member_urls:title' ] = "Rewrite member profile URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_rewrite_member_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin member profile URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_format:title' ] = "Member URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_format:description' ] = "
		Format to be used for vBulletin's Member URLs<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_id]</li>
		<li>[user_name]</li>
		</ul>
		<br/>
		";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_rewrite_member_list_urls:title' ] = "Rewrite member list URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_rewrite_member_list_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin member list URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_format:title' ] = "Member List URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_format:description' ] = "Format used by NuSEO to rewrite vBulletin member list URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_pages_format:title' ] = "Member List Index URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_pages_format:description' ] = "
		Format used by NuSEO to rewrite vBulletin Member List Index pages.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[page]</li>
		</ul>
		<br/>";

$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_letter_format:title' ] = "Member List Alphabetical Index URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:members_url_settings:vbulletin_member_list_letter_format:description' ] = "
		Format used by NuSEO to rewrite vBulletin Member List Alphabetical URLs.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[letter]</li>
		<li>[page]</li>
		</ul>
		<br/>";
#endregion

#region 
$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:title' ] = "Announcements URLs";
$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:description' ] = "Format for vBulletin's Announcement URLs.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_rewrite_announcement_urls:title' ] = "Rewrite announcement URLs?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_rewrite_announcement_urls:description' ] = "If enabled, NuSEO will rewrite vBulletin announcement URLs as specified below.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_announcement_format:title' ] = "Announcement URL format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_announcement_format:description' ] = "
		Format for vBulletin's Announcement URLs.
		<br/>
		<span class=\"ns-red-bold\">Note: </span>It is recommended to use the <span class=\"ns-bold-italic\">[announcement_id]</span> tag to ensure high performance.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_path]</li>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		<li>[announcement_title]</li>
		<li>[announcement_id]</li>
		</ul>
		<br/>";

$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_all_announcement_format:title' ] = "General Announcements URL Format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:announcement_url_settings:vbulletin_all_announcement_format:description' ] = "
		Format for vBulletin's General Announcement URLs.
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_path]</li>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		</ul>
		<br/>";
#enregion

#region Meta Tags 
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:title' ] = "Meta Tags";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:description' ] = "Settings for vBulletin's Keyword and Description Meta Tags.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_replace_keywords:title' ] = "Replace Keywords Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_replace_keywords:description' ] = "If enabled, NuSEO will replace the Keywords Meta Tag in vBulletin pages (e.g. forums, threads, user pages) with keywords relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_replace_description:title' ] = "Replace Description Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_replace_description:description' ] = "If enabled, NuSEO will replace the Description Meta Tag in vBulletin pages (e.g. forums, threads, user pages) with a description relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_max_description_length:title' ] = "Maximum Description Length";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_max_description_length:description' ] = "This number is used to limit the number of characters in the Description Meta Tag.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_member_description_format:title' ] = "Member Description format";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_member_description_format:description' ] = "Format used by NuSEO for member profile pages.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_expand_external_url_title:title' ] = "Expand Title in URLs without title?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:seo_content:vbulletin_expand_external_url_title:description' ] = "If enabled, NuSEO will expand the title of URLs which have been posted without a title.";

#endregion

#region rel="nofollow"
$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:title' ] = "rel=\"nofollow\" Settings";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:description' ] = "These settings control the use of rel=\"nofollow\" across vBulletin Pages.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_dynamic_links:title' ] = "Add rel=\"nofollow\" to dynamic links?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_dynamic_links:description' ] = "If enabled, NuSEO will add rel=\"nofollow\" to internal vBulletin dynamic links, which otherwise would be seen as Duplicate Content by Search Engines.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_member_links_from_postbit:title' ] = "Add rel=\"nofollow\" to Member Links in threads?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_member_links_from_postbit:description' ] = "If enabled, NuSEO will Add rel=\"nofollow\" to all member links present in threads (e.g. post author).";

$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_member_links_from_forumhome:title' ] = "Add rel=\"nofollow\" to Member Links in Forum Home?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:vBulletin_rel_nofollow:vbulletin_add_nofollow_to_member_links_from_forumhome:description' ] = "If enabled, NuSEO will Add rel=\"nofollow\" to member links shown in the forum home.";
#endregion

#region Guest Optimizations
$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:title' ] = "Guest Optimizations";
$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:description' ] = "Settings to Optimize vBulletin for guests.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_remove_forum_jump_for_guests:title' ] = "Remove forum jump for guests?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_remove_forum_jump_for_guests:description' ] = "If enabled, NuSEO will remove the forum jump option for guests.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_remove_thread_preview_for_guests:title' ] = "Remove thread preview for guests?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_remove_thread_preview_for_guests:description' ] = "If enabled, NuSEO will remove the thread preview option for guests.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_hide_goto_new_post_for_guests:title' ] = "Hide go to new post link for guests?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:guest_settings:vbulletin_hide_goto_new_post_for_guests:description' ] = "If enabled, NuSEO will hide the go to new post link for guests.";
#endregion

#region Social Bookmarking
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:title' ] = "Social Bookmarking";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:description' ] = "Settings for Social Bookmarking of vBulletin Threads and Posts.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_social_bookmarks_mode:title' ] = "Social Bookmarking Mode?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_social_bookmarks_mode:description' ] = "This mode determines where the selected Social Bookmark icons are added.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_digg_enabled:title' ] = "Digg enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_digg_enabled:description' ] = "Enable Digg for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_delicious_enabled:title' ] = "Delicius enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_delicious_enabled:description' ] = "Enable Delicius for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_technorati_enabled:title' ] = "Technorati enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_technorati_enabled:description' ] = "Enable Technorati for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_furl_enabled:title' ] = "Furl enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_furl_enabled:description' ] = "Enable Furl for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_connotea_enabled:title' ] = "Connotea enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_connotea_enabled:description' ] = "Enable Connotea for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_google_enabled:title' ] = "Google enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_google_enabled:description' ] = "Enable Google for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_magnolia_enabled:title' ] = "Magnolia enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_magnolia_enabled:description' ] = "Enable ma.gnolia for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_netscape_enabled:title' ] = "Netscape enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_netscape_enabled:description' ] = "Enable Netscape for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_netvouz_enabled:title' ] = "Netvouz enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_netvouz_enabled:description' ] = "Enable Netvouz for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_newsvine_enabled:title' ] = "Newsvine enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_newsvine_enabled:description' ] = "Enable Newsvine for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_rawsugar_enabled:title' ] = "RawSugar enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_rawsugar_enabled:description' ] = "Enable RawSugar for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_recommendzit_enabled:title' ] = "RecommendzIt enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_recommendzit_enabled:description' ] = "Enable RecommendzIt for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_reddit_enabled:title' ] = "reddit enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_reddit_enabled:description' ] = "Enable reddit for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_scuttle_enabled:title' ] = "Scuttle enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_scuttle_enabled:description' ] = "Enable Scuttle for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_shadows_enabled:title' ] = "Shadows enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_shadows_enabled:description' ] = "Enable Shadows for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_simpy_enabled:title' ] = "Simpy enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_simpy_enabled:description' ] = "Enable Simpy for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_spurl_enabled:title' ] = "Spurl enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_spurl_enabled:description' ] = "Enable Spurl for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_stumbleupon_enabled:title' ] = "StumbleUpon enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_stumbleupon_enabled:description' ] = "Enable StumbleUpon for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_wink_enabled:title' ] = "Wink enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_wink_enabled:description' ] = "Enable Wink for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_yahoomyweb_enabled:title' ] = "MyWeb enabled?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_yahoomyweb_enabled:description' ] = "Enable Yahoo! MyWeb for social bookmarking.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_custom_social_bookmarks:title' ] = "Custom social bookmarks";
$nuseo_language_strings[ 'english' ][ 'vbulletin:social_bookmarking:vbulletin_custom_social_bookmarks:description' ] = "
		Definition for custom social bookmarks, one per line. <br/>
		<br/>Syntax:<br/>
		&nbsp;&nbsp;&nbsp;<em>social_bookmark_url,image,tooltip_for_threads,tooltip_for_posts</em><br/><br/>
		When specifying the social_bookmark_url, use [url] and [title] where needed.<br/>
		<br/>
		Example<br/>
		http://reddit.com/submit?url=[url]&title=[title],redit.gif,Bookmark this Thread in Redit,Bookmark this Post in Redit
		";
#endregion

#region Micellaneous URLs
$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:title' ] = "Archive and E-mail";
$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:description' ] = "Archive and E-mail URL settings.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:vbulletin_redir_archive:title' ] = "Redirect Archive Links?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:vbulletin_redir_archive:description' ] = "If enabled, NuSEO will redirtect archive links to their corresponding forum and thread.";

$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:vbulletin_rewrite_email_urls:title' ] = "Rewrite vBulletin URLs in e-mails?";
$nuseo_language_strings[ 'english' ][ 'vbulletin:misc_url_settings:vbulletin_rewrite_email_urls:description' ] = "If enabled, NuSEO will rewrite all vBulletin URLs in e-mails (e.g. Noticiation e-mails).";

#endregion



#region Global Content Replacement variables
$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:bb_title' ] = "Board Title";
$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:default_keywords' ] = "Keywords from vBulletin Admin CP";

$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:forum_title' ] = "Forum Title";
$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:forum_description' ] = "Forum Description";

$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:thread_title' ] = "Thread Title of Showthread Pages";
$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:first_post_intro' ] = "Content of the First Post, limited by 'Maximum Description Length'";

$nuseo_language_strings[ 'english' ][ 'vbulletin:variable:thread_page' ] = "Thead page number";

#endregion


