<?php 

/************************************************************************\
 *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

$nuseo_language_strings[ 'english' ][ 'name' ] = "English";

$nuseo_language_strings[ 'english' ][ 'phpfox:description' ] = "These settings control NuSEO's phpFox Search Engine Optimization Engine.";

#region General Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:title' ] = "General Settings";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:description' ] = "General Settings and Configuration for phpFox.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_url_base:title' ] = "phpFox URL Base";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_url_base:description' ] = "Enter the Base URL for phpFox.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_domain:title' ] = "phpFox Domain Override";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_domain:description' ] = "If phpFox is installed in a subdomain different from your main site, enter it here, otherwise leave this setting blank.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_public_site:title' ] = "phpFox Public Site Prefix";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_general_settings:phpfox_public_site:description' ] = "This is the prefix for phpFox URLs, usually <em>/public</em>.";
#endregion 

#region Gallery URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:title' ] = "Gallery URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:description' ] = "Format for Gallery URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:phpfox_rewrite_gallery_urls:title' ] = "Rewrite Gallery URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:phpfox_rewrite_gallery_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Gallery URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:phpfox_gallery_format:title' ] = "Gallery URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_gallery_settings:phpfox_gallery_format:description' ] = "
		Format to be used for phpFox View Gallery URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[gallery_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous galleries or different galleries with the same name, it is recommended that the Gallery URLs Format include the <span class=\"ns-bold-italic\">[gallery_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[gallery_title]</li>
		<li>[gallery_id]</li>
		</ul>";
#endregion 

#region User URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:title' ] = "User URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:description' ] = "Format for User URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_urls:title' ] = "Rewrite User URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_format:title' ] = "User Profile URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_format:description' ] = "
		Format to be used for phpFox User Profile URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_gallery_urls:title' ] = "Rewrite User Gallery URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_gallery_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User Gallery URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_gallery_format:title' ] = "User Gallery URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_gallery_format:description' ] = "
		Format to be used for phpFox User Gallery URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User Gallery URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_blogs_urls:title' ] = "Rewrite User Blogs URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_blogs_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User Blogs URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_blogs_format:title' ] = "User Blogs URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_blogs_format:description' ] = "
		Format to be used for phpFox User Blogs URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User Blogs URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_guestbook_urls:title' ] = "Rewrite User Guestbook URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_guestbook_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User Guestbook URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_guestbook_format:title' ] = "User Guestbook URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_guestbook_format:description' ] = "
		Format to be used for phpFox User Guestbook URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User GuestBook URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_friends_urls:title' ] = "Rewrite User Friends URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_friends_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User Friends URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_friends_format:title' ] = "User Friends URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_friends_format:description' ] = "
		Format to be used for phpFox User Friends URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User Friends URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_favorites_urls:title' ] = "Rewrite User Favorites URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_rewrite_user_favorites_urls:description' ] = "If enabled, NuSEO will rewrite phpFox User Favorites URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_favorites_format:title' ] = "User Favorites URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_user_settings:phpfox_user_favorites_format:description' ] = "
		Format to be used for phpFox User Favorites URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[user_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous users or different users with the same name, it is recommended that the User Favorites URLs Format include the <span class=\"ns-bold-italic\">[user_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[user_name]</li>
		</ul>";
		

		
#endregion 

#region Blog URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:title' ] = "Blog URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:description' ] = "Format for Blog URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:phpfox_rewrite_blog_urls:title' ] = "Rewrite Blog URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:phpfox_rewrite_blog_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Blog URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:phpfox_blog_format:title' ] = "Blog URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_blog_settings:phpfox_blog_format:description' ] = "
		Format to be used for phpFox View Blog URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[blog_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous blogs or different blogs with the same name, it is recommended that the Blog URLs Format include the <span class=\"ns-bold-italic\">[blog_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[blog_title]</li>
		<li>[blog_id]</li>
		</ul>";
#endregion 

#region Forums URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:title' ] = "Forums URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:description' ] = "Format for Forums URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_rewrite_forum_urls:title' ] = "Rewrite Forums URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_rewrite_forum_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Forums URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_forum_format:title' ] = "Forum URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_forum_format:description' ] = "
		Format to be used for phpFox Forum URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[forum_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous forums or different forums with the same name, it is recommended that the Forum URLs Format include the <span class=\"ns-bold-italic\">[forum_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[forum_title]</li>
		<li>[forum_id]</li>
		</ul>";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_rewrite_topic_urls:title' ] = "Rewrite Topic URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_rewrite_topic_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Topic URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_topic_format:title' ] = "Topic URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_forum_settings:phpfox_topic_format:description' ] = "
		Format to be used for phpFox Topic URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[topic_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous topics or different topics with the same name, it is recommended that the Topic URLs Format include the <span class=\"ns-bold-italic\">[topic_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[topic_title]</li>
		<li>[topic_id]</li>
		</ul>";

#endregion 

#region Polls URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:title' ] = "Poll URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:description' ] = "Format for Poll URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:phpfox_rewrite_poll_urls:title' ] = "Rewrite Poll URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:phpfox_rewrite_poll_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Poll URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:phpfox_poll_format:title' ] = "Poll URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_poll_settings:phpfox_poll_format:description' ] = "
		Format to be used for phpFox Poll URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[poll_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous polls or different polls with the same name, it is recommended that the Poll URLs Format include the <span class=\"ns-bold-italic\">[poll_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[poll_title]</li>
		<li>[poll_id]</li>
		</ul>";
#endregion 

#region Groups URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:title' ] = "Group URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:description' ] = "Format for Group URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_rewrite_group_urls:title' ] = "Rewrite Group URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_rewrite_group_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Group URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_category_format:title' ] = "Group Category URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_category_format:description' ] = "
		Format to be used for phpFox Group Category URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[category_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous group categories or different group categories with the same name, it is recommended that the Group URLs Format include the <span class=\"ns-bold-italic\">[category_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_format:title' ] = "Group URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_format:description' ] = "
		Format to be used for phpFox Group URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";
		
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_forum_format:title' ] = "Group Forums URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_forum_format:description' ] = "
		Format to be used for phpFox Group Forums URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group Forums URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";	

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_topic_format:title' ] = "Group Forum Topic URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_topic_format:description' ] = "
		Format to be used for phpFox Group Forum Topic URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group Forums URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";	

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_posts_format:title' ] = "Group Forum Posts URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_posts_format:description' ] = "
		Format to be used for phpFox Group Forum Posts URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group Forums URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";	

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_members_format:title' ] = "Group Members URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_members_format:description' ] = "
		Format to be used for phpFox Group Members URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group Members URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_gallery_format:title' ] = "Group Galleries URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_group_settings:phpfox_group_gallery_format:description' ] = "
		Format to be used for phpFox Group Galleries URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[group_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous groups or different groups with the same name, it is recommended that the Group Galleries URLs Format include the <span class=\"ns-bold-italic\">[group_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		<li>[group_title]</li>
		<li>[group_id]</li>
		</ul>";
#endregion 

#region Listings URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:title' ] = "Listing URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:description' ] = "Format for Listing URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:phpfox_rewrite_listing_urls:title' ] = "Rewrite Listing URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:phpfox_rewrite_listing_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Listing URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:phpfox_listing_format:title' ] = "Listing URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_listing_settings:phpfox_listing_format:description' ] = "
		Format to be used for phpFox Listing URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[listing_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous listings or different listings with the same name, it is recommended that the Listing URLs Format include the <span class=\"ns-bold-italic\">[listing_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[listing_title]</li>
		<li>[listing_id]</li>
		</ul>";
#endregion 

#region Quizes URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:title' ] = "Quiz URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:description' ] = "Format for Quiz URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:phpfox_rewrite_quiz_urls:title' ] = "Rewrite Quiz URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:phpfox_rewrite_quiz_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Quiz URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:phpfox_quiz_format:title' ] = "Quiz URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_quiz_settings:phpfox_quiz_format:description' ] = "
		Format to be used for phpFox Quiz URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[quiz_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous quizes or different quizes with the same name, it is recommended that the Quiz URLs Format include the <span class=\"ns-bold-italic\">[quiz_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[quiz_title]</li>
		<li>[quiz_id]</li>
		</ul>";
#endregion 

#region Events URL Settings
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:title' ] = "Event URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:description' ] = "Format for Event URLs";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:phpfox_rewrite_event_urls:title' ] = "Rewrite Event URLs";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:phpfox_rewrite_event_urls:description' ] = "If enabled, NuSEO will rewrite phpFox Event URLs.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:phpfox_event_format:title' ] = "Event URL Format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_event_settings:phpfox_event_format:description' ] = "
		Format to be used for phpFox Event URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[event_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous events or different events with the same name, it is recommended that the Event URLs Format include the <span class=\"ns-bold-italic\">[event_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[event_title]</li>
		<li>[event_id]</li>
		</ul>";
#endregion 

#region Meta Tags 
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:title' ] = "Meta Tags";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:description' ] = "Settings for phpFox's Keyword and Description Meta Tags.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_replace_keywords:title' ] = "Replace Keywords Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_replace_keywords:description' ] = "If enabled, NuSEO will replace the Keywords Meta Tag in phpFox pages (e.g. forums, threads, user pages) with keywords relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_replace_description:title' ] = "Replace Description Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_replace_description:description' ] = "If enabled, NuSEO will replace the Description Meta Tag in phpFox pages (e.g. forums, threads, user pages) with a description relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_max_description_length:title' ] = "Maximum Description Length";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_max_description_length:description' ] = "This number is used to limit the number of characters in the Description Meta Tag.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_member_description_format:title' ] = "Member Description format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_member_description_format:description' ] = "Format used by NuSEO for the description meta tag for member profile pages.<br/>
	<span class=\"ns-bold\">Any field in a user's profile can be used. Examples:</span><br/>
		<ul>
		<li>[user]</li>
		<li>[me]</li>
		<li>[turnon]</li>
		<li>[turnoff]</li>
		<li>[hobbies]</li>
		</ul>";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_member_keywords_format:title' ] = "Member Keywords format";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_seo_content:phpfox_member_keywords_format:description' ] = "Format used by NuSEO for the keywords meta tag for member profile pages.<br/>
	<span class=\"ns-bold\">Any field in a user's profile can be used. Examples:</span><br/>
		<ul>
		<li>[user]</li>
		<li>[me]</li>
		<li>[turnon]</li>
		<li>[turnoff]</li>
		<li>[hobbies]</li>
		</ul>";
#endregion

#region Reserved Names 
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:title' ] = "Reserved Names";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:description' ] = "List of names reserved by phpFox";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:phpfox_reserved_dir_list:title' ] = "Reserved Directory List";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:phpfox_reserved_dir_list:description' ] = "This is a list of directories reserved by phpFox. Do not change unless instructed by NuHIT Staff.";

$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:phpfox_reserved_name_list:title' ] = "Reserved Name List";
$nuseo_language_strings[ 'english' ][ 'phpfox:phpfox_reserved_lists:phpfox_reserved_name_list:description' ] = "This is a list of names reserved by phpFox. Do not change unless instructed by NuHIT Staff.";
#endregion
