<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright ©2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

$nuseo_language_strings[ 'english' ][ 'name' ] = "English";

$nuseo_language_strings[ 'english' ][ 'Main:description' ] = "These settings control NuSEO Core Engine.";

// Core Settings
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:title' ] = "Core Settings";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:description' ] = "Enable/Disable NuSEO, Google and Yahoo Ad Targeting, Page Not Found Handling, 301 Redirects...";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enabled:title' ] = "NuSEO Enabled?";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enabled:description' ] = "If set to 'No', NuSEO.PHP will stop all rewriting and optimizing operations. <br/>
<br/>
Notice that as long as the .htaccess file is present (with the rules that direct traffic to nuseo.php), NuSEO.PHP will continue handling inbound requests, 
forwarding them to the corresponding script without doing anything else.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:license_number:title' ] = "<span class=\"ns-red-bold\">NuSEO License Number*</span>";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:license_number:description' ] = "Please verify that this setting matches the license number sent by NuHIT.<br/>
		The License Number is a 12 character long code that starts with the letters <b>SEO</b>";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:license_key:title' ] = "NuSEO License Key";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:license_key:description' ] = "Enter the License Key provided by NuHIT.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:admin_username:title' ] = "NuSEO Admin Control Panel Username";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:admin_username:description' ] = "This is the username used to log into NuSEO's Admin Control Panel.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:admin_password:title' ] = "NuSEO Admin Control Panel Password";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:admin_password:description' ] = "This is the encoded Admin Control Panel password. To reset your password, remove this line from nuseo_config.php";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:demo_mode:title' ] = "Demo Mode";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:demo_mode:description' ] = "Demo Mode.";
//

// URL Generation Settings
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:title' ] = "URL Generation Settings";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:description' ] = "Control how NuSEO generates URLs, including character translations, stop words, redirect external URLs, absolute vs. relative ...";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:title' ] = "Analytics Settings";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:description' ] = "Google Analytics, outgoing link tracking, custom analytics settings...";

$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:title' ] = "Custom Rules";
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:description' ] = "Rules for Custom Redirects and Custom Rewrites...";

$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:title' ] = "rel=\"nofollow\" Settings";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:description' ] = "Control whether rel=\"nofollow\" is added to external links...";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:title' ] = "Debug and Logging Settings";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:description' ] = "These settings control NuSEO Debug and Logging subsystem...";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:base_url_path:title' ] = "Base URL path";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:base_url_path:description' ] = "Enter the relative path to where NuSEO's .htaccess is located. If your NuSEO .htaccess is in the root of your site, leave this value empty.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:base_domain_list:title' ] = "Base Domain List";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:base_domain_list:description' ] = "This is a list of domains for your main site. If your site is not using different sub-domains leave this setting empty. <br/>
			Specify different domain aliases, one per line.<br/>
			<br/>
			Example:<br/>
			<br/>
			&nbsp;&nbsp;nuhit.com<br/>
			&nbsp;&nbsp;www.nuhit.com<br/>";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:language:title' ] = "Admin Interface Language";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:language:description' ] = "Select the language to be used for the Admin Interface.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:use_301_redirects:title' ] = "Enable 301 redirects?";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:use_301_redirects:description' ] = "301 redirect is the 'search engine safe' way to redirect pages.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enable_adsense_targeting:title' ] = "Enable Google Adsense Targeting?";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enable_adsense_targeting:description' ] = "
                    If set to 'yes', NuSEO will add Google Adsense specific targeting code.<br/>
					<a href=https://www.google.com/adsense/support/bin/answer.py?answer=23168\">https://www.google.com/adsense/support/bin/answer.py?answer=23168</a>
                ";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enable_yahoo_targeting:title' ] = "Enable Yahoo Ad Targeting?";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:enable_yahoo_targeting:description' ] = "
                    If set to 'yes', NuSEO will add yahoo specific ad targeting code.<br/>
					<a href=\"http://help.yahoo.com/help/us/ysearch/slurp/slurp-14.html\">http://help.yahoo.com/help/us/ysearch/slurp/slurp-14.html</a>
                ";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:affiliate_id:title' ] = "Enter your NuHIT Affiliate Id";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:affiliate_id:description' ] = "Forget about it.";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:copyright_type:title' ] = "Select the NuSEO Copyright Notice";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:copyright_type:description' ] = "Unless your site license includes the 'Branding Free Option', NuHIT's software license agreement requires that all pages enhanced by NuSEO display the copyright notice. ";

$nuseo_language_strings[ 'english' ][ 'Main:main_settings:file_not_found_handler:title' ] = "Page Not Found (404) Response";
$nuseo_language_strings[ 'english' ][ 'Main:main_settings:file_not_found_handler:description' ] = "
                    Select how \"page not found\" requests are handled.
                ";
//


// URL Generation Settings
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:title' ] = "URL Generation Settings";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:description' ] = "Control how NuSEO generates URLs, including character translations, stop words, redirect external URLs, absolute vs. relative ...";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:use_absolute_urls:title' ] = "Include Domain Name in URLs?";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:use_absolute_urls:description' ] = "If enabled, NuSEO will convert all relative internal URLs to absolute.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:replace_special_chars:title' ] = "Replace Non-English Characters in URLs?";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:replace_special_chars:description' ] = "If set to 'Yes', NuSEO will replace all non-English characters in URLs with their english equivalent. If enabled, NuSEO will use the map specified below.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:special_chars_map:title' ] = "Non-English Character Translation Map";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:special_chars_map:description' ] = "This is the translation map used by NuSEO when the option 'Replace Non-English Characters' is enabled. ";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:redirect_external_urls:title' ] = "Redirect External URLs?";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:redirect_external_urls:description' ] = "If enabled, all external URLs will be redirected through a NuSEO script.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:separator:title' ] = "Word Separator Character";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:separator:description' ] = "Select the character to be used to separate words when generating URLs.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:max_url_words:title' ] = "Maximum Number of Words in URLs";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:max_url_words:description' ] = "Enter the maximum number of words to be used when generating URLs. Set this value to zero (0) to disable this feature.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:remove_stopwords_from_urls:title' ] = "Remove Stopwords from URLs?";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:remove_stopwords_from_urls:description' ] = "If set to 'Yes', URLs will be filtered against the list of Stopwords defined below.";

$nuseo_language_strings[ 'english' ][ 'Main:url_settings:stopwords:title' ] = "Stopwords";
$nuseo_language_strings[ 'english' ][ 'Main:url_settings:stopwords:description' ] = "This is the list of words that will be filtered from URLs if 'Remove Stopwords from URLs' is enabled.";
//

// Analytics Settings
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:title' ] = "Analytics Settings";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:description' ] = "Google Analytics, outgoing link tracking, custom analytics settings...";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_enabled:title' ] = "Enable Google Analytics Integration?";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_enabled:description' ] = "If set to 'Yes', the Google Analytics script is added to all pages. Enter your site's 'Google Analytics Code' below.";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_code:title' ] = "Google Analytics Code?";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_code:description' ] = "This is the Google Analytics Code used by the 'Google Analytics Integration'.";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_track_outgoing:title' ] = "Track Outgoing URLs with Google Analytics?";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_track_outgoing:description' ] = "If enabled, NusEO will instruct Google Analytics to track all outgoing URLs.";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_outgoing_format:title' ] = "Google Analytics Ougoing URLs Format";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:urchin_outgoing_format:description' ] = "Enter the format used to track outgoing URLs in Google Analytics.";

$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:analytics_custom_code:title' ] = "Custom Analytics Code";
$nuseo_language_strings[ 'english' ][ 'Main:analytics_settings:analytics_custom_code:description' ] = "Enter the custom code to be added to all pages. This is useful if using an analytics package other than (or in addition to) Google Analytics, for instance, Mint, etc.";
// 

// Custom Rules
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:title' ] = "Custom Rules";
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:description' ] = "Rules for Custom Redirects and Custom Rewrites, Path Blacklist, etc...";

$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_rewrite_rules:title' ] = "Custom Rewrite Rules";
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_rewrite_rules:description' ] = "Enter custom rewrite rules. Refer to NuSEO's manual for more information.";

$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_redirects:title' ] = "Custom Redirect Rules";
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_redirects:description' ] = "
                    Enter custom redirect rules. Refer to the manual for more information.<br/>
                    <br/>
                    Example:<br/>
                	&nbsp;&nbsp; <em>/hello.php?q=$1 => http://www.google.com/search?q=$1</em>
                
                ";
				
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_path_blacklist:title' ] = "Custom Path Blacklist";
$nuseo_language_strings[ 'english' ][ 'Main:custom_rules:custom_path_blacklist:description' ] = "
                    Enter a list of paths or scripts (one per line) for which NuSEO.PHP should be disabled.<br/>
					Any URL which matches the paths listed in this setting will not be processed by NuSEO.PHP.<br/>
                    <br/>
                    Example:<br/>
                	&nbsp;&nbsp; <em>/mail/</em>
                ";
				
//

// rel=nofollow Settings
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:title' ] = "rel=\"nofollow\" Settings";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:description' ] = "Control whether rel=\"nofollow\" is added to external links...";

$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_to_external_links:title' ] = "Add rel=\"nofollow\" to External URLs?";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_to_external_links:description' ] = "If set to 'Yes', rel=\"nofollow\" will be added to links pointing to external sites, preventing search engines from following these links.";

$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_whitelist:title' ] = "External domains Whitelist for rel=\"nofollow\"";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_whitelist:description' ] = "Enter the list of domains to which rel=\"nofollow\" should not be added.";

$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_blacklist:title' ] = "Blacklist for rel=\"nofollow\"";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_blacklist:description' ] = "Enter a list of domains to which rel=\"nofollow\" will always be added regardless of other settings.";

$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_internal_ulrs:title' ] = "List of internal URLs for which rel=\"nofollow\" should be added.";
$nuseo_language_strings[ 'english' ][ 'Main:rel_nofollow:add_nofollow_internal_ulrs:description' ] = "Enter a list of internal URLs to which rel=\"nofollow\" should be added (overwrites previous settings). ";
//

// Debug and Logging Settings
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:title' ] = "Debug and Logging Settings";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:description' ] = "These settings control NuSEO Debug and Logging subsystem...";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_enabled:title' ] = "Enable NuSEO's URL Commands?";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_enabled:description' ] = "
                    If set to 'Yes', NuSEO will process and execute NuSEO URL Commands, used for diagnostics and troubleshooting. <br/>
					If enabled, only users who are connecting from an IP in the 'URL Commands IP List' will be allowed to use URL Commands.<br/>
					<br/>
					Do not set to 'Yes' unless instructed by NuHIT's staff.
                ";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_ip_list:title' ] = "NuSEO's URL Commands IP List";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_ip_list:description' ] = "
					This is the list of IPs (one per line) which are allowed to use NuSEO's URL Commands, if enabled above.<br/>
					<br/>
					The defaults include your local IP, as well as NuHIT's IP.<br/>";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_enabled:title' ] = "Enable NuSEO's URL Commands?";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:url_commands_enabled:description' ] = "
                    If set to 'Yes', NuSEO will process and execute NuSEO URL Commands, used for diagnostics and troubleshooting. Do not set to 'Yes' unless instructed by NuHIT's staff.
                ";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_enabled:title' ] = "Enable Logging?";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_enabled:description' ] = "Enable NuSEO's logging system?";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_type:title' ] = "Log Storage";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_type:description' ] = "Where should NuSEO save its logs?<br/>
                <br/>
                If 'Save Logs to Database' is selected, please edit nuseo_config.php 
                to enter the login information for the DB that NuSEO should use.";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_file_location:title' ] = "Log Files Location";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_file_location:description' ] = "This setting contains the directory path where NuSEO will save its logs, 
                if 'Save logs to Files' is selected.<br/>
                <br/>
                If left blank, NuSEO will use the logs directory in NuSEO's installation.";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_server_name:title' ] = "MySQL server name";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_server_name:description' ] = "MySQL Server Name for NuSEO Logs (applicable if 'Save Logs to Database' is selected).";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_server_port:title' ] = "SQL server port";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_server_port:description' ] = "MySQL Server Port for NuSEO Logs (applicable if 'Save Logs to Database' is selected).";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_name:title' ] = "Database name";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_name:description' ] = "Database name for NuSEO Logs (applicable if 'Save Logs to Database' is selected).";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_username:title' ] = "Database user name";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_username:description' ] = "Username to login to MySQL Server for NuSEO Logs (applicable if 'Save Logs to Database' is selected).";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_password:title' ] = "Database password";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_password:description' ] = "password to login to MySQL Server for NuSEO Logs (applicable if 'Save Logs to Database' is selected).";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_404:title' ] = "Log pages not found?";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_404:description' ] = "If enabled, NuSEO will log all URLs for files that are not found.";

$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_errors:title' ] = "Log DB Errors?";
$nuseo_language_strings[ 'english' ][ 'Main:debug_and_logs:log_db_errors:description' ] = "If enabled, NuSEO will log DB errors.";
//


// Support, Online Documentation and Diagnostic Tools	
$nuseo_language_strings[ 'english' ][ 'Help:description' ] = "Support, Online Documentation and Diagnostic Tools.";

$nuseo_language_strings[ 'english' ][ 'Help:help_links:title' ] = "Help & Support";
$nuseo_language_strings[ 'english' ][ 'Help:help_links:description' ] = "Links to Support Portal, Support Forums and Online Documentation";

$nuseo_language_strings[ 'english' ][ 'Help:help_diagnostics:title' ] = "Diagnostic Tools";
$nuseo_language_strings[ 'english' ][ 'Help:help_diagnostics:description' ] = "System Information and Diagnostic Tools";
//

// Content Replacement
$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:title' ] = "Global Replacements";
$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:description' ] = "Use Global Content Replacements to strategically place keywords and content relevant to each page";

$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:global_content_replacement_enabled:title' ] = "Enable Global Content Replacements?";
$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:global_content_replacement_enabled:description' ] = "If set to 'Yes', NuSEO will process the Global Content Replacements specified below";

$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:global_content_replacement_list:title' ] = "Global Content Replacement Rules";
$nuseo_language_strings[ 'english' ][ 'Main:global_content_replacement:global_content_replacement_list:description' ] = "Use this Setting to Define the Global Content Replacements Rules<BR/><BR/>
    Example:<br/>
    &nbsp;&nbsp; <em>NUSEO_GCR_1 => [forum_title] discussion at [bb_title].</em><BR/>
    &nbsp;&nbsp; <em>NUSEO_GCR_2 => &lt;h1&gt;[forum_title]&lt;/h1&gt;</em><BR/><BR/>
    And then place this in your template <b>&lt!--NUSEO_GCR_1--&gt</b><BR/><BR/>
    Please note that NuSEO.PHP supports unlimited Global Content Replacements.
";

//



// High Traffic Settings
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:title' ] = "High Traffic Optimizer";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:description' ] = "The High Traffic Optimizer (HTO) enables the use of distributed cache server farms like Memcached or a number of in-memory cache systems like eAccelerator or APC.
                                                                                    This is essential where a large number of concurrent users needs to be handled in high traffic sites while minimizing server load.";

$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_system_enabled:title' ] = "Enable NuSEO.PHP High Traffic Optimizer (HTO)?";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_system_enabled:description' ] = "If set to 'Yes', NuSEO.PHP High Traffic Optimizer will be enabled.";

$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_engine:title' ] = "Cache System to be used by NuSEO.PHP HTO";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_engine:description' ] = "Select the cache system to be used by NuSEO.PHP HTO. Make sure the selected system is available in your server and the corresponding PHP extension is installed and funcioning.<br /><br />
    <span class=\"ns-red-bold\">Note: </span>
    &nbsp;&nbsp; <em>If Memcached is selected, Memcached settings should be set in the next section</em><BR/>
";

$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_timeout:title' ] = "Cache timeout?";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_timeout:description' ] = "Specify the number of seconds an HTO object will remain in the cache.";

$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_url_requests:title' ] = "Cache URL Request Translation?";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_url_requests:description' ] = "If set to 'Yes', NuSEO.PHP HTO will cache the translation for incoming URL requests.";

$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_anchor_processing:title' ] = "Cache HTML Anchor Translation?";
$nuseo_language_strings[ 'english' ][ 'Main:high_traffic_optimizer:cache_anchor_processing:description' ] = "If set to 'Yes', NuSEO.PHP HTO will cache the translation for anchor URLs in HTML output.";

//

// Memcached settings
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:title' ] = "Memcached Settings";
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:description' ] = "Memcached severs and settings. NuSEO.PHP High Traffic Optimizer (HTO) must be enabled and configured to use Memcached.";

$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_persistent_connection:title' ] = "Enable Memcached persistent connections?";
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_persistent_connection:description' ] = "If set to 'Yes', NuSEO.PHP HTO will open persistent connections to the Memcached server or server farm which are kept open between sessions.";

$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_compression:title' ] = "Enable Compression?";
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_compression:description' ] = "If set to 'Yes', HTO Objects larger than the Compression Threshold will be compressed using zlib.";

$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_compression_threshold:title' ] = "Compression Threshold";
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_compression_threshold:description' ] = "HTO Objects larger than the specified size will be compressed using zlib.";

$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_server_list:title' ] = "Memcached Server List";
$nuseo_language_strings[ 'english' ][ 'Main:memcached_settings:memcached_server_list:description' ] = "Specify the list of Memcached servers available. Enter one server per line specifying one server address and port per line.<br />
    <br />
    Example:<br />
    <br />
    <b style=\"font-size:1.2em\">127.0.0.1:11211</b>
    <br />";



//