<?php 

/************************************************************************\
 *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/


$nuseo_language_strings[ 'english' ][ 'name' ] = "English";

$nuseo_language_strings[ 'english' ][ 'ldm:description' ] = "These settings control NuSEO's Links and Downloads Manager Search Engine Optimization Engine.";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:title' ] = "LDM URLs";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:description' ] = "Format for LDM's Category and File URLs.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_url_base:title' ] = "Links and Downloads Manager URL Base";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_url_base:description' ] = "Enter the Base URL for Links and Downloads Manager. This usually matches the URL Base for vBulletin.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_domain:title' ] = "Links and Downloads Manager Domain Override";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_domain:description' ] = "If Links and Downloads Manager is installed in a subdomain different from your main site, enter it here, otherwise leave this setting blank. This usually matches the URL Base for vBulletin.";

#region Home URL
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_home_url:title' ] = "Rewrite Links and Downloads Manager URL Home";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_home_url:description' ] = "If set to 'Yes', NuSEO will rewrite Links and Downloads Manager Home URL.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_home_format:title' ] = "Links and Downloads Manager Home URL";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_home_format:description' ] = "Enter the Home URL for Links and Downloads Manager.";
#endregion


$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_script:title' ] = "Links and Downloads Manager Script";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_script:description' ] = "Enter the Script for Links and Downloads Manager. Defaults to local_links.php.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_table_prefix:title' ] = "Links and Downloads Manager Table Prefix";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_table_prefix:description' ] = "This is the prefix used by all LDM tables. Leave this unchanged unless you have changed the value of THIS_SCRIPT in local_init.php. Defaults to local_.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_category_urls:title' ] = "Rewrite Links and Downloads Manager Category URLs";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_category_urls:description' ] = "If set to 'Yes', NuSEO will rewrite Links and Downloads Manager Category URLs";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_category_format:title' ] = "Links and Downloads Manager Category URL Format";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_category_format:description' ] = "
		Format to be used for Links and Downloads Manager Category URLs<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Using the <span class=\"ns-bold-italic\">[category_id]</span> tag may result in better performance. 
		If your site has a large number of visitors, numerous categories, or different categories with the same name, it is recommended that the Category URLs Format include the <span class=\"ns-bold-italic\">[category_id]</span> tag.<br/>
		<br/>
		<span class=\"ns-red-bold\">Note: </span>Since Links and Downloads Manager resides within vBulletin's folder, it is highly recommended that all Links And Downloads Manager URLs be prefixed with a common folder, for instance: <span class=\"ns-bold-italic\">downloads/</span>. <br/>
		<br/>
		<span class=\"ns-bold\">Tags available:</span><br/>
		<ul>
		<li>[category_title]</li>
		<li>[category_id]</li>
		</ul>
		<br/>
		";


$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_file_urls:title' ] = "Rewrite Links and Downloads Manager File URLs";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_rewrite_file_urls:description' ] = "If set to 'Yes', NuSEO will rewrite Links and Downloads Manager File URLs";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_file_format:title' ] = "Links and Downloads Manager File URL Format";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_settings:ldm_file_format:description' ] = "
Format to be used for Links and Downloads Manager File URLs.<br/>
<br/>
<span class=\"ns-red-bold\">Note: </span>It is strongly recommended to use the <span class=\"ns-bold-italic\">[file_id]</span> tag, since multiple files can share the same file_title.<br/>
<br/>
<span class=\"ns-bold\">Tags available:</span><br/>
<ul>
<li>[category_title]</li>
<li>[category_id]</li>
<li>[file_title]</li>
<li>[file_id]</li>
</ul>
<br/>";

#region Meta Tags 
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:title' ] = "Meta Tags";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:description' ] = "Settings for Links and Downloads Manager's Keyword and Description Meta Tags.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_replace_keywords:title' ] = "Replace Keywords Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_replace_keywords:description' ] = "If enabled, NuSEO will replace the Keywords Meta Tag in Links and Downloads Manager pages with keywords relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_replace_description:title' ] = "Replace Description Meta Tag?";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_replace_description:description' ] = "If enabled, NuSEO will replace the Description Meta Tag in Links and Downloads Manager pages with a description relevant to the content being shown.";

$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_max_description_length:title' ] = "Maximum Description Length";
$nuseo_language_strings[ 'english' ][ 'ldm:ldm_seo_content:ldm_max_description_length:description' ] = "This number is used to limit the number of characters in the Description Meta Tag.";

#endregion
