<?php 

/************************************************************************\
 *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

defined('NUSEO_SPACE') or die( 'This file is part of NuSEO.PHP Admin and cannot be called directly.' );

error_reporting( E_ALL );

?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>NuSEO.PHP Diagnostic Tools v1.3</title>
	
	
<style>
#title			{ margin: 40px; background:  #FFFFC0; padding: 10px; text-align: center; 
					border: 2px solid blue; font-size: 18px; font-weight: bold; color: blue; 
						-moz-border-radius-bottomleft:10px; -moz-border-radius-bottomright:10px; 
						-moz-border-radius-topleft:10px; -moz-border-radius-topright:10px; }

.info			{ margin: 40px; border: 1px solid #FF0000; background: #FFFFC0; padding: 10px; }
.path-check		{ margin: 40px; border: 1px solid #00FF00; background: #FFFFC0; padding: 10px; }
.bridge-check	{ margin: 40px; border: 1px solid #0000FF; background: #FFFFC0; padding: 10px; }

.nuseo-block-info	{ margin: 40px; border: 1px solid #0000FF; background: #FFFFC0; padding: 10px; 
						-moz-border-radius-bottomleft:10px; -moz-border-radius-bottomright:10px; 
						-moz-border-radius-topleft:10px; -moz-border-radius-topright:10px; }

.nuseo-block-notice	{ margin: 40px; border: 1px solid #0000FF; background: #C0FFFF; padding: 10px; 
						-moz-border-radius-bottomleft:10px; -moz-border-radius-bottomright:10px; 
						-moz-border-radius-topleft:10px; -moz-border-radius-topright:10px; }

h1.warning 		{ margin: 40px; background: #FFFFC0; padding: 10px; text-align: center; width: 800px; border: 1px solid red;
						-moz-border-radius-bottomleft:10px; -moz-border-radius-bottomright:10px; 
						-moz-border-radius-topleft:10px; -moz-border-radius-topright:10px; }

h1				{ font-size: 14px; padding: 0px; margin: 5px 80px 10px 0px; font-weight: bold; 
					border-bottom: 1px solid red; width: 400px; color: rgb(204,0,0); }

.title			{ margin-right: 20px; }
.value			{ font-weight: bold; color: blue; }


.line-success .value { color: green; }

.line-error .value { color: red; border: 1px solid red; }

</style>


</head>

<body>

<div id="title">NuSEO.PHP Diagnostic Tools v1.3</div>

<?php

$current_dir	= dirname( __FILE__ );						// ==> <root>/nuseo/admin
$nuseo_dir		= realpath( $current_dir . "/.." );			// ==> <root>/nuseo
$root_dir		= realpath( $nuseo_dir . "/.." );			// ==> <root>
 

$show_db_info = isset($_REQUEST['dbinfo']) && in_array( strtolower($_REQUEST['dbinfo']), array('yes', '1', 'true', 'show'));
$talk_page_create = isset($_REQUEST['create_talk']) && in_array( strtolower($_REQUEST['create_talk']), array('yes', '1', 'true', 'create'));

if ($show_db_info)
	echo "<h1 class=\"warning\">WARNING: Showing sensitive information about your database. Do not post in a public forum.</h1>";

echo "<h1 class=\"warning\">Do not use this in a public server. Server Information could be exposed.</h1>";

//----------------------------------------------------------------------------------------------------------------- Info
echo "<div class=\"nuseo-block-info\"><h1>OS, Server and PHP information</h1>";

output_row("PHP version...", phpversion() );
output_row("Zend Engine version...", zend_version() );
output_row("Server OS ...", php_uname() );
output_row("PHP SAPI version ...", php_sapi_name() );
output_row("Server Software ...", isset($_SERVER["SERVER_SOFTWARE"]) ? $_SERVER["SERVER_SOFTWARE"] : 'N/A' );
$apache_version = function_exists('apache_get_version') ? trim(apache_get_version()) : '';
output_row("Apache version ...", $apache_version ? "'$apache_version'" : 'N/A' );

output_row("zlib.output_compression...", ini_get('zlib.output_compression') ? 'true' : 'false');
output_row("session.auto_start..", ini_get('session.auto_start')  );
output_row("session.save_handler...", ini_get('session.save_handler') );
output_row("session_name...", session_name() );
output_row("session_id...", session_id() );
output_row("session.save_path...", ini_get('session.save_path') );
if (ini_get('session.save_path') && !is_writable(ini_get('session.save_path')))
{	// test if session save path is writable
	output_row("ini_get('session.save_path') permissions...", 'is not writable', 'error' );
}

output_row("session.use_cookies...", ini_get('session.use_cookies') );
output_row("session.use_only_cookies...", ini_get('session.use_only_cookies') );
output_row("session.cookie_path...", ini_get('session.cookie_path') );
output_row("session.cookie_domain...", ini_get('session.cookie_domain') );
//output_row("url_rewriter.tags...", ini_get('url_rewriter.tags') );

output_row("safe_mode...", ini_get('safe_mode') ? 'true' : 'false');
output_row("open_basedir...", ini_get('open_basedir') );
output_row("disable_functions...", ini_get('disable_functions') );
output_row("disable_classes...", ini_get('disable_classes') );
output_row("safe_mode_include_dir...", ini_get('safe_mode_include_dir') );
output_row("safe_mode_exec_dir...", ini_get('safe_mode_exec_dir') );

output_row("magic_quotes_gpc...", get_magic_quotes_gpc() );
output_row("magic_quotes_runtime...", ini_get( "magic_quotes_runtime" ) );
output_row("magic_quotes_sybase...", ini_get( "magic_quotes_sybase" ) );
output_row("memory_limit...", ini_get( 'memory_limit' ) );

output_row("display_errors...", ini_get('display_errors') );
output_row("log_errors...", ini_get('log_errors') );
output_row("log_errors_max_len...", ini_get('log_errors_max_len') );
output_row("error_log...", ini_get('error_log') );


if (function_exists( 'apache_get_modules' ))
	output_row("Apache Modules....", implode( ', ', apache_get_modules() ) );

echo "<br/>";

output_row("Current directory...", getcwd() );

output_row("Admin Directory...", $current_dir );
output_row("NuSEO Directory...", $nuseo_dir );
output_row("Web Root Directory...", $root_dir );

echo "<br/>\n</div>\n";


//--------------------------------------------------------------------------------------------------------------- Cookies
echo "<div class=\"nuseo-block-info\">\n<h1>Cookies and Browser Information</h1>";
echo nl2br(var_export($_COOKIE, true));
echo "<br/>";
output_row("User Agent ...", $_SERVER["HTTP_USER_AGENT"]);
output_row("User IP ...", $_SERVER["REMOTE_ADDR"]);
echo "<br/></div>";

//--------------------------------------------------------------------------------------------------------------- Session
echo "<div class=\"nuseo-block-info\">\n<h1>Session</h1>";

session_cache_limiter( 'private, must-revalidate' );
@session_start();

echo nl2br(var_export($_SESSION, true));
echo "<br/>";
echo "</div>";



//------------------------------------------------------------------------------------------------------------- Nuseo Config 

$nuseo_config_file_name = $nuseo_dir . "/nuseo_config.php";
echo "<div class=\"nuseo-block-info\">\n<h1>$nuseo_config_file_name</h1>";


$nuseo_config_file_content =  file_get_contents( $nuseo_config_file_name );

//$config_file_content = highlight_file( $nuseo_config_file_name );

if ( !$nuseo_config_file_content )
{
    echo "CONFIG FILE NOT FOUND!<br/>
	If this is a new installation, nuseo_config.php will be created the first time NuSEO.PHP is run.";
}
else
{
    if ( isset( $nuseo_config ) )
    {
        //echo "here";
        $find = array( "'" . $nuseo_config[ 'log_db_username' ] . "'",
                       "'" . $nuseo_config[ 'log_db_name' ]     . "'",
                       "'" . $nuseo_config[ 'log_db_password' ] . "'" );
        
        $nuseo_config_file_content = str_replace( $find, "'****'", $nuseo_config_file_content );
    }
    $nuseo_config_file_content = highlight_string( $nuseo_config_file_content );
    echo $nuseo_config_file_content;
}

echo "<br/>";
echo "</div>";


//------------------------------------------------------------------------------------------------------------- main .htaccess
$main_htaccess_filename = $root_dir . "/.htaccess"; 
echo "<div class=\"nuseo-block-info\">\n<h1>.htaccess content: $main_htaccess_filename</h1><BR>";

$htaccess_file_content = file_get_contents( $main_htaccess_filename );

if ( $htaccess_file_content )
{
    
    echo "<pre>";
    echo $htaccess_file_content;
    echo "</pre>";
}
else
{
    echo "FILE NOT FOUND!";
}

echo "<br/>";
echo "</div>";

//------------------------------------------------------------------------------------------------------------- others .htaccess
echo "<div class=\"nuseo-block-info\">\n<h1>Searching for other .htaccess files</h1>";

$other_htaccess_found = false;

foreach( glob( $root_dir  . "*", GLOB_ONLYDIR ) as $dir )
{
    $real_dir = realpath( $dir );
    echo "searching in $real_dir<BR>";
    $htaccess_filename = $real_dir . "\\.htaccess"; 
    if ( file_exists( $htaccess_filename  ) )
    {
        echo "<br/>Found: <b>{$htaccess_filename}</b>...<BR />";
		echo "	<div class=\"nuseo-block-notice\">\n";
		echo "		<h1>$htaccess_filename</h1>\n";
        echo "			<pre>";
        echo file_get_contents( $htaccess_filename );
        echo "			</pre>";
		echo "	</div>";
        echo "<br />";
        $other_htaccess_found |= true;
    }
}

if ( !$other_htaccess_found )
{
   echo "No other .htaccess found";
}
echo "<BR/>";
echo "</div>";

//--------------------------------------------------------------------------------------------------------------- $_SERVER
echo "<div class=\"nuseo-block-info\">\n<h1>\$_SERVER</h1>";

echo nl2br(var_export($_SERVER, true));
echo "<br/>";
echo "</div>";



//--------------------------------------------------------------------------------------------------------------- IonCube
echo "<div class=\"nuseo-block-info\">\n<h1>PHP Extensions</h1>";

if (extension_loaded('ionCube Loader'))
{
	output_row("IonCube Loader...", 'INSTALLED', 'success' );
}
else
{
	output_row("IonCube Loader...", 'NOT FOUND', 'error' );
	echo "<br/> Notice that IonCube may be installed even if NuSEO.PHP Diag cannot find the loader.<br/>
	To verify if IonCube is installed on your server, copy the content of the tools directory into nuseo/admin, and navigate to 
	www.yourdomain.com/nuseo/admin/ioncube-loader-helper.php in your browser, this page will identify if IonCube is installed.";
}

$memcache_installed = class_exists('Memcache');
output_row("Memcache Extension...", $memcache_installed ? 'INSTALLED' : 'NOT FOUND', $memcache_installed ? 'success' : '' );

$eAccel_installed = function_exists('eaccelerator_get');
output_row("eAccelerator Extension...", $eAccel_installed ? 'INSTALLED' : 'NOT FOUND', $eAccel_installed ? 'success' : '' );

echo "<br/>";
echo "</div>";

//--------------------------------------------------------------------------------------------------------------- 
die;


function output_row( $title, $value, $type='normal' )
{
	$title .= "&nbsp;&nbsp;";
	switch ($type)
	{
		default:
			echo "<div class=\"line\"><span class=\"title\">$title</span><span class=\"value\">$value</span></div>\n";
			break;
		case 'nonl':
			echo "<span class=\"line-nonl\"><span class=\"title\">$title</span><span class=\"value\">$value</span></span>\n";
			break;
		case 'error':
			echo "<div class=\"line-error\"><span class=\"title\">$title</span><span class=\"value\">$value</span></div>\n";
			break;
		case 'success':
			echo "<div class=\"line-success\"><span class=\"title\">$title</span><span class=\"value\">$value</span></div>\n";
			break;
	}
}



?>
</table>
</body>
</html>