<?php 

/***********************************************************************
* *
 * NuSEO.PHP
 * 
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 * This file may not be redistributed in whole or significant part.
 * http://www.nuhit.com | http://www.nuhit.com/license.html
 *
\************************************************************************/

error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
@ini_set( 'memory_limit', -1 );







/***********************************************************************
* * Start File: nuhit_lib_debug.h
 * Description: nuhit_lib_debug.h contains NuHIT's Debug Library for nuhit_php_compiler
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
 ************************************************************************/









	
	


//--------------------------------------------------------------------------
// nu_print and nu_print_r are the release and debug version of print and print_r
// These macros/functions always generate code
//--------------------------------------------------------------------------

















































/***********************************************************************
* * End File: nuhit_lib_debug.h
 ************************************************************************/





/***********************************************************************
* * Start File: nuseo_common.h
 * Description: Contains common nuhit_php_compiler declarations for NuSEO.PHP
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/








  
  


if( !function_exists( "nu_microtime" ) )
{
    function nu_microtime()
    {
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }
}












































/***********************************************************************
* * End File: nuseo_common.h
\************************************************************************/



if ( !isset( $nuseo_dir ) )
{
	$nuseo_dir = realpath( dirname(  __FILE__ ) . '/..' );
}

// Constants
define( 'NUSEO_ADMIN_CP', 1 );

define( 'NUSEO_PHP_CONFIG_BEGIN_SECTION', "// begin section:");
define( 'NUSEO_PHP_CONFIG_END_SECTION', "// end section");
define( 'NUSEO_PHP_CONFIG_SECTION_ENABLE_DISABLE', " enable/disable modules");

$nuseo_var_index = 1;
define( 'group_bits',			$nuseo_var_index++ );
define( 'setting_bits',			$nuseo_var_index++ );

define( 'tab_class_main',		$nuseo_var_index++ );
define( 'tab_class_modules',	$nuseo_var_index++ );
define( 'tab_class_help',		$nuseo_var_index++ );

define( 'active_tab_name',		$nuseo_var_index++ );

define( 'redir_url',			$nuseo_var_index++ );

define( 'message_type',			$nuseo_var_index++ );
define( 'message_text',			$nuseo_var_index++ );
define( 'message_class',		$nuseo_var_index++ );

define( 'old_password_display',	$nuseo_var_index++ );

define( 'css_path',				$nuseo_var_index++ );
define( 'js_path',				$nuseo_var_index++ );
define( 'img_path',				$nuseo_var_index++ );

define( 'top',		    		$nuseo_var_index++ );
define( 'bottom',				$nuseo_var_index++ );

define( 'admin_script',			$nuseo_var_index++ );
define( 'http_host',			$nuseo_var_index++ );
define( 'mod',			        $nuseo_var_index++ );
define( 'group',			    $nuseo_var_index++ );



// Values for $nuseo_admin_content[ message_type ]
define( 'MSG_TYPE_NONE',			'none' );
define( 'MSG_TYPE_INFO',			'info' );
define( 'MSG_TYPE_ERROR',			'error' );

//

// // empty config array, since it may have been inited in .htaccess call to nuseo.php
if (isset( $nuseo_config ) && isset($nuseo_dir) && !file_exists( $nuseo_dir . "/nuseo_config.php" ))
{
	$nuseo_config_dir = isset($nuseo_config['dir']) ? $nuseo_config['dir'] : false;
	$nuseo_config = array();		
	$nuseo_config['dir'] = $nuseo_config_dir;		// except nuseo's directory.
}

// NuSEO Admin main()

if ( get_magic_quotes_gpc() )
{     
    // undo magic quotes
    nuseo_strip_slashes( $_GET );
    nuseo_strip_slashes( $_POST );
    nuseo_strip_slashes( $_COOKIE );
    nuseo_strip_slashes( $_REQUEST );
}


function nuseo_strip_slashes( &$var )
{
    if ( is_array($var) ) 
    {
        foreach ($var AS $k => $v)
        {
            if (is_string($v))
            {
                $var["$k"] = stripslashes( $v );
            }
            else if (is_array($v))
            {
                nuseo_strip_slashes( $var["$k"] );
            }
        }
    }
}



require_once( $nuseo_dir . "/nuseo" . ".php" );
//nuseo_require_once( $nuseo_config['dir'] . "/admin/nuseo_admin_config_file" );
//nuseo_require_once( $nuseo_config['dir'] . "/admin/nuseo_admin_render" );


$nuseo_language_strings = array();
if ( !isset( $nuseo_config[ 'language' ] ) )
{
	$nuseo_config[ 'language' ] = "english";
}








/***********************************************************************
* * Start File: nuseo_admin_config_file.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

//----------------------------------------------------------------------
// Function: nuseo_admin_config_file_read
//	 Read the full file and return an array of lines
//
// Arguments:
//  &$file_name - file name 
//
//	Return:
//    array of lines
//----------------------------------------------------------------------
function nuseo_admin_config_file_read( &$file_name )
{
	$result = array();
	
	if ( file_exists( $file_name ) )
	{
		$file = fopen( $file_name, "r");
		
		while ( !feof( $file ) )
		{
			$result[] = rtrim( fgets( $file, 1024 ));
		}
		fclose( $file );
	}
	return $result;
}

function nuseo_admin_config_file_write( &$file_name, $lines )
{
	$file = fopen( $file_name, "w" );
	fwrite( $file, implode( "\n", $lines ) );
	fclose( $file );
}

function nuseo_admin_config_set_section( &$lines, $section_name, &$section_new_lines )
{
	$section_begin = NUSEO_PHP_CONFIG_BEGIN_SECTION . $section_name;
	$section_end = NUSEO_PHP_CONFIG_END_SECTION;
	
	$line_number = 0;
	$first_line = count( $lines );
	$section_length = 0;
	
	//find section range
	foreach( $lines as $line )
	{
		if ( 0 === strpos( $line, $section_begin ) )
		{
			//the first line is the previous line
			//due to the contract of sections where 
			//it is always enclosed by two lines of comments
			$first_line = $line_number - 1;
			$section_length = 2;
			for( $i = $line_number + 1; $i < count( $lines ); $i++)
			{
				$section_length++;
				if ( 0 === strpos( $lines [ $i ], $section_end ))
				{
					//include the closing line of comments
					$section_length++;
					break;
				}
			}  
			break;
		}
		$line_number++;
	}	
	
	//replace old section by new section
	array_splice( $lines, $first_line, $section_length, $section_new_lines );
}

function nuseo_admin_config_file_save_section( &$file_name, $section_name, &$section_new_lines, $do_save )
{
	$lines = nuseo_admin_config_file_read( $file_name );
	
	if ( count( $lines) > 0 ) 
	{
		nuseo_admin_config_set_section( /*ref*/$lines, $section_name, $section_new_lines );
		if ( true === $do_save )
		{
			nuseo_admin_config_file_write( $file_name, $lines );
		}
	}
}

//----------------------------------------------------------------------
// Function: nuseo_admin_config_file_read_section
//
// Arguments:
//  &$file_name - file name 
//	$section_name - section name to look for 
//  &$first_line - used to return the first line of the section inside the file, -1 section not found
//
//	Return:
//    Array of lines with the section
//----------------------------------------------------------------------
function nuseo_admin_config_file_read_section( &$file_name, $section_name, &$first_line )
{
	//the section format is as follow:
	// first line of comments
	// second line starts with // begin section: <section name> [optional comment]
	// [section content]
	// end section [optional comment]
	// last line comments
	
	$result = array();
	
	$section_begin = NUSEO_PHP_CONFIG_BEGIN_SECTION . $section_name;
	$section_end = NUSEO_PHP_CONFIG_END_SECTION;
	
	$previous_line = "";
	$first_line = -1;
	$line_number = 0;
	
	$file = fopen( $file_name, "r");
	
	while ( !feof( $file ) )
	{
		$line = rtrim( fgets( $file, 1024 ));
		
		if ( 0 === strpos( $line, $section_begin ) )
		{
			//add previous comment line
			$result[] = $previous_line;
			$result[] = $line;
			
			$first_line = $line_number;
			
			while ( !feof( $file ) )
			{
				$line = rtrim( fgets( $file, 1024 ));
				$result[] = $line;
				if ( 0 === strpos( $line, $section_end ))
				{
					//add last comment line
					$result[] =	rtrim( fgets( $file, 1024 ) );
					break;
				}
				$line_number++;
			}
			break;
		}
		$previous_line = $line;
		$line_number++;
	}
	fclose( $file );
	
	return $result;
}

function nuseo_admin_process_save_enable_disable()
{
	global $nuseo_modules, $nuseo_config, $nuseo_admin_content;
	
	nuseo_admin_load_modules_settings_definition( $nuseo_modules );
	
	$config_filename = $nuseo_config['dir'] . "/nuseo_config.php";	
	
	$config_lines = nuseo_admin_config_file_read( $config_filename );
	
	$enable_lines = array();
	
	$enable_lines[] = "//******************************";
	$enable_lines[] = NUSEO_PHP_CONFIG_BEGIN_SECTION . NUSEO_PHP_CONFIG_SECTION_ENABLE_DISABLE;
	
	$nuseo_modules_local = $nuseo_modules;		// avoid iterator confusion due to PHP bug.
	foreach ( $nuseo_modules_local as $module )
	{
		//get the module name from the file name        
		$matches = false;
		
		if (!preg_match('#^nuseo_(.*).xml$#i', basename( $module['file_name'] ), $matches))
			continue;
		
		$module_name = strtolower( $matches[1] );        
		
		$flag_name = strtolower( str_replace( " ", "_", $module_name) ) . "_enabled";
		
		$flag_value= ( isset( $_REQUEST[ "$flag_name" ] ) && ( 1 == $_REQUEST[ "$flag_name" ] ) ) ? "true" : "false";
		
		$enable_lines[] = "\$nuseo_config[ '{$flag_name}' ] = {$flag_value};";
	}
	
	$enable_lines[] = "";
	
	$enable_lines[] = NUSEO_PHP_CONFIG_END_SECTION;
	$enable_lines[] = "//******************************";
	
	nuseo_admin_config_set_section( $config_lines, NUSEO_PHP_CONFIG_SECTION_ENABLE_DISABLE, $enable_lines);
	
	nuseo_admin_config_file_write( $config_filename, $config_lines);
	
	// Let's save the file again, in case a module was enable to add defaults
	nuseo_admin_process_save( true );

	header( "Location: {$nuseo_admin_content[admin_script]}?action=edit&tab=modules" );		// FIXME: Shouldn't it use an absolute URL?
	exit;
}

function nuseo_admin_process_save( $force_modified )
{
	global $nuseo_modules, $nuseo_config;
	// load all definitions
	nuseo_admin_load_main_settings_definition();

	nuseo_admin_load_modules_settings_definition( $nuseo_modules );

	// now build config files...
	$config_modified = $force_modified;
	$config_output = array();
	
	$nuseo_modules_local = $nuseo_modules;		// avoid iterator confusion due to PHP bug.
	foreach( $nuseo_modules_local as $module_info )
	{
		if ( isset( $module_info['module_type'] ) && ($module_info['module_type'] == 'module_list') )
		{
			continue;
		}
		
		$module_modified = nuseo_admin_process_save_module( $module_info, $config_output );
		if ($module_modified)
		{
			$config_modified = true;
		}
	}
    
	// save config file
	if ($config_modified)
	{
		$config_output_str = implode( '', $config_output );
		
		eval( '$config_header = "' . nuseo_fetch_template( 'config_header' ) . '";' );
		eval( '$config_footer = "' . nuseo_fetch_template( 'config_footer' ) . '";' );
		
		$config_filename = $nuseo_config['dir'] . "/nuseo_config.php";
		
		$config_enable_disable_section = array();
		if (file_exists($config_filename))
		{
			// make sure this file is writeable
			if (!is_writable( $config_filename ))
			{	// try to change file permissions
				chmod( $config_filename, 0777 );
			}
			$enabled_first_line = 0;
			$config_enable_disable_section = nuseo_admin_config_file_read_section( $config_filename, " enable/disable modules", $section_first_line );
		}
		$fp = fopen( $config_filename, "w" );
		if ($fp)
		{
			fwrite( $fp, $config_header );
			fwrite( $fp, $config_output_str );
			
			if ( count( $config_enable_disable_section) > 0)
			{
				fwrite( $fp, implode( "\n", $config_enable_disable_section ));
			}
			
			fwrite( $fp, $config_footer );
			fclose( $fp );
			
			$_SESSION[ 'message_type' ] = MSG_TYPE_INFO;
			if (isset( $_SESSION[ 'message_text' ] ))
				$_SESSION[ 'message_text' ] .= "... Settings saved.";
			else
				$_SESSION[ 'message_text' ] = "Settings saved.";
		}
		else	// else could not write config file
		{
			$_SESSION[ 'message_type' ] = MSG_TYPE_ERROR;
			$_SESSION[ 'message_text' ] = "Could not write to config file: $config_filename.\nVerify file permissions.";
		}
	}
	
	// Clear license error flags, if needed, it can be retrieved again
	unset( $_SESSION['license_retrieval_failed'], $_SESSION['license_retrieval_error'] );

	// redirect to Admin CP
	$tab_name = isset( $_REQUEST['tab'] ) ? htmlentities( $_REQUEST['tab'] ) : 'main';
	$url = nuseo_admin_get_admin_script_url();
	$url .= "?tab=$tab_name";
    
    if ( isset( $_REQUEST['group'] ) && $_REQUEST['group'] != "" )
    {
        $url .= "&group=" . $_REQUEST['group'];
    }
    
    if ( isset( $_REQUEST['mod'] ) && $_REQUEST['mod'] != "" )
    {
        $url .= "&mod=" . $_REQUEST['mod'];
    }    
    
	header( "Location: $url" );
}

function nuseo_admin_get_setting_group_strings( $module_name, $group_name, /*ref*/&$setting_group )
{
    global $nuseo_config, $nuseo_language_strings;
   
    $language = $nuseo_config[ 'language' ];
    
    $title_key = $module_name . ":" .$group_name . ':title';
    if ( !isset( $setting_group['title'] ) )
    {
        $setting_group['title'] = $nuseo_language_strings[ "{$language}" ][ "{$title_key}" ];
    }
    else
    {
        $file = fopen( $nuseo_config[ 'dir' ] . '/languages/' . $language . 'groups.txt', "a+" );
        $line = "\$nuseo_language_strings[ '" .$language ."' ][ '" . $title_key . "' ] = '" . addcslashes( $setting_group['title'], "'\\" ) . "';";
        fwrite( $file,  $line . "\n" );
        fclose( $file );
    }
    
    $description_key = $module_name . ":" .$group_name . ':description';
    if ( !isset( $setting_group['description'] ) )
    {
        $setting_group['description'] = $nuseo_language_strings[ "{$language}" ][ "{$description_key}" ];
    }
    else
    {
        $file = fopen( $nuseo_config[ 'dir' ] . '/languages/' . $language . 'groups.txt', "a+" );
        $line = "\$nuseo_language_strings[ '" . $language . "' ][ '" . $description_key . "' ] = '" . addcslashes( $setting_group['description'], "'\\" ). "';";
        fwrite( $file, $line . "\n");
        fclose( $file );
    }
    
}

function nuseo_admin_get_setting_item_strings( $module_name, $group_name, $setting_name, /*ref*/&$setting_group )
{
    global $nuseo_config, $nuseo_language_strings;
   
    $language = $nuseo_config[ 'language' ];
        
    $title_key = "{$module_name}:{$group_name}:{$setting_name}:title";
    
    if ( !isset( $setting_group['title'] ) )
    {
        $setting_group['title'] = $nuseo_language_strings[ "{$language}" ][ "{$title_key}" ];
    }
    else
    {
        $file = fopen( $nuseo_config[ 'dir' ] . '/languages/' . $language . 'items.txt', "a+" );
        $line = "\$nuseo_language_strings[ '" . $language . "' ][ '" . $title_key . "' ] = '" . addcslashes( $setting_group['title'], "'\\" ). "';";
        fwrite( $file,  $line . "\n" );
        fclose( $file );
    }
    
    $description_key = "{$module_name}:{$group_name}:{$setting_name}:description";
    if ( !isset( $setting_group['description'] ) )
    {
        $setting_group['description'] = $nuseo_language_strings[ "{$language}" ][ "{$description_key}" ];
    }
    else
    {
        $file = fopen( $nuseo_config[ 'dir' ] . '/languages/' . $language . 'items.txt', "a+" );
        $line = "\$nuseo_language_strings[ '" . $language . "' ][ '" . $description_key . "' ] = '" . addcslashes( $setting_group['description'], "'\\" ) . "';";
        fwrite( $file, $line . "\n");
        fclose( $file );
    }
    
}


function nuseo_admin_process_save_module( &$module_info, &$config_output )
{
	global $nuseo, $nuseo_config, $nuseo_language_strings;
	$module_modified = false;
	
	$module_setting_groups = nuseo_admin_node_as_array( $module_info, 'setting_groups' );
	
	$module_name = $module_info['module_name'];
	
	$module_display_name = $module_info['module_display_name'];
	
	$module_filename = $module_info['file_name'];
	
	$config_output[] = "
//---------------------------------------------------
// $module_display_name Module
//
";
	
	foreach ( $module_setting_groups as $setting_group )
	{
        
        $group_name = $setting_group['name'];
        
        nuseo_admin_get_setting_group_strings( $module_name, $group_name, /*ref*/$setting_group );

        $group_title = $setting_group['title'];
        $group_description = $setting_group['description'];
       
		
		$config_output[] = "
	// -------------------------------------
	// {$setting_group['title']}
	// -------------------------------------
	
";

		// generate group settings
		$group_fields = array();
		
		$setting_group_defs = nuseo_admin_node_as_array( $setting_group, 'setting' );
		
		foreach ( $setting_group_defs as $setting )
		{
            
			$setting_name = isset($setting['varname'])		? $setting['varname'] : '';
            
            nuseo_admin_get_setting_item_strings( $module_name, $group_name, $setting_name, /*ref*/ $setting  );
            
            $setting_title = $setting['title'];
            $setting_description = $setting['description'];
                       
			$setting_datatype		= isset($setting['datatype'])		? strtolower($setting['datatype']) : '';
			$setting_defaultvalue	= isset($setting['defaultvalue'])	? $setting['defaultvalue'] : '';
			$setting_template		= isset($setting['template'])		? $setting['template'] : 'text';
			$setting_validator		= isset($setting['validator'])		? $setting['validator'] : false;
			
			if (!$setting_datatype)
				continue;

			if (isset( $nuseo_config[ $setting_name ] ))
			{
				$setting_value			= $nuseo_config[ $setting_name ];
			}
			else
			{
				if ($setting_datatype == 'array')
				{
					$setting_value		= nuseo_admin_string_to_array( $setting_defaultvalue );
				}
				else
				{
					$setting_value		= $setting_defaultvalue;
				}
			}
			
			// read from $_POST
			$field_name = 'setting_' . $setting_name;
			if (isset( $_POST[ $field_name ] ))
			{
				$setting_value = $_POST[ $field_name ];
				
				if ($setting_value == 'custom')
				{
					$field_name = 'custom_' . $setting_name;
					if (isset( $_POST[ $field_name ] ))
						$setting_value = $_POST[ $field_name ];
				}
				$module_modified = true;
			}

			// Call validator, if any
			if ($setting_validator)
            {
				$setting_validator( $setting_name, $setting_value );
            }
            
			// Output Setting Title as a comment.
			$setting_title	= strip_tags( $setting_title );

			$config_output[] = "\t\t// $setting_title\n";

			// do type casting			
			if ($setting_datatype == 'boolean')
			{
				$setting_value_str = $setting_value ? 'true' : 'false';
				$nuseo_config[ $setting_name ] = $setting_value;
			}
			else if ($setting_datatype == 'number')
			{
				$setting_value_str = is_numeric( $setting_value ) ?  $setting_value : 0;
				$nuseo_config[ $setting_name ] = $setting_value;
			}
			else if ($setting_datatype == 'array')
			{
				$setting_value_str = 'array( ' . nuseo_admin_array_to_string( $setting_value, true ) . ')';
				$nuseo_config[ $setting_name ] = nuseo_admin_string_to_array( $setting_value );
			}
			else
			{
				$nuseo_config[ $setting_name ] = $setting_value;
				$setting_value_str	= addcslashes( trim( $setting_value ), "'\\" );	// do not escape "
				$setting_value_str = "'" . $setting_value_str . "'";
			}
			
			// escape $setting_name
			$setting_name	= addcslashes( $setting_name, "'\\" );

			// Output setting value
			$config_output[] = "\t\t\$nuseo_config[ '$setting_name' ] = $setting_value_str;\n\n";
		}
		
		$config_output[] = "\n\n";
	}
	
	return $module_modified;	
}

function nuseo_admin_string_to_array( $array_str )
{
	if (is_array( $array_str ))
		return $array_str;
	
	$ret_array = array();
	
	$lines = explode( "\n", str_replace( "\r\n", "\n", $array_str ) );
	
	foreach ($lines as $line)
	{
		$line = trim($line);
		if (!$line)
			continue;		// empty line
		
		if (substr( $line, 0, 2 ) == '//')
			continue;		// comment
		
		$pair = explode( '=>', $line );
		
		if (count( $pair ) > 1)
		{
			$key = trim( array_shift( $pair ) );
			$value = trim( implode( '=>', $pair ) );
			
			$ret_array[ $key ] = $value;
		}
		else
			$ret_array[] = $line;
	}
	
	return $ret_array;
}

function nuseo_admin_array_to_string( $value_array, $enclose_in_slashes )
{
	if (!is_array( $value_array ))
	{	// we were passed a string, convert it back to array
		$value_array = nuseo_admin_string_to_array( $value_array );
	}
	
	$is_keyed_array = nuseo_admin_is_keyed_array( $value_array );
	
	$ret_string = '';
	
	foreach ( $value_array as $key => $value )
	{
		if ($enclose_in_slashes)
		{
			$key = "'" . addcslashes( trim($key), "'\\" ) . "'";
			$value = "'" . addcslashes( trim( $value ), "'\\" ) . "',";
			
			$ret_string .= "\t\t\t";
		}
		if ($is_keyed_array)
			$ret_string .= $key . ' => ' . $value . "\n";
		else
			$ret_string .= $value . "\n";
	}
	
	return $ret_string;
}

function nuseo_admin_is_keyed_array( $arr )
{
	$keys = array_keys( $arr );
	$keycount = count( $keys );
	$is_keyed_array = false;
	for ($i=0; $i<$keycount; $i++)
	{
		if ( !is_numeric($keys[ $i ]) || ($keys[ $i ] != $i) )
		{
			$is_keyed_array = true;
			break;
		}
	}
	return $is_keyed_array;
}

function nuseo_admin_validate_config()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	$error_msg = false;
	$error_tab = false;
	
	
	// check logging settings
	if ($nuseo_config['log_enabled'])
	{
		if ($nuseo_config['log_type'] == 'db')
		{
			// Check DB
			nuseo_connect_to_log_db();

			if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
			{
				if ($nuseo_config['log_404'])		// then check the nuseo_page_not_found table
				{
					$table_ok = nuseo_admin_check_not_found_table();
					if (!$table_ok)
					{
						nuseo_admin_create_not_found_table();
						$table_ok = nuseo_admin_check_not_found_table();
						if (!$table_ok)
						{
							$error_msg = "'Save Log to Database' selected. Error creating nuseo_page_not_found table.<br/>
									Please verify that the MySQL DB user specified in nuseo_config.php has the correct permissions in the MySQL server.";
							$error_tab = 'main';
						}
					}
				}
				if ( !empty($nuseo_config['log_db_errors']) )		// then check the nuseo_log table
				{
					$table_ok = nuseo_admin_check_log_table();
					if (!$table_ok)
					{
						nuseo_admin_create_log_table();
						$table_ok = nuseo_admin_check_log_table();
						if (!$table_ok)
						{
							$error_msg = "'Save Log to Database' selected. Error creating nuseo_log table.<br/>
									Please verify that the MySQL DB user specified in nuseo_config.php has the correct permissions in the MySQL server.";
							$error_tab = 'main';
						}
					}
				}
			}
			else
			{
				$error_msg = "'Save Log to Database' selected. Error connecting to MySQL DB.<br/>
						Please verify the server name and login settings in nuseo_config.php.";
				$error_tab = 'main';
			}
		}
		else
		{
			// check that we can write to $nuseo_config['log_file_location']
			$nuseo_config['log_file_location'] = trim( $nuseo_config['log_file_location'] );
			if (!$nuseo_config['log_file_location'])
			{
				global $nuseo_dir;
				$nuseo_config['log_file_location'] = $nuseo_dir . '/logs';
			}
			
			// replace backslashes for forward slashes
			$nuseo_config['log_file_location'] = str_replace( '\\', '/', $nuseo_config['log_file_location'] );
				
			// check if it ends in '/'
			if ($nuseo_config['log_file_location'] && (substr($nuseo_config['log_file_location'], -1) == '/'))
			{
				$nuseo_config['log_file_location'] = substr( $nuseo_config['log_file_location'], 0, -1 );
			}

			$log_file_location = $nuseo_config['log_file_location'];
			if (!file_exists( $log_file_location ))
			{
				$error_msg = "ERROR: 'Save Log to File' selected, however, the log location doesn't exist: $log_file_location.";
				$error_tab = 'main';
			}
			else	// else, file exists, let's check if we can write
			{
				if (!is_writable($log_file_location))
				{
					$error_msg = "ERROR: 'Save Log to File' selected, however, the log location is not writeable: $log_file_location.";
					$error_tab = 'main';
				}
			}
		}
	}
	
	// validate .htaccess
	nuseo_admin_validate_htaccess();
	
	if ($error_msg)
	{
		nuseo_admin_add_user_message( $error_msg, MSG_TYPE_ERROR );
	
		// if an error is reported, and a tab is preferred, switch to it.
		if ($error_tab)
		{
			$_REQUEST['tab'] = $error_tab;
		}	
	}
}

function nuseo_admin_validate_htaccess()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (!empty( $nuseo_config['demo_mode'] ))
		return;		// in demo mode, we don't check for htaccess
	
	$sapi_type = php_sapi_name();
	$is_apache = strpos( $sapi_type, 'apache' ) !== false;
	
	if ($is_apache)
	{
		$htaccess_file_name = realpath( $nuseo_config['dir'] . '/..' ) . '/.htaccess';
		
		if (!file_exists( $htaccess_file_name ))
		{
			$error_msg = "<span class=\"ns-red-bold\"><b>.htaccess</b> not found (<b>$htaccess_file_name</b>)</span>. NuSEO.PHP will be disabled until NuSEO.PHP's .htaccess is installed.<br/>
							<br/>
							Please refer to NuSEO.PHP's installation instructions for more information.";
			nuseo_admin_add_user_message( $error_msg, MSG_TYPE_INFO );
		}
		else	// .htaccess exists, check if nuseo.php is referenced in it.
		{
			$nuseo_found_in_htaccess = false;

			$htaccess_content = file_get_contents( $htaccess_file_name );

			$htaccess_lines = explode( "\n", $htaccess_content );

			foreach ($htaccess_lines as $line_iter)
			{
				$line_iter = trim( $line_iter );
				if (strlen( $line_iter ) > 0)
				{
					if ($line_iter[0] == '#')
						continue;			// this is a comment line
						
					if (strpos( $line_iter, 'nuseo.php' ) || strpos( $line_iter, 'nuseo_d.php' ))
					{
						$nuseo_found_in_htaccess = true;
					}
				}
			} // foreach
			
			if (!$nuseo_found_in_htaccess)
			{
				$error_msg = ".htaccess found ($htaccess_file_name). However, <span class=\"ns-red-bold\">NuSEO.PHP's rules were not found</span>. NuSEO.PHP will not operate until these rules are added to the .htaccess file.<br/>
							<br/>
							Please refer to NuSEO.PHP's installation instructions for more information.";
				nuseo_admin_add_user_message( $error_msg, MSG_TYPE_INFO );
			}
		}
	} // if is_apache
}

function nuseo_admin_check_not_found_table()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
	{
		$table_ok = nuseo_admin_log_table_exists( 'nuseo_page_not_found' );
	}
	else
	{
		$table_ok = false;
	}
	
	return $table_ok;
}

function nuseo_admin_check_log_table()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
	{
		$table_ok = nuseo_admin_log_table_exists( 'nuseo_log' );
	}
	else
	{
		$table_ok = false;
	}
	
	return $table_ok;
}

function nuseo_admin_log_table_exists( $table_name )
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (!isset($nuseo['log_db_conn']) || !$nuseo['log_db_conn'])
	{
		nuseo_connect_to_log_db();
	}
	
	if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
	{
		$sql = "SHOW TABLES LIKE '$table_name'";
		$table_exists = $nuseo['log_db_conn']->get_one( $sql );
	}
	else
		$table_exists = false;
		
	return $table_exists;
}

function nuseo_admin_create_not_found_table()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
	{
		$sql = "CREATE TABLE IF NOT EXISTS `nuseo_page_not_found` (
				`page_id`		INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
				`url`			VARCHAR(255) NOT NULL,
				`referrer`		VARCHAR(255) NOT NULL,
				`ip`			VARCHAR(255) NOT NULL,
				`useragent`		VARCHAR(255) NOT NULL,
				`dateadded`		DATETIME NOT NULL,
				KEY `nuseo_page_not_found_url` (`url`)
				)";
		$nuseo['log_db_conn']->execute_write( $sql );
	}	
}

function nuseo_admin_create_log_table()
{
	global $nuseo_modules, $nuseo_config, $nuseo;
	
	if (isset($nuseo['log_db_conn']) && $nuseo['log_db_conn'])
	{
		$sql = "CREATE TABLE IF NOT EXISTS `nuseo_log` (
				`log_id`		INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
				`error`			VARCHAR(255) NOT NULL,
				`referrer`		VARCHAR(255) NOT NULL,
				`ip`			VARCHAR(255) NOT NULL,
				`useragent`		VARCHAR(255) NOT NULL,
				`type`			VARCHAR(255) NOT NULL,
				`dateadded`		DATETIME NOT NULL,
				KEY `nuseo_log_date` (`dateadded`)
				)";
		$nuseo['log_db_conn']->execute_write( $sql );
	}	
}

function nuseo_admin_validate_url_base( $setting_name, &$setting_value )
{
	if ($setting_value[0] != '/')							// make sure that url_base starts in /
    {
		$setting_value = '/' . $setting_value;
    }

	if (substr( $setting_value, -1, 1 ) != '/')			// make sure that url_base ends in /
    {
		$setting_value .= '/';
    }
}

function nuseo_admin_validate_thread_words( $setting_name, &$setting_value )
{
     global $nuseo_config;    
    
     $setting_as_array = nuseo_admin_string_to_array( $setting_value );
     $setting_as_array = str_replace( ' ', $nuseo_config['separator'], $setting_as_array );
     $setting_as_array = implode( '|', $setting_as_array );
    
     if ( !empty( $setting_as_array ) )
     {
        $nuseo_config['vbulletin_reversed_thread_patterns'] = '|' . $setting_as_array;
     }
     else
     {
        $nuseo_config['vbulletin_reversed_thread_patterns'] = '';
     }
}

function nuseo_admin_validate_custom_forum_urls( $setting_name, &$setting_value )
{
	global $nuseo_config;

	$setting_as_array = nuseo_admin_string_to_array( $setting_value );
	
	$custom_url_list = array();
	$custom_domain_list = array();
	
	foreach ( $setting_as_array as $key => $forum_custom_url )
	{
		$domain_sep = strpos( $forum_custom_url, '|' );

		if ($domain_sep)
		{
			$forum_custom_domain = substr( $forum_custom_url, 0, $domain_sep );
			$forum_custom_url = substr( $forum_custom_url, $domain_sep + 1 );
		}
		else
		{
			$forum_custom_domain = '';
		}
		
		if (substr( $forum_custom_url, -1, 1 ) != '/')
			$forum_custom_url .= '/';
			
		$custom_url_list[ $key ] = $forum_custom_url;
		$custom_domain_list[ $key ] = $forum_custom_domain;
	}

	$nuseo_config[ 'vbulletin_custom_forum_url_list' ] = $custom_url_list;
	$nuseo_config[ 'vbulletin_custom_forum_domain_list' ] = $custom_domain_list;
}

/***********************************************************************
* * End File: nuseo_admin_config_file.nuphp
\************************************************************************/








/***********************************************************************
* * Start File: nuseo_admin_render.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

function nuseo_admin_render_module_summary(  &$module_info )
{
	global $nuseo_admin_content, $nuseo_language_strings, $nuseo_config;
    
	$module_setting_groups = nuseo_admin_node_as_array( $module_info, 'setting_groups' );
	
	$setting_summary_html = "";
	$module_name = $module_info['module_name'];
    $module_display_name = $module_info['module_display_name'];

	$index = 0;	
	foreach ( $module_setting_groups as $setting_group )
	{
        $group_name = $setting_group['name'];
        
        nuseo_admin_get_setting_group_strings( $module_name, $group_name, /*ref*/$setting_group );

        $setting_group_name = $setting_group['title'];
        $setting_group_description = $setting_group['description'];        
		
		$index++;
		$row_class = ($index % 2) ? 'ns-setting-row-odd' : 'ns-setting-row-even';
		
		eval( '$setting_summary_html .= "' . nuseo_fetch_template( 'settings_summary_row' ) . '";' );
	}
    
    nuseo_admin_get_module_description_strings( $module_name, $module_info );
    $summary_description = $module_info['description'];    
/*
	$summary_description = isset( $module_info['description'] ) ? $module_info['description'] 
					: "These settings control NuSEO's {$module_display_name} module.";
*/
	$summary_title = $module_display_name . " Settings Summary";
	
	$settings_container_style = ( ( "Main" != $module_name ) && 
								  ( "Help" != $module_name )) ? "display:none;" : "";
 
	//$group_name = $module_name;
	eval( '$result = "' . nuseo_fetch_template( 'settings_summary' ) . '";' );
	return $result;
}

function nuseo_generate_module_list()
{
	global $nuseo_admin_content, $nuseo_modules, $nuseo_templates, $nuseo_config; 
	
	$nuseo_admin_content[ group_bits ] = '';
	
	$module_list_html = '';
	$group_fields_html = '';			
	$settings_container_style = '';
	$group_name = '';
	
	$group_title = "NuSEO.PHP modules";
	$group_description = "List of NuSEO.PHP modules installed in your system";
	
	$module_row_template = nuseo_fetch_template( "nuseo_admin_module_row");
	$index = 0;
	$nuseo_modules_local = $nuseo_modules;		// avoid iterator confusion due to PHP bug.
	foreach( $nuseo_modules_local as $key => $module)
	{
		$module_name = $module[ 'module_name'];
        $module_display_name = $module[ 'module_display_name'];
		
		if ( true != nuseo_admin_is_list_of_modules( $module ))
		{
			// enabled / disabled flag
			$constant_name = strtolower( str_replace( " ", "_", $module_name) ) . "_enabled";
			
			$module_state = (isset( $nuseo_config[ $constant_name ] ) && $nuseo_config[ $constant_name ]);
			$module_state_text = ($module_state) ? "Enabled" : "Disabled";
			$module_state_key = ($module_state) ? "enabled" : "disabled";
			$module_toggle_state_action = (!$module_state) ? "enable" : "disable";		// this is reversed
			
            nuseo_admin_get_module_description_strings( $module_name, $module );
			$module_description = $module['description'];
			
			$index++;
			$row_class = ($index % 2) ? 'ns-setting-row-odd' : 'ns-setting-row-even';
			eval( '$group_fields_html .= "' . $module_row_template . '";');
		}
	}

	$module_name = $nuseo_modules[ 0 ]['module_name'];//"Module List";
    $module_display_name = $nuseo_modules[ 0 ]['module_display_name'];//"Module List";
	eval( '$module_list_html = "' . nuseo_fetch_template( 'module_list_container' ) . '";');
	
	return $module_list_html;
}

function nuseo_admin_render_module_list( &$module_info )
{
	global $nuseo_admin_content, $nuseo_modules;
	
	$group_links_html = "";//$module_info['module_name'];
	$group_settings_html = nuseo_generate_module_list();
	$module_name = $module_info['module_name'];
    $module_display_name = $module_info['module_display_name'];
	
	$all_settings_style = '';
	
	eval( '$nuseo_admin_content[ group_bits ] .= "' . nuseo_fetch_template( 'module_list_group_navigator' ) . '";' );
	eval( '$nuseo_admin_content[ setting_bits ] .= "' . nuseo_fetch_template( 'group_settings' ) . '";' );
}


function nuseo_admin_render_groups( &$module_info  )
{
	global $nuseo, $nuseo_config, $nuseo_admin_content, $nuseo_language_strings;
	
	$module_setting_groups = nuseo_admin_node_as_array( $module_info, 'setting_groups' );
	
	$group_index = 0;
	$row_class = 'ns-row2';

	$result = array( 'links' => array(), 'settings' => array());
	$group_links = &$result[ 'links' ];
	$group_settings = &$result[ 'settings' ];

	$module_name = $module_info['module_name'];
    $module_display_name = $module_info['module_display_name'];
	
	foreach ( $module_setting_groups as $setting_group )
	{
		$group_name			= $setting_group['name'];
        
        nuseo_admin_get_setting_group_strings( $module_name, $group_name, $setting_group );
        
		$group_title		= $setting_group['title'];
		$group_description	= $setting_group['description'];
		
		// generate group navigator
		eval( '$group_links[] = "' . nuseo_fetch_template( 'group_navigator_link' ) . '";' );
		
		// generate group settings
		if (isset( $setting_group['template'] ))
		{
			eval( '$this_group_settings = "' . nuseo_fetch_template( $setting_group['template'] ) . '";' );
		}
		else
		{
			$this_group_settings = nuseo_admin_render_group_settings( $module_name, $module_display_name,  
																	$setting_group, $group_index );
		}
		$group_settings[] = $this_group_settings;
		
		$group_index++;
	}
	return $result;
}


function nuseo_admin_get_module_content_variables( &$setting, &$result_html )
{
    global $nuseo_config, $nuseo_module_variables, $nuseo_language_strings;
    $result_html[ top ] = "";
    $result_html[ bottom ] = "<BR>";
    
    $language = $nuseo_config[ 'language' ];
    
   
    foreach( $nuseo_module_variables as $module_variables )
    {
        $result_html[ bottom ] .= "Module {$module_variables['name']} <BR>";
        foreach( $module_variables['variables']['variable'] as $variable_name )
        {
            $string_key = $module_variables['name'] .':variable:'. $variable_name;
            //echo $string_key . "<BR>";
            $variable_description = $nuseo_language_strings[ $language ][ $string_key ];
            $line = '&nbsp;&nbsp;[' . $variable_name . ']: ' . $variable_description . '<BR>';
            $result_html[ bottom ] .= $line;
        }
    }
    
}

function nuseo_admin_render_group_settings( $module_name, $module_display_name,  
												&$setting_group, $group_index )
{
	global $nuseo, $nuseo_config, $nuseo_admin_content, $nuseo_language_strings;
	
	$group_name			= $setting_group['name'];
	$group_title		= $setting_group['title'];
	$group_description	= $setting_group['description'];
	
	$group_fields = array();

	$setting_group_defs = nuseo_admin_node_as_array( $setting_group, 'setting' );

	$index = 0;
    
    $setting_field_html = array( top => "", bottom => "" );
	
	// Is License valid?
	$step_count = ($nuseo['step_count'] - $nuseo['timenow']) + $nuseo['nowload'];
	
	foreach ( $setting_group_defs as $setting )
	{
		$setting_name = isset($setting['varname'])		? $setting['varname'] : '';
		
		nuseo_admin_get_setting_item_strings( $module_name, $group_name, $setting_name, /*ref*/ $setting );
		
		if ( isset( $setting['prerender'] ) )
		{
			$setting['prerender']( $setting, $setting_field_html );
		}
		else
		{
			$setting_field_html[ top ] = '';
			$setting_field_html[ bottom ] = '';
		}
		
		$setting_title			= isset($setting['title'])			? $setting['title'] : '';
		$setting_description	= isset($setting['description'])	? $setting['description'] : '';
		
		$setting_datatype		= isset($setting['datatype'])		? $setting['datatype'] : '';
		$setting_defaultvalue	= isset($setting['defaultvalue'])	? $setting['defaultvalue'] : '';
		$setting_template		= isset($setting['template'])		? $setting['template'] : 'text';
		$setting_visibility		= isset( $setting['visibility'] )	? $setting['visibility'] : "show";
		
		if (!$setting_name)
			continue;
		
		// FIXME: Need a more elegant solution
		if (($setting_name == 'license_number') && 
				(!isset( $nuseo_config['license_number'] ) || !$nuseo_config['license_number'] || !$step_count)
			)
		{
			$setting_visibility = 'show';
		}
		
		if ( $setting_visibility  == "hidden" )
			continue;


		if (isset( $nuseo_config[ $setting_name ] ))
		{
			$setting_value			= $nuseo_config[ $setting_name ];
		}
		else
		{
			if ($setting_datatype == 'array')
			{
				$setting_value		= nuseo_admin_string_to_array( $setting_defaultvalue );
			}
			else
			{
				$setting_value		= $setting_defaultvalue;
			}
		}
        
        /*if ( $setting_name == "log_location" )
        {
            echo "<pre>";
            
        }*/
		
		$template_name			= 'field_' . $setting_template;
		
		$checked_yes	= $setting_value	? 'checked="checked"' : '';
		$checked_no		= !$setting_value	? 'checked="checked"' : '';

		if ( "show" == $setting_visibility  )
		{
			$index++;
			$row_class = ($index % 2) ? 'ns-setting-row-odd' : 'ns-setting-row-even';
			$setting_type_class = "ns-standard-setting";
			$advanced_setting_style = "";
		}
		else
		{
			$row_class = 'ns-setting-row-advanced';
			$setting_type_class = "ns-advanced-setting";
			$advanced_setting_style = "display: none";
		}
		
		$html_control_renderer = "nuseo_render_" . $template_name;
		
		//---------------------
		//Posible control-rendering functions:
		//   nuseo_render_field_dropdown
		//   nuseo_render_field_radiogroup <=== this has a radio-item bit template
		
		if (is_array($setting_value))		// FIXME: May want to come up with a generic mechanism, maybe reuse html_control_renderer
		{
			$setting_value = nuseo_admin_array_to_string( $setting_value, false );
		}

		$control_code = function_exists( $html_control_renderer ) ? $html_control_renderer( $setting, $setting_value ) : "";
		
		$setting_value			= htmlentities( trim( $setting_value ) );
		eval( '$group_fields[] = "' . nuseo_fetch_template( $template_name ) . '";' );
	}
	
	$group_fields_html = implode( '', $group_fields );

	$settings_container_style = "display:none;";
    
    //don't show save button in the help page                               
    $save_button_visibility = ( "Help" == $module_name ) ? "display:none;" : "";                              

	eval( '$this_group_settings = "' . nuseo_fetch_template( 'settings_container' ) . '";' );
	
	return $this_group_settings;
}

function nuseo_admin_is_list_of_modules( &$module_info )
{
	return (isset( $module_info['module_type'] ) && ($module_info['module_type'] == 'module_list') );
}

function nuseo_admin_is_module_enabled( &$module )
{
	global $nuseo_config;
	
	$module_name = ( is_string( $module) ) ? $module : $module['module_name'];
	
	if ( ( $module_name != 'Main' ) && ( $module_name != 'Help' ) )
	{
		$enabled_variable = strtolower( str_replace( " ", "_", $module_name) ) . "_enabled";
		$is_module_enabled = isset( $nuseo_config[ $enabled_variable ] ) && $nuseo_config[ $enabled_variable ];
	}
	else
	{
		$is_module_enabled = true;
	}
    
	return $is_module_enabled;
}

function nuseo_admin_render_settings()
{
	global $nuseo_admin_content, $nuseo_modules;
	
	$nuseo_admin_content[ group_bits ] = '';
	$nuseo_admin_content[ setting_bits ] = '';
    
	// modules
	$nuseo_modules_local = $nuseo_modules;		// avoid iterator confusion due to PHP bug.
	foreach( $nuseo_modules_local as $module_info )
	{
		if ( nuseo_admin_is_list_of_modules( $module_info ) )
		{
			nuseo_admin_render_module_list( $module_info );
		}
		else
		{
			//generate module summary
			$group_settings_html = nuseo_admin_render_module_summary( $module_info );
			eval( '$nuseo_admin_content[ setting_bits ] .= "' . nuseo_fetch_template( 'group_settings' ) . '";' );
			
			$module_name = $module_info['module_name'];
            $module_display_name = $module_info['module_display_name'];
			
			//generate link and groups for enabled modules only
			if (  nuseo_admin_is_module_enabled( $module_name  ) )
			{

				//genrate left-side links and right side setting grups
				$groups_link_and_settings = nuseo_admin_render_groups( $module_info );
				$group_links_html = implode( '', $groups_link_and_settings[ 'links' ] );
				$group_settings_html = implode( '', $groups_link_and_settings[ 'settings' ] );
				
				$all_settings_style = $module_name == 'Help' ? 'display:none' : '';
				
				eval( '$nuseo_admin_content[ group_bits ] .= "' . nuseo_fetch_template( 'group_navigator' ) . '";' );
				eval( '$nuseo_admin_content[ setting_bits ] .= "' . nuseo_fetch_template( 'group_settings' ) . '";' );
			}
		}
	}
	
}

function nuseo_admin_render_page( $main_template_name )
{
	global $nuseo, $nuseo_config, $nuseo_admin_content, $nuseo_tab_header, $nuseo_js_variables, $nuseo_additional_script,
           $nuseo_your_site, $nuseo_sitemap_link;
		
	if (isset( $_SESSION['message_text'] ))
	{
		$nuseo_admin_content[ message_type ] = isset( $_SESSION['message_type'] ) ? $_SESSION['message_type'] : MSG_TYPE_INFO;
		$nuseo_admin_content[ message_text ] = $_SESSION['message_text'];
		$nuseo_admin_content[ message_class ] = 'ns-msg-' . $nuseo_admin_content[ message_type ];
	}
	else
	{
		$nuseo_admin_content[ message_type ] = MSG_TYPE_NONE;
		$nuseo_admin_content[ message_text ] = '';
		$nuseo_admin_content[ message_class ] = "ns-msg-none";
	}
	
	unset( $_SESSION['message_text'] );
	unset( $_SESSION['message_type'] );

	$nuseo_admin_content[ http_host ] = $_SERVER['HTTP_HOST'];

	// evaluate templates
	eval( '$header = "' . nuseo_fetch_template('header') . '";' );
	eval( '$footer = "' . nuseo_fetch_template('footer') . '";' );		
	eval( '$output = "' . nuseo_fetch_template( $main_template_name ) . '";' );	
	echo $output;
}

function nuseo_admin_language_items()
{
    global $nuseo_languages, $nuseo_language_strings;
    
    $language_items = array();
    
    foreach( $nuseo_languages as $language )
    {
        $language_items[] = array ( 'itemvalue' => $language, 'text' => $nuseo_language_strings[ $language ]['name'] );
    }
    
    return $language_items;
}


function nuseo_render_field_dropdown( &$settingnode, $setting_value )
{
    $html_result = array();
    $items  = null;
    
    if ( isset( $settingnode['custom_items'] ) )
    {
        if ( function_exists( $settingnode['custom_items'] ) )
        {
            $items = $settingnode['custom_items']();
        }
    }
    
    if ( isset( $settingnode['dropdownitems']['item'] ))
    {

	    $items = &$settingnode['dropdownitems']['item'];
    }
    
    if ( isset( $items ) )
    {
        foreach( $items as $item)
        {
	        $value = $item['itemvalue'];
	        $selected = ( $value == $setting_value ) ? 'selected="selected"' : "";
	        $html_result[] = "<option value = {$value} {$selected} >{$item['text']}</option>";
        }
    }

	
	return implode( " ",  $html_result);
}

function nuseo_render_field_radiogroup( &$settingnode, $setting_value )
{
    global $nuseo_admin_content;
    
	$bit_template_value = nuseo_fetch_template( "field_" . $settingnode[ 'items']['item_bit_template'] );
	$field_name = $settingnode['varname'];

    //to check that custom field was done 1 time only
    $custom_value_found = false;
	$selected_value_found = false;
    
	$items = &$settingnode['items']['item'];

	$field_index = 0;
	$custom_field_index = 0;
	
	$html_result = array();    
	foreach( $items as $item)
	{
		$option_checked = '';
		//prepare values to render bit 
		$value = $item['itemvalue'];
		$option_title = ( isset( $item['text'] ) ) ? $item['text'] : $value;
		
		if ( 'custom' != $value)
		{
			//generate regular field using the bit template
			$option_checked = ( $value == $setting_value) ? 'checked="checked"' : "";
			
			if ( $option_checked ) 
			{
				$selected_value_found = true;
			}
			eval( '$html_result[] = "' . $bit_template_value . '";' );
		}
		else if ( !$custom_value_found )
		{
			//save custom values to generate html at the end
			$custom_field_index = $field_index;
			$custom_option_title = $option_title;
			$custom_value_found = true;
		}
		$field_index++;
	}
	
	//do the custom value at the end
	if ( $custom_value_found )
	{
		$value = 'custom';
		$option_title = $custom_option_title;
		
		//if the value wasnt found before we are in the presence of 
		//a custom value
		if ( !$selected_value_found ) 
		{
			$option_checked = 'checked="checked"';
			$input_value = $setting_value;
		}
		else
		{
			$option_checked = '';
			$input_value = "";
		}
		$field_index = $custom_field_index;
		
		eval( '$html_result[] = "' . $bit_template_value . '";' );
		
		$html_result[] = "<tr><td><input onkeyup=\"if(this.value)document.getElementById('setting_{$field_name}_{$custom_field_index}').checked=true\" 
				size='34' value='{$input_value}' name='custom_{$field_name}'/></td</tr>";		
	}
	return implode( " ",  $html_result);
}

/***********************************************************************
* * End File: nuseo_admin_render.nuphp
\************************************************************************/









/***********************************************************************
* * Start File: nuseo_admin_install.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

function nuseo_admin_check_install()
{
	global $nuseo_config, $nuseo_modules, $nuseo_admin_content, $nuseo_dir; 
	
	if (isset( $nuseo_dir ))
	{
		$dir = $nuseo_dir;
	}
	else if (isset( $nuseo_config['dir'] ))
	{
		$dir = $nuseo_config['dir'];
	}
	else
	{
		$dir = false;
	}
	
	$error_message = false;
	if ($dir)
	{
		$full_config_file_name = $dir . "/nuseo_config.php";
		$full_config_dist_file_name = $dir . "/nuseo_config.php-dist";
		
		if (!file_exists( $full_config_file_name ))
		{																// nuseo_config.php not found
			if (file_exists( $full_config_dist_file_name ))
			{															// nuseo_config.php-dist found
				if (!is_writable( $full_config_dist_file_name ))
				{	// nuseo_config.php-dist is not writable
					chmod( $full_config_dist_file_name, 0777 );
				}

				// rename nuseo_config.php-dist to nuseo_config.php
				rename( $full_config_dist_file_name, $full_config_file_name );
				
				if (!file_exists( $full_config_file_name ))
				{	// then we couldn't rename file
					$error_message = "Please rename <em>nuseo_config.php-dist</em> to <b>nuseo_config.php</b>.<br/>
								And change the permissions for <b>nuseo_config.php</b> to 777.";
				}
			}
			else
			{
				$error_message = "Some files are missing from NuSEO.PHP's installation. <br/><br/>
								File not found: <b>$full_config_dist_file_name</b>.";
			}
		}
	}
	
	if ($error_message)
	{
		// show message and exit
		nuseo_admin_show_message( $error_message );
		exit;
	}
	
}

function nuseo_admin_show_message( $error_message )
{
	global $nuseo_admin_content, $nuseo_tab_header;

	// save current page
	$request_url = 'http://' . $_SERVER['HTTP_HOST'] . nuseo_get_request_uri();
	$nuseo_admin_content[ redir_url ] = $request_url;
	
	$error_message .= "<br/>
	<br/>
	<a href=\"$request_url\">Click here to continue.</a><br/>";
	
	$_SESSION['message_type'] = MSG_TYPE_ERROR;
	$_SESSION['message_text'] = $error_message;

	// render page
	$nuseo_tab_header = "NuSEO.PHP " . NUSEO_VERSION . " - Admin Control Panel - Message";
	nuseo_admin_render_page( 'main_message' );
	exit;
}

/***********************************************************************
* * End File: nuseo_admin_install.nuphp
\************************************************************************/









/***********************************************************************
* * Start File: nuhit_xml.nuphp
 * Note: This is not a php file.
 * Copyright 2006-2007 NuHit, LLC. All Rights Reserved.
\************************************************************************/

class nuhit_xml_reader
{
	// xml content
	var $_xml = '';
	
	// xml in array hierarchy
	var $_xml_root = array();
	
	
	// used by callbacks from PHP XML Parser
	var $_tag = null;
	var $_tag_stack = array();
	
	var $_parser_instance = null;
	
	var $_encoding = 'ISO-8859-1';		// default to Windows encoding.
	
	// xml debuggin
	var $_debug_indent = 0;
	var $_debug_xml_parser = false;
	
	function nuhit_xml_reader()
	{
		$this->init_php_xml();
	}

	function &parse_file( $filename )
	{
		$this->_xml = @file_get_contents( $filename );
		$this->run_parser();
		return $this->_xml_root;
	}
	
	function &parse_xml( $xml_string )
	{
		$this->_xml = $xml_string;
		$this->run_parser();
		return $this->_xml_root;
	}
	
	function run_parser()
	{
        $this->_xml_root = false;
		
		if ( $this->_xml )
		{
			// Create XML parser instance 
            $this->_parser_instance = xml_parser_create( $this->_encoding );
            
    	    if ( $this->_parser_instance )
		    {
				// reset temp tag and tag stack
				$this->_tag =  array( 'name' => '_xml_root_tag_', 'attributes' => array(), 'cdata' => '' );
				$this->_tag_stack = array();
				
				$this->_debug_indent = 1;
				
				
				// set object instance
				xml_set_object( $this->_parser_instance, $this );

				// set start and end element handlers.
		        xml_set_element_handler( $this->_parser_instance, 'xml_tag_open', 'xml_tag_close' );
				
				// set character data handler. handler param can be a string or an array with an object instance and the method name.
		        xml_set_character_data_handler( $this->_parser_instance,  'xml_tag_data' );

				// keep xml_parse from uppercasing all texts
		        xml_parser_set_option( $this->_parser_instance,	XML_OPTION_CASE_FOLDING,	/* int */ 0 );

				// do not skip whitespaces.
		        xml_parser_set_option( $this->_parser_instance,	XML_OPTION_SKIP_WHITE,		/* int */ 0 );

				// run parser.
		        xml_parse( $this->_parser_instance, $this->_xml );
        		
				// check success
		        $error = xml_get_error_code( $this->_parser_instance );
        		
				// release resources
		        xml_parser_free( $this->_parser_instance );

		        if ( $error )
		        {
			        $this->_xml_root = false;
		        }
				else
				{
					$this->_xml_root = $this->_tag['attributes'];
				}

				if ($this->_debug_xml_parser)
				{
					print_r( $this->_xml_root );
					exit;
				}				
			}
        }
	}

	function xml_tag_open( &$parser, $name, $attributes )
	{
		if ($this->_debug_xml_parser)
		{
			echo str_repeat( ' ', $this->_debug_indent * 4 ) 
									. "[{$this->_debug_indent}] xml_tag_open: $name, attrs:(";
			foreach ($attributes as $attr_name => $attr_value )
			{
				echo "$attr_name='$attr_value', ";
			}
			echo ")\n";
			$this->_debug_indent ++;
		}

		// convert all &nbsp;, etc. to chars.
		if (!empty( $attributes ) && is_array( $attributes ))
		{
			foreach ($attributes as $attr_name => $attr_value )
			{
				if ( preg_match( '/&[a-z]+;/i', $attr_value ) )
				{
					$attribs[ $attr_name ] = unhtmlspecialchars( $attr_value );
				}
			}
		}
		
		if ($this->_tag)
		{	// push current tag into stack. use array_shift/unshift instead of pop/push to avoid using count.
			array_unshift( $this->_tag_stack, $this->_tag );
		}

		// this is the tag that was just openned.
		$this->_tag = array( 'name' => $name, 'attributes' => $attributes, 'cdata' => '' );
	}
	
	function xml_tag_data( &$_parser_instance, $cdata )
	{
		if ($this->_debug_xml_parser)
		{
			echo str_repeat( ' ', $this->_debug_indent * 4 ) 
									. "[{$this->_debug_indent}] xml_tag_cdata: $cdata\n";
		}
		if (!empty( $cdata ))
		{
			if ($this->_tag)
			{
				// make newlines unix-like.
				$clean_cdata = array( "\r\n" => "\n" );
				$cdata = str_replace( array_keys( $clean_cdata ), array_values( $clean_cdata ), $cdata );
				
				// append to current tag's cdata
				$this->_tag[ 'cdata' ] .= $cdata;
			}
		}
	}

	function xml_tag_close( &$_parser_instance, $name )
	{
		if ($this->_debug_xml_parser)
		{
			$this->_debug_indent--;
			echo str_repeat( ' ', $this->_debug_indent * 4 ) 
									. "[{$this->_debug_indent}] xml_tag_close $name\n";
		}
		// check that we are closing
		if ($this->_tag && ($this->_tag['name'] == $name))
		{
			$tag_name = $name;

			// add cdata back
			if ( empty( $this->_tag['attributes'] ) )		// this tag does not have any attributes.
			{
				$tag_content = $this->_tag['cdata'];
			}
			else
			{
				if (trim( $this->_tag['cdata'] ))
				{
					// then add cdata as a 'value' child, next to other attributes
					$this->add_node_content( $this->_tag['attributes'], 'cdata', $this->_tag['cdata'] );
				}
				
				$tag_content = $this->_tag['attributes'];
			}
			
			// pop current tag from stack
			if (!empty( $this->_tag_stack ))
			{
				$this->_tag = array_shift( $this->_tag_stack );
				$this->append_tag_content( $this->_tag['attributes'], $tag_name, $tag_content );
			}
        }
		else
		{
			if (!empty( $this->_tag_stack ))
			{
				// pop current tag from stack
				$this->_tag = array_shift( $this->_tag_stack );
			}
		}
	}


	function append_tag_content( &$attributes, $tag_name, $tag_content )
	{
		if (is_array( $attributes ))
		{
			if ( isset( $attributes[ $tag_name ] ) )
			{
				if (is_array( $attributes[ $tag_name ] ) && isset( $attributes[ $tag_name ][0] ))
				{	// we already have a multiple value array for this.
					$attributes[ $tag_name ][] = $tag_content;
				}
				else
				{
					$current_content = $attributes[ $tag_name ];
					$attributes[ $tag_name ] = array( $current_content, $tag_content );
				}
			}
			else
			{	// first time we are adding this tag
				$attributes[ $tag_name ] = $tag_content;
			}
		}
		else
		{
			$current_value = $attributes;
			$attributes = array( 'value' => $current_value, $tag_name => $tag_content );
		}
	}

	function init_php_xml()
	{
		if ( !function_exists( 'xml_set_object' ) )
		{
			$extension_dir = ini_get( 'extension_dir' );
		    
			if ( DIRECTORY_SEPARATOR == '/' )
			{
				//unix/linux
				$extension_file = 'xml.so';
			}
			else
			{
				//windows
				$extension_file = 'php_xml.dll';
			}
			
			if ( $extension_dir && file_exists( $extension_dir . '/' . $extension_file ) )
			{
				ini_set( 'display_errors', true );
				dl( $extension_file );
			}
		}
	}
}

/***********************************************************************
* * End File: nuhit_xml.nuphp
\************************************************************************/


//#include "../nuhit_curl.nuphp"


nuseo_admin_main();
//



function nuseo_admin_main()
{
	global $nuseo_config, $nuseo_modules, $nuseo_admin_content; 
	
	$nuseo_modules = array();
	$nuseo_admin_content = array(); 
    






    $nuseo_admin_content[css_path] = "../admin/";
    $nuseo_admin_content[js_path] = "../scripts/";
    $nuseo_admin_content[img_path] = "../images/";
    $nuseo_admin_content[admin_script] = "nuseo_admin.php";

	
	// setup session
	@session_start();
	
	// load templates
	nuseo_admin_init_templates();
    
    nuseo_admin_language_load();
	
	nuseo_admin_check_install();			// this will only do something the first time NuSEO.PHP is installed.
	
	$action = isset( $_REQUEST['action'] ) ? htmlentities( $_REQUEST['action'] ) : '';

	switch ($action)
	{
		case 'login':			nuseo_admin_process_login();		break;
		case 'logout':			nuseo_admin_process_logout();		break;
		case 'save':			nuseo_admin_process_save( false );	break;
		case 'enable_disable':  nuseo_admin_process_save_enable_disable(); break;
		
		case 'reset_password':	nuseo_admin_reset_password();		break;
		case 'save_password':	nuseo_admin_save_password();		break;

		default:				nuseo_admin_show_settings();		break;
	}
}

function nuseo_admin_language_load()
{
    global $nuseo_languages, $nuseo_config, $nuseo_language_strings;
    
    $nuseo_languages = array();
       
    $language_folder = $nuseo_config['dir'] . "/languages/";
    
    foreach ( glob( $language_folder . "language.*.php" ) as $language_file )
    {    
        $matches = false;
        if ( preg_match('#^(?:.*)language\.(.*)\.(.*)\.php$#i', $language_file, $matches ) )
        {
            $language_key = $matches[ 1 ];
			$nuseo_languages[ $language_key ] = $language_key;

            include( $language_file );
        }
    }

}


function nuseo_admin_show_settings()
{
	global $nuseo_admin_content, $nuseo_tab_header, $nuseo_js_variables, $nuseo_config, $nuseo_modules, $nuseo_additional_script,
           $nuseo_your_site, $nuseo_dir, $nuseo_sitemap_link;

	$nuseo_additional_script = '';

	// check if we are logged in.
	nuseo_admin_check_login();
	
	// check load
	nuseo_admin_check_load();

	// Validate the current config.
	nuseo_admin_validate_config();
	
	$tab = isset( $_REQUEST['tab'] ) ? $_REQUEST['tab'] : 'main';
	
	$nuseo_admin_content[ tab_class_main ] = $nuseo_admin_content[ tab_class_modules ] = $nuseo_admin_content[ tab_class_help ] = "";
    
    $nuseo_admin_content[ mod ] = isset( $_REQUEST[ 'mod' ] ) ? $_REQUEST[ 'mod' ] : '';
    
    $nuseo_admin_content[ group ] = isset( $_REQUEST[ 'group' ] ) ? $_REQUEST[ 'group' ] : '';

	$nuseo_js_variables = "var g_current_tab = 'main';";
	                            
    $nuseo_status = ( $nuseo_config['enabled'] ) ? " - NuSEO.PHP is ON" : " - NuSEO.PHP is OFF";
    
    $nuseo_your_site = $_SERVER[ 'HTTP_HOST' ];

	switch ( $tab )
	{
		default:
		case 'main':
		{
			$active_tab = tab_class_main;
			$nuseo_tab_header = "NuSEO.PHP " . NUSEO_VERSION . " - Admin Control Panel - Main Settings" . $nuseo_status;
			
			// load setting definition
			nuseo_admin_load_main_settings_definition();
            
            //read module variables
            nuseo_admin_load_modules_settings_definition( $nuseo_temp_modules );
            nuseo_admin_load_module_variables( $nuseo_temp_modules );
            
            unset( $nuseo_temp_modules );
			
			// render settings
			nuseo_admin_render_settings();
			break;
		}
		
		case 'modules':
			$active_tab = tab_class_modules;
			$nuseo_tab_header = "NuSEO.PHP " . NUSEO_VERSION . " - Admin Control Panel - Modules" . $nuseo_status;
			$nuseo_js_variables = "var g_current_tab = 'modules';";
			
			// add module list "virtual module"
			nuseo_admin_add_module_list_to_modules();
			
			// load setting definition
			nuseo_admin_load_modules_settings_definition( $nuseo_modules );
            nuseo_admin_load_module_variables( $nuseo_modules );
			
			// render settings
			nuseo_admin_render_settings();
			break;
		
		case 'help':
			$nuseo_tab_header = "NuSEO.PHP " . NUSEO_VERSION . " - Admin Control Panel - Help & Support Center" . $nuseo_status;
			$active_tab = tab_class_help;
			$nuseo_js_variables = "var g_current_tab = 'help';";
			// load setting definition
			nuseo_admin_load_help_settings_definition();
			
			// render settings
			nuseo_admin_render_settings();
			break;
        case 'diag';
            include "nuseo_diag.php";
            exit;
            break;
	}
	
	$nuseo_admin_content[ $active_tab ] = "ns-on";
	$nuseo_admin_content[ active_tab_name ] = $tab;
    
	
    //sitemap link
    if ( file_exists( $nuseo_dir . "/sitemap/admin/nuseo_admin.php" ) )
    {
      $nuseo_sitemap_link = "<a href='http://{$nuseo_your_site}/nuseo/sitemap/admin/nuseo_admin.php'>NuSEO Sitemap Generator</a> |";
    }
    else
    {
      $nuseo_sitemap_link = "";
    }
	// render page
	nuseo_admin_render_page( 'admin_main' );
	exit;
}



function nuseo_admin_load_module_variables( &$nuseo_modules )
{
    global $nuseo_module_variables;
    $nuseo_module_variables = array();
    foreach ( $nuseo_modules as $module )
    {
        if ( isset( $module[ 'module_variables' ] ) )
        {
            $nuseo_module_variables[] = array( 'name' => $module['module_name'], 'variables' => $module['module_variables'] );
        }
    }
}

// Login
function nuseo_admin_show_login_form()
{
	global $nuseo_admin_content, $nuseo_tab_header;
	
	// save current page
	$request_url = 'http://' . $_SERVER['HTTP_HOST'] . nuseo_get_request_uri();
	$nuseo_admin_content[ redir_url ] = $request_url;

	// render page
	$nuseo_tab_header = "NuSEO.PHP " . NUSEO_VERSION . " - Admin Control Panel - Login";
	nuseo_admin_render_page( 'main_login' );
	exit;
}

function nuseo_admin_invalid_login()
{
	// send message to login form
	$_SESSION['message_type'] = MSG_TYPE_ERROR;
	$_SESSION['message_text'] = "Invalid username or password.";
	
	// show login page again
	nuseo_admin_show_login_form();
}

function nuseo_admin_process_login()
{
	global $nuseo_config;
	// get form values
	$ns_username	= strtolower( trim( htmlentities( $_POST['ns_username'] ) ) );
	$ns_password	= htmlentities( $_POST['ns_password'] );
	$ns_md5password	= htmlentities( $_POST['ns_md5password'] );
	
	if (!$ns_md5password)			// in case javascript was disabled and password came in clear text.
		$ns_md5password = md5( $ns_password );

	// verify username / password
	$config_username = isset( $nuseo_config['admin_username'] ) ? strtolower( trim($nuseo_config['admin_username']) ) : 'admin';
	$config_password = isset( $nuseo_config['admin_password'] ) ? $nuseo_config['admin_password'] : md5('');
	
	if (!empty( $nuseo_config['demo_mode'] ))
	{
		$config_password = md5( 'password' );
	}

	
	if (($config_username == $ns_username) && ($config_password == $ns_md5password))
	{	// valid login 
		$_SESSION['nuseo_admin_logged_in'] = true;		// we are now logged in.

		// redirect to where we need to go.
		$redir_url = isset($_REQUEST['redir_url']) ? urldecode( $_REQUEST['redir_url'] ) : '';
		if (!$redir_url || (strpos($redir_url, 'action=login')))
			$redir_url = nuseo_get_admin_home_url();

		header( "Location: $redir_url" );
		exit;
	}
	else
	{
		nuseo_admin_invalid_login();
	}
}

function nuseo_admin_process_logout()
{
	// clear session variables
	$_SESSION['nuseo_admin_logged_in'] = false;		// we are now logged out
	unset( $_SESSION['license_retrieval_failed'], $_SESSION['license_retrieval_error'] );
	
	nuseo_admin_redir_to_admin_home();
}

function nuseo_admin_redir_to_admin_home()
{
	// redir to login form
	$admin_home_url = nuseo_admin_get_admin_script_url();
	header( "Location: $admin_home_url" );
	exit;
}

function nuseo_admin_check_login()
{
	global $nuseo_config, $nuseo;
	
	if (!isset( $nuseo['step_count'] ))
	{
		$nuseo['timenow'] = time();
		$nuseo['nowload'] = rand(0,1000);
		$nuseo['step_count'] = nuseo_get_step_count();
	}
	
	// check if password needs to be set
	if (!isset($nuseo_config['admin_password']) || !$nuseo_config['admin_password'] 
		|| ($nuseo_config['admin_password'] == md5('')))
	{
		nuseo_admin_reset_password();
		exit;
	}
	

	// if logged in return.
	$is_logged_in = isset( $_SESSION['nuseo_admin_logged_in'] ) && $_SESSION['nuseo_admin_logged_in'];
	if ($is_logged_in)
		return;
	
	// if not logged in, show login form
	nuseo_admin_show_login_form();
}
//

// Template

function nuseo_admin_init_templates()
{
	global $nuseo_templates, $nuseo_config;
	$nuseo_templates = array();
	
	$template_directory = $nuseo_config[ 'dir'] . "/templates/";
	
	// get templates 
	
	$handle = opendir( $template_directory );
	while (($file = readdir($handle)) !== false)
	{
		$matches = false;
		if (!preg_match('#^(.*).tpl.php$#i', $file, $matches))
			continue;
			
		$template_name = strtolower( $matches[1] );
		
		$template = file_get_contents( "$template_directory$file" );
		
		$template = str_replace( '"', '\"', $template );
		
		$nuseo_templates[ "$template_name" ] = $template;
	} // while
	
}

function nuseo_fetch_template( $template_name )
{
	global $nuseo_templates;
	
	if (isset( $nuseo_templates[ $template_name ] ))
		return $nuseo_templates[ $template_name ];
	else
	{
		echo "template $template_name not found";
		return '';
	}
}
//

// Settings
function nuseo_admin_load_main_settings_definition()
{
	global $nuseo_config, $nuseo_modules;
	$main_settings_filename = $nuseo_config['dir'] . "/nuseo_settings.xml";
    
	nuseo_admin_load_settings_file( $main_settings_filename, $nuseo_modules, 'main' );
}

function nuseo_admin_load_help_settings_definition()
{
	global $nuseo_config, $nuseo_modules;
	$main_settings_filename = $nuseo_config['dir'] . "/nuseo_settings.xml";
	
	nuseo_admin_load_settings_file( $main_settings_filename, $nuseo_modules, 'help' );
}

function nuseo_admin_add_module_list_to_modules()
{
	global $nuseo_modules;
	
	$nuseo_modules[] = array
	(
		'module_type' => 'module_list',
		'module_name' => 'Module List',
        'module_display_name' => 'Module List'
		
	);
}

function nuseo_admin_load_modules_settings_definition( &$nuseo_modules )
{
	global $nuseo, $nuseo_config;
	//load all files in ..\modules\nuseo_*.xml
    //echo "here1";
    
	foreach( glob( $nuseo_config['dir'] . "/modules/nuseo_*.xml") as $setting_file_name)
	{
		//check for a parallel php file
		$php_module_file = substr( $setting_file_name, 0, - 4 ) . ".php";

		if ( file_exists( $php_module_file ))
		{
			nuseo_admin_load_settings_file( $setting_file_name, $nuseo_modules );
		}
	}
}


function nuseo_admin_get_module_description_strings( $module_name, &$module_data )
{
    global $nuseo_language_strings, $nuseo_config;
    
    $language = $nuseo_config[ 'language' ];
    
    $description_key = $module_name . ":description";
    
    if ( isset($nuseo_language_strings[ "{$language}" ][ "{$description_key}" ]) )
    {
        $module_data['description'] = $nuseo_language_strings[ "{$language}" ][ "{$description_key}" ];
    }
    else 
    {
        if ( !isset( $module_data['description'] ) )
        { 
	        $module_data['description'] = "xxxx";
        }
        $file = fopen( $nuseo_config[ 'dir' ] . '/languages/' . $language . 'modules.txt', "a+" );
        $line = "\$nuseo_language_strings[ '" .$language ."' ][ '" . $description_key . "' ] = '" . addcslashes( $module_data['description'], "'\\" ) . "';";
        fwrite( $file,  $line . "\n" );
        fclose( $file );

    }
}

function nuseo_admin_load_settings_file( $settings_filename, &$nuseo_modules, $module_name_filter = false )
{
	if ($module_name_filter)	
		$module_name_filter = strtolower( $module_name_filter );

	// parse xml file
	$xml_reader = new nuhit_xml_reader();
	
	$parsed_xml =& $xml_reader->parse_file( $settings_filename );			// assign ref to global has to go through GLOBALS
    
    	
	// iterate through module list
	if (isset( $parsed_xml['modules'] ))
	{
		$module_list = nuseo_admin_node_as_array( $parsed_xml['modules'], 'module' );
	}
	else
	{
		$module_list = nuseo_admin_node_as_array( $parsed_xml, 'module' );
	}

	$module_index = 0;
  
	foreach ($module_list as $module_data)
	{

		$module_display_name = isset( $module_data['module_display_name'] ) ? $module_data['module_display_name'] : '';
        
        if ( strtolower( basename( $settings_filename ) ) == "nuseo_settings.xml" )
        {
            $module_name = $module_display_name;
        }
        else
        {
		    if (!preg_match('#^nuseo_(.*).xml$#i', basename( $settings_filename ), $matches))
			    continue;
                
	        $module_name = $matches[1];
        }
       
		if ($module_name_filter && ($module_name_filter != strtolower($module_name)))
			continue;
            
		$setting_groups = nuseo_admin_node_as_array( $module_data, 'settinggroup' );
        
        nuseo_admin_get_module_description_strings( $module_name, $module_data );
        $module_description = $module_data['description'];
        
        $module_variables = ( isset( $module_data['module_variables'] ) ) ? $module_data['module_variables'] : null;
        
		$module = array( 'module_name' => $module_name, 
                         'module_display_name' => $module_display_name, 
                         'description' => $module_description, 
                         'file_name' => $settings_filename, 
                         'setting_groups' => $setting_groups, 
                         'module_variables' =>  $module_variables );
	
		$module_key = $module_name ? $module_name : ($settings_filename . '-' . $module_index);
	
		$nuseo_modules[ $module_key ] = $module;
		$module_index++;
	}
}

function nuseo_admin_node_as_array( &$data, $key )
{
	if ( is_array( $data[ $key ] ) && isset( $data[ $key ][0] ) )
		return $data[ $key ];
	else
		return array( $data[ $key ] );
}
//

// Reset Password 
function nuseo_admin_reset_password()
{
	global $nuseo_config, $nuseo_admin_content, $nuseo_tab_header;
	
	// save current page
	$request_url = 'http://' . $_SERVER['HTTP_HOST'] . nuseo_get_request_uri();
	$nuseo_admin_content[ redir_url ] = $request_url;
	
	// show old password only if set
	$nuseo_admin_content[old_password_display] = (!isset($nuseo_config['admin_password']) 
													|| !$nuseo_config['admin_password'] 
													|| ($nuseo_config['admin_password'] == md5(''))) 
														? 'none' : 'block';
	// render page
	nuseo_admin_render_page( 'main_reset_password' );
	exit;
}

function nuseo_admin_save_password()
{
	global $nuseo_config;
	// get form values
	$ns_password_old		= htmlentities( $_POST['ns_password_old'] );
	$ns_md5password_old		= htmlentities( $_POST['ns_md5password_old'] );

	$ns_password_new		= htmlentities( $_POST['ns_password_new'] );
	$ns_md5password_new		= htmlentities( $_POST['ns_md5password_new'] );

	$ns_password_confirm	= htmlentities( $_POST['ns_password_confirm'] );
	$ns_md5password_confirm	= htmlentities( $_POST['ns_md5password_confirm'] );

	// md5 clear password if javascript was disabled
	if (!$ns_md5password_old)
		$ns_md5password_old = md5( $ns_password_old );
		
	if (!$ns_md5password_new)
		$ns_md5password_new = md5( $ns_password_new );

	if (!$ns_md5password_confirm)
		$ns_md5password_confirm = md5( $ns_password_confirm );

	// verify username / old password
	$config_username = isset( $nuseo_config['admin_username'] ) ? strtolower( trim($nuseo_config['admin_username']) ) : 'admin';
	$config_password = isset( $nuseo_config['admin_password'] ) ? $nuseo_config['admin_password'] : md5('');

	if ($config_password && ($config_password != $ns_md5password_old))
	{
		// old password did not match
		$_SESSION['message_type'] = MSG_TYPE_ERROR;
		$_SESSION['message_text'] = "Please enter the old password to proceed.";
		
		nuseo_admin_reset_password();
	}
	
	// Verify that a password was entered
	if ($ns_md5password_new == md5(''))
	{
		// old password did not match
		$_SESSION['message_type'] = MSG_TYPE_ERROR;
		$_SESSION['message_text'] = "Password cannot be empty.";

		nuseo_admin_reset_password();
	}
	// verify that new password was confirmed properly
	if ($ns_md5password_new != $ns_md5password_confirm)
	{
		// old password did not match
		$_SESSION['message_type'] = MSG_TYPE_ERROR;
		$_SESSION['message_text'] = "'New Password' and 'Confirm Password' do not match.";

		nuseo_admin_reset_password();
	}

	// we are ok, save new passowrd
	$_POST['setting_admin_password'] = $ns_md5password_new;
	nuseo_admin_process_save( true );				// this will redirect to the admin main page
	exit;
}
//

// Misc
function nuseo_get_request_uri()
{
	if (isset($_SERVER['REQUEST_URI']) && $_SERVER['REQUEST_URI'])
	{
		$request_uri = $_SERVER['REQUEST_URI'];
	}
	else
	{
		if (isset($_SERVER['REDIRECT_URL']) && $_SERVER['REDIRECT_URL'])
		{
			$request_uri = $_SERVER['REDIRECT_URL'];
		}
		else if (isset($_SERVER['PHP_SELF']) && $_SERVER['PHP_SELF'])
		{
			$request_uri = $_SERVER['PHP_SELF'];
		}

		// add query string
		if (isset($_SERVER['QUERY_STRING']) && $_SERVER['QUERY_STRING'])
		{
			$request_uri .= '?' . $_SERVER['QUERY_STRING'];
		}
	}

	return urldecode($request_uri);
}

function nuseo_admin_get_admin_script_url()
{
	$url = 'http://' . $_SERVER['HTTP_HOST'] . nuseo_get_request_uri();
	$query_pos = strpos( $url, '?' );
	if ($query_pos)
		$url = substr( $url, 0, $query_pos );
	return $url;
}
//

// License Support
function nuseo_admin_check_load()
{
	global $nuseo;
    
	if (!isset( $nuseo['step_count'] ))
	{
		$nuseo['timenow'] = time();
		$nuseo['nowload'] = rand(0,1000);
		$nuseo['step_count'] = nuseo_get_step_count();
	}

	$step_count = ($nuseo['step_count'] - $nuseo['timenow']) + $nuseo['nowload'];
}

//

function nuseo_admin_add_user_message( $msg_text, $msg_type )
{
	if (!isset($_SESSION[ 'message_type' ]))
	{
		$_SESSION[ 'message_type' ] = $msg_type;
	}
	else	// not set
	{
		if ($msg_type == MSG_TYPE_ERROR)		// overwrite only if this is an error
		{
			$_SESSION[ 'message_type' ] = $msg_type;
		}
	}
	
	if (isset( $_SESSION[ 'message_text' ] ))
		$_SESSION[ 'message_text' ] .= '<br /><br />' . $msg_text;
	else
		$_SESSION[ 'message_text' ] = $msg_text;
}